<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if( !class_exists( 'WindoorProSiteBlog' ) ) {
    class WindoorProSiteBlog extends WindoorPlusSiteBlog {

        private static $_instance = null;
        public $element_position = array();

        public static function instance() {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

        function __construct() {
            $this->load_widgets();
            add_action( 'windoor_after_main_css', array( $this, 'enqueue_css_assets' ), 20 );
            add_filter('blog_post_grid_list_style_update', array( $this, 'blog_post_grid_list_style_update' ));
            add_filter('blog_post_cover_style_update', array( $this, 'blog_post_cover_style_update' ));
        }

        function enqueue_css_assets() {
            wp_enqueue_style( 'windoor-pro-blog', WINDOOR_PRO_DIR_URL . 'modules/blog/assets/css/blog.css', false, WINDOOR_PRO_VERSION, 'all');

            $post_style = windoor_get_archive_post_style();
            $file_path = WINDOOR_PRO_DIR_PATH . 'modules/blog/templates/'.esc_attr($post_style).'/assets/css/blog-archive-'.esc_attr($post_style).'.css';
            if ( file_exists( $file_path ) ) {
                wp_enqueue_style( 'wdt-blog-archive-'.esc_attr($post_style), WINDOOR_PRO_DIR_URL . 'modules/blog/templates/'.esc_attr($post_style).'/assets/css/blog-archive-'.esc_attr($post_style).'.css', false, WINDOOR_PRO_VERSION, 'all');
            }

        }

        function load_widgets() {
            add_action( 'widgets_init', array( $this, 'register_widgets_init' ) );
        }

        function register_widgets_init() {
            include_once WINDOOR_PRO_DIR_PATH.'modules/blog/widget/widget-recent-posts.php';
            register_widget('Windoor_Widget_Recent_Posts');
        }

        function blog_post_grid_list_style_update($list) {

            $pro_list = array (
                'wdt-simple'        => esc_html__('Simple', 'windoor-pro'),
                'wdt-overlap'       => esc_html__('Overlap', 'windoor-pro'),
                'wdt-thumb-overlap' => esc_html__('Thumb Overlap', 'windoor-pro'),
                'wdt-minimal'       => esc_html__('Minimal', 'windoor-pro'),
                'wdt-fancy-box'     => esc_html__('Fancy Box', 'windoor-pro'),
                'wdt-bordered'      => esc_html__('Bordered', 'windoor-pro'),
                'wdt-magnificent'   => esc_html__('Magnificent', 'windoor-pro')
            );

            return array_merge( $list, $pro_list );

        }

        function blog_post_cover_style_update($list) {

            $pro_list = array ();
            return array_merge( $list, $pro_list );

        }

    }
}

WindoorProSiteBlog::instance();

if( !class_exists( 'WindoorProSiteRelatedBlog' ) ) {
    class WindoorProSiteRelatedBlog extends WindoorProSiteBlog {
        function __construct() {}
    }
}