<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if (! class_exists ( 'WindoorPlusHeaderPostType' ) ) {

	class WindoorPlusHeaderPostType {

        private static $_instance = null;

        public static function instance() {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

		function __construct() {

			add_action ( 'init', array( $this, 'windoor_register_cpt' ), 5 );
			add_filter ( 'template_include', array ( $this, 'windoor_template_include' ) );
		}

		function windoor_register_cpt() {

			$labels = array (
				'name'				 => __( 'Headers', 'windoor-plus' ),
				'singular_name'		 => __( 'Header', 'windoor-plus' ),
				'menu_name'			 => __( 'Headers', 'windoor-plus' ),
				'add_new'			 => __( 'Add Header', 'windoor-plus' ),
				'add_new_item'		 => __( 'Add New Header', 'windoor-plus' ),
				'edit'				 => __( 'Edit Header', 'windoor-plus' ),
				'edit_item'			 => __( 'Edit Header', 'windoor-plus' ),
				'new_item'			 => __( 'New Header', 'windoor-plus' ),
				'view'				 => __( 'View Header', 'windoor-plus' ),
				'view_item' 		 => __( 'View Header', 'windoor-plus' ),
				'search_items' 		 => __( 'Search Headers', 'windoor-plus' ),
				'not_found' 		 => __( 'No Headers found', 'windoor-plus' ),
				'not_found_in_trash' => __( 'No Headers found in Trash', 'windoor-plus' ),
			);

			$args = array (
				'labels' 				=> $labels,
				'public' 				=> true,
				'exclude_from_search'	=> true,
				'show_in_nav_menus' 	=> false,
				'show_in_rest' 			=> true,
				'menu_position'			=> 25,
				'menu_icon' 			=> 'dashicons-heading',
				'hierarchical' 			=> false,
				'supports' 				=> array ( 'title', 'editor', 'revisions' ),
			);

			register_post_type ( 'wdt_headers', $args );
		}

		function windoor_template_include($template) {
			if ( is_singular( 'wdt_headers' ) ) {
				if ( ! file_exists ( get_stylesheet_directory () . '/single-wdt_headers.php' ) ) {
					$template = WINDOOR_PLUS_DIR_PATH . 'post-types/templates/single-wdt_headers.php';
				}
			}

			return $template;
		}
	}
}

WindoorPlusHeaderPostType::instance();